/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dcx;

import com.twelvemonkeys.imageio.plugins.dcx.DCXImageReader;
import com.twelvemonkeys.imageio.plugins.dcx.DCXProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class DCXImageReaderSpi
extends ImageReaderSpiBase {
    public DCXImageReaderSpi() {
        super(new DCXProviderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            ByteOrder byteOrder = imageInputStream.getByteOrder();
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            try {
                boolean bl = imageInputStream.readInt() == 987654321;
                imageInputStream.setByteOrder(byteOrder);
                return bl;
            }
            catch (Throwable throwable) {
                imageInputStream.setByteOrder(byteOrder);
                throw throwable;
            }
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new DCXImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Multi-page PCX fax document (DCX) image reader";
    }
}

