/* text-engine-version.h.in
 *
 * Copyright 2022 Matthew Jakeman <mjakeman26@outlook.co.nz>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#pragma once

#if !defined(TEXT_ENGINE_INSIDE) && !defined(TEXT_ENGINE_COMPILATION)
# error "Only <text-engine.h> can be included directly."
#endif

/**
 * SECTION:text_engineversion
 * @short_description: text-engine version checking
 *
 * text-engine provides macros to check the version of the library
 * at compile-time
 */

/**
 * TEXT_ENGINE_MAJOR_VERSION:
 *
 * text-engine major version component (e.g. 1 if %TEXT_ENGINE_VERSION is 1.2.3)
 */
#define TEXT_ENGINE_MAJOR_VERSION (0)

/**
 * TEXT_ENGINE_MINOR_VERSION:
 *
 * text-engine minor version component (e.g. 2 if %TEXT_ENGINE_VERSION is 1.2.3)
 */
#define TEXT_ENGINE_MINOR_VERSION (1)

/**
 * TEXT_ENGINE_MICRO_VERSION:
 *
 * text-engine micro version component (e.g. 3 if %TEXT_ENGINE_VERSION is 1.2.3)
 */
#define TEXT_ENGINE_MICRO_VERSION (0)

/**
 * TEXT_ENGINE_VERSION
 *
 * text-engine version.
 */
#define TEXT_ENGINE_VERSION (0.1.0)

/**
 * TEXT_ENGINE_VERSION_S:
 *
 * text-engine version, encoded as a string, useful for printing and
 * concatenation.
 */
#define TEXT_ENGINE_VERSION_S "0.1.0"

#define TEXT_ENGINE_ENCODE_VERSION(major,minor,micro) \
        ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * TEXT_ENGINE_VERSION_HEX:
 *
 * text-engine version, encoded as an hexadecimal number, useful for
 * integer comparisons.
 */
#define TEXT_ENGINE_VERSION_HEX \
        (TEXT_ENGINE_ENCODE_VERSION (TEXT_ENGINE_MAJOR_VERSION, TEXT_ENGINE_MINOR_VERSION, TEXT_ENGINE_MICRO_VERSION))

/**
 * TEXT_ENGINE_CHECK_VERSION:
 * @major: required major version
 * @minor: required minor version
 * @micro: required micro version
 *
 * Compile-time version checking. Evaluates to %TRUE if the version
 * of text-engine is greater than the required one.
 */
#define TEXT_ENGINE_CHECK_VERSION(major,minor,micro)   \
        (TEXT_ENGINE_MAJOR_VERSION > (major) || \
         (TEXT_ENGINE_MAJOR_VERSION == (major) && TEXT_ENGINE_MINOR_VERSION > (minor)) || \
         (TEXT_ENGINE_MAJOR_VERSION == (major) && TEXT_ENGINE_MINOR_VERSION == (minor) && \
          TEXT_ENGINE_MICRO_VERSION >= (micro)))
