get_by_env(){

	PROXY_IP=$(echo $http_proxy | sed 's/http:\/\///g' | sed 's/\///g' | awk -F':' '{print $1}')
	PROXY_PORT=$(echo $http_proxy | sed 's/http:\/\///g' | sed 's/\///g' | awk -F':' '{print $2}')
	if [ -z "$PROXY_IP" ]; then
		USE_PROXY="N"
	else
		USE_PROXY="Y"
	fi
}

get_by_gconf(){

	type gconftool-2 >/dev/null 2>&1
	if [ $? -ne 0 ] ;then
		return 0
	fi

	PROXY_MODE=$(gconftool-2 -g /system/proxy/mode)
	if [ -z ${PROXY_MODE} ] || [ ${PROXY_MODE} != "manual" ]; then
		USE_PROXY="N"
		PROXY_IP=""
		RPOXY_PORT=0
	else
		USE_PROXY="Y"
		PROXY_IP=$(gconftool-2 -g /system/http_proxy/host)
		PROXY_PORT=$(gconftool-2 -g /system/http_proxy/port)
		if [ -z "${PROXY_PORT}" ]; then
			PROXY_PORT=8080
		fi
	fi

}

get_by_kreadconf(){

	type kreadconfig >/dev/null 2>&1
	if [ $? -ne 0 ] ;then
		return 0
	fi

	PROXY_TYPE=$(kreadconfig --file kioslaverc --group "Proxy Settings" --key ProxyType)
	if [ -z ${PROXY_TYPE} ] || [ ${PROXY_TYPE} -ne 1 ]; then
		USE_PROXY="N"
		PROXY_IP=""
		RPOXY_PORT=0
	else
		USE_PROXY="Y"
		PROXY_IP=$(kreadconfig --file kioslaverc --group "Proxy Settings" --key httpProxy | sed 's/http:\/\///g' | sed 's/\///g' | awk -F' ' '{print $1}')
		PROXY_PORT=$(kreadconfig --file kioslaverc --group "Proxy Settings" --key httpProxy | sed 's/http:\/\///g' | sed 's/\///g' | awk -F' ' '{print $2}')
	fi

}

report_proxy(){

	echo -n "${PROXY_IP}:${PROXY_PORT}"
	exit 0
}

USE_PROXY="N"
PROXY_IP=""
PROXY_PORT=0

get_by_env
if [ ${USE_PROXY} = "Y" ]; then
	report_proxy
fi

get_by_gconf
if [ ${USE_PROXY} = "Y" ]; then
        report_proxy
fi
get_by_kreadconf

if [ ${USE_PROXY} = "Y" ]; then
	report_proxy
fi

echo -n "no_proxy"
exit 0



