/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;

public final class CacheStrategy {
    public static final Companion Companion = new Companion(null);
    private final Request networkRequest;
    private final Response cacheResponse;

    public CacheStrategy(Request networkRequest, Response cacheResponse) {
        this.networkRequest = networkRequest;
        this.cacheResponse = cacheResponse;
    }

    public final Request getNetworkRequest() {
        return this.networkRequest;
    }

    public final Response getCacheResponse() {
        return this.cacheResponse;
    }

    public static final class Factory {
        private final long nowMillis;
        private final Request request;
        private final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds;

        public Factory(long nowMillis, Request request, Response cacheResponse) {
            Intrinsics.checkNotNullParameter(request, "request");
            this.nowMillis = nowMillis;
            this.request = request;
            this.cacheResponse = cacheResponse;
            this.ageSeconds = -1;
            if (this.cacheResponse != null) {
                this.sentRequestMillis = this.cacheResponse.sentRequestAtMillis();
                this.receivedResponseMillis = this.cacheResponse.receivedResponseAtMillis();
                Headers headers = this.cacheResponse.headers();
                int n = 0;
                int n2 = headers.size();
                while (n < n2) {
                    int i = n++;
                    String fieldName = headers.name(i);
                    String value = headers.value(i);
                    if (StringsKt.equals(fieldName, "Date", true)) {
                        this.servedDate = DatesKt.toHttpDateOrNull(value);
                        this.servedDateString = value;
                        continue;
                    }
                    if (StringsKt.equals(fieldName, "Expires", true)) {
                        this.expires = DatesKt.toHttpDateOrNull(value);
                        continue;
                    }
                    if (StringsKt.equals(fieldName, "Last-Modified", true)) {
                        this.lastModified = DatesKt.toHttpDateOrNull(value);
                        this.lastModifiedString = value;
                        continue;
                    }
                    if (StringsKt.equals(fieldName, "ETag", true)) {
                        this.etag = value;
                        continue;
                    }
                    if (!StringsKt.equals(fieldName, "Age", true)) continue;
                    this.ageSeconds = Util.toNonNegativeInt(value, -1);
                }
            }
        }

        private final boolean isFreshnessLifetimeHeuristic() {
            Response response = this.cacheResponse;
            Intrinsics.checkNotNull(response);
            return response.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
        }

        public final CacheStrategy compute() {
            CacheStrategy candidate = this.computeCandidate();
            if (candidate.getNetworkRequest() != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return candidate;
        }

        private final CacheStrategy computeCandidate() {
            if (this.cacheResponse == null) {
                return new CacheStrategy(this.request, null);
            }
            if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                return new CacheStrategy(this.request, null);
            }
            if (!Companion.isCacheable(this.cacheResponse, this.request)) {
                return new CacheStrategy(this.request, null);
            }
            CacheControl requestCaching = this.request.cacheControl();
            if (requestCaching.noCache() || this.hasConditions(this.request)) {
                return new CacheStrategy(this.request, null);
            }
            CacheControl responseCaching = this.cacheResponse.cacheControl();
            long ageMillis = this.cacheResponseAge();
            long freshMillis = this.computeFreshnessLifetime();
            if (requestCaching.maxAgeSeconds() != -1) {
                long l = TimeUnit.SECONDS.toMillis(requestCaching.maxAgeSeconds());
                freshMillis = Math.min(freshMillis, l);
            }
            long minFreshMillis = 0L;
            if (requestCaching.minFreshSeconds() != -1) {
                minFreshMillis = TimeUnit.SECONDS.toMillis(requestCaching.minFreshSeconds());
            }
            long maxStaleMillis = 0L;
            if (!responseCaching.mustRevalidate() && requestCaching.maxStaleSeconds() != -1) {
                maxStaleMillis = TimeUnit.SECONDS.toMillis(requestCaching.maxStaleSeconds());
            }
            if (!responseCaching.noCache() && ageMillis + minFreshMillis < freshMillis + maxStaleMillis) {
                long oneDayMillis;
                Response.Builder builder = this.cacheResponse.newBuilder();
                if (ageMillis + minFreshMillis >= freshMillis) {
                    builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                }
                if (ageMillis > (oneDayMillis = 86400000L) && this.isFreshnessLifetimeHeuristic()) {
                    builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                }
                return new CacheStrategy(null, builder.build());
            }
            String conditionName = null;
            String conditionValue = null;
            if (this.etag != null) {
                conditionName = "If-None-Match";
                conditionValue = this.etag;
            } else if (this.lastModified != null) {
                conditionName = "If-Modified-Since";
                conditionValue = this.lastModifiedString;
            } else if (this.servedDate != null) {
                conditionName = "If-Modified-Since";
                conditionValue = this.servedDateString;
            } else {
                return new CacheStrategy(this.request, null);
            }
            Headers.Builder conditionalRequestHeaders = this.request.headers().newBuilder();
            String string = conditionValue;
            Intrinsics.checkNotNull(string);
            conditionalRequestHeaders.addLenient$okhttp(conditionName, string);
            Request conditionalRequest = this.request.newBuilder().headers(conditionalRequestHeaders.build()).build();
            return new CacheStrategy(conditionalRequest, this.cacheResponse);
        }

        private final long computeFreshnessLifetime() {
            Response response = this.cacheResponse;
            Intrinsics.checkNotNull(response);
            CacheControl responseCaching = response.cacheControl();
            if (responseCaching.maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(responseCaching.maxAgeSeconds());
            }
            Date expires = this.expires;
            if (expires != null) {
                Date date = this.servedDate;
                Long l = date == null ? null : Long.valueOf(date.getTime());
                long servedMillis = l == null ? this.receivedResponseMillis : l;
                long delta = expires.getTime() - servedMillis;
                return delta > 0L ? delta : 0L;
            }
            if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
                Date date = this.servedDate;
                Long l = date == null ? null : Long.valueOf(date.getTime());
                long servedMillis = l == null ? this.sentRequestMillis : l;
                Date date2 = this.lastModified;
                Intrinsics.checkNotNull(date2);
                long delta = servedMillis - date2.getTime();
                return delta > 0L ? delta / (long)10 : 0L;
            }
            return 0L;
        }

        private final long cacheResponseAge() {
            long l;
            long apparentReceivedAge;
            long l2;
            long l3;
            Date servedDate = this.servedDate;
            if (servedDate != null) {
                long l4 = 0L;
                l3 = this.receivedResponseMillis - servedDate.getTime();
                l2 = Math.max(l4, l3);
            } else {
                l2 = apparentReceivedAge = 0L;
            }
            if (this.ageSeconds != -1) {
                l3 = TimeUnit.SECONDS.toMillis(this.ageSeconds);
                l = Math.max(apparentReceivedAge, l3);
            } else {
                l = apparentReceivedAge;
            }
            long receivedAge = l;
            long responseDuration = this.receivedResponseMillis - this.sentRequestMillis;
            long residentDuration = this.nowMillis - this.receivedResponseMillis;
            return receivedAge + responseDuration + residentDuration;
        }

        private final boolean hasConditions(Request request) {
            return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isCacheable(Response response, Request request) {
            Intrinsics.checkNotNullParameter(response, "response");
            Intrinsics.checkNotNullParameter(request, "request");
            switch (response.code()) {
                case 200: 
                case 203: 
                case 204: 
                case 300: 
                case 301: 
                case 308: 
                case 404: 
                case 405: 
                case 410: 
                case 414: 
                case 501: {
                    break;
                }
                case 302: 
                case 307: {
                    if (Response.header$default(response, "Expires", null, 2, null) != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return !response.cacheControl().noStore() && !request.cacheControl().noStore();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

