/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;

public final class ObjectSerializer<T>
implements KSerializer<T> {
    private final T objectInstance;
    private List<? extends Annotation> _annotations;
    private final Lazy descriptor$delegate;

    public ObjectSerializer(String serialName, T objectInstance) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(objectInstance, "objectInstance");
        this.objectInstance = objectInstance;
        this._annotations = CollectionsKt.emptyList();
        this.descriptor$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> ObjectSerializer.descriptor_delegate$lambda$1(serialName, this));
    }

    @Override
    public SerialDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (SerialDescriptor)lazy.getValue();
    }

    @Override
    public void serialize(Encoder encoder, T value) {
        Intrinsics.checkNotNullParameter(encoder, "encoder");
        Intrinsics.checkNotNullParameter(value, "value");
        encoder.beginStructure(this.getDescriptor()).endStructure(this.getDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T deserialize(Decoder decoder) {
        int index;
        void $this$decodeStructure$iv;
        CompositeDecoder composite$iv;
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        Decoder decoder2 = decoder;
        SerialDescriptor descriptor$iv = this.getDescriptor();
        boolean $i$f$decodeStructure = false;
        CompositeDecoder $this$deserialize_u24lambda_u242 = composite$iv = $this$decodeStructure$iv.beginStructure(descriptor$iv);
        boolean bl = false;
        if (!$this$deserialize_u24lambda_u242.decodeSequentially() && (index = $this$deserialize_u24lambda_u242.decodeElementIndex(this.getDescriptor())) != -1) {
            throw new SerializationException("Unexpected index " + index);
        }
        Unit result$iv = Unit.INSTANCE;
        composite$iv.endStructure(descriptor$iv);
        return this.objectInstance;
    }

    private static final Unit descriptor_delegate$lambda$1$lambda$0(ObjectSerializer this$0, ClassSerialDescriptorBuilder $this$buildSerialDescriptor) {
        Intrinsics.checkNotNullParameter($this$buildSerialDescriptor, "$this$buildSerialDescriptor");
        $this$buildSerialDescriptor.setAnnotations(this$0._annotations);
        return Unit.INSTANCE;
    }

    private static final SerialDescriptor descriptor_delegate$lambda$1(String $serialName, ObjectSerializer this$0) {
        return SerialDescriptorsKt.buildSerialDescriptor($serialName, StructureKind.OBJECT.INSTANCE, new SerialDescriptor[0], arg_0 -> ObjectSerializer.descriptor_delegate$lambda$1$lambda$0(this$0, arg_0));
    }
}

