/*
 * Decompiled with CFR 0.152.
 */
package kotlin.time;

import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;

public final class DurationKt {
    public static final long toDuration(long $this$toDuration, DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        long maxNsInUnit = DurationUnitKt.convertDurationUnitOverflow(4611686018426999999L, DurationUnit.NANOSECONDS, unit);
        boolean bl = -maxNsInUnit <= $this$toDuration ? $this$toDuration <= maxNsInUnit : false;
        if (bl) {
            return DurationKt.durationOfNanos(DurationUnitKt.convertDurationUnitOverflow($this$toDuration, unit, DurationUnit.NANOSECONDS));
        }
        long millis = DurationUnitKt.convertDurationUnit($this$toDuration, unit, DurationUnit.MILLISECONDS);
        return DurationKt.durationOfMillis(RangesKt.coerceIn(millis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    public static final long toDuration(double $this$toDuration, DurationUnit unit) {
        long l;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)unit, "unit");
        double valueInNs = DurationUnitKt.convertDurationUnit($this$toDuration, unit, DurationUnit.NANOSECONDS);
        boolean bl2 = bl = !Double.isNaN(valueInNs);
        if (!bl) {
            boolean bl3 = false;
            String string = "Duration value cannot be NaN.";
            throw new IllegalArgumentException(string.toString());
        }
        long nanos = MathKt.roundToLong(valueInNs);
        boolean bl4 = -4611686018426999999L <= nanos ? nanos < 4611686018427000000L : false;
        if (bl4) {
            l = DurationKt.durationOfNanos(nanos);
        } else {
            long millis = MathKt.roundToLong(DurationUnitKt.convertDurationUnit($this$toDuration, unit, DurationUnit.MILLISECONDS));
            l = DurationKt.durationOfMillisNormalized(millis);
        }
        return l;
    }

    private static final long parseDuration(String value, boolean strictIso) {
        int length = value.length();
        if (length == 0) {
            throw new IllegalArgumentException("The string is empty");
        }
        int index = 0;
        long result2 = Duration.Companion.getZERO-UwyO8pc();
        String infinityString = "Infinity";
        switch (value.charAt(index)) {
            case '+': 
            case '-': {
                ++index;
            }
        }
        boolean hasSign = index > 0;
        boolean isNegative = hasSign && StringsKt.startsWith$default((CharSequence)value, '-', false, 2, null);
        if (length <= index) {
            throw new IllegalArgumentException("No components");
        }
        if (value.charAt(index) == 'P') {
            if (++index == length) {
                throw new IllegalArgumentException();
            }
            String nonDigitSymbols = "+-.";
            boolean isTimeComponent = false;
            DurationUnit prevUnit = null;
            while (index < length) {
                String component;
                int i$iv$iv;
                if (value.charAt(index) == 'T') {
                    if (isTimeComponent || ++index == length) {
                        throw new IllegalArgumentException();
                    }
                    isTimeComponent = true;
                    continue;
                }
                String $this$substringWhile$iv = value;
                boolean $i$f$substringWhile22 = false;
                String string = $this$substringWhile$iv;
                String $this$skipWhile$iv$iv22 = $this$substringWhile$iv;
                boolean $i$f$skipWhile2 = false;
                for (i$iv$iv = index; i$iv$iv < $this$skipWhile$iv$iv22.length(); ++i$iv$iv) {
                    char it = $this$skipWhile$iv$iv22.charAt(i$iv$iv);
                    boolean bl = false;
                    boolean bl2 = '0' <= it ? it < ':' : false;
                    if (!(bl2 || StringsKt.contains$default((CharSequence)nonDigitSymbols, it, false, 2, null))) break;
                }
                int $this$skipWhile$iv$iv22 = i$iv$iv;
                Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                Intrinsics.checkNotNullExpressionValue(string.substring(index, $this$skipWhile$iv$iv22), "substring(...)");
                if (((CharSequence)component).length() == 0) {
                    throw new IllegalArgumentException();
                }
                CharSequence $i$f$substringWhile22 = value;
                if (!(0 <= (index += component.length()) ? index < $i$f$substringWhile22.length() : false)) {
                    int it = index;
                    boolean bl = false;
                    throw new IllegalArgumentException("Missing unit for value " + component);
                }
                char unitChar = $i$f$substringWhile22.charAt(index);
                ++index;
                DurationUnit unit = DurationUnitKt.durationUnitByIsoChar(unitChar, isTimeComponent);
                if (prevUnit != null && prevUnit.compareTo((Enum)unit) <= 0) {
                    throw new IllegalArgumentException("Unexpected order of duration components");
                }
                prevUnit = unit;
                int dotIndex = StringsKt.indexOf$default((CharSequence)component, '.', 0, false, 6, null);
                if (unit == DurationUnit.SECONDS && dotIndex > 0) {
                    String whole;
                    String $i$f$skipWhile2 = component;
                    i$iv$iv = 0;
                    Intrinsics.checkNotNull($i$f$skipWhile2, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue($i$f$skipWhile2.substring(i$iv$iv, dotIndex), "substring(...)");
                    result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(DurationKt.parseOverLongIsoComponent(whole), unit));
                    String string2 = component;
                    Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type java.lang.String");
                    String string3 = string2.substring(dotIndex);
                    Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                    result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Double.parseDouble(string3), unit));
                    continue;
                }
                result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(DurationKt.parseOverLongIsoComponent(component), unit));
            }
        } else {
            if (strictIso) {
                throw new IllegalArgumentException();
            }
            if (StringsKt.regionMatches(value, index, infinityString, 0, Math.max(length - index, infinityString.length()), true)) {
                result2 = Duration.Companion.getINFINITE-UwyO8pc();
            } else {
                boolean allowSpaces;
                DurationUnit prevUnit = null;
                boolean afterFirst = false;
                boolean bl = allowSpaces = !hasSign;
                if (hasSign && value.charAt(index) == '(' && StringsKt.last(value) == ')') {
                    allowSpaces = true;
                    if (++index == --length) {
                        throw new IllegalArgumentException("No components");
                    }
                }
                while (index < length) {
                    String unitName;
                    int i$iv$iv;
                    String component;
                    int i$iv$iv2;
                    if (afterFirst && allowSpaces) {
                        int i$iv;
                        String $this$skipWhile$iv = value;
                        boolean $i$f$skipWhile = false;
                        for (i$iv = index; i$iv < $this$skipWhile$iv.length(); ++i$iv) {
                            char it = $this$skipWhile$iv.charAt(i$iv);
                            boolean bl3 = false;
                            if (!(it == ' ')) break;
                        }
                        index = i$iv;
                    }
                    afterFirst = true;
                    String $this$substringWhile$iv = value;
                    boolean $i$f$substringWhile = false;
                    String it = $this$substringWhile$iv;
                    String $this$skipWhile$iv$iv422 = $this$substringWhile$iv;
                    boolean $i$f$skipWhile = false;
                    for (i$iv$iv2 = index; i$iv$iv2 < $this$skipWhile$iv$iv422.length(); ++i$iv$iv2) {
                        char it2 = $this$skipWhile$iv$iv422.charAt(i$iv$iv2);
                        boolean bl4 = false;
                        boolean bl5 = '0' <= it2 ? it2 < ':' : false;
                        if (!(bl5 || it2 == '.')) break;
                    }
                    int $this$skipWhile$iv$iv422 = i$iv$iv2;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue(it.substring(index, $this$skipWhile$iv$iv422), "substring(...)");
                    if (((CharSequence)component).length() == 0) {
                        throw new IllegalArgumentException();
                    }
                    index += component.length();
                    String $this$substringWhile$iv2 = value;
                    boolean $i$f$substringWhile2 = false;
                    String $this$skipWhile$iv$iv422 = $this$substringWhile$iv2;
                    String $this$skipWhile$iv$iv = $this$substringWhile$iv2;
                    boolean $i$f$skipWhile3 = false;
                    for (i$iv$iv = index; i$iv$iv < $this$skipWhile$iv$iv.length(); ++i$iv$iv) {
                        char it3 = $this$skipWhile$iv$iv.charAt(i$iv$iv);
                        boolean bl6 = false;
                        boolean bl7 = 'a' <= it3 ? it3 < '{' : false;
                        if (!bl7) break;
                    }
                    int n = i$iv$iv;
                    Intrinsics.checkNotNull($this$skipWhile$iv$iv422, "null cannot be cast to non-null type java.lang.String");
                    Intrinsics.checkNotNullExpressionValue($this$skipWhile$iv$iv422.substring(index, n), "substring(...)");
                    index += unitName.length();
                    DurationUnit unit = DurationUnitKt.durationUnitByShortName(unitName);
                    if (prevUnit != null && prevUnit.compareTo((Enum)unit) <= 0) {
                        throw new IllegalArgumentException("Unexpected order of duration components");
                    }
                    prevUnit = unit;
                    int dotIndex = StringsKt.indexOf$default((CharSequence)component, '.', 0, false, 6, null);
                    if (dotIndex > 0) {
                        String whole;
                        String string = component;
                        int n2 = 0;
                        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                        Intrinsics.checkNotNullExpressionValue(string.substring(n2, dotIndex), "substring(...)");
                        result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Long.parseLong(whole), unit));
                        String string4 = component;
                        Intrinsics.checkNotNull(string4, "null cannot be cast to non-null type java.lang.String");
                        String string5 = string4.substring(dotIndex);
                        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                        result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Double.parseDouble(string5), unit));
                        if (index >= length) continue;
                        throw new IllegalArgumentException("Fractional component must be last");
                    }
                    result2 = Duration.plus-LRDsOJo(result2, DurationKt.toDuration(Long.parseLong(component), unit));
                }
            }
        }
        return isNegative ? Duration.unaryMinus-UwyO8pc(result2) : result2;
    }

    private static final long parseOverLongIsoComponent(String value) {
        int length = value.length();
        int startIndex = 0;
        if (length > 0 && StringsKt.contains$default((CharSequence)"+-", value.charAt(0), false, 2, null)) {
            ++startIndex;
        }
        if (length - startIndex > 16) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = new IntRange(startIndex, StringsKt.getLastIndex(value));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        char c = value.charAt(it);
                        if ('0' <= c ? c < ':' : false) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return value.charAt(0) == '-' ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
        }
        return StringsKt.startsWith$default(value, "+", false, 2, null) ? Long.parseLong(StringsKt.drop(value, 1)) : Long.parseLong(value);
    }

    private static final long nanosToMillis(long nanos) {
        return nanos / (long)1000000;
    }

    private static final long millisToNanos(long millis) {
        return millis * (long)1000000;
    }

    private static final long durationOfNanos(long normalNanos) {
        return Duration.constructor-impl(normalNanos << 1);
    }

    private static final long durationOfMillis(long normalMillis) {
        return Duration.constructor-impl((normalMillis << 1) + 1L);
    }

    private static final long durationOf(long normalValue, int unitDiscriminator) {
        return Duration.constructor-impl((normalValue << 1) + (long)unitDiscriminator);
    }

    private static final long durationOfNanosNormalized(long nanos) {
        return (-4611686018426999999L <= nanos ? nanos < 4611686018427000000L : false) ? DurationKt.durationOfNanos(nanos) : DurationKt.durationOfMillis(DurationKt.nanosToMillis(nanos));
    }

    private static final long durationOfMillisNormalized(long millis) {
        return (-4611686018426L <= millis ? millis < 4611686018427L : false) ? DurationKt.durationOfNanos(DurationKt.millisToNanos(millis)) : DurationKt.durationOfMillis(RangesKt.coerceIn(millis, -4611686018427387903L, 0x3FFFFFFFFFFFFFFFL));
    }

    public static final /* synthetic */ long access$parseDuration(String value, boolean strictIso) {
        return DurationKt.parseDuration(value, strictIso);
    }

    public static final /* synthetic */ long access$durationOf(long normalValue, int unitDiscriminator) {
        return DurationKt.durationOf(normalValue, unitDiscriminator);
    }

    public static final /* synthetic */ long access$durationOfNanosNormalized(long nanos) {
        return DurationKt.durationOfNanosNormalized(nanos);
    }

    public static final /* synthetic */ long access$durationOfMillisNormalized(long millis) {
        return DurationKt.durationOfMillisNormalized(millis);
    }

    public static final /* synthetic */ long access$nanosToMillis(long nanos) {
        return DurationKt.nanosToMillis(nanos);
    }

    public static final /* synthetic */ long access$millisToNanos(long millis) {
        return DurationKt.millisToNanos(millis);
    }

    public static final /* synthetic */ long access$durationOfNanos(long normalNanos) {
        return DurationKt.durationOfNanos(normalNanos);
    }

    public static final /* synthetic */ long access$durationOfMillis(long normalMillis) {
        return DurationKt.durationOfMillis(normalMillis);
    }
}

