/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api.json;

import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.JsonNumber;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.internal.UtilsKt;
import com.apollographql.apollo.exception.JsonDataException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

public final class MapJsonReader
implements JsonReader {
    public static final Companion Companion = new Companion(null);
    private final Object root;
    private final List<Object> pathRoot;
    private JsonReader.Token peekedToken;
    private Object peekedData;
    private Object[] path;
    private Map<String, Object>[] containerStack;
    private Iterator<?>[] iteratorStack;
    private int[] nameIndexStack;
    private int stackSize;

    public MapJsonReader(Object root, List<? extends Object> pathRoot) {
        Intrinsics.checkNotNullParameter(pathRoot, "pathRoot");
        this.root = root;
        this.pathRoot = pathRoot;
        this.path = new Object[64];
        this.containerStack = new Map[64];
        this.iteratorStack = new Iterator[64];
        this.nameIndexStack = new int[64];
        this.peekedToken = this.anyToToken(this.root);
        this.peekedData = this.root;
    }

    public /* synthetic */ MapJsonReader(Object object, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(object, list);
    }

    private final JsonReader.Token anyToToken(Object any) {
        Object object = any;
        return object == null ? JsonReader.Token.NULL : (object instanceof List ? JsonReader.Token.BEGIN_ARRAY : (object instanceof Map ? JsonReader.Token.BEGIN_OBJECT : (object instanceof Integer ? JsonReader.Token.NUMBER : (object instanceof Long ? JsonReader.Token.LONG : (object instanceof Double ? JsonReader.Token.NUMBER : (object instanceof JsonNumber ? JsonReader.Token.NUMBER : (object instanceof String ? JsonReader.Token.STRING : (object instanceof Boolean ? JsonReader.Token.BOOLEAN : JsonReader.Token.ANY))))))));
    }

    private final void advanceIterator() {
        if (this.stackSize == 0) {
            this.peekedToken = JsonReader.Token.END_DOCUMENT;
            return;
        }
        Iterator<?> iterator2 = this.iteratorStack[this.stackSize - 1];
        Intrinsics.checkNotNull(iterator2);
        Iterator<?> currentIterator = iterator2;
        if (this.path[this.stackSize - 1] instanceof Integer) {
            Object object = this.path[this.stackSize - 1];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
            this.path[this.stackSize - 1] = (Integer)object + 1;
        }
        if (currentIterator.hasNext()) {
            Object next = currentIterator.next();
            this.peekedData = next;
            this.peekedToken = next instanceof Map.Entry ? JsonReader.Token.NAME : this.anyToToken(next);
        } else {
            this.peekedToken = this.path[this.stackSize - 1] instanceof Integer ? JsonReader.Token.END_ARRAY : JsonReader.Token.END_OBJECT;
        }
    }

    private final void increaseStack() {
        if (this.stackSize == this.path.length) {
            Object[] objectArray = Arrays.copyOf(this.path, this.path.length * 2);
            Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
            this.path = objectArray;
            Map<String, Object>[] mapArray = Arrays.copyOf(this.containerStack, this.containerStack.length * 2);
            Intrinsics.checkNotNullExpressionValue(mapArray, "copyOf(...)");
            this.containerStack = mapArray;
            int[] nArray = Arrays.copyOf(this.nameIndexStack, this.nameIndexStack.length * 2);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.nameIndexStack = nArray;
            Iterator<?>[] iteratorArray = Arrays.copyOf(this.iteratorStack, this.iteratorStack.length * 2);
            Intrinsics.checkNotNullExpressionValue(iteratorArray, "copyOf(...)");
            this.iteratorStack = iteratorArray;
        }
        int n = this.stackSize;
        this.stackSize = n + 1;
    }

    @Override
    public MapJsonReader beginArray() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$beginArray_u24lambda_u240 = mapJsonReader = this;
        boolean bl = false;
        if ($this$beginArray_u24lambda_u240.peek() != JsonReader.Token.BEGIN_ARRAY) {
            throw new JsonDataException("Expected BEGIN_ARRAY but was " + (Object)((Object)$this$beginArray_u24lambda_u240.peek()) + " at path " + $this$beginArray_u24lambda_u240.getPathAsString());
        }
        Object object = $this$beginArray_u24lambda_u240.peekedData;
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.Any?>");
        List currentValue = (List)object;
        $this$beginArray_u24lambda_u240.increaseStack();
        $this$beginArray_u24lambda_u240.path[$this$beginArray_u24lambda_u240.stackSize - 1] = -1;
        $this$beginArray_u24lambda_u240.iteratorStack[$this$beginArray_u24lambda_u240.stackSize - 1] = currentValue.iterator();
        $this$beginArray_u24lambda_u240.advanceIterator();
        return mapJsonReader;
    }

    @Override
    public MapJsonReader endArray() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$endArray_u24lambda_u241 = mapJsonReader = this;
        boolean bl = false;
        if ($this$endArray_u24lambda_u241.peek() != JsonReader.Token.END_ARRAY) {
            throw new JsonDataException("Expected END_ARRAY but was " + (Object)((Object)$this$endArray_u24lambda_u241.peek()) + " at path " + $this$endArray_u24lambda_u241.getPathAsString());
        }
        int n = $this$endArray_u24lambda_u241.stackSize;
        $this$endArray_u24lambda_u241.stackSize = n + -1;
        $this$endArray_u24lambda_u241.iteratorStack[$this$endArray_u24lambda_u241.stackSize] = null;
        $this$endArray_u24lambda_u241.path[$this$endArray_u24lambda_u241.stackSize] = null;
        $this$endArray_u24lambda_u241.advanceIterator();
        return mapJsonReader;
    }

    @Override
    public MapJsonReader beginObject() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$beginObject_u24lambda_u242 = mapJsonReader = this;
        boolean bl = false;
        if ($this$beginObject_u24lambda_u242.peek() != JsonReader.Token.BEGIN_OBJECT) {
            throw new JsonDataException("Expected BEGIN_OBJECT but was " + (Object)((Object)$this$beginObject_u24lambda_u242.peek()) + " at path " + $this$beginObject_u24lambda_u242.getPathAsString());
        }
        $this$beginObject_u24lambda_u242.increaseStack();
        Map<String, Object>[] mapArray = $this$beginObject_u24lambda_u242.containerStack;
        int n = $this$beginObject_u24lambda_u242.stackSize - 1;
        Object object = $this$beginObject_u24lambda_u242.peekedData;
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
        mapArray[n] = object;
        $this$beginObject_u24lambda_u242.rewind();
        return mapJsonReader;
    }

    @Override
    public MapJsonReader endObject() {
        MapJsonReader mapJsonReader;
        MapJsonReader $this$endObject_u24lambda_u243 = mapJsonReader = this;
        boolean bl = false;
        int n = $this$endObject_u24lambda_u243.stackSize;
        $this$endObject_u24lambda_u243.stackSize = n + -1;
        $this$endObject_u24lambda_u243.iteratorStack[$this$endObject_u24lambda_u243.stackSize] = null;
        $this$endObject_u24lambda_u243.path[$this$endObject_u24lambda_u243.stackSize] = null;
        $this$endObject_u24lambda_u243.containerStack[$this$endObject_u24lambda_u243.stackSize] = null;
        $this$endObject_u24lambda_u243.advanceIterator();
        return mapJsonReader;
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public JsonReader.Token peek() {
        return this.peekedToken;
    }

    @Override
    public String nextName() {
        if (this.peek() != JsonReader.Token.NAME) {
            throw new JsonDataException("Expected NAME but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        Object object = this.peekedData;
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map.Entry<kotlin.String, kotlin.Any?>");
        Map.Entry data = (Map.Entry)object;
        this.path[this.stackSize - 1] = data.getKey();
        this.peekedData = data.getValue();
        this.peekedToken = this.anyToToken(data.getValue());
        return (String)data.getKey();
    }

    @Override
    public String nextString() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a String but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object object = this.peekedData;
        Intrinsics.checkNotNull(object);
        String it = string = object.toString();
        boolean bl = false;
        this.advanceIterator();
        return string;
    }

    @Override
    public boolean nextBoolean() {
        if (this.peek() != JsonReader.Token.BOOLEAN) {
            throw new JsonDataException("Expected BOOLEAN but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        Object object = this.peekedData;
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        Boolean bl = (Boolean)object;
        boolean it = bl;
        boolean bl2 = false;
        this.advanceIterator();
        return bl;
    }

    @Override
    public Void nextNull() {
        if (this.peek() != JsonReader.Token.NULL) {
            throw new JsonDataException("Expected NULL but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
        }
        this.advanceIterator();
        return null;
    }

    @Override
    public double nextDouble() {
        double d;
        double d2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a Double but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer) {
            d2 = ((Number)value).intValue();
        } else if (value instanceof Long) {
            d2 = UtilsKt.-LongToDoubleExact(((Number)value).longValue());
        } else if (value instanceof Double) {
            d2 = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            d2 = Double.parseDouble((String)value);
        } else if (value instanceof JsonNumber) {
            d2 = Double.parseDouble(((JsonNumber)value).getValue());
        } else {
            throw new IllegalStateException(("Expected a Double but got " + value + " instead").toString());
        }
        double it = d = d2;
        boolean bl = false;
        this.advanceIterator();
        return d;
    }

    @Override
    public int nextInt() {
        int n;
        int n2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected an Int but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer) {
            n2 = ((Number)value).intValue();
        } else if (value instanceof Long) {
            n2 = UtilsKt.-LongToIntExact(((Number)value).longValue());
        } else if (value instanceof Double) {
            n2 = UtilsKt.-DoubleToIntExact(((Number)value).doubleValue());
        } else if (value instanceof String) {
            n2 = Integer.parseInt((String)value);
        } else if (value instanceof JsonNumber) {
            n2 = Integer.parseInt(((JsonNumber)value).getValue());
        } else {
            throw new IllegalStateException(("Expected an Int but got " + value + " instead").toString());
        }
        int it = n = n2;
        boolean bl = false;
        this.advanceIterator();
        return n;
    }

    @Override
    public long nextLong() {
        long l;
        long l2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a Long but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer) {
            l2 = ((Number)value).intValue();
        } else if (value instanceof Long) {
            l2 = ((Number)value).longValue();
        } else if (value instanceof Double) {
            l2 = UtilsKt.-DoubleToLongExact(((Number)value).doubleValue());
        } else if (value instanceof String) {
            l2 = Long.parseLong((String)value);
        } else if (value instanceof JsonNumber) {
            l2 = Long.parseLong(((JsonNumber)value).getValue());
        } else {
            throw new IllegalStateException(("Expected Int but got " + value + " instead").toString());
        }
        long it = l = l2;
        boolean bl = false;
        this.advanceIterator();
        return l;
    }

    @Override
    public JsonNumber nextNumber() {
        JsonNumber jsonNumber;
        JsonNumber jsonNumber2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.peek().ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new JsonDataException("Expected a Number but was " + (Object)((Object)this.peek()) + " at path " + this.getPathAsString());
            }
        }
        Object value = this.peekedData;
        if (value instanceof Integer || value instanceof Long || value instanceof Double) {
            jsonNumber2 = new JsonNumber(value.toString());
        } else if (value instanceof String) {
            jsonNumber2 = new JsonNumber((String)value);
        } else if (value instanceof JsonNumber) {
            jsonNumber2 = (JsonNumber)value;
        } else {
            throw new IllegalStateException(("Expected JsonNumber but got " + value + " instead").toString());
        }
        JsonNumber it = jsonNumber = jsonNumber2;
        boolean bl = false;
        this.advanceIterator();
        return jsonNumber;
    }

    @Override
    public void skipValue() {
        this.advanceIterator();
    }

    @Override
    public void close() {
    }

    private final int findName(String needle, List<String> haystack) {
        int expectedIndex = this.nameIndexStack[this.stackSize - 1];
        if (expectedIndex < haystack.size() && Intrinsics.areEqual(haystack.get(expectedIndex), needle)) {
            this.nameIndexStack[this.stackSize - 1] = this.nameIndexStack[this.stackSize - 1] + 1;
            return expectedIndex;
        }
        int index = haystack.indexOf(needle);
        if (index != -1) {
            this.nameIndexStack[this.stackSize - 1] = index + 1;
        }
        return index;
    }

    @Override
    public int selectName(List<String> names) {
        Intrinsics.checkNotNullParameter(names, "names");
        while (this.hasNext()) {
            String name = this.nextName();
            int index = this.findName(name, names);
            if (index != -1) {
                return index;
            }
            this.skipValue();
        }
        return -1;
    }

    @Override
    public void rewind() {
        Map<String, Object> container = this.containerStack[this.stackSize - 1];
        this.path[this.stackSize - 1] = null;
        Map<String, Object> map2 = container;
        Intrinsics.checkNotNull(map2);
        this.iteratorStack[this.stackSize - 1] = map2.entrySet().iterator();
        this.nameIndexStack[this.stackSize - 1] = 0;
        this.advanceIterator();
    }

    @Override
    public List<Object> getPath() {
        List result2 = new ArrayList();
        result2.addAll((Collection)this.pathRoot);
        int n = this.stackSize;
        for (int index = 0; index < n; ++index) {
            Object it;
            if (this.path[index] == null) continue;
            boolean bl = false;
            ((Collection)result2).add(it);
        }
        return result2;
    }

    private final String getPathAsString() {
        return CollectionsKt.joinToString$default(this.getPath(), ".", null, null, 0, null, null, 62, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public final MapJsonReader buffer(JsonReader $this$buffer) {
            Intrinsics.checkNotNullParameter($this$buffer, "<this>");
            if ($this$buffer instanceof MapJsonReader) {
                return (MapJsonReader)$this$buffer;
            }
            JsonReader.Token token = $this$buffer.peek();
            if (!(token == JsonReader.Token.BEGIN_OBJECT)) {
                boolean $i$a$-check-MapJsonReader$Companion$buffer$22 = false;
                String $i$a$-check-MapJsonReader$Companion$buffer$22 = "Failed to buffer json reader, expected `BEGIN_OBJECT` but found `" + (Object)((Object)token) + "` json token";
                throw new IllegalStateException($i$a$-check-MapJsonReader$Companion$buffer$22.toString());
            }
            List<Object> pathRoot = $this$buffer.getPath();
            Object object = -JsonReaders.readAny($this$buffer);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Map data = (Map)object;
            return new MapJsonReader(data, pathRoot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            try {
                nArray[JsonReader.Token.END_OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.END_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.NUMBER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

