/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.exception.ApolloException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

public final class ApolloResponse<D extends Operation.Data> {
    public final UUID requestUuid;
    public final Operation<D> operation;
    public final D data;
    public final List<Error> errors;
    public final ApolloException exception;
    public final Map<String, Object> extensions;
    public final ExecutionContext executionContext;
    public final boolean isLast;

    private ApolloResponse(UUID requestUuid, Operation<D> operation, D data, List<Error> errors, ApolloException exception, Map<String, ? extends Object> extensions, ExecutionContext executionContext, boolean isLast) {
        this.requestUuid = requestUuid;
        this.operation = operation;
        this.data = data;
        this.errors = errors;
        this.exception = exception;
        this.extensions = extensions;
        this.executionContext = executionContext;
        this.isLast = isLast;
    }

    public final boolean hasErrors() {
        Collection collection = this.errors;
        return !(collection == null || collection.isEmpty());
    }

    public final Builder<D> newBuilder() {
        return new Builder<D>(this.operation, this.requestUuid, this.data, this.errors, this.extensions, this.exception).addExecutionContext(this.executionContext).isLast(this.isLast);
    }

    public /* synthetic */ ApolloResponse(UUID requestUuid, Operation operation, Operation.Data data, List errors, ApolloException exception, Map extensions, ExecutionContext executionContext, boolean isLast, DefaultConstructorMarker $constructor_marker) {
        this(requestUuid, operation, data, errors, exception, extensions, executionContext, isLast);
    }

    public static final class Builder<D extends Operation.Data> {
        private final Operation<D> operation;
        private UUID requestUuid;
        private D data;
        private List<Error> errors;
        private Map<String, ? extends Object> extensions;
        private ApolloException exception;
        private ExecutionContext executionContext;
        private boolean isLast;

        public Builder(Operation<D> operation, UUID requestUuid, D data, List<Error> errors, Map<String, ? extends Object> extensions, ApolloException exception) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            Intrinsics.checkNotNullParameter(requestUuid, "requestUuid");
            this.operation = operation;
            this.requestUuid = requestUuid;
            this.data = data;
            this.errors = errors;
            this.extensions = extensions;
            this.exception = exception;
            this.executionContext = ExecutionContext.Empty;
        }

        public Builder(Operation<D> operation, UUID requestUuid) {
            Intrinsics.checkNotNullParameter(operation, "operation");
            Intrinsics.checkNotNullParameter(requestUuid, "requestUuid");
            this(operation, requestUuid, null, null, null, null);
        }

        public final Builder<D> addExecutionContext(ExecutionContext executionContext) {
            Builder builder;
            Intrinsics.checkNotNullParameter(executionContext, "executionContext");
            Builder $this$addExecutionContext_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$addExecutionContext_u24lambda_u240.executionContext = $this$addExecutionContext_u24lambda_u240.executionContext.plus(executionContext);
            return builder;
        }

        public final Builder<D> data(D data) {
            Builder builder;
            Builder $this$data_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$data_u24lambda_u241.data = data;
            return builder;
        }

        public final Builder<D> errors(List<Error> errors) {
            Builder builder;
            Builder $this$errors_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$errors_u24lambda_u242.errors = errors;
            return builder;
        }

        public final Builder<D> exception(ApolloException exception) {
            Builder builder;
            Builder $this$exception_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$exception_u24lambda_u243.exception = exception;
            return builder;
        }

        public final Builder<D> extensions(Map<String, ? extends Object> extensions) {
            Builder builder;
            Builder $this$extensions_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$extensions_u24lambda_u244.extensions = extensions;
            return builder;
        }

        public final Builder<D> requestUuid(UUID requestUuid) {
            Builder builder;
            Intrinsics.checkNotNullParameter(requestUuid, "requestUuid");
            Builder $this$requestUuid_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$requestUuid_u24lambda_u245.requestUuid = requestUuid;
            return builder;
        }

        public final Builder<D> isLast(boolean isLast) {
            Builder builder;
            Builder $this$isLast_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$isLast_u24lambda_u246.isLast = isLast;
            return builder;
        }

        public final ApolloResponse<D> build() {
            Operation<D> operation = this.operation;
            UUID uUID = this.requestUuid;
            D d = this.data;
            ExecutionContext executionContext = this.executionContext;
            Map<String, Object> map2 = this.extensions;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map<String, ? extends Object> map3 = map2;
            List<Error> list = this.errors;
            ApolloException apolloException = this.exception;
            boolean bl = this.isLast;
            return new ApolloResponse(uUID, operation, (Operation.Data)d, list, apolloException, map3, executionContext, bl, null);
        }
    }
}

