/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

public final class Http2Connection
implements Closeable {
    public static final Companion Companion;
    private final boolean client;
    private final Listener listener;
    private final Map<Integer, Http2Stream> streams;
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    private final Settings okHttpSettings;
    private Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final Socket socket;
    private final Http2Writer writer;
    private final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    private static final Settings DEFAULT_SETTINGS;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(Builder builder) {
        Settings settings;
        Intrinsics.checkNotNullParameter(builder, "builder");
        this.client = builder.getClient$okhttp();
        this.listener = builder.getListener$okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = builder.getConnectionName$okhttp();
        this.nextStreamId = builder.getClient$okhttp() ? 3 : 2;
        this.taskRunner = builder.getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = builder.getPushObserver$okhttp();
        Settings settings2 = settings = new Settings();
        Http2Connection http2Connection = this;
        boolean bl2 = false;
        if (builder.getClient$okhttp()) {
            void $this$okHttpSettings_u24lambda_u2d0;
            $this$okHttpSettings_u24lambda_u2d0.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = settings;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$okhttp();
        this.writer = new Http2Writer(builder.getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(new Http2Reader(builder.getSource$okhttp(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (builder.getPingIntervalMillis$okhttp() != 0) {
            void this_$iv;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(builder.getPingIntervalMillis$okhttp());
            TaskQueue bl2 = this.writerQueue;
            String name$iv = Intrinsics.stringPlus(this.connectionName, " ping");
            boolean $i$f$schedule = false;
            this_$iv.schedule(new Task(name$iv, this, pingIntervalNanos){
                final /* synthetic */ String $name;
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    this.$name = $name;
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l;
                    super($name, false, 2, null);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public long runOnce() {
                    long l;
                    boolean bl;
                    boolean bl2 = false;
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl3;
                        boolean bl4 = false;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl3 = true;
                        } else {
                            long l2 = Http2Connection.access$getIntervalPingsSent$p(this.this$0);
                            Http2Connection.access$setIntervalPingsSent$p(this.this$0, l2 + 1L);
                            bl3 = false;
                        }
                        bl = bl3;
                    }
                    boolean failDueToMissingPong = bl;
                    if (failDueToMissingPong) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        l = -1L;
                    } else {
                        this.this$0.writePing(false, 1, 0);
                        l = this.$pingIntervalNanos$inlined;
                    }
                    return l;
                }
            }, pingIntervalNanos);
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final Listener getListener$okhttp() {
        return this.listener;
    }

    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    public final void setLastGoodStreamId$okhttp(int n) {
        this.lastGoodStreamId = n;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final void setNextStreamId$okhttp(int n) {
        this.nextStreamId = n;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    public final void setPeerSettings(Settings settings) {
        Intrinsics.checkNotNullParameter(settings, "<set-?>");
        this.peerSettings = settings;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    public final synchronized Http2Stream getStream(int id) {
        return this.streams.get(id);
    }

    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        boolean $i$f$notifyAll = false;
        ((Object)$this$notifyAll$iv).notifyAll();
        return stream;
    }

    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        this.readBytesTotal += read;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += readBytesToAcknowledge;
        }
    }

    public final Http2Stream newStream(List<Header> requestHeaders, boolean out) throws IOException {
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        return this.newStream(0, requestHeaders, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        boolean outFinished = !out;
        boolean inFinished = false;
        boolean flushHeaders = false;
        Http2Stream stream = null;
        int streamId = 0;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            boolean bl = false;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean $i$a$-synchronized-Http2Connection$newStream$1$22 = false;
                if (this.getNextStreamId$okhttp() > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.getNextStreamId$okhttp();
                this.setNextStreamId$okhttp(this.getNextStreamId$okhttp() + 2);
                stream = new Http2Stream(streamId, this, outFinished, inFinished, null);
                boolean bl2 = flushHeaders = !out || this.getWriteBytesTotal() >= this.getWriteBytesMaximum() || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.getStreams$okhttp().put(streamId, stream);
                }
                Unit $i$a$-synchronized-Http2Connection$newStream$1$22 = Unit.INSTANCE;
            }
            if (associatedStreamId == 0) {
                this.getWriter().headers(outFinished, streamId, requestHeaders);
            } else {
                if (!(!this.getClient$okhttp())) {
                    boolean bl3 = false;
                    String string = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(string.toString());
                }
                this.getWriter().pushPromise(associatedStreamId, streamId, requestHeaders);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (flushHeaders) {
            this.writer.flush();
        }
        return stream;
    }

    public final void writeHeaders$okhttp(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        Intrinsics.checkNotNullParameter(alternating, "alternating");
        this.writer.headers(outFinished, streamId, alternating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = 0L;
        byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite = 0;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean bl = false;
                try {
                    while (this.getWriteBytesTotal() >= this.getWriteBytesMaximum()) {
                        if (!this.getStreams$okhttp().containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        boolean $i$f$wait = false;
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                toWrite = (int)Math.min(byteCount2, this.getWriteBytesMaximum() - this.getWriteBytesTotal());
                toWrite = Math.min(toWrite, this.getWriter().maxDataLength());
                this.writeBytesTotal = this.getWriteBytesTotal() + (long)toWrite;
                Unit unit = Unit.INSTANCE;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] writeSynReset";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, errorCode){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException e) {
                    Http2Connection.access$failConnection(this.this$0, e);
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    public final void writeSynReset$okhttp(int streamId, ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)statusCode, "statusCode");
        this.writer.rstStream(streamId, statusCode);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        void this_$iv;
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] windowUpdate";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, unacknowledgedBytesRead){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$unacknowledgedBytesRead$inlined = l;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException e) {
                    Http2Connection.access$failConnection(this.this$0, e);
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            this.writer.ping(reply, payload1, payload2);
        }
        catch (IOException e) {
            this.failConnection(e);
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)statusCode, "statusCode");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            boolean bl = false;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean bl2 = false;
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.getLastGoodStreamId$okhttp();
                Unit unit = Unit.INSTANCE;
            }
            this.getWriter().goAway(lastGoodStreamId.element, statusCode, Util.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$okhttp(ErrorCode connectionCode, ErrorCode streamCode, IOException cause) {
        Intrinsics.checkNotNullParameter((Object)connectionCode, "connectionCode");
        Intrinsics.checkNotNullParameter((Object)streamCode, "streamCode");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        boolean $i$f$ignoreIoExceptions = false;
        try {
            boolean bl = false;
            this.shutdown(connectionCode);
        }
        catch (IOException iOException) {
        }
        Http2Stream[] streamsToClose = null;
        Http2Connection bl = this;
        synchronized (bl) {
            boolean $i$a$-synchronized-Http2Connection$close$32 = false;
            if (!this.getStreams$okhttp().isEmpty()) {
                Collection<Http2Stream> $this$toTypedArray$iv = this.getStreams$okhttp().values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                Http2Stream[] http2StreamArray = thisCollection$iv.toArray(new Http2Stream[0]);
                if (http2StreamArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                streamsToClose = http2StreamArray;
                this.getStreams$okhttp().clear();
            }
            Unit $i$a$-synchronized-Http2Connection$close$32 = Unit.INSTANCE;
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream element$iv;
                Http2Stream stream = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                boolean $i$f$ignoreIoExceptions2 = false;
                try {
                    boolean bl3 = false;
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {
                }
            }
        }
        boolean $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl4 = false;
            this.getWriter().close();
        }
        catch (IOException iOException) {
        }
        $i$f$ignoreIoExceptions3 = false;
        try {
            boolean bl5 = false;
            this.getSocket$okhttp().close();
        }
        catch (IOException iOException) {
        }
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    private final void failConnection(IOException e) {
        this.close$okhttp(ErrorCode.PROTOCOL_ERROR, ErrorCode.PROTOCOL_ERROR, e);
    }

    /*
     * WARNING - void declaration
     */
    public final void start(boolean sendConnectionPreface, TaskRunner taskRunner) throws IOException {
        void name$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                this.writer.windowUpdate(0, windowSize - 65535);
            }
        }
        TaskQueue windowSize = taskRunner.newQueue();
        String string = this.connectionName;
        Function0 block$iv = this.readerRunnable;
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task((String)name$iv, cancelable$iv, block$iv){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.$block = $block;
                super($name, $cancelable);
            }

            public long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, delayNanos$iv);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, TaskRunner taskRunner, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            taskRunner = TaskRunner.INSTANCE;
        }
        http2Connection.start(bl, taskRunner);
    }

    public final synchronized boolean isHealthy(long nowNs) {
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || nowNs < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void sendDegradedPingLater$okhttp() {
        void this_$iv;
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + (long)1000000000;
            Unit $i$a$-synchronized-Http2Connection$sendDegradedPingLater$2 = Unit.INSTANCE;
        }
        object = this.writerQueue;
        String name$iv = Intrinsics.stringPlus(this.connectionName, " ping");
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                super($name, $cancelable);
            }

            public long runOnce() {
                boolean bl = false;
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, delayNanos$iv);
    }

    public final boolean pushedStream$okhttp(int streamId) {
        return streamId != 0 && (streamId & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, List<Header> requestHeaders) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        Object object = this;
        synchronized (object) {
            boolean bl = false;
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            bl = this.currentPushRequests.add(streamId);
        }
        object = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onRequest";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, requestHeaders){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block5: {
                    boolean bl = false;
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId$inlined, this.$requestHeaders$inlined);
                    boolean $i$f$ignoreIoExceptions = false;
                    try {
                        boolean bl2 = false;
                        if (!cancel) break block5;
                        this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            boolean bl3 = false;
                            boolean bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, List<Header> requestHeaders, boolean inFinished) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onHeaders";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, requestHeaders, inFinished){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ List $requestHeaders$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block6: {
                    boolean bl = false;
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId$inlined, this.$requestHeaders$inlined, this.$inFinished$inlined);
                    boolean $i$f$ignoreIoExceptions = false;
                    try {
                        boolean bl2 = false;
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (!cancel && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            boolean bl3 = false;
                            boolean bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, BufferedSource source2, int byteCount, boolean inFinished) throws IOException {
        void this_$iv;
        Intrinsics.checkNotNullParameter(source2, "source");
        Buffer buffer = new Buffer();
        source2.require(byteCount);
        source2.read(buffer, byteCount);
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onData";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, buffer, byteCount, inFinished){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ Buffer $buffer$inlined;
            final /* synthetic */ int $byteCount$inlined;
            final /* synthetic */ boolean $inFinished$inlined;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n2;
                this.$inFinished$inlined = bl;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                block6: {
                    boolean bl = false;
                    boolean $i$f$ignoreIoExceptions = false;
                    try {
                        boolean bl2 = false;
                        boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onData(this.$streamId$inlined, this.$buffer$inlined, this.$byteCount$inlined, this.$inFinished$inlined);
                        if (cancel) {
                            this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                        }
                        if (!cancel && !this.$inFinished$inlined) break block6;
                        Http2Connection http2Connection = this.this$0;
                        synchronized (http2Connection) {
                            boolean bl3 = false;
                            boolean bl4 = Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onReset";
        long delayNanos$iv = 0L;
        boolean cancelable$iv = true;
        boolean $i$f$execute = false;
        this_$iv.schedule(new Task(name$iv, cancelable$iv, this, streamId, errorCode){
            final /* synthetic */ String $name;
            final /* synthetic */ boolean $cancelable;
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId$inlined;
            final /* synthetic */ ErrorCode $errorCode$inlined;
            {
                this.$name = $name;
                this.$cancelable = $cancelable;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super($name, $cancelable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long runOnce() {
                boolean bl = false;
                Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId$inlined, this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                synchronized (http2Connection) {
                    boolean bl2 = false;
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    Unit unit = Unit.INSTANCE;
                }
                return -1L;
            }
        }, delayNanos$iv);
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection $this) {
        return $this.intervalPingsSent;
    }

    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l) {
        $this.intervalPingsSent = l;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    static {
        Settings settings;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2d35 = settings = new Settings();
        boolean bl = false;
        $this$DEFAULT_SETTINGS_u24lambda_u2d35.set(7, 65535);
        $this$DEFAULT_SETTINGS_u24lambda_u2d35.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    public static final class Builder {
        private boolean client;
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        private Listener listener;
        private PushObserver pushObserver;
        private int pingIntervalMillis;

        public Builder(boolean client, TaskRunner taskRunner) {
            Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
            this.client = client;
            this.taskRunner = taskRunner;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket != null) {
                return socket;
            }
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            return null;
        }

        public final void setSocket$okhttp(Socket socket) {
            Intrinsics.checkNotNullParameter(socket, "<set-?>");
            this.socket = socket;
        }

        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("connectionName");
            return null;
        }

        public final void setConnectionName$okhttp(String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.connectionName = string;
        }

        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                return bufferedSource;
            }
            Intrinsics.throwUninitializedPropertyAccessException("source");
            return null;
        }

        public final void setSource$okhttp(BufferedSource bufferedSource) {
            Intrinsics.checkNotNullParameter(bufferedSource, "<set-?>");
            this.source = bufferedSource;
        }

        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                return bufferedSink;
            }
            Intrinsics.throwUninitializedPropertyAccessException("sink");
            return null;
        }

        public final void setSink$okhttp(BufferedSink bufferedSink) {
            Intrinsics.checkNotNullParameter(bufferedSink, "<set-?>");
            this.sink = bufferedSink;
        }

        public final Listener getListener$okhttp() {
            return this.listener;
        }

        public final void setListener$okhttp(Listener listener2) {
            Intrinsics.checkNotNullParameter(listener2, "<set-?>");
            this.listener = listener2;
        }

        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        public final void setPingIntervalMillis$okhttp(int n) {
            this.pingIntervalMillis = n;
        }

        public final Builder socket(Socket socket, String peerName, BufferedSource source2, BufferedSink sink2) throws IOException {
            Builder builder;
            Intrinsics.checkNotNullParameter(socket, "socket");
            Intrinsics.checkNotNullParameter(peerName, "peerName");
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(sink2, "sink");
            Builder $this$socket_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$socket_u24lambda_u2d0.setSocket$okhttp(socket);
            $this$socket_u24lambda_u2d0.setConnectionName$okhttp($this$socket_u24lambda_u2d0.getClient$okhttp() ? Util.okHttpName + ' ' + peerName : Intrinsics.stringPlus("MockWebServer ", peerName));
            $this$socket_u24lambda_u2d0.setSource$okhttp(source2);
            $this$socket_u24lambda_u2d0.setSink$okhttp(sink2);
            return builder;
        }

        public final Builder listener(Listener listener2) {
            Builder builder;
            Intrinsics.checkNotNullParameter(listener2, "listener");
            Builder $this$listener_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$listener_u24lambda_u2d1.setListener$okhttp(listener2);
            return builder;
        }

        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            Builder builder;
            Builder $this$pingIntervalMillis_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$pingIntervalMillis_u24lambda_u2d3.setPingIntervalMillis$okhttp(pingIntervalMillis);
            return builder;
        }

        public final Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        private final Http2Reader reader;

        public ReaderRunnable(Http2Reader reader) {
            Intrinsics.checkNotNullParameter(Http2Connection.this, "this$0");
            Intrinsics.checkNotNullParameter(reader, "reader");
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
            }
            catch (IOException e) {
                errorException = e;
                connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                streamErrorCode = ErrorCode.PROTOCOL_ERROR;
            }
            finally {
                Http2Connection.this.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                Util.closeQuietly(this.reader);
            }
        }

        @Override
        public void data(boolean inFinished, int streamId, BufferedSource source2, int length) throws IOException {
            Intrinsics.checkNotNullParameter(source2, "source");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushDataLater$okhttp(streamId, source2, length, inFinished);
                return;
            }
            Http2Stream dataStream = Http2Connection.this.getStream(streamId);
            if (dataStream == null) {
                Http2Connection.this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                Http2Connection.this.updateConnectionFlowControl$okhttp(length);
                source2.skip(length);
                return;
            }
            dataStream.receiveData(source2, length);
            if (inFinished) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void headers(boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock) {
            Intrinsics.checkNotNullParameter(headerBlock, "headerBlock");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Stream stream = null;
            Http2Connection http2Connection = Http2Connection.this;
            Http2Connection http2Connection2 = Http2Connection.this;
            Http2Connection http2Connection3 = http2Connection;
            synchronized (http2Connection3) {
                boolean bl = false;
                stream = http2Connection2.getStream(streamId);
                if (stream == null) {
                    void this_$iv;
                    if (http2Connection2.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection2.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection2.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Headers headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection2, false, inFinished, headers);
                    http2Connection2.setLastGoodStreamId$okhttp(streamId);
                    Object object = http2Connection2.getStreams$okhttp();
                    Integer n = streamId;
                    object.put((Integer)n, (Http2Stream)newStream);
                    object = http2Connection2.taskRunner.newQueue();
                    String name$iv = http2Connection2.getConnectionName$okhttp() + '[' + streamId + "] onStream";
                    long delayNanos$iv = 0L;
                    boolean cancelable$iv = true;
                    boolean $i$f$execute = false;
                    this_$iv.schedule(new Task(name$iv, cancelable$iv, http2Connection2, newStream){
                        final /* synthetic */ String $name;
                        final /* synthetic */ boolean $cancelable;
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Http2Stream $newStream$inlined;
                        {
                            this.$name = $name;
                            this.$cancelable = $cancelable;
                            this.this$0 = http2Connection;
                            this.$newStream$inlined = http2Stream;
                            super($name, $cancelable);
                        }

                        public long runOnce() {
                            boolean bl = false;
                            try {
                                this.this$0.getListener$okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException e) {
                                Platform.Companion.get().log(Intrinsics.stringPlus("Http2Connection.Listener failure for ", this.this$0.getConnectionName$okhttp()), 4, e);
                                boolean $i$f$ignoreIoExceptions = false;
                                try {
                                    boolean bl2 = false;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, e);
                                }
                                catch (IOException iOException) {
                                }
                            }
                            return -1L;
                        }
                    }, delayNanos$iv);
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            stream.receiveHeaders(Util.toHeaders(headerBlock), inFinished);
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            Http2Stream rstStream;
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            if (Http2Connection.this.pushedStream$okhttp(streamId)) {
                Http2Connection.this.pushResetLater$okhttp(streamId, errorCode);
                return;
            }
            Http2Stream http2Stream = rstStream = Http2Connection.this.removeStream$okhttp(streamId);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void settings(boolean clearPrevious, Settings settings) {
            void this_$iv;
            Intrinsics.checkNotNullParameter(settings, "settings");
            TaskQueue taskQueue = Http2Connection.this.writerQueue;
            String name$iv = Intrinsics.stringPlus(Http2Connection.this.getConnectionName$okhttp(), " applyAndAckSettings");
            long delayNanos$iv = 0L;
            boolean cancelable$iv = true;
            boolean $i$f$execute = false;
            this_$iv.schedule(new Task(name$iv, cancelable$iv, this, clearPrevious, settings){
                final /* synthetic */ String $name;
                final /* synthetic */ boolean $cancelable;
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious$inlined;
                final /* synthetic */ Settings $settings$inlined;
                {
                    this.$name = $name;
                    this.$cancelable = $cancelable;
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl;
                    this.$settings$inlined = settings;
                    super($name, $cancelable);
                }

                public long runOnce() {
                    boolean bl = false;
                    this.this$0.applyAndAckSettings(this.$clearPrevious$inlined, this.$settings$inlined);
                    return -1L;
                }
            }, delayNanos$iv);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void applyAndAckSettings(boolean clearPrevious, Settings settings) {
            Object object;
            Intrinsics.checkNotNullParameter(settings, "settings");
            long delta = 0L;
            Http2Stream[] streamsToNotify = null;
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray = Http2Connection.this.getWriter();
            Http2Connection http2Connection = Http2Connection.this;
            Http2Stream[] http2StreamArray2 = http2StreamArray;
            synchronized (http2StreamArray2) {
                boolean $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$32 = false;
                object = http2Connection;
                synchronized (object) {
                    void this_$iv;
                    Http2Stream[] http2StreamArray3;
                    Settings settings2;
                    boolean $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$1$22 = false;
                    Settings previousPeerSettings = http2Connection.getPeerSettings();
                    Ref.ObjectRef objectRef = newPeerSettings;
                    if (clearPrevious) {
                        settings2 = settings;
                    } else {
                        void $this$applyAndAckSettings_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d4;
                        Settings settings3;
                        Settings settings4 = settings3 = new Settings();
                        Ref.ObjectRef objectRef2 = objectRef;
                        boolean bl = false;
                        $this$applyAndAckSettings_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d4.merge(previousPeerSettings);
                        $this$applyAndAckSettings_u24lambda_u2d7_u24lambda_u2d6_u24lambda_u2d4.merge(settings);
                        objectRef = objectRef2;
                        settings2 = settings3;
                    }
                    objectRef.element = settings2;
                    long peerInitialWindowSize = ((Settings)newPeerSettings.element).getInitialWindowSize();
                    delta = peerInitialWindowSize - (long)previousPeerSettings.getInitialWindowSize();
                    if (delta == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                        http2StreamArray3 = null;
                    } else {
                        Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$okhttp().values();
                        boolean $i$f$toTypedArray = false;
                        Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                        Http2Stream[] http2StreamArray4 = thisCollection$iv.toArray(new Http2Stream[0]);
                        if (http2StreamArray4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        http2StreamArray3 = http2StreamArray4;
                    }
                    streamsToNotify = http2StreamArray3;
                    http2Connection.setPeerSettings((Settings)newPeerSettings.element);
                    TaskQueue $this$toTypedArray$iv = http2Connection.settingsListenerQueue;
                    String name$iv = Intrinsics.stringPlus(http2Connection.getConnectionName$okhttp(), " onSettings");
                    long delayNanos$iv = 0L;
                    boolean cancelable$iv = true;
                    boolean $i$f$execute = false;
                    this_$iv.schedule(new Task(name$iv, cancelable$iv, http2Connection, newPeerSettings){
                        final /* synthetic */ String $name;
                        final /* synthetic */ boolean $cancelable;
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                        {
                            this.$name = $name;
                            this.$cancelable = $cancelable;
                            this.this$0 = http2Connection;
                            this.$newPeerSettings$inlined = objectRef;
                            super($name, $cancelable);
                        }

                        public long runOnce() {
                            boolean bl = false;
                            this.this$0.getListener$okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings$inlined.element);
                            return -1L;
                        }
                    }, delayNanos$iv);
                    Unit $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$1$22 = Unit.INSTANCE;
                }
                try {
                    http2Connection.getWriter().applyAndAckSettings((Settings)newPeerSettings.element);
                }
                catch (IOException e) {
                    http2Connection.failConnection(e);
                }
                Unit $i$a$-synchronized-Http2Connection$ReaderRunnable$applyAndAckSettings$32 = Unit.INSTANCE;
            }
            if (streamsToNotify != null) {
                for (Http2Stream stream : streamsToNotify) {
                    object = stream;
                    synchronized (object) {
                        boolean bl = false;
                        stream.addBytesToWriteWindow(delta);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            if (ack) {
                Http2Connection http2Connection = Http2Connection.this;
                Http2Connection http2Connection2 = Http2Connection.this;
                Http2Connection http2Connection3 = http2Connection;
                synchronized (http2Connection3) {
                    Object object;
                    boolean bl = false;
                    switch (payload1) {
                        case 1: {
                            long l = http2Connection2.intervalPongsReceived;
                            http2Connection2.intervalPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 2: {
                            long l = http2Connection2.degradedPongsReceived;
                            http2Connection2.degradedPongsReceived = l + 1L;
                            object = l;
                            break;
                        }
                        case 3: {
                            long l = http2Connection2.awaitPongsReceived;
                            http2Connection2.awaitPongsReceived = l + 1L;
                            Http2Connection $this$notifyAll$iv = http2Connection2;
                            boolean $i$f$notifyAll = false;
                            ((Object)$this$notifyAll$iv).notifyAll();
                            object = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            object = Unit.INSTANCE;
                        }
                    }
                    Unit unit = object;
                }
            } else {
                void name$iv;
                void this_$iv;
                TaskQueue taskQueue = Http2Connection.this.writerQueue;
                String string = Intrinsics.stringPlus(Http2Connection.this.getConnectionName$okhttp(), " ping");
                Http2Connection http2Connection = Http2Connection.this;
                long delayNanos$iv = 0L;
                boolean cancelable$iv = true;
                boolean $i$f$execute = false;
                this_$iv.schedule(new Task((String)name$iv, cancelable$iv, http2Connection, payload1, payload2){
                    final /* synthetic */ String $name;
                    final /* synthetic */ boolean $cancelable;
                    final /* synthetic */ Http2Connection this$0;
                    final /* synthetic */ int $payload1$inlined;
                    final /* synthetic */ int $payload2$inlined;
                    {
                        this.$name = $name;
                        this.$cancelable = $cancelable;
                        this.this$0 = http2Connection;
                        this.$payload1$inlined = n;
                        this.$payload2$inlined = n2;
                        super($name, $cancelable);
                    }

                    public long runOnce() {
                        boolean bl = false;
                        this.this$0.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                        return -1L;
                    }
                }, delayNanos$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            Intrinsics.checkNotNullParameter(debugData, "debugData");
            if (debugData.size() > 0) {
                // empty if block
            }
            Http2Stream[] streamsCopy = null;
            Http2Stream[] http2StreamArray = Http2Connection.this;
            Http2Connection http2Connection = Http2Connection.this;
            Http2Stream[] http2StreamArray2 = http2StreamArray;
            synchronized (http2StreamArray2) {
                boolean $i$a$-synchronized-Http2Connection$ReaderRunnable$goAway$22 = false;
                Collection<Http2Stream> $this$toTypedArray$iv = http2Connection.getStreams$okhttp().values();
                boolean $i$f$toTypedArray = false;
                Collection<Http2Stream> thisCollection$iv = $this$toTypedArray$iv;
                Http2Stream[] http2StreamArray3 = thisCollection$iv.toArray(new Http2Stream[0]);
                if (http2StreamArray3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                streamsCopy = http2StreamArray3;
                http2Connection.isShutdown = true;
                Unit $i$a$-synchronized-Http2Connection$ReaderRunnable$goAway$22 = Unit.INSTANCE;
            }
            for (Http2Stream http2Stream : streamsCopy) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                Http2Connection.this.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long windowSizeIncrement) {
            if (streamId == 0) {
                Http2Connection http2Connection = Http2Connection.this;
                Http2Connection http2Connection2 = Http2Connection.this;
                Http2Connection http2Connection3 = http2Connection;
                synchronized (http2Connection3) {
                    boolean bl = false;
                    http2Connection2.writeBytesMaximum = http2Connection2.getWriteBytesMaximum() + windowSizeIncrement;
                    Http2Connection $this$notifyAll$iv = http2Connection2;
                    boolean $i$f$notifyAll = false;
                    ((Object)$this$notifyAll$iv).notifyAll();
                    Unit unit = Unit.INSTANCE;
                }
            }
            Http2Stream stream = Http2Connection.this.getStream(streamId);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    boolean bl = false;
                    stream.addBytesToWriteWindow(windowSizeIncrement);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            Intrinsics.checkNotNullParameter(requestHeaders, "requestHeaders");
            Http2Connection.this.pushRequestLater$okhttp(promisedStreamId, requestHeaders);
        }
    }

    public static abstract class Listener {
        public static final Companion Companion = new Companion(null);
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            public void onStream(Http2Stream stream) throws IOException {
                Intrinsics.checkNotNullParameter(stream, "stream");
                stream.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection connection, Settings settings) {
            Intrinsics.checkNotNullParameter(connection, "connection");
            Intrinsics.checkNotNullParameter(settings, "settings");
        }

        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

