/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.modules.SerializersModule;

public final class WriteModeKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final WriteMode switchMode(Json $this$switchMode, SerialDescriptor desc) {
        WriteMode writeMode;
        Intrinsics.checkNotNullParameter($this$switchMode, "<this>");
        Intrinsics.checkNotNullParameter(desc, "desc");
        SerialKind serialKind = desc.getKind();
        if (serialKind instanceof PolymorphicKind) {
            writeMode = WriteMode.POLY_OBJ;
            return writeMode;
        } else if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            writeMode = WriteMode.LIST;
            return writeMode;
        } else if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            Json $this$selectMapMode$iv = $this$switchMode;
            boolean $i$f$selectMapMode = false;
            SerialDescriptor keyDescriptor$iv = WriteModeKt.carrierDescriptor(desc.getElementDescriptor(0), $this$selectMapMode$iv.getSerializersModule());
            SerialKind keyKind$iv = keyDescriptor$iv.getKind();
            if (keyKind$iv instanceof PrimitiveKind || Intrinsics.areEqual(keyKind$iv, SerialKind.ENUM.INSTANCE)) {
                boolean bl = false;
                writeMode = WriteMode.MAP;
                return writeMode;
            } else {
                if (!$this$selectMapMode$iv.getConfiguration().getAllowStructuredMapKeys()) throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor$iv);
                boolean bl = false;
                writeMode = WriteMode.LIST;
            }
            return writeMode;
        } else {
            writeMode = WriteMode.OBJ;
        }
        return writeMode;
    }

    public static final SerialDescriptor carrierDescriptor(SerialDescriptor $this$carrierDescriptor, SerializersModule module) {
        SerialDescriptor serialDescriptor;
        Intrinsics.checkNotNullParameter($this$carrierDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(module, "module");
        if (Intrinsics.areEqual($this$carrierDescriptor.getKind(), SerialKind.CONTEXTUAL.INSTANCE)) {
            serialDescriptor = ContextAwareKt.getContextualDescriptor(module, $this$carrierDescriptor);
            if (serialDescriptor == null || (serialDescriptor = WriteModeKt.carrierDescriptor(serialDescriptor, module)) == null) {
                serialDescriptor = $this$carrierDescriptor;
            }
        } else {
            serialDescriptor = $this$carrierDescriptor.isInline() ? WriteModeKt.carrierDescriptor($this$carrierDescriptor.getElementDescriptor(0), module) : $this$carrierDescriptor;
        }
        return serialDescriptor;
    }
}

