/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecodingException;
import kotlinx.serialization.json.internal.JsonEncodingException;

public final class JsonExceptionsKt {
    public static final JsonDecodingException JsonDecodingException(int offset, String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return new JsonDecodingException(offset >= 0 ? "Unexpected JSON token at offset " + offset + ": " + message : message);
    }

    public static final JsonDecodingException JsonDecodingException(int offset, String message, CharSequence input) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(input, "input");
        return JsonExceptionsKt.JsonDecodingException(offset, message + "\nJSON input: " + JsonExceptionsKt.minify(input, offset));
    }

    public static final JsonEncodingException InvalidFloatingPointEncoded(Number value, String output) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(output, "output");
        return new JsonEncodingException("Unexpected special floating-point value " + value + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output, 0, 1, null));
    }

    public static final Void throwInvalidFloatingPointDecoded(AbstractJsonLexer $this$throwInvalidFloatingPointDecoded, Number result2) {
        Intrinsics.checkNotNullParameter($this$throwInvalidFloatingPointDecoded, "<this>");
        Intrinsics.checkNotNullParameter(result2, "result");
        AbstractJsonLexer.fail$default($this$throwInvalidFloatingPointDecoded, "Unexpected special floating-point value " + result2 + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification", 0, "It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'", 2, null);
        throw new KotlinNothingValueException();
    }

    public static final Void invalidTrailingComma(AbstractJsonLexer $this$invalidTrailingComma, String entity) {
        Intrinsics.checkNotNullParameter($this$invalidTrailingComma, "<this>");
        Intrinsics.checkNotNullParameter(entity, "entity");
        $this$invalidTrailingComma.fail("Trailing comma before the end of JSON " + entity, $this$invalidTrailingComma.currentPosition - 1, "Trailing commas are non-complaint JSON and not allowed by default. Use 'allowTrailingCommas = true' in 'Json {}' builder to support them.");
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Void invalidTrailingComma$default(AbstractJsonLexer abstractJsonLexer, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "object";
        }
        return JsonExceptionsKt.invalidTrailingComma(abstractJsonLexer, string);
    }

    public static final JsonEncodingException InvalidKeyKindException(SerialDescriptor keyDescriptor) {
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        return new JsonEncodingException("Value of type '" + keyDescriptor.getSerialName() + "' can't be used in JSON as a key in the map. It should have either primitive or enum kind, but its kind is '" + keyDescriptor.getKind() + "'.\nUse 'allowStructuredMapKeys = true' in 'Json {}' builder to convert such maps to [key1, value1, key2, value2,...] arrays.");
    }

    public static final JsonDecodingException InvalidFloatingPointDecoded(Number value, String key, String output) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(output, "output");
        return JsonExceptionsKt.JsonDecodingException(-1, JsonExceptionsKt.unexpectedFpErrorMessage(value, key, output));
    }

    private static final String unexpectedFpErrorMessage(Number value, String key, String output) {
        return "Unexpected special floating-point value " + value + " with key " + key + ". By default, non-finite floating point values are prohibited because they do not conform JSON specification. It is possible to deserialize them using 'JsonBuilder.allowSpecialFloatingPointValues = true'\nCurrent output: " + JsonExceptionsKt.minify$default(output, 0, 1, null);
    }

    public static final JsonDecodingException UnknownKeyException(String key, String input) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(input, "input");
        return JsonExceptionsKt.JsonDecodingException(-1, "Encountered an unknown key '" + key + "'.\nUse 'ignoreUnknownKeys = true' in 'Json {}' builder to ignore unknown keys.\nCurrent input: " + JsonExceptionsKt.minify$default(input, 0, 1, null));
    }

    public static final CharSequence minify(CharSequence $this$minify, int offset) {
        Intrinsics.checkNotNullParameter($this$minify, "<this>");
        if ($this$minify.length() < 200) {
            return $this$minify;
        }
        if (offset == -1) {
            int start = $this$minify.length() - 60;
            if (start <= 0) {
                return $this$minify;
            }
            CharSequence charSequence = $this$minify;
            int n = charSequence.length();
            return "....." + ((Object)charSequence.subSequence(start, n)).toString();
        }
        int start = offset - 30;
        int end = offset + 30;
        String prefix = start <= 0 ? "" : ".....";
        String suffix = end >= $this$minify.length() ? "" : ".....";
        return prefix + ((Object)$this$minify.subSequence(RangesKt.coerceAtLeast(start, 0), RangesKt.coerceAtMost(end, $this$minify.length()))).toString() + suffix;
    }

    public static /* synthetic */ CharSequence minify$default(CharSequence charSequence, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return JsonExceptionsKt.minify(charSequence, n);
    }
}

