/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonEncoder;

public final class JsonElementSerializersKt {
    private static final void verify(Encoder encoder) {
        JsonElementSerializersKt.asJsonEncoder(encoder);
    }

    private static final void verify(Decoder decoder) {
        JsonElementSerializersKt.asJsonDecoder(decoder);
    }

    public static final JsonDecoder asJsonDecoder(Decoder $this$asJsonDecoder) {
        Intrinsics.checkNotNullParameter($this$asJsonDecoder, "<this>");
        JsonDecoder jsonDecoder = $this$asJsonDecoder instanceof JsonDecoder ? (JsonDecoder)$this$asJsonDecoder : null;
        if (jsonDecoder == null) {
            throw new IllegalStateException("This serializer can be used only with Json format.Expected Decoder to be JsonDecoder, got " + Reflection.getOrCreateKotlinClass($this$asJsonDecoder.getClass()));
        }
        return jsonDecoder;
    }

    public static final JsonEncoder asJsonEncoder(Encoder $this$asJsonEncoder) {
        Intrinsics.checkNotNullParameter($this$asJsonEncoder, "<this>");
        JsonEncoder jsonEncoder = $this$asJsonEncoder instanceof JsonEncoder ? (JsonEncoder)$this$asJsonEncoder : null;
        if (jsonEncoder == null) {
            throw new IllegalStateException("This serializer can be used only with Json format.Expected Encoder to be JsonEncoder, got " + Reflection.getOrCreateKotlinClass($this$asJsonEncoder.getClass()));
        }
        return jsonEncoder;
    }

    private static final SerialDescriptor defer(Function0<? extends SerialDescriptor> deferred) {
        return new SerialDescriptor(deferred){
            private final Lazy original$delegate;
            {
                this.original$delegate = LazyKt.lazy($deferred);
            }

            private final SerialDescriptor getOriginal() {
                Lazy lazy = this.original$delegate;
                return (SerialDescriptor)lazy.getValue();
            }

            public String getSerialName() {
                return this.getOriginal().getSerialName();
            }

            public SerialKind getKind() {
                return this.getOriginal().getKind();
            }

            public int getElementsCount() {
                return this.getOriginal().getElementsCount();
            }

            public String getElementName(int index) {
                return this.getOriginal().getElementName(index);
            }

            public int getElementIndex(String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                return this.getOriginal().getElementIndex(name);
            }

            public List<Annotation> getElementAnnotations(int index) {
                return this.getOriginal().getElementAnnotations(index);
            }

            public SerialDescriptor getElementDescriptor(int index) {
                return this.getOriginal().getElementDescriptor(index);
            }

            public boolean isElementOptional(int index) {
                return this.getOriginal().isElementOptional(index);
            }

            public boolean isNullable() {
                return SerialDescriptor.DefaultImpls.isNullable(this);
            }

            public boolean isInline() {
                return SerialDescriptor.DefaultImpls.isInline(this);
            }

            public List<Annotation> getAnnotations() {
                return SerialDescriptor.DefaultImpls.getAnnotations(this);
            }
        };
    }

    public static final /* synthetic */ void access$verify(Encoder encoder) {
        JsonElementSerializersKt.verify(encoder);
    }

    public static final /* synthetic */ SerialDescriptor access$defer(Function0 deferred) {
        return JsonElementSerializersKt.defer(deferred);
    }

    public static final /* synthetic */ void access$verify(Decoder decoder) {
        JsonElementSerializersKt.verify(decoder);
    }
}

