/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;

public final class PrimitiveSerialDescriptor
implements SerialDescriptor {
    private final String serialName;
    private final PrimitiveKind kind;

    public PrimitiveSerialDescriptor(String serialName, PrimitiveKind kind) {
        Intrinsics.checkNotNullParameter(serialName, "serialName");
        Intrinsics.checkNotNullParameter(kind, "kind");
        this.serialName = serialName;
        this.kind = kind;
    }

    @Override
    public String getSerialName() {
        return this.serialName;
    }

    @Override
    public PrimitiveKind getKind() {
        return this.kind;
    }

    @Override
    public int getElementsCount() {
        return 0;
    }

    @Override
    public String getElementName(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public int getElementIndex(String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public boolean isElementOptional(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public SerialDescriptor getElementDescriptor(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    @Override
    public List<Annotation> getElementAnnotations(int index) {
        this.error();
        throw new KotlinNothingValueException();
    }

    public String toString() {
        return "PrimitiveDescriptor(" + this.getSerialName() + ')';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrimitiveSerialDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual(this.getSerialName(), ((PrimitiveSerialDescriptor)other).getSerialName()) && Intrinsics.areEqual(this.getKind(), ((PrimitiveSerialDescriptor)other).getKind());
    }

    public int hashCode() {
        return this.getSerialName().hashCode() + 31 * this.getKind().hashCode();
    }

    private final Void error() {
        throw new IllegalStateException("Primitive descriptor does not have elements");
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isInline() {
        return SerialDescriptor.DefaultImpls.isInline(this);
    }

    @Override
    public List<Annotation> getAnnotations() {
        return SerialDescriptor.DefaultImpls.getAnnotations(this);
    }
}

