/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.api;

import com.apollographql.apollo.api.Adapter;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import kotlin.jvm.internal.Intrinsics;

public final class NullableAdapter<T>
implements Adapter<T> {
    private final Adapter<T> wrappedAdapter;

    public NullableAdapter(Adapter<T> wrappedAdapter) {
        Intrinsics.checkNotNullParameter(wrappedAdapter, "wrappedAdapter");
        this.wrappedAdapter = wrappedAdapter;
        if (!(!(this.wrappedAdapter instanceof NullableAdapter))) {
            boolean bl = false;
            String string = "The adapter is already nullable";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public T fromJson(JsonReader reader, CustomScalarAdapters customScalarAdapters) {
        T t;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        if (reader.peek() == JsonReader.Token.NULL) {
            reader.skipValue();
            t = null;
        } else {
            t = this.wrappedAdapter.fromJson(reader, customScalarAdapters);
        }
        return t;
    }

    @Override
    public void toJson(JsonWriter writer, CustomScalarAdapters customScalarAdapters, T value) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(customScalarAdapters, "customScalarAdapters");
        if (value == null) {
            writer.nullValue();
        } else {
            this.wrappedAdapter.toJson(writer, customScalarAdapters, value);
        }
    }
}

