/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Objects;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long groupHandle;
    long labelHandle;
    long imageHandle;
    long boxHandle;
    int accelerator;
    int userId;
    String toolTipText;
    Image defaultDisableImage;
    boolean enabled = true;
    long modelHandle;
    long actionHandle;
    long shortcutHandle;
    Menu.Section section;
    String actionName;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (0 > index || index > count) {
            this.error(6);
        }
        this.createWidget(index);
    }

    void addAccelerator(long accelGroup) {
        this.updateAccelerator(accelGroup, true);
    }

    void addAccelerators(long accelGroup) {
        this.addAccelerator(accelGroup);
        if (this.menu != null) {
            this.menu.addAccelerators(accelGroup);
        }
    }

    public void addArmListener(ArmListener listener) {
        this.addTypedListener(listener, 30);
    }

    public void addHelpListener(HelpListener listener) {
        this.addTypedListener(listener, 28);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        int bits = 122;
        if (GTK.GTK4) {
            switch (this.style & bits) {
                case 2: {
                    this.modelHandle = OS.g_menu_new();
                    this.handle = OS.g_menu_item_new_section(null, this.modelHandle);
                    break;
                }
                case 16: {
                    long stringVariantType = OS.g_variant_type_new(OS.G_VARIANT_TYPE_STRING);
                    this.actionHandle = OS.g_simple_action_new_stateful(Converter.javaStringToCString(String.valueOf(this.hashCode())), stringVariantType, OS.g_variant_new_string(Converter.javaStringToCString("untoggled")));
                    OS.g_action_map_add_action(this.parent.actionGroup, this.actionHandle);
                    this.actionName = String.valueOf(this.parent.hashCode()) + "." + String.valueOf(this.hashCode()) + "::toggled";
                    this.handle = OS.g_menu_item_new(null, Converter.javaStringToCString(this.actionName));
                    OS.g_variant_type_free(stringVariantType);
                    break;
                }
                case 32: {
                    long boolVariantType = OS.g_variant_type_new(OS.G_VARIANT_TYPE_BOOLEAN);
                    this.actionHandle = OS.g_simple_action_new_stateful(Converter.javaStringToCString(String.valueOf(this.hashCode())), 0L, OS.g_variant_new_boolean(false));
                    OS.g_action_map_add_action(this.parent.actionGroup, this.actionHandle);
                    this.actionName = String.valueOf(this.parent.hashCode()) + "." + String.valueOf(this.hashCode());
                    this.handle = OS.g_menu_item_new(null, Converter.javaStringToCString(this.actionName));
                    OS.g_variant_type_free(boolVariantType);
                    break;
                }
                case 64: {
                    this.modelHandle = OS.g_menu_new();
                    this.handle = OS.g_menu_item_new_submenu(Converter.javaStringToCString(""), this.modelHandle);
                    break;
                }
                default: {
                    this.actionHandle = OS.g_simple_action_new(Converter.javaStringToCString(String.valueOf(this.hashCode())), 0L);
                    OS.g_action_map_add_action(this.parent.actionGroup, this.actionHandle);
                    this.actionName = String.valueOf(this.parent.hashCode()) + "." + String.valueOf(this.hashCode());
                    this.handle = OS.g_menu_item_new(null, Converter.javaStringToCString(this.actionName));
                }
            }
            Menu.Section selectedSection = this.parent.sections.getLast();
            for (Menu.Section section : this.parent.sections) {
                int sectionPosition = section.getSectionPosition();
                int sectionLength = section.getSectionSize();
                if (index <= sectionPosition || index > sectionPosition + sectionLength + 1) continue;
                selectedSection = section;
                break;
            }
            int sectionRelativeIndex = index - (selectedSection.getSectionPosition() + 1);
            if ((this.style & 2) != 0) {
                Menu menu = this.parent;
                Objects.requireNonNull(menu);
                this.section = menu.new Menu.Section(this);
                int itemsToMove = selectedSection.sectionItems.size() - sectionRelativeIndex;
                for (int i = 0; i < itemsToMove; ++i) {
                    MenuItem removedItem = selectedSection.sectionItems.remove(sectionRelativeIndex);
                    this.section.sectionItems.add(removedItem);
                    OS.g_menu_remove(selectedSection.getSectionHandle(), sectionRelativeIndex);
                    OS.g_menu_insert_item(this.modelHandle, this.section.sectionItems.indexOf(removedItem), removedItem.handle);
                    removedItem.section = this.section;
                }
                int sectionInsertIndex = this.parent.sections.indexOf(selectedSection) + 1;
                this.parent.sections.add(sectionInsertIndex, this.section);
                OS.g_menu_insert_item(this.parent.modelHandle, sectionInsertIndex, this.handle);
            } else {
                this.section = selectedSection;
                selectedSection.sectionItems.add(sectionRelativeIndex, this);
                OS.g_menu_insert_item(selectedSection.getSectionHandle(), sectionRelativeIndex, this.handle);
            }
            this.parent.items.add(index, this);
        } else {
            long parentHandle;
            boolean enabled;
            byte[] buffer = new byte[1];
            switch (this.style & bits) {
                case 2: {
                    this.handle = GTK3.gtk_separator_menu_item_new();
                    if (this.handle != 0L) break;
                    this.error(2);
                    break;
                }
                case 16: {
                    this.groupHandle = GTK3.gtk_radio_menu_item_new(0L);
                    if (this.groupHandle == 0L) {
                        this.error(2);
                    }
                    OS.g_object_ref_sink(this.groupHandle);
                    long group = GTK3.gtk_radio_menu_item_get_group(this.groupHandle);
                    this.handle = GTK3.gtk_radio_menu_item_new(group);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(buffer);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                case 32: {
                    this.handle = GTK3.gtk_check_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(buffer);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                case 64: {
                    this.handle = GTK3.gtk_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(buffer);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if ((this.parent.style & bits) == 2 || !OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                    break;
                }
                default: {
                    this.handle = GTK3.gtk_menu_item_new();
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    this.labelHandle = GTK3.gtk_accel_label_new(buffer);
                    if (this.labelHandle == 0L) {
                        this.error(2);
                    }
                    this.boxHandle = this.gtk_box_new(0, false, 6);
                    if (this.boxHandle == 0L) {
                        this.error(2);
                    }
                    if (!OS.SWT_PADDED_MENU_ITEMS) break;
                    this.imageHandle = GTK.gtk_image_new();
                    if (this.imageHandle != 0L) break;
                    this.error(2);
                }
            }
            if (this.imageHandle != 0L) {
                if (OS.SWT_PADDED_MENU_ITEMS) {
                    GTK.gtk_image_set_pixel_size(this.imageHandle, 16);
                }
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK.gtk_widget_show(this.imageHandle);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_label_set_xalign(this.labelHandle, 0.0f);
                GTK.gtk_widget_set_halign(this.labelHandle, 0);
                this.gtk_box_pack_end(this.boxHandle, this.labelHandle, true, true, 0);
                GTK.gtk_widget_show(this.labelHandle);
            }
            if (this.boxHandle != 0L) {
                GTK3.gtk_container_add(this.handle, this.boxHandle);
                GTK.gtk_widget_show(this.boxHandle);
            }
            if ((this.style & 2) == 0) {
                if (this.boxHandle == 0L) {
                    this.labelHandle = GTK3.gtk_bin_get_child(this.handle);
                }
                GTK3.gtk_accel_label_set_accel_widget(this.labelHandle, 0L);
            }
            if (!(enabled = GTK.gtk_widget_get_sensitive(parentHandle = this.parent.handle))) {
                GTK.gtk_widget_set_sensitive(parentHandle, true);
            }
            GTK3.gtk_menu_shell_insert(parentHandle, this.handle, index);
            if (!enabled) {
                GTK.gtk_widget_set_sensitive(parentHandle, false);
            }
            GTK.gtk_widget_show(this.handle);
        }
    }

    void fixMenus(Decorations newParent) {
        if (this.menu != null && !this.menu.isDisposed() && !newParent.isDisposed()) {
            this.menu.fixMenus(newParent);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    long getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return 0L;
        }
        Decorations shell = menu.parent;
        if (shell == null) {
            return 0L;
        }
        return shell.menuBar == menu ? shell.accelGroup : 0L;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (GTK.GTK4) {
            if ((this.style & 0x40) != 0) {
                return true;
            }
            return OS.g_action_get_enabled(this.actionHandle);
        }
        return GTK.gtk_widget_get_sensitive(this.handle);
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if (GTK.GTK4) {
            long gVariantState = OS.g_action_get_state(this.actionHandle);
            if ((this.style & 0x20) != 0) {
                return OS.g_variant_get_boolean(gVariantState);
            }
            String stateString = Converter.cCharPtrToJavaString(OS.g_variant_get_string(gVariantState, null), false);
            return stateString.equals("toggled");
        }
        return GTK3.gtk_check_menu_item_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_activate(long widget) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0L;
        }
        if (!GTK.GTK4 && !this.isEnabled()) {
            return 0L;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    long gtk_select(long item) {
        this.parent.selectedItem = this;
        this.sendEvent(30);
        return 0L;
    }

    @Override
    long gtk3_show_help(long widget, long helpType) {
        boolean handled = this.hooks(28);
        if (handled) {
            this.postEvent(28);
        } else {
            handled = this.parent.sendHelpEvent(helpType);
        }
        if (handled) {
            GTK3.gtk_menu_shell_deactivate(this.parent.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4) {
            if ((this.style & 8) != 0 || (this.style & 0x10) != 0) {
                OS.g_signal_connect(this.actionHandle, OS.activate, this.display.activateProc, this.handle);
            }
        } else {
            OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.handle, OS.select, this.display.getClosure(44), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
        }
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
            this.menu = null;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (GTK.GTK4) {
            if (this.parent.actionGroup != 0L && this.actionName != null) {
                OS.g_action_map_remove_action(this.parent.actionGroup, Converter.javaStringToCString(this.actionName));
            }
        } else {
            long accelGroup = this.getAccelGroup();
            if (accelGroup != 0L) {
                this.removeAccelerator(accelGroup);
            }
            if (this.groupHandle != 0L) {
                OS.g_object_unref(this.groupHandle);
            }
            this.groupHandle = 0L;
            this.parent = null;
        }
        this.accelerator = 0;
        this.disposeDefaultDisabledImage();
    }

    @Override
    void destroyWidget() {
        if (GTK.GTK4) {
            if ((this.style & 2) != 0) {
                Menu.Section aboveSection = this.parent.sections.get(this.parent.sections.indexOf(this.section) - 1);
                aboveSection.sectionItems.addAll(this.section.sectionItems);
                for (MenuItem item : this.section.sectionItems) {
                    OS.g_menu_insert_item(aboveSection.getSectionHandle(), aboveSection.sectionItems.indexOf(item), item.handle);
                }
                OS.g_menu_remove(this.parent.modelHandle, this.parent.sections.indexOf(this.section));
                this.parent.sections.remove(this.section);
            } else {
                OS.g_menu_remove(this.section.getSectionHandle(), this.section.sectionItems.indexOf(this));
                this.section.sectionItems.remove(this);
            }
            this.parent.items.remove(this);
            this.parent = null;
            if (this.modelHandle != 0L) {
                OS.g_object_unref(this.modelHandle);
            }
            OS.g_object_unref(this.handle);
            this.releaseHandle();
        } else {
            super.destroyWidget();
        }
    }

    void removeAccelerator(long accelGroup) {
        this.updateAccelerator(accelGroup, false);
    }

    void removeAccelerators(long accelGroup) {
        this.removeAccelerator(accelGroup);
        if (this.menu != null) {
            this.menu.removeAccelerators(accelGroup);
        }
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void selectRadio() {
        MenuItem[] items = this.parent.getItems();
        for (int index = 0; index < items.length && items[index] != this; ++index) {
        }
        for (int i = index - 1; i >= 0 && items[i].setRadioSelection(false); --i) {
        }
        for (int j = index + 1; j < items.length && items[j].setRadioSelection(false); ++j) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        if (GTK.GTK4) {
            if (this.shortcutHandle != 0L) {
                GTK4.gtk_shortcut_controller_remove_shortcut(this.parent.shortcutController, this.shortcutHandle);
                this.shortcutHandle = 0L;
            }
            this.accelerator = accelerator;
            this.addShortcut(accelerator);
        } else {
            long accelGroup = this.getAccelGroup();
            if (accelGroup != 0L) {
                this.removeAccelerator(accelGroup);
            }
            this.accelerator = accelerator;
            if (accelGroup != 0L) {
                this.addAccelerator(accelGroup);
            }
        }
    }

    void addShortcut(int accelerator) {
        int keyval;
        int newKey;
        if (accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((accelerator & 0x400000) != 0) {
            return;
        }
        int mask = 0;
        if ((accelerator & 0x10000) != 0) {
            mask |= 8;
        }
        if ((accelerator & 0x20000) != 0) {
            mask |= 1;
        }
        if ((accelerator & 0x40000) != 0) {
            mask |= 4;
        }
        if ((newKey = Display.untranslateKey(keyval = accelerator & 0x100FFFF)) != 0) {
            keyval = newKey;
        } else {
            switch (keyval) {
                case 13: {
                    keyval = 65293;
                    break;
                }
                default: {
                    keyval = Converter.wcsToMbcs((char)keyval);
                }
            }
        }
        if (keyval != 0) {
            this.shortcutHandle = GTK4.gtk_shortcut_new(GTK4.gtk_keyval_trigger_new(keyval, mask), GTK4.gtk_named_action_new(Converter.javaStringToCString(this.actionName)));
            if (this.shortcutHandle == 0L) {
                this.error(2);
            }
            GTK4.gtk_shortcut_controller_add_shortcut(this.parent.shortcutController, this.shortcutHandle);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (GTK.GTK4) {
            if (this.actionHandle != 0L) {
                OS.g_simple_action_set_enabled(this.actionHandle, enabled);
            }
        } else {
            if (GTK.gtk_widget_get_sensitive(this.handle) == enabled) {
                return;
            }
            long accelGroup = this.getAccelGroup();
            if (accelGroup != 0L) {
                this.removeAccelerator(accelGroup);
            }
            GTK.gtk_widget_set_sensitive(this.handle, enabled);
            if (accelGroup != 0L) {
                this.addAccelerator(accelGroup);
            }
        }
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this._setEnabledOrDisabledImage();
    }

    private void _setEnabledOrDisabledImage() {
        if (!this.enabled) {
            if (this.defaultDisableImage == null && this.image != null) {
                this.defaultDisableImage = new Image((Device)this.getDisplay(), this.image, 1);
            }
            this._setImage(this.defaultDisableImage);
        }
        if (this.enabled && this.image != null) {
            this._setImage(this.image);
        }
    }

    public void setID(int id) {
        this.checkWidget();
        if (id < 0) {
            this.error(5);
        }
        this.userId = id;
    }

    @Override
    public void setImage(Image image) {
        if (GTK.GTK4) {
            return;
        }
        this.checkWidget();
        if (this.image == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disposeDefaultDisabledImage();
        super.setImage(image);
        this._setEnabledOrDisabledImage();
    }

    private void _setImage(Image image) {
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            int imageIndex = imageList.indexOf(image);
            long surface = 0L;
            if (imageIndex == -1) {
                imageIndex = imageList.add(image);
                surface = imageList.getSurface(imageIndex);
            } else {
                imageList.put(imageIndex, image);
                surface = imageList.getSurface(imageIndex);
            }
            if (!GTK3.GTK_IS_MENU_ITEM(this.handle)) {
                return;
            }
            if (OS.SWT_PADDED_MENU_ITEMS && this.imageHandle != 0L) {
                GTK3.gtk_image_set_from_surface(this.imageHandle, surface);
            } else if (this.imageHandle == 0L) {
                this.imageHandle = GTK3.gtk_image_new_from_surface(surface);
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK3.gtk_box_reorder_child(this.boxHandle, this.imageHandle, 0);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, surface);
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else if (this.imageHandle != 0L) {
            if (OS.SWT_PADDED_MENU_ITEMS) {
                GTK3.gtk_container_remove(this.boxHandle, this.imageHandle);
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_image_set_pixel_size(this.imageHandle, 16);
                GTK3.gtk_container_add(this.boxHandle, this.imageHandle);
                GTK.gtk_widget_show(this.imageHandle);
            } else {
                GTK3.gtk_container_remove(this.boxHandle, this.imageHandle);
                this.imageHandle = 0L;
            }
        }
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        if (GTK.GTK4) {
            this.menu = menu;
            if (menu != null) {
                menu.cascade = this;
                OS.g_menu_item_set_submenu(this.handle, menu.modelHandle);
            } else {
                oldMenu.cascade = null;
                OS.g_menu_item_set_submenu(this.handle, 0L);
            }
            OS.g_menu_remove(this.section.getSectionHandle(), this.section.getItemPosition(this));
            OS.g_menu_insert_item(this.section.getSectionHandle(), this.section.getItemPosition(this), this.handle);
        } else {
            long accelGroup = this.getAccelGroup();
            if (accelGroup != 0L) {
                this.removeAccelerators(accelGroup);
            }
            if (oldMenu != null) {
                oldMenu.cascade = null;
                OS.g_object_ref(oldMenu.handle);
                GTK3.gtk_menu_item_set_submenu(this.handle, 0L);
            }
            if ((this.menu = menu) != null) {
                menu.cascade = this;
                GTK3.gtk_menu_item_set_submenu(this.handle, menu.handle);
            }
            if (accelGroup != 0L) {
                this.addAccelerators(accelGroup);
            }
        }
    }

    @Override
    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.parent.style & 0x4000000) != 0 || !create) {
            int dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction(this.handle, dir);
            GTK3.gtk_container_forall(this.handle, this.display.setDirectionProc, dir);
            if (this.menu != null) {
                this.menu._setOrientation(this.parent.style & 0x6000000);
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if (GTK.GTK4) {
            if ((this.style & 0x20) != 0) {
                OS.g_simple_action_set_state(this.actionHandle, OS.g_variant_new_boolean(selected));
            } else {
                OS.g_simple_action_set_state(this.actionHandle, OS.g_variant_new_string(Converter.javaStringToCString(selected ? "toggled" : "untoggled")));
            }
        } else {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
            GTK3.gtk_check_menu_item_set_active(this.handle, selected);
            if ((this.style & 0x10) != 0) {
                GTK3.gtk_check_menu_item_set_active(this.groupHandle, !selected);
            }
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int index = string.indexOf(9);
        if (index != -1) {
            string = string.substring(0, index);
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        if (GTK.GTK4) {
            OS.g_menu_item_set_label(this.handle, buffer);
            MaskKeysym maskKeysym = this.getMaskKeysym();
            if (maskKeysym != null) {
                OS.g_menu_item_set_attribute(this.handle, Converter.javaStringToCString("accel"), Converter.javaStringToCString("s"), GTK.gtk_accelerator_name(maskKeysym.keysym, maskKeysym.mask));
            }
            OS.g_menu_remove(this.section.getSectionHandle(), this.section.getItemPosition(this));
            OS.g_menu_insert_item(this.section.getSectionHandle(), this.section.getItemPosition(this), this.handle);
        } else if (this.labelHandle != 0L && GTK.GTK_IS_LABEL(this.labelHandle)) {
            GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
            if (GTK.GTK_IS_ACCEL_LABEL(this.labelHandle)) {
                MaskKeysym maskKeysym = this.getMaskKeysym();
                if (maskKeysym != null) {
                    GTK3.gtk_accel_label_set_accel_widget(this.labelHandle, this.handle);
                    GTK3.gtk_accel_label_set_accel(this.labelHandle, maskKeysym.keysym, maskKeysym.mask);
                }
                OS.g_signal_emit_by_name(this.handle, OS.accel_closures_changed);
            }
        }
    }

    public void setToolTipText(String toolTip) {
        this.checkWidget();
        if (GTK.GTK4) {
            return;
        }
        if (toolTip != null && (toolTip.trim().length() == 0 || toolTip.equals(this.toolTipText))) {
            return;
        }
        this.toolTipText = toolTip;
        this.setToolTipText(this.handle, toolTip);
    }

    void updateAccelerator(long accelGroup, boolean add) {
        int keysym;
        int newKey;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        int mask = 0;
        if ((this.accelerator & 0x10000) != 0) {
            mask |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            mask |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            mask |= 4;
        }
        if ((newKey = Display.untranslateKey(keysym = this.accelerator & 0x100FFFF)) != 0) {
            keysym = newKey;
        } else {
            switch (keysym) {
                case 13: {
                    keysym = 65293;
                    break;
                }
                default: {
                    keysym = Converter.wcsToMbcs((char)keysym);
                }
            }
        }
        if (keysym != 0) {
            if (add) {
                GTK3.gtk_widget_add_accelerator(this.handle, OS.activate, accelGroup, keysym, mask, 1);
            } else {
                GTK3.gtk_widget_remove_accelerator(this.handle, accelGroup, keysym, mask);
            }
        }
    }

    private MaskKeysym getMaskKeysym() {
        if (this.text == null) {
            return null;
        }
        MaskKeysym maskKeysym = new MaskKeysym();
        int accelIndex = this.text.indexOf(9);
        if (accelIndex == -1) {
            return null;
        }
        int start = accelIndex + 1;
        int plusIndex = this.text.indexOf(43, start);
        while (plusIndex != -1) {
            String maskStr = this.text.substring(start, plusIndex);
            if (maskStr.equals("Ctrl")) {
                maskKeysym.mask |= 4;
            }
            if (maskStr.equals("Shift")) {
                maskKeysym.mask |= 1;
            }
            if (maskStr.equals("Alt")) {
                maskKeysym.mask |= 8;
            }
            start = plusIndex + 1;
            plusIndex = this.text.indexOf(43, start);
        }
        if ("Enter".equals(this.text.substring(start))) {
            maskKeysym.keysym = 65076;
        }
        block0 : switch (this.text.length() - start) {
            case 1: {
                maskKeysym.keysym = this.text.charAt(start);
                maskKeysym.keysym = Converter.wcsToMbcs((char)maskKeysym.keysym);
                break;
            }
            case 2: {
                if (this.text.charAt(start) != 'F') break;
                switch (this.text.charAt(start + 1)) {
                    case '1': {
                        maskKeysym.keysym = 65470;
                        break;
                    }
                    case '2': {
                        maskKeysym.keysym = 65471;
                        break;
                    }
                    case '3': {
                        maskKeysym.keysym = 65472;
                        break;
                    }
                    case '4': {
                        maskKeysym.keysym = 65473;
                        break;
                    }
                    case '5': {
                        maskKeysym.keysym = 65474;
                        break;
                    }
                    case '6': {
                        maskKeysym.keysym = 65475;
                        break;
                    }
                    case '7': {
                        maskKeysym.keysym = 65476;
                        break;
                    }
                    case '8': {
                        maskKeysym.keysym = 65477;
                        break;
                    }
                    case '9': {
                        maskKeysym.keysym = 65478;
                    }
                }
                break;
            }
            case 3: {
                if (this.text.charAt(start) != 'F' || this.text.charAt(start + 1) != '1') break;
                switch (this.text.charAt(start + 2)) {
                    case '0': {
                        maskKeysym.keysym = 65479;
                        break block0;
                    }
                    case '1': {
                        maskKeysym.keysym = 65480;
                        break block0;
                    }
                    case '2': {
                        maskKeysym.keysym = 65481;
                        break block0;
                    }
                    case '3': {
                        maskKeysym.keysym = 65482;
                        break block0;
                    }
                    case '4': {
                        maskKeysym.keysym = 65483;
                        break block0;
                    }
                    case '5': {
                        maskKeysym.keysym = 65484;
                    }
                }
            }
        }
        return maskKeysym;
    }

    boolean updateAcceleratorText(boolean show) {
        if (this.accelerator != 0) {
            return false;
        }
        MaskKeysym maskKeysym = null;
        if (show) {
            maskKeysym = this.getMaskKeysym();
        }
        if (maskKeysym == null) {
            return true;
        }
        if (maskKeysym.keysym != 0) {
            long accelGroup = this.getAccelGroup();
            if (show) {
                GTK3.gtk_widget_add_accelerator(this.handle, OS.activate, accelGroup, maskKeysym.keysym, maskKeysym.mask, 1);
            } else {
                GTK3.gtk_widget_remove_accelerator(this.handle, accelGroup, maskKeysym.keysym, maskKeysym.mask);
            }
        }
        return maskKeysym.keysym != 0;
    }

    @Override
    long dpiChanged(long object, long arg0) {
        super.dpiChanged(object, arg0);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }

    private void disposeDefaultDisabledImage() {
        if (this.defaultDisableImage != null) {
            this.defaultDisableImage.dispose();
            this.defaultDisableImage = null;
        }
    }

    private static class MaskKeysym {
        int mask = 0;
        int keysym = 0;

        private MaskKeysym() {
        }
    }
}

