/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Settings;
import application.Shutter;
import application.VideoPlayer;
import library.FFPROBE;
import settings.FunctionUtils;

public class Transitions
extends Shutter {
    public static String setVideoFade(String filterComplex, boolean isVideoPlayer) {
        if (grpTransitions.isEnabled() || VideoPlayer.fullscreenPlayer) {
            if (Shutter.caseVideoFadeIn.isSelected()) {
                if (filterComplex != "") {
                    filterComplex = (String)filterComplex + ",";
                }
                long videoInValue = (long)((float)Integer.parseInt(Shutter.spinnerVideoFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
                String color = "black";
                if (Shutter.lblFadeInColor.getText().equals(language.getProperty("white"))) {
                    color = "white";
                }
                String videoFade = "fade=in:st=0ms:d=" + videoInValue + "ms:color=" + color;
                filterComplex = isVideoPlayer ? (VideoPlayer.cursorWaveform.getX() == VideoPlayer.playerInMark || VideoPlayer.playTransition ? (String)filterComplex + videoFade : (String)filterComplex + "null") : (String)filterComplex + videoFade;
            }
            if (Shutter.caseVideoFadeOut.isSelected()) {
                if (filterComplex != "") {
                    filterComplex = (String)filterComplex + ",";
                }
                long videoOutValue = (long)((float)Integer.parseInt(Shutter.spinnerVideoFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
                long videoStart = (long)FFPROBE.totalLength - videoOutValue;
                if (caseEnableSequence.isSelected()) {
                    videoOutValue = (long)((float)Integer.parseInt(Shutter.spinnerVideoFadeOut.getText()) * (1000.0f / (float)Integer.parseInt(caseSequenceFPS.getSelectedItem().toString().replace(",", "."))));
                    videoStart = (long)(1000.0f / (float)Integer.parseInt(caseSequenceFPS.getSelectedItem().toString().replace(",", ".")) * (float)list.getSize()) - videoOutValue;
                } else if (Settings.btnSetBab.isSelected()) {
                    videoOutValue = (long)((float)Integer.parseInt(Shutter.spinnerVideoFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
                    videoStart = (long)FunctionUtils.mergeDuration - videoOutValue;
                } else {
                    long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                    long totalOut = FFPROBE.totalLength;
                    if (VideoPlayer.playerOutMark < VideoPlayer.waveformContainer.getWidth() - 2) {
                        totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                    }
                    if (isVideoPlayer) {
                        totalIn = (long)Math.floor(VideoPlayer.playerCurrentFrame * (double)(1000.0f / FFPROBE.currentFPS));
                    }
                    videoStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? totalOut - totalIn - videoOutValue : (long)FFPROBE.totalLength - (totalOut - totalIn) - videoOutValue;
                }
                String color = "black";
                if (Shutter.lblFadeOutColor.getText().equals(language.getProperty("white"))) {
                    color = "white";
                }
                String videoFade = "fade=out:st=" + videoStart + "ms:d=" + videoOutValue + "ms:color=" + color;
                filterComplex = videoStart > 0L ? (String)filterComplex + videoFade : (String)filterComplex + "null";
            }
        }
        return filterComplex;
    }

    public static String setAudioFadeIn(boolean isVideoPlayer) {
        Object audioFilter = "";
        if ((grpTransitions.isEnabled() || VideoPlayer.fullscreenPlayer) && Shutter.caseAudioFadeIn.isSelected()) {
            long audioInValue = (long)((float)Integer.parseInt(Shutter.spinnerAudioFadeIn.getText()) * (1000.0f / FFPROBE.currentFPS));
            audioFilter = isVideoPlayer ? (VideoPlayer.cursorWaveform.getX() == VideoPlayer.playerInMark || VideoPlayer.playTransition ? (String)audioFilter + "afade=in:st=0ms:d=" + audioInValue + "ms" : (String)audioFilter + "anull") : (String)audioFilter + "afade=in:st=0ms:d=" + audioInValue + "ms";
        }
        return audioFilter;
    }

    public static String setAudioFadeOut(boolean isVideoPlayer) {
        Object audioFilter = "";
        if ((grpTransitions.isEnabled() || VideoPlayer.fullscreenPlayer) && Shutter.caseAudioFadeOut.isSelected()) {
            long audioOutValue = (long)((float)Integer.parseInt(Shutter.spinnerAudioFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
            long audioStart = (long)FFPROBE.totalLength - audioOutValue;
            if (Settings.btnSetBab.isSelected()) {
                audioOutValue = (long)((float)Integer.parseInt(Shutter.spinnerVideoFadeOut.getText()) * (1000.0f / FFPROBE.currentFPS));
                audioStart = (long)FunctionUtils.mergeDuration - audioOutValue;
            } else {
                long totalIn = (long)((float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseInS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0f / FFPROBE.currentFPS));
                long totalOut = FFPROBE.totalLength;
                if (VideoPlayer.playerOutMark < VideoPlayer.waveformContainer.getWidth() - 2) {
                    totalOut = (long)((float)(Integer.parseInt(VideoPlayer.caseOutH.getText()) * 3600000 + Integer.parseInt(VideoPlayer.caseOutM.getText()) * 60000 + Integer.parseInt(VideoPlayer.caseOutS.getText()) * 1000) + (float)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0f / FFPROBE.currentFPS));
                }
                if (isVideoPlayer) {
                    totalIn = (long)Math.floor(VideoPlayer.playerCurrentFrame * (double)(1000.0f / FFPROBE.currentFPS));
                }
                audioStart = VideoPlayer.comboMode.getSelectedItem().toString().contentEquals(Shutter.language.getProperty("cutUpper")) ? totalOut - totalIn - audioOutValue : (long)FFPROBE.totalLength - (totalOut - totalIn) - audioOutValue;
            }
            audioFilter = audioStart > 0L ? (String)audioFilter + "afade=out:st=" + audioStart + "ms:d=" + audioOutValue + "ms" : (String)audioFilter + "anull";
        }
        return audioFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String setAudioSpeed() {
        Object audioFilter = "";
        if (!(grpTransitions.isEnabled() || VideoPlayer.fullscreenPlayer || grpAudio.isVisible())) {
            if (!grpSetAudio.isVisible()) return audioFilter;
        }
        if (caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) || grpImageSequence.isVisible() && caseEnableSequence.isSelected()) {
            float value;
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (caseEnableSequence.isSelected()) {
                newFPS = Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", "."));
            }
            if ((value = newFPS / FFPROBE.currentFPS) >= 0.5f && value <= 2.0f) {
                return "atempo=" + value;
            }
            if (value <= 0.5f && value >= 0.25f) {
                audioFilter = "atempo=" + value * 2.0f;
                audioFilter = (String)audioFilter + ",";
                return (String)audioFilter + "atempo=" + value * 2.0f;
            }
            if (!(value >= 2.0f)) return " -an";
            if (!(value <= 4.0f)) return " -an";
            audioFilter = "atempo=" + value / 2.0f;
            audioFilter = (String)audioFilter + ",";
            return (String)audioFilter + "atempo=" + value / 2.0f;
        }
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            return " -an";
        }
        if (!caseConvertAudioFramerate.isSelected()) return audioFilter;
        float AudioFPSIn = Float.parseFloat(comboAudioIn.getSelectedItem().toString().replace(",", "."));
        float AudioFPSOut = Float.parseFloat(comboAudioOut.getSelectedItem().toString().replace(",", "."));
        float value = AudioFPSOut / AudioFPSIn;
        return (String)audioFilter + "atempo=" + value;
    }
}

