/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.RecordInputDevice;
import application.Shutter;
import application.SubtitlesEmbed;
import application.VideoPlayer;
import functions.VideoEncoders;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Timecode;

public class Overlay
extends Shutter {
    public static String showTimecode(String filterComplex, String file, boolean videoPlayerCapture) {
        if (Shutter.caseAddTimecode.isSelected() || Shutter.caseShowTimecode.isSelected() || Shutter.caseAddText.isSelected() || Shutter.caseShowFileName.isSelected()) {
            FFPROBE.analyzedMedia = null;
            if (VideoPlayer.videoPath == null || !lblCurrentEncoding.getText().equals(new File(VideoPlayer.videoPath).getName())) {
                VideoPlayer.videoPath = null;
                float scale = 0.0f;
                if (FFPROBE.previousImageWidth > 0 && (scale = (float)FFPROBE.imageWidth / (float)FFPROBE.previousImageWidth) != 0.0f) {
                    if (Shutter.caseShowTimecode.isSelected() || Shutter.caseAddTimecode.isSelected()) {
                        Shutter.textTcSize.setText(String.valueOf(Math.round((float)Integer.parseInt(Shutter.textTcSize.getText()) * scale)));
                    }
                    if (Shutter.caseShowFileName.isSelected() || Shutter.caseAddText.isSelected()) {
                        Shutter.textNameSize.setText(String.valueOf(Math.round((float)Integer.parseInt(Shutter.textNameSize.getText()) * scale)));
                    }
                    VideoPlayer.resizeAll();
                }
            }
            String tc1 = FFPROBE.timecode1;
            String tc2 = FFPROBE.timecode2;
            String tc3 = FFPROBE.timecode3;
            String tc4 = FFPROBE.timecode4;
            if (!(!Shutter.caseAddTimecode.isSelected() || Shutter.TC1.getText().isEmpty() || Shutter.TC2.getText().isEmpty() || Shutter.TC3.getText().isEmpty() || Shutter.TC4.getText().isEmpty())) {
                tc1 = Shutter.TC1.getText();
                tc2 = Shutter.TC2.getText();
                tc3 = Shutter.TC3.getText();
                tc4 = Shutter.TC4.getText();
            } else if (Shutter.caseShowTimecode.isSelected() && !FFPROBE.timecode1.equals("")) {
                float tcH = (float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS;
                float tcM = (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS;
                float tcS = (float)Integer.parseInt(tc3) * FFPROBE.currentFPS;
                float timeIn = (float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60 + Integer.parseInt(VideoPlayer.caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(VideoPlayer.caseInF.getText());
                float offset = timeIn + tcH + tcM + tcS + (float)Integer.parseInt(tc4);
                if (offset < 0.0f) {
                    offset = 0.0f;
                }
                DecimalFormat formatter = new DecimalFormat("00");
                tc1 = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 3600.0f));
                tc2 = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 60.0f) % 60.0);
                tc3 = formatter.format(Math.floor(offset / FFPROBE.currentFPS) % 60.0);
                tc4 = formatter.format(Math.round(offset % FFPROBE.currentFPS));
            }
            if (videoPlayerCapture) {
                double currentTime;
                double offset;
                if (Shutter.caseShowTimecode.isSelected()) {
                    tc1 = FFPROBE.timecode1;
                    tc2 = FFPROBE.timecode2;
                    tc3 = FFPROBE.timecode3;
                    tc4 = FFPROBE.timecode4;
                }
                DecimalFormat formatter = new DecimalFormat("00");
                float tcH = (float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS;
                float tcM = (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS;
                float tcS = (float)Integer.parseInt(tc3) * FFPROBE.currentFPS;
                float timeIn = (float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60 + Integer.parseInt(VideoPlayer.caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(VideoPlayer.caseInF.getText());
                if (Shutter.caseShowTimecode.isSelected()) {
                    timeIn = 0.0f;
                }
                if ((offset = (currentTime = Timecode.setNTSCtimecode(VideoPlayer.playerCurrentFrame)) - (double)timeIn + (double)tcH + (double)tcM + (double)tcS + (double)Integer.parseInt(tc4)) < 0.0) {
                    offset = 0.0;
                }
                tc1 = formatter.format(Math.floor(offset / (double)FFPROBE.currentFPS / 3600.0));
                tc2 = formatter.format(Math.floor(offset / (double)FFPROBE.currentFPS / 60.0) % 60.0);
                tc3 = formatter.format(Math.floor(offset / (double)FFPROBE.currentFPS) % 60.0);
                tc4 = formatter.format(Math.floor(offset % (double)FFPROBE.currentFPS));
            }
            String rate = String.valueOf(FFPROBE.currentFPS);
            if (caseConform.isSelected()) {
                rate = comboFPS.getSelectedItem().toString().replace(",", ".");
            } else if (caseForcerDesentrelacement.isSelected() && lblTFF.getText().contains("x2")) {
                rate = String.valueOf(FFPROBE.currentFPS * 2.0f);
            }
            Object overlayFont = "";
            if (System.getProperty("os.name").contains("Mac")) {
                String[] fontName;
                File[] fontFolder = new File("/Library/Fonts").listFiles();
                int i = 0;
                while (i < fontFolder.length) {
                    File fontPath;
                    if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                        overlayFont = fontFolder[i].getAbsolutePath();
                        break;
                    }
                    ++i;
                }
                if (overlayFont == "") {
                    fontFolder = new File("/System/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "" && new File("/System/Library/Fonts/Supplemental").exists()) {
                    fontFolder = new File("/System/Library/Fonts/Supplemental").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File(System.getProperty("user.home") + "/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].equals(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File("/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].contains(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File("/System/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].contains(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    fontFolder = new File(System.getProperty("user.home") + "/Library/Fonts").listFiles();
                    i = 0;
                    while (i < fontFolder.length) {
                        File fontPath;
                        if (fontFolder[i].isFile() && (fontName = (fontPath = new File(fontFolder[i].toString())).getName().toLowerCase().replace(" ", "").replace("_", "").split("\\."))[0].contains(Shutter.comboOverlayFont.getSelectedItem().toString().toLowerCase().replace(" ", "").replace("_", ""))) {
                            overlayFont = fontFolder[i].getAbsolutePath();
                            break;
                        }
                        ++i;
                    }
                }
                if (overlayFont == "") {
                    overlayFont = "/Library/Fonts/Arial";
                }
            } else {
                overlayFont = "font=" + Shutter.comboOverlayFont.getSelectedItem().toString();
            }
            float imageRatio = 1.0f;
            int ow = FFPROBE.imageWidth;
            if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    ow = (int)Math.round((double)ow * value);
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    if (comboResolution.getSelectedItem().toString().contains("AI")) {
                        ow = Shutter.comboResolution.getSelectedItem().toString().contains("2x") ? Math.round(ow * 2) : Math.round(ow * 4);
                    } else {
                        String[] s = comboResolution.getSelectedItem().toString().split("x");
                        ow = Integer.parseInt(s[0]);
                    }
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    ow = s[0].equals("auto") ? Math.round(FFPROBE.imageHeight / Integer.parseInt(s[1])) : (s[1].equals("auto") ? Math.round(FFPROBE.imageWidth / Integer.parseInt(s[0])) : Integer.parseInt(s[1]));
                }
                if (VideoEncoders.setScalingFirst()) {
                    imageRatio = (float)FFPROBE.imageWidth / (float)ow;
                }
            }
            if (Shutter.caseShowFileName.isSelected()) {
                if (filterComplex != "") {
                    filterComplex = (String)filterComplex + ",";
                }
                filterComplex = (String)filterComplex + "drawtext=" + (String)overlayFont + ":text='" + file + "':r=" + rate + ":x=" + Math.round((float)Integer.parseInt(Shutter.textNamePosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(Shutter.textNamePosY.getText()) / imageRatio) + ":fontcolor=0x" + Shutter.foregroundHex + Shutter.foregroundNameAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(Shutter.textNameSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + Shutter.backgroundHex + Shutter.backgroundNameAlpha;
            }
            if (Shutter.caseAddText.isSelected()) {
                String text = FunctionUtils.setPrefixSuffix(Shutter.overlayText.getText(), true);
                if (filterComplex != "") {
                    filterComplex = (String)filterComplex + ",";
                }
                filterComplex = (String)filterComplex + "drawtext=" + (String)overlayFont + ":text='" + text + "':r=" + rate + ":x=" + Math.round((float)Integer.parseInt(Shutter.textNamePosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(Shutter.textNamePosY.getText()) / imageRatio) + ":fontcolor=0x" + Shutter.foregroundHex + Shutter.foregroundNameAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(Shutter.textNameSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + Shutter.backgroundHex + Shutter.backgroundNameAlpha;
            }
            if (Shutter.caseAddTimecode.isSelected() || Shutter.caseShowTimecode.isSelected()) {
                String dropFrame = ":";
                if (!(FFPROBE.dropFrameTC.equals(":") || FFPROBE.currentFPS != 29.97f && FFPROBE.currentFPS != 59.94f)) {
                    dropFrame = ";";
                }
                if (Shutter.caseConform.isSelected()) {
                    dropFrame = Shutter.comboFPS.getSelectedItem().toString().equals("29,97") || Shutter.comboFPS.getSelectedItem().toString().equals("59,94") ? ";" : ":";
                }
                if (filterComplex != "") {
                    filterComplex = (String)filterComplex + ",";
                }
                if (Shutter.caseAddTimecode.isSelected() && Shutter.lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber"))) {
                    String startNumber = String.format("%.0f", Float.valueOf((float)(Integer.parseInt(tc1) * 3600) * FFPROBE.currentFPS + (float)(Integer.parseInt(tc2) * 60) * FFPROBE.currentFPS + (float)Integer.parseInt(tc3) * FFPROBE.currentFPS + (float)Integer.parseInt(tc4)));
                    filterComplex = (String)filterComplex + "drawtext=" + (String)overlayFont + ":text='%{frame_num}': start_number=" + startNumber + ":x=" + Math.round((float)Integer.parseInt(Shutter.textTcPosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(Shutter.textTcPosY.getText()) / imageRatio) + ":fontcolor=0x" + Shutter.foregroundHex + Shutter.foregroundTcAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(Shutter.textTcSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + Shutter.backgroundHex + Shutter.backgroundTcAlpha;
                } else {
                    filterComplex = (String)filterComplex + "drawtext=" + (String)overlayFont + ":timecode='" + tc1 + "\\:" + tc2 + "\\:" + tc3 + "\\" + dropFrame + tc4 + "':r=" + rate + ":x=" + Math.round((float)Integer.parseInt(Shutter.textTcPosX.getText()) / imageRatio) + ":y=" + Math.round((float)Integer.parseInt(Shutter.textTcPosY.getText()) / imageRatio) + ":fontcolor=0x" + Shutter.foregroundHex + Shutter.foregroundTcAlpha + ":fontsize=" + Math.round((float)Integer.parseInt(Shutter.textTcSize.getText()) / imageRatio) + ":box=1:boxcolor=0x" + Shutter.backgroundHex + Shutter.backgroundTcAlpha + ":tc24hmax=1";
                }
            }
        }
        return filterComplex;
    }

    public static String setSubtitles(boolean limitToFHD, String file) {
        if (caseAddSubtitles.isSelected()) {
            caseAddSubtitles.setEnabled(true);
            Shutter.fileList.setSelectedValue(file, true);
            if (Shutter.subtitlesBurn) {
                autoBurn = true;
            } else {
                autoEmbed = true;
            }
            String ext = file.substring(file.lastIndexOf("."));
            if (new File(file.replace(ext, ".srt")).exists() || new File(file.replace(ext, ".vtt")).exists() || new File(file.replace(ext, ".ass")).exists() || new File(file.replace(ext, ".ssa")).exists() || new File(file.replace(ext, ".scc")).exists() || comboSubsSource.getSelectedIndex() != 0) {
                FunctionUtils.addSubtitles(false);
                if (VideoPlayer.runProcess != null) {
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.runProcess.isAlive());
                }
                FunctionUtils.addSubtitles(true);
            }
            autoBurn = false;
            autoEmbed = false;
            caseAddSubtitles.setEnabled(false);
            try {
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.isRunning);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (caseAddSubtitles.isSelected() && subtitlesBurn) {
            if (subtitlesFile.toString().substring(subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
                Object background = "";
                background = Shutter.lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + Shutter.subsAlpha + Shutter.subsHex2 + "&,Outline=0" : ",Outline=" + Shutter.outline + ",OutlineColour=&H" + Shutter.subsAlpha + Shutter.subsHex2 + "&";
                if (Shutter.btnG.getForeground() != Color.BLACK) {
                    background = (String)background + ",Bold=1";
                }
                if (Shutter.btnI.getForeground() != Color.BLACK) {
                    background = (String)background + ",Italic=1";
                }
                String[] i = FFPROBE.imageResolution.split("x");
                float timeIn = (float)(Integer.parseInt(VideoPlayer.caseInH.getText()) * 3600 + Integer.parseInt(VideoPlayer.caseInM.getText()) * 60 + Integer.parseInt(VideoPlayer.caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(VideoPlayer.caseInF.getText());
                VideoPlayer.writeCurrentSubs(timeIn, false);
                if (comboSubsSource.getSelectedIndex() != 0) {
                    subtitlesFilePath.delete();
                }
                if (limitToFHD || !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    String[] s = "1920x1080".split("x");
                    if (comboResolution.getSelectedItem().toString().contains("%")) {
                        double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                        s[0] = String.valueOf(Math.round((double)Integer.parseInt(s[0]) * value));
                        s[1] = String.valueOf(Math.round((double)Integer.parseInt(s[1]) * value));
                    } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                        s = comboResolution.getSelectedItem().toString().split("x");
                    }
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(s[0]);
                    int oh = Integer.parseInt(s[1]);
                    int width = Math.round((float)Integer.parseInt(Shutter.textSubsWidth.getText()) / ((float)iw / (float)ow));
                    int height = Math.round((float)(ih + Integer.parseInt(Shutter.textSubtitlesPosition.getText())) / ((float)ih / (float)oh));
                    return " -f lavfi -i \"color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles='" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + Shutter.comboSubsFont.getSelectedItem().toString() + ",FontSize=" + Shutter.textSubsSize.getText() + ",PrimaryColour=&H" + Shutter.subsHex + "&" + (String)background + "'\"";
                }
                int fontSize = Integer.parseInt(Shutter.textSubsSize.getText());
                int height = Integer.parseInt(Shutter.textSubtitlesPosition.getText());
                if (Shutter.caseEnableCrop.isSelected()) {
                    int ih = Integer.parseInt(i[1]);
                    int oh = Integer.parseInt(Shutter.textCropHeight.getText());
                    height -= Integer.parseInt(Shutter.textCropPosY.getText());
                    fontSize = (int)((float)fontSize * ((float)ih / (float)oh));
                }
                return " -f lavfi -i \"color=black@0.0,format=rgba,scale=" + Shutter.textSubsWidth.getText() + ":" + i[1] + "+" + height + ",subtitles='" + subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + Shutter.comboSubsFont.getSelectedItem().toString() + ",FontSize=" + fontSize + ",PrimaryColour=&H" + Shutter.subsHex + "&" + (String)background + "'\"";
            }
            String[] i = FFPROBE.imageResolution.split("x");
            Shutter.textSubsWidth.setText(i[0]);
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    s[0] = String.valueOf(Math.round((double)Integer.parseInt(s[0]) * value));
                    s[1] = String.valueOf(Math.round((double)Integer.parseInt(s[1]) * value));
                } else if (comboResolution.getSelectedItem().toString().contains("AI")) {
                    if (Shutter.comboResolution.getSelectedItem().toString().contains("2x")) {
                        s[0] = String.valueOf(Math.round(Integer.parseInt(s[0]) * 2));
                        s[1] = String.valueOf(Math.round(Integer.parseInt(s[1]) * 2));
                    } else {
                        s[0] = String.valueOf(Math.round(Integer.parseInt(s[0]) * 4));
                        s[1] = String.valueOf(Math.round(Integer.parseInt(s[1]) * 4));
                    }
                } else {
                    s = comboResolution.getSelectedItem().toString().split("x");
                }
                int iw = Integer.parseInt(i[0]);
                int ih = Integer.parseInt(i[1]);
                int ow = Integer.parseInt(s[0]);
                int oh = Integer.parseInt(s[1]);
                int width = Math.round((float)Integer.parseInt(Shutter.textSubsWidth.getText()) / ((float)iw / (float)ow));
                int height = Math.round((float)(ih + Integer.parseInt(Shutter.textSubtitlesPosition.getText())) / ((float)ih / (float)oh));
                return " -f lavfi" + InputAndOutput.inPoint + " -i \"color=black@0.0,format=rgba,scale=" + width + ":" + height + ",subtitles='" + subtitlesFile.toString() + "':alpha=1\"";
            }
            return " -f lavfi" + InputAndOutput.inPoint + " -i \"color=black@0.0,format=rgba,scale=" + i[0] + ":" + i[1] + ",subtitles='" + subtitlesFile.toString() + "':alpha=1\"";
        }
        if (caseAddSubtitles.isSelected() && !subtitlesBurn) {
            Object subsFiles = "";
            Component[] componentArray = SubtitlesEmbed.frame.getContentPane().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JTextField && !((JTextField)c).getText().equals(language.getProperty("aucun"))) {
                    subsFiles = (String)subsFiles + InputAndOutput.inPoint + " -i \"" + ((JTextField)c).getText() + "\"";
                }
                ++n2;
            }
            return subsFiles;
        }
        return "";
    }

    public static String setLogo() {
        if (Shutter.caseAddWatermark.isSelected() && Shutter.overlayDeviceIsRunning) {
            return " " + RecordInputDevice.setOverlayDevice();
        }
        if (Shutter.caseAddWatermark.isSelected()) {
            return " -i \"" + Shutter.logoFile + "\"";
        }
        return "";
    }

    public static String setWatermark(String filterComplex) {
        if (Shutter.caseAddWatermark.isSelected()) {
            FFPROBE.analyzedMedia = null;
            if (VideoPlayer.videoPath == null || !lblCurrentEncoding.getText().equals(new File(VideoPlayer.videoPath).getName())) {
                VideoPlayer.videoPath = null;
                float scale = 0.0f;
                if (FFPROBE.previousImageWidth > 0 && (scale = (float)FFPROBE.imageWidth / (float)FFPROBE.previousImageWidth) != 0.0f) {
                    Shutter.textWatermarkSize.setText(String.valueOf(Math.round((float)Integer.parseInt(Shutter.textWatermarkSize.getText()) * scale)));
                }
                VideoPlayer.resizeAll();
                VideoPlayer.loadWatermark(Integer.parseInt(Shutter.textWatermarkSize.getText()));
                if (Shutter.watermarkPreset != null) {
                    Shutter.logo.setLocation((int)Math.floor((float)Integer.valueOf(Shutter.textWatermarkPosX.getText()).intValue() / Shutter.playerRatio), (int)Math.floor((float)Integer.valueOf(Shutter.textWatermarkPosY.getText()).intValue() / Shutter.playerRatio));
                }
            }
            float imageRatio = 1.0f;
            int ow = FFPROBE.imageWidth;
            if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    ow = (int)Math.round((double)ow * value);
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    if (comboResolution.getSelectedItem().toString().contains("AI")) {
                        ow = Shutter.comboResolution.getSelectedItem().toString().contains("2x") ? Math.round(ow * 2) : Math.round(ow * 4);
                    } else {
                        String[] s = comboResolution.getSelectedItem().toString().split("x");
                        ow = Integer.parseInt(s[0]);
                    }
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    String[] s = comboResolution.getSelectedItem().toString().split(":");
                    ow = s[0].equals("auto") ? Math.round(FFPROBE.imageHeight / Integer.parseInt(s[1])) : (s[1].equals("auto") ? Math.round(FFPROBE.imageWidth / Integer.parseInt(s[0])) : Integer.parseInt(s[1]));
                }
                if (VideoEncoders.setScalingFirst()) {
                    imageRatio = (float)FFPROBE.imageWidth / (float)ow;
                }
            }
            float size = (float)Integer.parseInt(Shutter.textWatermarkSize.getText()) / 100.0f;
            filterComplex = filterComplex != "" ? "[0:v]" + (String)filterComplex + "[v];[1:v]scale=iw*" + 1.0 / (double)imageRatio * (double)size + ":ih*" + 1.0 / (double)imageRatio * (double)size + ",lut=a=val*" + (float)Integer.parseInt(Shutter.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[v][scaledwatermark]overlay=" + Math.round((float)Integer.parseInt(Shutter.textWatermarkPosX.getText()) / imageRatio) + ":" + Math.round((float)Integer.parseInt(Shutter.textWatermarkPosY.getText()) / imageRatio) : "[1:v]scale=iw*" + 1.0 / (double)imageRatio * (double)size + ":ih*" + 1.0 / (double)imageRatio * (double)size + ",lut=a=val*" + (float)Integer.parseInt(Shutter.textWatermarkOpacity.getText()) / 100.0f + "[scaledwatermark];[0:v][scaledwatermark]overlay=" + Math.round((float)Integer.parseInt(Shutter.textWatermarkPosX.getText()) / imageRatio) + ":" + Math.round((float)Integer.parseInt(Shutter.textWatermarkPosY.getText()) / imageRatio);
        }
        return filterComplex;
    }

    public static String setOverlay(String filterComplex, boolean limitToFHD) {
        if (Shutter.caseAddSubtitles.isSelected() && subtitlesBurn) {
            String[] i = FFPROBE.imageResolution.split("x");
            int ImageWidth = Integer.parseInt(i[0]);
            int posX = Math.round(ImageWidth - Integer.parseInt(Shutter.textSubsWidth.getText())) / 2;
            if (Shutter.caseEnableCrop.isSelected()) {
                posX -= Integer.parseInt(Shutter.textCropPosX.getText());
            }
            if (limitToFHD) {
                String[] s = "1920x1080".split("x");
                if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    s = comboResolution.getSelectedItem().toString().split("x");
                }
                int iw = Integer.parseInt(i[0]);
                int ow = Integer.parseInt(s[0]);
                float imageRatio = (float)iw / (float)ow;
                posX = Math.round((float)posX / imageRatio);
            } else if (!comboFonctions.getSelectedItem().toString().equals("DVD") && !comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] s = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    s[0] = String.valueOf(Math.round((double)Integer.parseInt(s[0]) * value));
                    s[1] = String.valueOf(Math.round((double)Integer.parseInt(s[1]) * value));
                } else {
                    s = comboResolution.getSelectedItem().toString().split("x");
                }
                int iw = Integer.parseInt(i[0]);
                int ow = Integer.parseInt(s[0]);
                float imageRatio = (float)iw / (float)ow;
                posX = Math.round((float)posX / imageRatio);
            }
            filterComplex = Shutter.caseAddWatermark.isSelected() ? (String)filterComplex + "[p];[p][2:v]overlay=shortest=1:x=" + posX : (filterComplex != "" ? (String)filterComplex + "[p];[p][1:v]overlay=shortest=1:x=" + posX : "[0:v][1:v]overlay=shortest=1:x=" + posX);
        }
        return filterComplex;
    }
}

