/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Equalizer;
import application.RecordInputDevice;
import application.Shutter;
import application.Utils;
import functions.AudioNormalization;
import java.awt.Component;
import java.io.File;
import javax.swing.JComboBox;
import library.FFMPEG;
import library.FFPROBE;
import settings.Transitions;

public class AudioSettings
extends Shutter {
    public static String setAudioFiles(String audioFiles, File file) {
        int channels = 1;
        int i2 = 0;
        while (i2 < list.getSize()) {
            File audioName = new File((String)list.getElementAt(i2));
            audioName = new File(audioName.getName().substring(0, audioName.getName().lastIndexOf(".")));
            File videoName = new File(file.getName().substring(0, file.getName().lastIndexOf(".")));
            if (audioName.toString().contains(videoName.toString()) && !audioName.toString().equals(videoName.toString())) {
                audioFiles = (String)audioFiles + " -i \"" + (String)list.getElementAt(i2) + "\" ";
                ++channels;
            }
            ++i2;
        }
        int map = 0;
        while (map < channels) {
            if (map > 0) {
                audioFiles = (String)audioFiles + "-map " + map + ":a ";
            }
            ++map;
        }
        return audioFiles;
    }

    public static String setAudioMapping(String filterComplex, String audioCodec, String audioFiles, File file) {
        Object audioBitrate = "";
        boolean isEditingCodec = false;
        boolean isBroadcastCodec = false;
        if (grpBitrate.isVisible() || comboFonctions.getSelectedItem().toString().equals("DVD")) {
            audioBitrate = " -b:a " + debitAudio.getSelectedItem().toString() + "k";
        } else if (comboFonctions.getSelectedItem().toString().equals("DVD")) {
            audioBitrate = " -b:a 320k";
        } else if (comboFonctions.getSelectedItem().toString().contains("XDCAM") || comboFonctions.getSelectedItem().toString().equals("AVC-Intra 100") || comboFonctions.getSelectedItem().toString().contains("XAVC")) {
            isBroadcastCodec = true;
        } else {
            isEditingCodec = true;
        }
        if (comboAudioCodec.getSelectedItem().equals(language.getProperty("codecCopy"))) {
            Object mapping = "";
            if (comboAudio1.getSelectedIndex() == 0 && comboAudio2.getSelectedIndex() == 1 && comboAudio3.getSelectedIndex() == 2 && comboAudio4.getSelectedIndex() == 3 && comboAudio5.getSelectedIndex() == 4 && comboAudio6.getSelectedIndex() == 5 && comboAudio7.getSelectedIndex() == 6 && comboAudio8.getSelectedIndex() == 7) {
                mapping = " -map a?";
                if (inputDeviceIsRunning && ((String)list.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                    mapping = (String)mapping + " -map 2?";
                }
            } else {
                if (comboAudio1.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio1.getSelectedIndex() + "?";
                }
                if (comboAudio2.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio2.getSelectedIndex() + "?";
                }
                if (comboAudio3.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio3.getSelectedIndex() + "?";
                }
                if (comboAudio4.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio4.getSelectedIndex() + "?";
                }
                if (comboAudio5.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio5.getSelectedIndex() + "?";
                }
                if (comboAudio6.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio6.getSelectedIndex() + "?";
                }
                if (comboAudio7.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio7.getSelectedIndex() + "?";
                }
                if (comboAudio8.getSelectedIndex() != 16) {
                    mapping = (String)mapping + " -map a:" + comboAudio8.getSelectedIndex() + "?";
                }
            }
            return " -c:a copy" + (String)mapping;
        }
        if (debitAudio.getSelectedItem().toString().equals("0") && audioCodec != "FLAC" && !isEditingCodec && !isBroadcastCodec || comboAudioCodec.getSelectedItem().equals(language.getProperty("noAudio")) || grpImageSequence.isVisible() && caseEnableSequence.isSelected()) {
            return " -an";
        }
        Object audio = "";
        if (audioCodec.equals("AC3")) {
            audioCodec = "ac3";
        } else if (audioCodec.equals("Opus")) {
            audioCodec = "libopus";
        } else if (audioCodec.equals("Vorbis")) {
            audioCodec = "libvorbis";
        } else if (audioCodec.equals("Dolby Digital Plus")) {
            audioCodec = "eac3";
        } else if (audioCodec.equals("WMA")) {
            audioCodec = "wmav2";
        } else if (audioCodec.equals("MP3")) {
            audioCodec = "libmp3lame";
        } else if (audioCodec.equals("MP2")) {
            audioCodec = "mp2";
        } else if (audioCodec.equals("PCM 16Bits")) {
            audioCodec = comboFonctions.getSelectedItem().toString().equals("MJPEG") ? "pcm_s16be" : "pcm_s16le";
        } else if (audioCodec.equals("PCM 24Bits")) {
            audioCodec = comboFonctions.getSelectedItem().toString().equals("MJPEG") ? "pcm_s24be" : "pcm_s24le";
        } else if (audioCodec.equals("PCM 32Bits")) {
            audioCodec = comboFonctions.getSelectedItem().toString().equals("MJPEG") ? "pcm_s32be" : "pcm_s32le";
        } else if (comboAudioCodec.getSelectedItem().toString().equals("PCM 32Float")) {
            audioCodec = "pcm_f32be";
        } else if (audioCodec.equals("FLAC")) {
            audioCodec = "flac";
            audioBitrate = " -compression_level " + debitAudio.getSelectedItem().toString();
        } else if (audioCodec.equals("ALAC 16Bits")) {
            audioCodec = "alac";
            audioBitrate = " -sample_fmt s16p";
        } else if (audioCodec.equals("ALAC 24Bits")) {
            audioCodec = "alac";
            audioBitrate = " -sample_fmt s32p";
        } else {
            audioCodec = System.getProperty("os.name").contains("Mac") ? "aac_at" : "aac";
        }
        Object audioFiltering = "";
        audioFiltering = AudioSettings.setEQ((String)audioFiltering);
        if (Transitions.setAudioFadeIn(false) != "") {
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            if (Transitions.setAudioSpeed().equals(" -an")) {
                return " -an";
            }
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + Transitions.setAudioSpeed();
        }
        if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
            AudioNormalization.main(file);
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (AudioNormalization.thread.isAlive());
            lblCurrentEncoding.setText(file.getName());
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + "volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB";
        }
        if (caseOPATOM.isSelected()) {
            return audioFiles + (String)audio + " -ar " + lbl48k.getSelectedItem().toString();
        }
        if (grpSetAudio.isVisible() && caseChangeAudioCodec.isSelected() && comboAudioCodec.getSelectedItem().equals(language.getProperty("custom")) && !isBroadcastCodec) {
            return AudioSettings.setCustomAudio(isBroadcastCodec, (String)audioFiltering);
        }
        if (FFPROBE.stereo) {
            if (FFPROBE.surround && !lblAudioMapping.getSelectedItem().toString().equals("Multi")) {
                if (audioFiltering != "") {
                    audioFiltering = (String)audioFiltering + ",";
                }
                String mono = "";
                if (lblAudioMapping.getSelectedItem().toString().equals(language.getProperty("mono"))) {
                    mono = " -ac 1";
                }
                String channelMix = "";
                channelMix = FFPROBE.channelLayout.equals("7.1") ? "pan=stereo|FL=0.6*FL+0.5*FC+0.3*BL+0.3*SL+0.2*LFE|FR=0.6*FR+0.5*FC+0.3*BR+0.3*SR+0.2*LFE" : (FFPROBE.channelLayout.equals("6.1") ? "pan=stereo|FL=0.6*FL+0.5*FC+0.3*BC+0.3*SL+0.2*LFE|FR=0.6*FR+0.5*FC+0.3*BC+0.3*SR+0.2*LFE" : "pan=stereo|FL=0.707*FL+0.707*FC+0.5*BL+0.5*SL|FR=0.707*FR+0.707*FC+0.5*BR+0.5*SR");
                audio = (String)audio + " -c:a " + audioCodec + mono + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate + " -filter:a \"" + (String)audioFiltering + channelMix + "\" -map a?";
            } else if (lblAudioMapping.getSelectedItem().toString().equals("Multi")) {
                Object mapping = "";
                if (comboAudio1.getSelectedIndex() == 0 && comboAudio2.getSelectedIndex() == 1 && comboAudio3.getSelectedIndex() == 2 && comboAudio4.getSelectedIndex() == 3 && comboAudio5.getSelectedIndex() == 4 && comboAudio6.getSelectedIndex() == 5 && comboAudio7.getSelectedIndex() == 6 && comboAudio8.getSelectedIndex() == 7) {
                    if (!isBroadcastCodec) {
                        mapping = " -map a?";
                    }
                    if (inputDeviceIsRunning && ((String)list.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                        mapping = (String)mapping + " -map 2?";
                    }
                } else if (!isBroadcastCodec) {
                    if (comboAudio1.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio1.getSelectedIndex() + "?";
                    }
                    if (comboAudio2.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio2.getSelectedIndex() + "?";
                    }
                    if (comboAudio3.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio3.getSelectedIndex() + "?";
                    }
                    if (comboAudio4.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio4.getSelectedIndex() + "?";
                    }
                    if (comboAudio5.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio5.getSelectedIndex() + "?";
                    }
                    if (comboAudio6.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio6.getSelectedIndex() + "?";
                    }
                    if (comboAudio7.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio7.getSelectedIndex() + "?";
                    }
                    if (comboAudio8.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio8.getSelectedIndex() + "?";
                    }
                }
                if (audioCodec.equals("libopus") && FFPROBE.channelLayout != "") {
                    mapping = (String)mapping + " -channel_layout " + FFPROBE.channelLayout;
                }
                if (isBroadcastCodec) {
                    audioFiltering = "";
                } else if (audioFiltering != "") {
                    audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
                }
                audio = (String)audio + " -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate + (String)audioFiltering + (String)mapping;
            } else if (lblAudioMapping.getSelectedItem().toString().equals(language.getProperty("mono"))) {
                if (audioFiltering != "") {
                    audioFiltering = "," + (String)audioFiltering;
                }
                audio = filterComplex != "" ? (String)audio + ";" : (String)audio + " -filter_complex \"";
                audio = comboAudio1.getSelectedIndex() != 16 && comboAudio2.getSelectedIndex() != 16 ? (String)audio + "[0:a]anull" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate : (comboAudio1.getSelectedIndex() == 0 ? (String)audio + "[0:a]channelsplit=channel_layout=stereo:channels=FL" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate : (String)audio + "[0:a]channelsplit=channel_layout=stereo:channels=FR" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate);
            } else if (lblAudioMapping.getSelectedItem().toString().equals("Mix")) {
                if (audioFiltering != "") {
                    audioFiltering = "," + (String)audioFiltering;
                }
                audio = filterComplex != "" ? (String)audio + ";" : (String)audio + " -filter_complex \"";
                audio = (String)audio + "[0:a]amix=inputs=" + FFPROBE.channels + (String)audioFiltering + "[a]\" -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
            } else {
                if (audioFiltering != "") {
                    audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
                }
                audio = (String)audio + " -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate + (String)audioFiltering + " -map a:" + comboAudio1.getSelectedIndex();
            }
        } else if (FFPROBE.channels > 1) {
            if (inputDeviceIsRunning) {
                if (audioFiltering != "") {
                    audioFiltering = "," + (String)audioFiltering;
                }
                audio = filterComplex != "" ? (String)audio + ";" : (String)audio + " -filter_complex \"";
                if (lblAudioMapping.getSelectedItem().toString().equals(language.getProperty("stereo"))) {
                    audio = (String)audio + "[0:a][2:a]amix=inputs=2" + (String)audioFiltering + "[a]\" -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
                } else if (lblAudioMapping.getSelectedItem().toString().equals("Multi")) {
                    if (audioFiltering != "") {
                        audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
                    }
                    audio = (String)audio + " -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate + (String)audioFiltering + " -map 0:a? -map 2:a?";
                } else if (lblAudioMapping.getSelectedItem().toString().equals(language.getProperty("mono"))) {
                    audio = comboAudio1.getSelectedIndex() != 16 && comboAudio2.getSelectedIndex() != 16 ? (String)audio + "[" + String.valueOf(comboAudio1.getSelectedIndex()).replace("1", "2") + ":a][" + String.valueOf(comboAudio2.getSelectedIndex()).replace("1", "2") + ":a]amerge=inputs=2" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate : (String)audio + "[" + String.valueOf(comboAudio1.getSelectedIndex()).replace("1", "2") + ":a]anull" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
                } else if (lblAudioMapping.getSelectedItem().toString().equals("Mix")) {
                    audio = (String)audio + "[0:a]amix=inputs=" + FFPROBE.channels + (String)audioFiltering + "[a]\" -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
                }
            } else if (lblAudioMapping.getSelectedItem().toString().equals(language.getProperty("stereo"))) {
                if (audioFiltering != "") {
                    audioFiltering = "," + (String)audioFiltering;
                }
                audio = filterComplex != "" ? (String)audio + ";" : (String)audio + " -filter_complex \"";
                audio = (String)audio + "[0:a:" + comboAudio1.getSelectedIndex() + "][0:a:" + comboAudio2.getSelectedIndex() + "]amerge=inputs=2" + (String)audioFiltering + "[a]\" -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
            } else if (lblAudioMapping.getSelectedItem().toString().equals(language.getProperty("mono"))) {
                if (audioFiltering != "") {
                    audioFiltering = "," + (String)audioFiltering;
                }
                audio = filterComplex != "" ? (String)audio + ";" : (String)audio + " -filter_complex \"";
                audio = comboAudio1.getSelectedIndex() != 16 && comboAudio2.getSelectedIndex() != 16 ? (String)audio + "[0:a:" + comboAudio1.getSelectedIndex() + "][0:a:" + comboAudio2.getSelectedIndex() + "]amerge=inputs=2" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate : (String)audio + "[0:a:" + comboAudio1.getSelectedIndex() + "]anull" + (String)audioFiltering + "[a]\" -ac 1 -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
            } else if (lblAudioMapping.getSelectedItem().toString().equals("Mix")) {
                if (audioFiltering != "") {
                    audioFiltering = "," + (String)audioFiltering;
                }
                audio = filterComplex != "" ? (String)audio + ";" : (String)audio + " -filter_complex \"";
                audio = (String)audio + "[0:a]amix=inputs=" + FFPROBE.channels + (String)audioFiltering + "[a]\" -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate;
            } else {
                Object mapping = "";
                if (comboAudio1.getSelectedIndex() == 0 && comboAudio2.getSelectedIndex() == 1 && comboAudio3.getSelectedIndex() == 2 && comboAudio4.getSelectedIndex() == 3 && comboAudio5.getSelectedIndex() == 4 && comboAudio6.getSelectedIndex() == 5 && comboAudio7.getSelectedIndex() == 6 && comboAudio8.getSelectedIndex() == 7) {
                    if (!isBroadcastCodec) {
                        mapping = " -map a?";
                    }
                    if (inputDeviceIsRunning && ((String)list.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 && RecordInputDevice.overlayAudioDeviceIndex > 0) {
                        mapping = (String)mapping + " -map 2?";
                    }
                } else if (!isBroadcastCodec) {
                    if (comboAudio1.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio1.getSelectedIndex() + "?";
                    }
                    if (comboAudio2.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio2.getSelectedIndex() + "?";
                    }
                    if (comboAudio3.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio3.getSelectedIndex() + "?";
                    }
                    if (comboAudio4.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio4.getSelectedIndex() + "?";
                    }
                    if (comboAudio5.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio5.getSelectedIndex() + "?";
                    }
                    if (comboAudio6.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio6.getSelectedIndex() + "?";
                    }
                    if (comboAudio7.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio7.getSelectedIndex() + "?";
                    }
                    if (comboAudio8.getSelectedIndex() != 16) {
                        mapping = (String)mapping + " -map a:" + comboAudio8.getSelectedIndex() + "?";
                    }
                }
                if (isBroadcastCodec) {
                    audioFiltering = "";
                } else if (audioFiltering != "") {
                    audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
                }
                audio = (String)audio + " -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate + (String)audioFiltering + (String)mapping;
            }
        } else {
            if (isBroadcastCodec) {
                audioFiltering = "";
            } else if (audioFiltering != "") {
                audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
            }
            audio = (String)audio + " -c:a " + audioCodec + " -ar " + lbl48k.getSelectedItem().toString() + (String)audioBitrate + (String)audioFiltering + " -map a?";
        }
        return audio;
    }

    public static String setEQ(String filter) {
        if (Shutter.caseEqualizer.isSelected()) {
            if (Equalizer.sliderEQ1.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=60:g=" + Equalizer.sliderEQ1.getValue();
            }
            if (Equalizer.sliderEQ2.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=170:g=" + Equalizer.sliderEQ2.getValue();
            }
            if (Equalizer.sliderEQ3.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=310:g=" + Equalizer.sliderEQ3.getValue();
            }
            if (Equalizer.sliderEQ4.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=600:g=" + Equalizer.sliderEQ4.getValue();
            }
            if (Equalizer.sliderEQ5.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=1000:g=" + Equalizer.sliderEQ5.getValue();
            }
            if (Equalizer.sliderEQ6.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=3000:g=" + Equalizer.sliderEQ6.getValue();
            }
            if (Equalizer.sliderEQ7.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=6000:g=" + Equalizer.sliderEQ7.getValue();
            }
            if (Equalizer.sliderEQ8.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=12000:g=" + Equalizer.sliderEQ8.getValue();
            }
            if (Equalizer.sliderEQ9.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=14000:g=" + Equalizer.sliderEQ9.getValue();
            }
            if (Equalizer.sliderEQ10.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "equalizer=f=16000:g=" + Equalizer.sliderEQ10.getValue();
            }
            if (Equalizer.sliderGain.getValue() != 0) {
                if (filter != "") {
                    filter = (String)filter + ",";
                }
                filter = (String)filter + "volume=" + Equalizer.sliderGain.getValue() + "dB";
            }
        }
        return filter;
    }

    public static String setCustomAudio(Boolean isBroadcastCodec, String audioFiltering) {
        Object audioMapping = "";
        String audioCodec = "";
        Object codecMapping = "";
        Object bitrateMapping = "";
        Object rateMapping = "";
        Object languageMapping = "";
        int i = 0;
        Component[] componentArray = grpSetAudio.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JComboBox && ((JComboBox)c).getName().matches("comboAudio[0-9]+")) {
                if (((JComboBox)c).getSelectedIndex() != 16) {
                    Component a;
                    audioMapping = (String)audioMapping + " -map a:" + ((JComboBox)c).getSelectedIndex() + "?";
                    Component[] componentArray2 = grpSetAudio.getComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        a = componentArray2[n4];
                        if (a instanceof JComboBox && ((JComboBox)a).getName().matches("comboAudioCodec[0-9]+") && ((JComboBox)a).getName().endsWith(String.valueOf(i + 1))) {
                            audioCodec = ((JComboBox)a).getSelectedItem().toString();
                            String codec = "";
                            codec = audioCodec.equals("AC3") ? "ac3" : (audioCodec.equals("Opus") ? "libopus" : (audioCodec.equals("Vorbis") ? "libvorbis" : (audioCodec.equals("Dolby Digital Plus") ? "eac3" : (audioCodec.equals("WMA") ? "wmav2" : (audioCodec.equals("MP3") ? "libmp3lame" : (audioCodec.equals("MP2") ? "mp2" : (audioCodec.equals("PCM 16Bits") ? (comboFonctions.getSelectedItem().toString().equals("MJPEG") ? "pcm_s16be" : "pcm_s16le") : (audioCodec.equals("PCM 24Bits") ? (comboFonctions.getSelectedItem().toString().equals("MJPEG") ? "pcm_s24be" : "pcm_s24le") : (audioCodec.equals("PCM 32Bits") ? (comboFonctions.getSelectedItem().toString().equals("MJPEG") ? "pcm_s32be" : "pcm_s32le") : (audioCodec.equals("PCM 32Float") ? "pcm_f32be" : (audioCodec.equals("FLAC") ? "flac" : (audioCodec.equals("ALAC 16Bits") ? "alac" : (audioCodec.equals("ALAC 24Bits") ? "alac" : (audioCodec.equals(language.getProperty("codecCopy")) ? "copy" : (System.getProperty("os.name").contains("Mac") ? "aac_at" : "aac")))))))))))))));
                            codecMapping = (String)codecMapping + " -c:a:" + i + " " + codec;
                            break;
                        }
                        ++n4;
                    }
                    componentArray2 = grpSetAudio.getComponents();
                    n3 = componentArray2.length;
                    n4 = 0;
                    while (n4 < n3) {
                        a = componentArray2[n4];
                        if (a instanceof JComboBox && ((JComboBox)a).getName().matches("comboAudioBitrate[0-9]+") && ((JComboBox)a).getName().endsWith(String.valueOf(i + 1))) {
                            if (audioCodec.equals("FLAC")) {
                                bitrateMapping = (String)bitrateMapping + " -compression_level:a:" + i + " " + ((JComboBox)a).getSelectedItem().toString();
                                break;
                            }
                            if (audioCodec.equals("ALAC 16Bits")) {
                                bitrateMapping = (String)bitrateMapping + " -sample_fmt:a:" + i + " s16p";
                                break;
                            }
                            if (audioCodec.equals("ALAC 24Bits")) {
                                bitrateMapping = (String)bitrateMapping + " -sample_fmt:a:" + i + " s32p";
                                break;
                            }
                            if (audioCodec.contains("PCM")) break;
                            bitrateMapping = (String)bitrateMapping + " -b:a:" + i + " " + String.valueOf(((JComboBox)a).getSelectedItem()) + "k";
                            break;
                        }
                        ++n4;
                    }
                    componentArray2 = grpSetAudio.getComponents();
                    n3 = componentArray2.length;
                    n4 = 0;
                    while (n4 < n3) {
                        a = componentArray2[n4];
                        if (a instanceof JComboBox && ((JComboBox)a).getName().matches("comboAudioRate[0-9]+") && ((JComboBox)a).getName().endsWith(String.valueOf(i + 1))) {
                            rateMapping = (String)rateMapping + " -ar:a:" + i + " " + String.valueOf(((JComboBox)a).getSelectedItem());
                            break;
                        }
                        ++n4;
                    }
                    componentArray2 = grpSetAudio.getComponents();
                    n3 = componentArray2.length;
                    n4 = 0;
                    while (n4 < n3) {
                        a = componentArray2[n4];
                        if (a instanceof JComboBox && ((JComboBox)a).getName().matches("comboLanguage[0-9]+") && ((JComboBox)a).getName().endsWith(String.valueOf(i + 1))) {
                            if (((JComboBox)a).getSelectedItem().toString().equals("default")) break;
                            languageMapping = (String)languageMapping + " -metadata:s:a:" + i + " language=" + Utils.ISO_639_2_LANGUAGES[((JComboBox)a).getSelectedIndex() - 1][1];
                            break;
                        }
                        ++n4;
                    }
                }
                ++i;
            }
            ++n2;
        }
        if (isBroadcastCodec.booleanValue()) {
            audioFiltering = "";
        } else if (audioFiltering != "") {
            audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
        }
        return (String)audioFiltering + (String)audioMapping + (String)codecMapping + (String)bitrateMapping + (String)rateMapping + (String)languageMapping;
    }
}

