/*
 * Decompiled with CFR 0.152.
 */
package library;

import application.Console;
import application.GOP;
import application.RecordInputDevice;
import application.Settings;
import application.Shutter;
import application.VideoPlayer;
import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import library.FFMPEG;
import settings.FunctionUtils;

public class FFPROBE
extends Shutter {
    public static Process process;
    public static boolean isRunning;
    public static boolean calcul;
    private static boolean videoStreamAnalyzed;
    public static boolean audioOnly;
    public static boolean hasAudio;
    public static boolean attachedPic;
    public static Thread processData;
    public static Thread processFrameData;
    public static Thread processVideoLevels;
    public static Thread processGOP;
    public static Thread processFindStreams;
    public static Thread processSetLength;
    public static String analyzedMedia;
    public static String subtitlesCodec;
    public static int subtitleStreams;
    public static int videoStreams;
    public static int audioStreams;
    public static int totalLength;
    public static String getVideoLengthTC;
    public static String lumaLevel;
    public static float currentFPS;
    public static double accurateFPS;
    public static String interlaced;
    public static String fieldOrder;
    private static boolean videoStream;
    public static String pixelformat;
    public static int imageDepth;
    public static String imageResolution;
    public static int previousImageWidth;
    public static int previousImageHeight;
    public static int imageWidth;
    public static int imageHeight;
    public static float imageRatio;
    public static int cropPixelsWidth;
    public static int cropPixelsHeight;
    public static String dropFrameTC;
    public static String timecode1;
    public static String timecode2;
    public static String timecode3;
    public static String timecode4;
    public static int audioSampleRate;
    public static boolean stereo;
    public static boolean surround;
    public static String channelLayout;
    public static int channels;
    public static int qantization;
    public static String videoCodec;
    public static String audioCodec;
    public static String[] audioCodecs;
    public static String audioBitrate;
    public static String timeBase;
    public static String creationTime;
    public static float HDRmin;
    public static float HDRmax;
    public static int maxCLL;
    public static int maxFALL;
    public static double keyFrame;
    public static int gopCount;
    public static int gopSpace;
    public static boolean hasAlpha;
    public static boolean isRotated;
    public static int gridRows;
    public static int gridCols;

    static {
        isRunning = false;
        calcul = false;
        videoStreamAnalyzed = false;
        audioOnly = true;
        hasAudio = false;
        attachedPic = false;
        analyzedMedia = null;
        subtitlesCodec = "";
        subtitleStreams = 0;
        videoStreams = 0;
        audioStreams = 0;
        videoStream = false;
        pixelformat = "";
        imageDepth = 8;
        imageRatio = 1.777777f;
        dropFrameTC = "";
        timecode1 = "";
        timecode2 = "";
        timecode3 = "";
        timecode4 = "";
        audioSampleRate = 48000;
        stereo = true;
        surround = false;
        channelLayout = "";
        timeBase = "";
        creationTime = "";
        HDRmin = 0.0f;
        HDRmax = 0.0f;
        maxCLL = 0;
        maxFALL = 0;
        keyFrame = 0.0;
        gopCount = 0;
        gopSpace = 124;
        hasAlpha = false;
        isRotated = false;
        gridRows = 0;
        gridCols = 0;
    }

    public static void Data(final String file) {
        if (!file.equals(analyzedMedia) || scanIsRunning || Settings.btnWaitFileComplete.isSelected()) {
            analyzedMedia = file;
            getVideoLengthTC = null;
            if (!inputDeviceIsRunning) {
                channels = 0;
                stereo = false;
            }
            interlaced = null;
            if (!caseForcerDesentrelacement.isSelected() || caseForcerDesentrelacement.isSelected() && lblTFF.getText().contains("x2")) {
                fieldOrder = null;
            }
            videoStreamAnalyzed = false;
            currentFPS = 25.0f;
            accurateFPS = currentFPS;
            dropFrameTC = "";
            surround = false;
            channelLayout = "";
            totalLength = 0;
            qantization = 16;
            subtitlesCodec = "";
            subtitleStreams = 0;
            audioSampleRate = 48000;
            videoStreams = 0;
            audioStreams = 0;
            if (!calcul) {
                audioOnly = true;
            }
            creationTime = "";
            lumaLevel = "unavailable";
            imageWidth = 0;
            imageHeight = 0;
            imageResolution = null;
            videoCodec = null;
            audioCodec = null;
            audioCodecs = new String[50];
            audioBitrate = null;
            FFMPEG.error = false;
            hasAudio = false;
            attachedPic = false;
            btnStart.setEnabled(false);
            imageRatio = 1.777777f;
            String extension = file.toString().substring(file.toString().lastIndexOf("."));
            if (!(caseGenerateFromDate.isSelected() || comboFonctions.getSelectedItem().toString().contains("JPEG") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionPicture")) || extension.toLowerCase().equals(".pdf"))) {
                previousImageWidth = imageWidth;
                previousImageHeight = imageHeight;
            }
            timecode1 = "";
            timecode2 = "";
            timecode3 = "";
            timecode4 = "";
            processData = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            String line;
                            ProcessBuilder processFFPROBE;
                            if (System.getProperty("os.name").contains("Windows")) {
                                PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                PathToFFPROBE = ((String)PathToFFPROBE).substring(1, ((String)PathToFFPROBE).length() - 1);
                                PathToFFPROBE = "\"" + ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", " ") + "/Library/ffprobe.exe\"";
                                if (inputDeviceIsRunning && (file.equals("Capture.current.screen") || file.equals("Capture.input.device"))) {
                                    if (file.equals("Capture.input.device") && RecordInputDevice.inputDeviceResolution == "") {
                                        s = RecordInputDevice.setInputDevices().split("-f ");
                                        if (overlayDeviceIsRunning) {
                                            s = RecordInputDevice.setOverlayDevice().split("-f ");
                                        }
                                        id = s[1].split("\"");
                                        inputDevice = id[0] + "\"" + id[1] + "\"";
                                        processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -f " + inputDevice);
                                    } else if (file.equals("Capture.input.device") && RecordInputDevice.videoDeviceIndex > 0) {
                                        deviceSize = RecordInputDevice.inputDeviceResolution.split("x");
                                        processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -f lavfi -i nullsrc=s=" + deviceSize[0] + "x" + deviceSize[1] + ":d=0:r=" + currentFPS + "\"");
                                    } else {
                                        processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -f lavfi -i nullsrc=s=" + String.valueOf(RecordInputDevice.screenWidth) + "x" + String.valueOf(RecordInputDevice.screenHeigth) + ":d=0\"");
                                    }
                                } else {
                                    processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -i \"" + file + "\"");
                                }
                            } else {
                                PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                                PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).length() - 1);
                                PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", "\\ ") + "/Library/ffprobe";
                                if (inputDeviceIsRunning && (file.equals("Capture.current.screen") || file.equals("Capture.input.device"))) {
                                    if (file.equals("Capture.input.device") && RecordInputDevice.inputDeviceResolution == "") {
                                        s = RecordInputDevice.setInputDevices().split("-f ");
                                        if (overlayDeviceIsRunning) {
                                            s = RecordInputDevice.setOverlayDevice().split("-f ");
                                        }
                                        id = s[1].split("\"");
                                        if (RecordInputDevice.audioDeviceIndex > 0 && !overlayDeviceIsRunning) {
                                            id = s[2].split("\"");
                                        }
                                        inputDevice = id[0] + "\"" + id[1] + "\"";
                                        processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -f " + inputDevice);
                                    } else if (file.equals("Capture.input.device") && RecordInputDevice.videoDeviceIndex > 0) {
                                        deviceSize = RecordInputDevice.inputDeviceResolution.split("x");
                                        processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -f lavfi -i nullsrc=s=" + deviceSize[0] + "x" + deviceSize[1] + ":d=0:r=" + currentFPS + "\"");
                                    } else {
                                        processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -f lavfi -i nullsrc=s=" + String.valueOf(RecordInputDevice.screenWidth) + "x" + String.valueOf(RecordInputDevice.screenHeigth) + ":d=0");
                                    }
                                } else {
                                    processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -i \"" + file + "\"");
                                }
                            }
                            isRunning = true;
                            process = processFFPROBE.start();
                            BufferedReader input = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                            Console.consoleFFPROBE.append(System.lineSeparator());
                            while ((line = input.readLine()) != null) {
                                String[] s;
                                String[] str;
                                Console.consoleFFPROBE.append(line + System.lineSeparator());
                                FFMPEG.checkForErrors(line);
                                if (line.contains("top first") || line.contains("top coded first")) {
                                    interlaced = "1";
                                    if (!caseForcerDesentrelacement.isSelected() || caseForcerDesentrelacement.isSelected() && lblTFF.getText().contains("x2")) {
                                        fieldOrder = "0";
                                    }
                                } else if (line.contains("bottom first") || line.contains("bottom coded first")) {
                                    interlaced = "1";
                                    if (!caseForcerDesentrelacement.isSelected() || caseForcerDesentrelacement.isSelected() && lblTFF.getText().contains("x2")) {
                                        fieldOrder = "1";
                                    }
                                }
                                if (line.contains("Duration:") && !line.contains("Duration: N/A") && !line.contains("<Duration>")) {
                                    String ffmpegTime;
                                    str = line.substring(line.indexOf(":") + 2);
                                    String[] s2 = str.split(",");
                                    getVideoLengthTC = ffmpegTime = s2[0].replace(".", ":");
                                    totalLength = FFPROBE.getTimeToMS(ffmpegTime);
                                    if (totalLength != 0) {
                                        if (VideoPlayer.playerVideo != null) {
                                            VideoPlayer.totalDuration();
                                        }
                                        FFPROBE.setFilesize();
                                    }
                                }
                                if (!(!line.contains("Video:") && !line.contains("Tile Grid:") || line.contains("attached pic") || line.contains("unspecified size") || videoStreamAnalyzed)) {
                                    Pattern resolutionPattern;
                                    Matcher matcher;
                                    if (line.contains("Video:")) {
                                        String[] splitVideo = line.substring(line.indexOf("Video:")).split(" ");
                                        videoCodec = splitVideo[1].replace(",", "");
                                        if (videoCodec.equals("dnxhd") && line.toLowerCase().contains("dnxhr")) {
                                            videoCodec = "dnxhr";
                                        }
                                        if (videoCodec.equals("qtrle")) {
                                            videoCodec = "qt animation";
                                        }
                                        audioOnly = false;
                                        if (line.contains("tv")) {
                                            lumaLevel = "16-235";
                                        } else if (line.contains("pc")) {
                                            lumaLevel = "0-255";
                                        }
                                        String data = line;
                                        data = line.substring(data.indexOf("Video:"));
                                    }
                                    if ((matcher = (resolutionPattern = Pattern.compile("(\\d{2,5})x(\\d{2,5})")).matcher(line)).find()) {
                                        imageWidth = Integer.parseInt(matcher.group(1));
                                        imageHeight = Integer.parseInt(matcher.group(2));
                                        imageResolution = imageWidth + "x" + imageHeight;
                                    }
                                    if (inputDeviceIsRunning && file.equals("Capture.current.screen")) {
                                        imageResolution = String.valueOf(RecordInputDevice.screenWidth) + "x" + String.valueOf(RecordInputDevice.screenHeigth);
                                        imageWidth = RecordInputDevice.screenWidth;
                                        imageHeight = RecordInputDevice.screenHeigth;
                                    }
                                    if (line.contains("DAR")) {
                                        String[] splitDAR = line.split("DAR");
                                        String[] splitDAR2 = splitDAR[1].split(",");
                                        String[] splitDAR3 = splitDAR2[0].replace(" ", "").replace("]", "").split(":");
                                        int ratioWidth = Integer.parseInt(splitDAR3[0]);
                                        int ratioHeight = Integer.parseInt(splitDAR3[1]);
                                        imageRatio = (float)ratioWidth / (float)ratioHeight;
                                    } else {
                                        imageRatio = (float)imageWidth / (float)imageHeight;
                                    }
                                    if (isRotated) {
                                        Integer h = imageHeight;
                                        Integer w = imageWidth;
                                        imageWidth = h;
                                        imageHeight = w;
                                        imageRatio = (float)imageWidth / (float)imageHeight;
                                    }
                                    int width = 0;
                                    int height = 0;
                                    if (ratioFinal < (float)imageWidth / (float)imageHeight) {
                                        int pixelsWidth = imageWidth - height;
                                        cropPixelsWidth = (int)((float)pixelsWidth) / 2;
                                        cropPixelsHeight = 0;
                                    } else {
                                        int pixelsHeight = imageHeight - width;
                                        cropPixelsHeight = (int)((float)pixelsHeight) / 2;
                                        cropPixelsWidth = 0;
                                    }
                                    if (inputDeviceIsRunning) {
                                        currentFPS = file.equals("Capture.current.screen") ? Float.parseFloat(RecordInputDevice.txtScreenRecord.getText()) : Float.parseFloat(RecordInputDevice.txtInputDevice.getText());
                                    } else if (line.contains("fps")) {
                                        String[] str2 = line.split("fps");
                                        if ((str2 = str2[0].substring(str2[0].lastIndexOf(",")).split(" "))[1].contains("k")) {
                                            str2 = line.split("tbr");
                                            str2 = str2[0].substring(str2[0].lastIndexOf(",")).split(" ");
                                        }
                                        if (!((str2 = String.valueOf(currentFPS = Float.parseFloat(str2[1].replace("k", "000"))).split("\\."))[1].length() != 2 || str2[1].equals("00") || str2[1].equals("88") || str2[1].equals("94") || str2[1].equals("97") || str2[1].equals("98"))) {
                                            str2 = line.split("tbr");
                                            if (!(str2 = str2[0].substring(str2[0].lastIndexOf(",")).split(" "))[1].contains("k")) {
                                                currentFPS = Float.parseFloat(str2[1]);
                                            }
                                        }
                                    } else if (line.contains("tbr")) {
                                        String[] str3 = line.split("tbr");
                                        str3 = str3[0].substring(str3[0].lastIndexOf(",")).split(" ");
                                        currentFPS = Float.parseFloat(str3[1]);
                                        if (!((str3 = String.valueOf(currentFPS).split("\\."))[1].length() != 2 || str3[1].equals("00") || str3[1].equals("88") || str3[1].equals("94") || str3[1].equals("97") || str3[1].equals("98"))) {
                                            str3 = line.split("tbr");
                                            if (!(str3 = str3[0].substring(str3[0].lastIndexOf(",")).split(" "))[1].contains("k")) {
                                                currentFPS = Float.parseFloat(str3[1]);
                                            }
                                        }
                                    }
                                    videoStreamAnalyzed = true;
                                }
                                accurateFPS = currentFPS == 23.98f ? 23.976024627685547 : (currentFPS == 29.97f ? (double)29.97003f : (currentFPS == 59.94f ? (double)59.94006f : (double)currentFPS));
                                if (line.contains("attached pic")) {
                                    attachedPic = true;
                                }
                                if (line.contains("Audio:") && !line.contains("Could not find codec parameters")) {
                                    hasAudio = true;
                                    if (line.contains("pcm_s24")) {
                                        qantization = 24;
                                    }
                                    if (line.contains("pcm_s32")) {
                                        qantization = 32;
                                    }
                                    ++channels;
                                    if (line.contains("Hz")) {
                                        s = line.split(",");
                                        int i = 0;
                                        while (!s[++i].contains("Hz")) {
                                        }
                                        audioSampleRate = Integer.parseInt(s[i].replace(" ", "").replace("Hz", ""));
                                    }
                                    if (line.contains("2 channels") || line.contains("stereo")) {
                                        stereo = true;
                                        surround = false;
                                    } else if (line.contains("1 channels") || line.contains("mono")) {
                                        stereo = false;
                                        surround = false;
                                    } else if (line.contains("5.1") || line.contains("6.1") || line.contains("7.1")) {
                                        if (line.contains("5.1")) {
                                            channelLayout = "5.1";
                                        } else if (line.contains("6.1")) {
                                            channelLayout = "6.1";
                                        } else if (line.contains("7.1")) {
                                            channelLayout = "7.1";
                                        }
                                        stereo = true;
                                        surround = true;
                                    }
                                    String[] splitAudio = line.substring(line.indexOf("Audio:")).split(" ");
                                    FFPROBE.audioCodecs[FFPROBE.channels - 1] = audioCodec = splitAudio[1].replace(",", "");
                                    String[] splitBitrate = line.substring(line.indexOf("Audio:")).split(" kb/s");
                                    String[] bitrate = splitBitrate[0].split(" ");
                                    String value = bitrate[bitrate.length - 1];
                                    audioBitrate = value.matches("-?\\d+") ? value : "1536";
                                }
                                if (line.contains("Video:")) {
                                    ++videoStreams;
                                }
                                if (line.contains("Audio:")) {
                                    ++audioStreams;
                                }
                                if (line.contains("Subtitle:")) {
                                    ++subtitleStreams;
                                    s = line.substring(line.lastIndexOf(":") + 1).split(" ");
                                    subtitlesCodec = s[1].replace(",", "");
                                }
                                if (line.contains("timecode") && !line.contains("timecode is invalid") && !line.contains("Input")) {
                                    dropFrameTC = line.contains(";") ? ";" : ":";
                                    if (timecode1 == "") {
                                        str = line.replace(" ", "").replace(";", ":").split(":");
                                        timecode1 = str[1];
                                        timecode2 = str[2];
                                        timecode3 = str[3];
                                        timecode4 = str[4];
                                    }
                                }
                                if (!line.contains("creation_time") || !creationTime.equals("")) continue;
                                s = line.substring(line.indexOf(":") + 1).replace(" ", "").replace("T", " ").split("\\.");
                                creationTime = s[0];
                            }
                            process.waitFor();
                            if (Shutter.caseEnableCrop.isSelected() && cropLock.getName().equals("cropLock")) {
                                Shutter.comboPreset.setSelectedItem(Shutter.comboPreset.getSelectedItem());
                            }
                            if (comboFonctions.getSelectedItem().equals(language.getProperty("functionExtract"))) {
                                FFPROBE.changeFilters();
                            }
                            Console.consoleFFPROBE.append(System.lineSeparator());
                        }
                        catch (Exception e) {
                            FFMPEG.error = true;
                            e.printStackTrace();
                            isRunning = false;
                            btnStart.setEnabled(true);
                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    finally {
                        isRunning = false;
                        btnStart.setEnabled(true);
                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
            processData.start();
        }
    }

    public static void FrameData(final String file) {
        Console.consoleFFPROBE.append(System.lineSeparator());
        Console.consoleFFPROBE.append(language.getProperty("file") + language.getProperty("colon") + " " + file);
        videoStreamAnalyzed = false;
        videoStream = false;
        pixelformat = "";
        imageDepth = 8;
        timeBase = "";
        HDRmin = 0.01f;
        HDRmax = 1000.0f;
        maxCLL = 1000;
        maxFALL = 400;
        hasAlpha = false;
        isRotated = false;
        gridRows = 0;
        gridCols = 0;
        FFMPEG.error = false;
        btnStart.setEnabled(false);
        processFrameData = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        ProcessBuilder processFFPROBE;
                        final String extension = file.substring(file.lastIndexOf("."));
                        String loglevel = "warning";
                        if (extension.toLowerCase().equals(".heic") || extension.toLowerCase().equals(".heif")) {
                            loglevel = "trace";
                        }
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(1, ((String)PathToFFPROBE).length() - 1);
                            PathToFFPROBE = "\"" + ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", " ") + "/Library/ffprobe.exe\"";
                            processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -show_frames -show_streams -read_intervals %+#1 -loglevel " + loglevel + " -i \"" + file + "\"");
                        } else {
                            PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).length() - 1);
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", "\\ ") + "/Library/ffprobe";
                            processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -i \"" + file + "\" -show_frames -show_streams -read_intervals %+#1 -loglevel " + loglevel);
                        }
                        isRunning = true;
                        final Process process = processFFPROBE.start();
                        Thread stream = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                InputStreamReader esr = new InputStreamReader(process.getErrorStream());
                                BufferedReader bre = new BufferedReader(esr);
                                try {
                                    String line;
                                    while ((line = bre.readLine()) != null) {
                                        Console.consoleFFPROBE.append(line + System.lineSeparator());
                                        if (!extension.toLowerCase().equals(".heic") && !extension.toLowerCase().equals(".heif") || !line.contains("grid_rows")) continue;
                                        String[] s = line.split("grid_rows");
                                        String[] s2 = s[1].split(" ");
                                        gridCols = Integer.valueOf(s2[1]);
                                        gridRows = Integer.valueOf(s2[3]);
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                Console.consoleFFPROBE.append(System.lineSeparator());
                            }
                        });
                        stream.start();
                        InputStreamReader isr = new InputStreamReader(process.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        Console.consoleFFPROBE.append(System.lineSeparator());
                        while ((line = br.readLine()) != null) {
                            String[] s2;
                            String depth;
                            String[] s;
                            Console.consoleFFPROBE.append(line + System.lineSeparator());
                            FFMPEG.checkForErrors(line);
                            if (line.contains("interlaced_frame")) {
                                String interlace;
                                interlaced = interlace = line.substring(line.indexOf("interlaced_frame") + 17);
                            }
                            if (line.contains("top_field_first")) {
                                String field = line.substring(line.indexOf("top_field_first") + 16);
                                if (!caseForcerDesentrelacement.isSelected() || caseForcerDesentrelacement.isSelected() && lblTFF.getText().contains("x2")) {
                                    fieldOrder = field.equals("1") ? "0" : "1";
                                }
                            }
                            if (line.contains("rotation") && (s = line.split("="))[1].contains("90")) {
                                isRotated = true;
                            }
                            if (line.contains("codec_type=")) {
                                if (videoStream) {
                                    videoStreamAnalyzed = true;
                                }
                                videoStream = line.contains("codec_type=video") && !videoStreamAnalyzed;
                            }
                            if (line.contains("bits_per_raw_sample") && videoStream && !(depth = line.substring(line.indexOf("bits_per_raw_sample") + 20)).equals("N/A")) {
                                imageDepth = Integer.parseInt(depth);
                            }
                            if (line.contains("pix_fmt") && videoStream) {
                                pixelformat = depth = line.substring(line.indexOf("pix_fmt") + 8);
                                if (!depth.equals("N/A")) {
                                    if (depth.contains("p10")) {
                                        imageDepth = 10;
                                    } else if (depth.contains("p16")) {
                                        imageDepth = 16;
                                    }
                                }
                            }
                            if (line.contains("time_base") && (timeBase = (s = line.split("="))[1]).contains("1/")) {
                                timeBase = s[1].replace("1/", "");
                            }
                            if (line.contains("min_luminance")) {
                                s = line.split("=");
                                s2 = s[1].split("/");
                                HDRmin = (float)Integer.parseInt(s2[0]) / (float)Integer.parseInt(s2[1]);
                            }
                            if (line.contains("max_luminance")) {
                                s = line.split("=");
                                s2 = s[1].split("/");
                                HDRmax = (float)Integer.parseInt(s2[0]) / (float)Integer.parseInt(s2[1]);
                            }
                            if (line.contains("max_content")) {
                                s = line.split("=");
                                maxCLL = Integer.parseInt(s[1]);
                            }
                            if (line.contains("max_average")) {
                                s = line.split("=");
                                maxFALL = Integer.parseInt(s[1]);
                            }
                            if (!line.contains("alpha_mode=1") && !pixelformat.contains("a")) continue;
                            hasAlpha = true;
                        }
                    }
                    catch (Exception e) {
                        FFMPEG.error = true;
                        e.printStackTrace();
                        isRunning = false;
                        btnStart.setEnabled(true);
                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                finally {
                    isRunning = false;
                    btnStart.setEnabled(true);
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        processFrameData.start();
    }

    public static void AnalyzeGOP(final String file, final boolean isGOPWindow) {
        gopCount = 0;
        gopSpace = 124;
        processGOP = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        String line;
                        ProcessBuilder processFFPROBE;
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(1, ((String)PathToFFPROBE).length() - 1);
                            PathToFFPROBE = "\"" + ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", " ") + "/Library/ffprobe.exe\"";
                            processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -show_frames -select_streams v:0 -i \"" + file + "\"");
                        } else {
                            PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).length() - 1);
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", "\\ ") + "/Library/ffprobe";
                            processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -i \"" + file + "\" -select_streams v:0 -show_frames");
                        }
                        processFFPROBE.redirectErrorStream(true);
                        isRunning = true;
                        if (isGOPWindow) {
                            do {
                                Thread.sleep(100L);
                            } while (GOP.frame == null);
                        }
                        Process process = processFFPROBE.start();
                        InputStreamReader isr = new InputStreamReader(process.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        int i = 0;
                        int intra = 0;
                        do {
                            line = br.readLine();
                            Console.consoleFFPROBE.append(line + System.lineSeparator());
                            if (line == null || intra == 2 || i > 10000 || gopCount > 500) {
                                isRunning = false;
                                process.destroy();
                                if (i <= 10000 && gopCount <= 500 || !isGOPWindow) break;
                                GOP.frame.dispose();
                                JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantAnalyzeGop"), Shutter.language.getProperty("analyzeError"), 0);
                                break;
                            }
                            if (line.equals("pict_type=I") && ++intra == 2) {
                                if (isGOPWindow) {
                                    GOP.newImage('I', gopSpace);
                                }
                                gopSpace += 112;
                                ++gopCount;
                            }
                            if (line.equals("pict_type=P")) {
                                if (isGOPWindow) {
                                    GOP.newImage('P', gopSpace);
                                }
                                gopSpace += 112;
                                ++gopCount;
                            }
                            if (line.equals("pict_type=B")) {
                                if (isGOPWindow) {
                                    GOP.newImage('B', gopSpace);
                                }
                                gopSpace += 112;
                                ++gopCount;
                            }
                            ++i;
                        } while (line != null);
                        process.wait();
                    }
                    catch (Exception exception) {
                        isRunning = false;
                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                finally {
                    isRunning = false;
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        processGOP.start();
    }

    public static void Keyframes(final String file, final double inputTime, final boolean getTheNextKey) {
        keyFrame = 0.0;
        FFMPEG.error = false;
        processFrameData = new Thread(new Runnable(){
            double seekTime;
            {
                this.seekTime = d;
            }

            @Override
            public void run() {
                if (!getTheNextKey) {
                    this.seekTime = inputTime - 20000.0;
                    if (this.seekTime < 0.0) {
                        this.seekTime = 0.0;
                    }
                }
                try {
                    try {
                        String line;
                        ProcessBuilder processFFPROBE;
                        if (System.getProperty("os.name").contains("Windows")) {
                            PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(1, ((String)PathToFFPROBE).length() - 1);
                            PathToFFPROBE = "\"" + ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", " ") + "/Library/ffprobe.exe\"";
                            processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -v quiet -read_intervals " + (long)this.seekTime + "ms -show_entries frame=pict_type,pts_time,flags -select_streams v:0 -skip_frame nokey -print_format csv=print_section=0 -i \"" + file + "\"");
                        } else {
                            PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).length() - 1);
                            PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", "\\ ") + "/Library/ffprobe";
                            processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -i \"" + file + "\" -v quiet -read_intervals " + (long)this.seekTime + "ms -show_entries frame=pict_type,pts_time,flags -select_streams v:0 -skip_frame nokey -print_format csv=print_section=0");
                        }
                        processFFPROBE.redirectErrorStream(true);
                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                        isRunning = true;
                        Process process = processFFPROBE.start();
                        InputStreamReader isr = new InputStreamReader(process.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        while ((line = br.readLine()) != null) {
                            FFMPEG.checkForErrors(line);
                            if (line.equals("") || !line.contains("I")) continue;
                            String[] s = line.split(",");
                            float keyPTS = Float.parseFloat(s[0]) * 1000.0f;
                            if (getTheNextKey) {
                                if (!((double)keyPTS > inputTime)) continue;
                                keyFrame = (double)keyPTS / VideoPlayer.inputFramerateMS;
                                process.destroy();
                                break;
                            }
                            if ((double)keyPTS < inputTime && (double)keyPTS > keyFrame) {
                                keyFrame = (double)keyPTS / VideoPlayer.inputFramerateMS;
                                continue;
                            }
                            if (!((double)keyPTS >= inputTime)) continue;
                            process.destroy();
                            break;
                        }
                        process.waitFor();
                    }
                    catch (Exception e) {
                        FFMPEG.error = true;
                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                        isRunning = false;
                    }
                }
                finally {
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    isRunning = false;
                }
            }
        });
        processFrameData.start();
    }

    public static boolean FindStreams(String file) {
        try {
            String line;
            ProcessBuilder processFFPROBE;
            if (System.getProperty("os.name").contains("Windows")) {
                PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                PathToFFPROBE = ((String)PathToFFPROBE).substring(1, ((String)PathToFFPROBE).length() - 1);
                PathToFFPROBE = "\"" + ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", " ") + "/Library/ffprobe.exe\"";
                processFFPROBE = new ProcessBuilder((String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -show_streams -i \"" + file + "\"");
            } else {
                PathToFFPROBE = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).length() - 1);
                PathToFFPROBE = ((String)PathToFFPROBE).substring(0, ((String)PathToFFPROBE).lastIndexOf("/")).replace("%20", "\\ ") + "/Library/ffprobe";
                processFFPROBE = new ProcessBuilder("/bin/bash", "-c", (String)PathToFFPROBE + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -hide_banner -i \"" + file + "\" -show_streams");
            }
            processFFPROBE.redirectErrorStream(true);
            isRunning = true;
            Process process = processFFPROBE.start();
            InputStreamReader input = new InputStreamReader(process.getInputStream());
            BufferedReader br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                if (!line.contains("codec_type=video") && !line.contains("media_type=video")) continue;
                return true;
            }
            process.waitFor();
            return false;
        }
        catch (Exception exception) {
        }
        finally {
            isRunning = false;
            Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    public static void setLength() {
        frame.setCursor(Cursor.getPredefinedCursor(3));
        processSetLength = new Thread(new Runnable(){

            @Override
            public void run() {
                block23: {
                    try {
                        try {
                            calcul = true;
                            if (Shutter.list.getSize() == 0) break block23;
                            if (Shutter.scanIsRunning) {
                                File dir = new File(Shutter.list.firstElement());
                                File[] fileArray = dir.listFiles();
                                int n = fileArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    File f = fileArray[n2];
                                    if (!f.isHidden() && f.isFile()) {
                                        FFPROBE.Data(f.toString());
                                        do {
                                            Thread.sleep(100L);
                                        } while (processData.isAlive());
                                        break block23;
                                    }
                                    ++n2;
                                }
                                break block23;
                            }
                            if (Shutter.fileList.getSelectedIndices().length != 0) {
                                if (!inputDeviceIsRunning) {
                                    FFPROBE.Data(Shutter.fileList.getSelectedValue());
                                }
                                do {
                                    Thread.sleep(100L);
                                } while (processData.isAlive());
                                if (totalLength != 0 && !inputDeviceIsRunning) {
                                    if (Shutter.comboFonctions.getSelectedItem().toString().equals("Blu-ray")) {
                                        float debit = 2.3E7f / (float)totalLength * 8.0f;
                                        if (comboFilter.getSelectedIndex() == 0) {
                                            if (debit > 38.0f) {
                                                debitVideo.setSelectedItem(38000);
                                            } else {
                                                debitVideo.setSelectedItem((int)debit * 1000);
                                            }
                                        } else if (debit > 50.0f) {
                                            debitVideo.setSelectedItem(50000);
                                        } else {
                                            debitVideo.setSelectedItem((int)debit * 1000);
                                        }
                                    }
                                    if (VideoPlayer.playerVideo != null) {
                                        VideoPlayer.totalDuration();
                                    }
                                    FFPROBE.setFilesize();
                                }
                            } else if (!isLocked) {
                                bitrateSize.setText("-");
                            }
                        }
                        catch (Exception exception) {
                            calcul = false;
                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    finally {
                        calcul = false;
                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        processSetLength.start();
    }

    public static void setFilesize() {
        if (grpBitrate.isVisible()) {
            int multi = 0;
            if (lblAudioMapping.getSelectedItem().toString().equals("Multi") && !comboAudioBitrate.getSelectedItem().equals(language.getProperty("custom").toLowerCase())) {
                if (comboAudio1.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio2.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio3.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio4.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio5.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio6.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio7.getSelectedIndex() != 16) {
                    ++multi;
                }
                if (comboAudio8.getSelectedIndex() != 16) {
                    ++multi;
                }
            } else {
                multi = 1;
            }
            if (!(Shutter.list.getSize() <= 0 || imageResolution == null || lblVBR.getText().equals("CQ") && lblVBR.isVisible())) {
                int h = VideoPlayer.durationH;
                int min = VideoPlayer.durationM;
                int sec = VideoPlayer.durationS;
                int frames = VideoPlayer.durationF;
                int audio = 0;
                if (comboAudioBitrate.getSelectedItem().equals(language.getProperty("custom").toLowerCase())) {
                    Component[] componentArray = grpSetAudio.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        if (c instanceof JComboBox && ((JComboBox)c).getName().matches("comboAudio[0-9]+") && ((JComboBox)c).getSelectedIndex() != 16) {
                            Component[] componentArray2 = grpSetAudio.getComponents();
                            int n3 = componentArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Component c2 = componentArray2[n4];
                                if (c2 instanceof JComboBox && ((JComboBox)c2).getName().contains("comboAudioBitrate") && ((JComboBox)c2).getName().equals(((JComboBox)c).getName().replace("comboAudio", "comboAudioBitrate"))) {
                                    audio += Integer.parseInt(((JComboBox)c2).getSelectedItem().toString());
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                } else {
                    audio = Integer.parseInt(debitAudio.getSelectedItem().toString());
                }
                if (isLocked) {
                    float finalSize = Float.parseFloat(bitrateSize.getText().replace(",", "."));
                    float result = finalSize / ((float)(h * 3600 + min * 60 + sec) + (float)frames * (1.0f / currentFPS));
                    float resultAudio = (float)(audio * multi) / 8.0f / 1024.0f;
                    float resultatBitrate = (result - resultAudio) * 8.0f * 1024.0f;
                    debitVideo.getModel().setSelectedItem((int)resultatBitrate);
                } else {
                    float resultAudio;
                    Integer videoBitrate;
                    float resultVideo;
                    float resultatBitrate;
                    if (comboAudioCodec.getSelectedItem().toString().equals("FLAC")) {
                        audio = 1536;
                    }
                    if ((resultatBitrate = ((resultVideo = (float)(videoBitrate = Integer.valueOf(FunctionUtils.setVideoBitrate())).intValue() / 8.0f / 1024.0f) + (resultAudio = (float)(audio * multi) / 8.0f / 1024.0f)) * ((float)(h * 3600 + min * 60 + sec) + (float)frames * (1.0f / currentFPS))) < 10.0f) {
                        bitrateSize.setText(String.valueOf((double)Math.round((double)resultatBitrate * 100.0) / 100.0));
                    } else {
                        bitrateSize.setText(String.valueOf((int)resultatBitrate));
                    }
                }
            } else if (!isLocked) {
                bitrateSize.setText("-");
            }
        }
    }

    private static int getTimeToMS(String time) {
        String[] t = time.split(":");
        int heures = Integer.parseInt(t[0]);
        int minutes = Integer.parseInt(t[1]);
        int secondes = Integer.parseInt(t[2]);
        int images = Integer.parseInt(t[3]) * 10;
        int totalMiliSecondes = heures * 3600000 + minutes * 60000 + secondes * 1000 + images;
        return totalMiliSecondes;
    }
}

