/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.RenderQueue;
import application.Shutter;
import application.VideoPlayer;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Timecode;

public class VMAF
extends Shutter {
    boolean warningSourceFile = true;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < list.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)list.getElementAt(i)));
                    if (file == null) break;
                    JOptionPane.showMessageDialog(frame, language.getProperty("sourceFile") + language.getProperty("colon") + System.lineSeparator() + file.getName(), "VMAF", 1);
                    FileDialog dialog = new FileDialog((Frame)frame, language.getProperty("source"), 0);
                    dialog.setDirectory(new File(file.toString()).getParent());
                    dialog.setLocation(VMAF.frame.getLocation().x - 50, VMAF.frame.getLocation().y + 50);
                    dialog.setAlwaysOnTop(true);
                    dialog.setMultipleMode(false);
                    dialog.setVisible(true);
                    if (dialog.getFile() != null) {
                        try {
                            String fileName = file.getName();
                            lblCurrentEncoding.setText(fileName);
                            if (FunctionUtils.analyze(file, false)) {
                                if (VideoPlayer.caseApplyCutToAll.isSelected()) {
                                    VideoPlayer.videoPath = file.toString();
                                    VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(InputAndOutput.savedInPoint));
                                    VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode((double)FFPROBE.totalLength / 1000.0 * FFPROBE.accurateFPS - InputAndOutput.savedOutPoint));
                                    VideoPlayer.setFileList();
                                }
                                InputAndOutput.getInputAndOutput(VideoPlayer.getFileList(file.toString(), FFPROBE.totalLength));
                                String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -filter_complex libvmaf -an -f null -" : " -filter_complex libvmaf -an -f null -\"";
                                FFMPEG.run(InputAndOutput.inPoint + " -i \"" + file.toString() + "\"" + InputAndOutput.inPoint + " -i \"" + dialog.getDirectory() + dialog.getFile().toString() + "\"" + InputAndOutput.outPoint + cmd);
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.runProcess.isAlive());
                                if (!cancelled) {
                                    VMAF.showDetection(file);
                                }
                                if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && VMAF.lastActions(file, fileName)) {
                                    break;
                                }
                            }
                        }
                        catch (InterruptedException e) {
                            FFMPEG.error = true;
                        }
                    }
                    ++i;
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    VMAF.endOfFunction();
                }
            }
        });
        thread.start();
    }

    private static void showDetection(File file) {
        if (FFMPEG.VMAFScore != null && !Shutter.cancelled && !FFMPEG.error) {
            if (comboFilter.getSelectedIndex() == 0) {
                JOptionPane.showMessageDialog(frame, file.getName() + System.lineSeparator() + FFMPEG.VMAFScore, "VMAF", 1);
            } else {
                String prefix = "";
                if (casePrefix.isSelected()) {
                    prefix = FunctionUtils.setPrefixSuffix(txtPrefix.getText(), false);
                }
                String extensionName = "";
                if (btnExtension.isSelected()) {
                    extensionName = FunctionUtils.setPrefixSuffix(txtExtension.getText(), false);
                }
                String fileOutputName = FunctionUtils.setOutputDestination("", file).replace("\\", "/") + "/" + prefix + file.getName() + extensionName;
                try {
                    PrintWriter writer = new PrintWriter(fileOutputName + ".txt", "UTF-8");
                    writer.println(Shutter.language.getProperty("analyzeOf") + " " + file.getName());
                    writer.println("");
                    writer.println(FFMPEG.VMAFScore);
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean lastActions(File file, String fileName) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++FunctionUtils.completed;
        }
        lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
        FunctionUtils.addFileForMail(fileName);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            VMAF.main();
            return true;
        }
        return false;
    }
}

