/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import library.FFMPEG;
import org.json.JSONArray;
import settings.FunctionUtils;

public class Translate
extends Shutter {
    private static final int CHUNK_SIZE = 5000;

    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                btnStart.setEnabled(false);
                btnCancel.setEnabled(true);
                int i = 0;
                while (i < list.getSize()) {
                    FFMPEG.error = false;
                    progressBar1.setValue(0);
                    File file = FunctionUtils.setInputFile(new File((String)list.getElementAt(i)));
                    if (file == null) break;
                    try {
                        String fileName = file.getName();
                        String extension = fileName.substring(fileName.lastIndexOf("."));
                        if (extension.equals(".txt") || extension.equals(".vtt") || extension.equals(".srt")) {
                            lblCurrentEncoding.setText(fileName);
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String prefix = "";
                            if (casePrefix.isSelected()) {
                                prefix = FunctionUtils.setPrefixSuffix(txtPrefix.getText(), false);
                            }
                            String extensionName = "";
                            if (btnExtension.isSelected()) {
                                extensionName = FunctionUtils.setPrefixSuffix(txtExtension.getText(), false);
                            }
                            String selectedLanguage = Utils.ISO_639_2_LANGUAGES[comboFilter.getSelectedIndex()][0];
                            String fileOutputName = labelOutput.replace("\\", "/") + "/" + prefix + fileName.replace(extension, extensionName + "_" + String.valueOf(comboFilter.getSelectedItem()) + extension);
                            String content = Files.readString(file.toPath(), StandardCharsets.UTF_8);
                            List<String> chunks = Translate.chunkText(content, 5000);
                            progressBar1.setMaximum(chunks.size());
                            String translated = Translate.translateText(content, "auto", selectedLanguage);
                            Files.writeString(new File(fileOutputName).toPath(), (CharSequence)translated, StandardCharsets.UTF_8, new OpenOption[0]);
                        } else {
                            FFMPEG.error = true;
                        }
                        if (!FFMPEG.saveCode && Translate.lastActions(file, fileName)) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                Translate.endOfFunction();
            }
        });
        thread.start();
    }

    private static String translateText(String text, String sourceLang, String targetLang) throws Exception {
        List<String> chunks = Translate.chunkText(text, 5000);
        StringBuilder result = new StringBuilder();
        for (String chunk : chunks) {
            result.append(Translate.translateChunk(chunk, sourceLang, targetLang)).append(" ");
            progressBar1.setValue(progressBar1.getValue() + 1);
            if (cancelled) break;
        }
        return result.toString().trim();
    }

    private static String translateChunk(String text, String sourceLang, String targetLang) throws Exception {
        String urlStr = String.format("https://translate.googleapis.com/translate_a/single?client=gtx&sl=%s&tl=%s&dt=t&q=%s", URLEncoder.encode(sourceLang, "UTF-8"), URLEncoder.encode(targetLang, "UTF-8"), URLEncoder.encode(text, "UTF-8"));
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String response = reader.readLine();
            return Translate.parseTranslation(response);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String parseTranslation(String json) {
        JSONArray arr = new JSONArray(json);
        JSONArray inner = arr.getJSONArray(0);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < inner.length()) {
            sb.append(inner.getJSONArray(i).getString(0));
            ++i;
        }
        return sb.toString();
    }

    private static List<String> chunkText(String text, int chunkSize) {
        ArrayList<String> chunks = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int length = text.length();
        int i = 0;
        while (i < length) {
            int nextSpace = text.indexOf(32, i);
            int nextNewline = text.indexOf(10, i);
            int next = -1;
            next = nextSpace == -1 && nextNewline == -1 ? length : (nextSpace == -1 ? nextNewline : (nextNewline == -1 ? nextSpace : Math.min(nextSpace, nextNewline)));
            String token = text.substring(i, Math.min(next, length));
            if (current.length() + token.length() + 1 > chunkSize) {
                chunks.add(current.toString());
                current.setLength(0);
            }
            current.append(token);
            if (next == nextNewline) {
                current.append('\n');
            } else {
                current.append(' ');
            }
            i = next + 1;
        }
        if (current.length() > 0) {
            chunks.add(current.toString());
        }
        return chunks;
    }

    private static boolean lastActions(File file, String fileName) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++FunctionUtils.completed;
        }
        lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
        FunctionUtils.addFileForMail(fileName);
        return false;
    }
}

