/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.RenderQueue;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import library.FFMPEG;
import library.FFPROBE;
import settings.AudioSettings;
import settings.FunctionUtils;
import settings.Timecode;

public class Merge
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int toExtension = ((String)list.firstElement()).toString().lastIndexOf(46);
                String container = ((String)list.firstElement()).substring(toExtension);
                FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseFileName"), 1);
                dialog.setDirectory(new File(((String)list.elementAt(0)).toString()).getParent());
                dialog.setFile(language.getProperty("functionMerge") + container);
                dialog.setVisible(true);
                if (dialog.getFile() != null) {
                    String fileOutputName = dialog.getDirectory() + dialog.getFile().toString().replace(container, "") + container;
                    File listeBAB = new File(dialog.getDirectory() + dialog.getFile().toString() + ".txt");
                    try {
                        int totalLength = 0;
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        PrintWriter writer = new PrintWriter(listeBAB, "UTF-8");
                        String timecode = "";
                        int i = 0;
                        while (i < list.getSize()) {
                            File file2;
                            if (Settings.btnWaitFileComplete.isSelected() && !FunctionUtils.waitFileCompleted(file2 = new File((String)list.getElementAt(i)))) break;
                            FFPROBE.Data((String)list.getElementAt(i));
                            do {
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (InterruptedException file2) {
                                    // empty catch block
                                }
                            } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
                            do {
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (InterruptedException file2) {
                                    // empty catch block
                                }
                            } while (FFPROBE.isRunning);
                            if (i == 0) {
                                timecode = Timecode.setTimecode(null);
                            }
                            totalLength += FFPROBE.totalLength;
                            FFPROBE.totalLength = 0;
                            writer.println("file '" + (String)list.getElementAt(i) + "'");
                            ++i;
                        }
                        writer.close();
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        progressBar1.setMaximum(totalLength / 1000);
                        FFPROBE.totalLength = progressBar1.getMaximum();
                        FFMPEG.fileLength = progressBar1.getMaximum();
                        lblCurrentEncoding.setText(Shutter.language.getProperty("babEncoding"));
                        String metadatas = FunctionUtils.setMetadata();
                        File fileOut = new File(fileOutputName);
                        String audio = Merge.setAudio();
                        String audioMapping = Merge.setAudioMapping();
                        String openGOP = "";
                        if (caseOpenGop.isSelected()) {
                            openGOP = " -copyinkf";
                        }
                        if (!cancelled) {
                            String cmd = timecode + openGOP + " -video_track_timescale 90000 -c:v copy -c:s copy" + audio + " -map v:0?" + audioMapping + metadatas + " -map s? -y ";
                            FFMPEG.run(" -safe 0 -f concat -i \"" + listeBAB.toString() + "\"" + cmd + "\"" + fileOutputName + "\"");
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                        }
                        listeBAB.delete();
                        if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                            Merge.lastActions(fileOut);
                        }
                    }
                    catch (FileNotFoundException | UnsupportedEncodingException | InterruptedException e) {
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        FFMPEG.error = true;
                    }
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    Merge.endOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setAudio() {
        if (caseChangeAudioCodec.isSelected()) {
            if (comboAudioCodec.getSelectedItem().equals(language.getProperty("custom"))) {
                return "";
            }
            if (comboAudioCodec.getSelectedItem().toString().contains("PCM")) {
                switch (comboAudioCodec.getSelectedIndex()) {
                    case 0: {
                        return " -c:a pcm_s16le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k";
                    }
                    case 1: {
                        return " -c:a pcm_s24le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k";
                    }
                    case 2: {
                        return " -c:a pcm_s32le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k";
                    }
                    case 3: {
                        return " -c:a pcm_f32le -ar " + lbl48k.getSelectedItem().toString() + " -b:a 1536k";
                    }
                }
            } else {
                if (comboAudioCodec.getSelectedItem().toString().equals("FLAC")) {
                    return " -c:a flac -ar " + lbl48k.getSelectedItem().toString() + " -compression_level " + comboAudioBitrate.getSelectedItem().toString();
                }
                if (comboAudioCodec.getSelectedItem().toString().equals("AAC")) {
                    if (System.getProperty("os.name").contains("Mac")) {
                        return " -c:a aac_at -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                    }
                    return " -c:a aac -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                }
                if (comboAudioCodec.getSelectedItem().toString().equals("MP3")) {
                    return " -c:a libmp3lame -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                }
                if (comboAudioCodec.getSelectedItem().toString().equals("AC3")) {
                    return " -c:a ac3 -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                }
                if (comboAudioCodec.getSelectedItem().toString().equals("Opus")) {
                    return " -c:a libopus -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                }
                if (comboAudioCodec.getSelectedItem().toString().equals("Vorbis")) {
                    return " -c:a libvorbis -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                }
                if (comboAudioCodec.getSelectedItem().toString().equals("Dolby Digital Plus")) {
                    return " -c:a eac3 -ar " + lbl48k.getSelectedItem().toString() + " -b:a " + comboAudioBitrate.getSelectedItem().toString() + "k";
                }
                if (comboAudioCodec.getSelectedItem().toString().equals(language.getProperty("noAudio"))) {
                    return " -an";
                }
            }
        }
        return " -c:a copy";
    }

    private static String setAudioMapping() {
        Object audioFiltering = "";
        audioFiltering = AudioSettings.setEQ((String)audioFiltering);
        if (grpSetAudio.isVisible() && caseChangeAudioCodec.isSelected() && comboAudioCodec.getSelectedItem().equals(language.getProperty("custom"))) {
            return AudioSettings.setCustomAudio(false, (String)audioFiltering);
        }
        Object mapping = "";
        if (comboAudio1.getSelectedIndex() == 0 && comboAudio2.getSelectedIndex() == 1 && comboAudio3.getSelectedIndex() == 2 && comboAudio4.getSelectedIndex() == 3 && comboAudio5.getSelectedIndex() == 4 && comboAudio6.getSelectedIndex() == 5 && comboAudio7.getSelectedIndex() == 6 && comboAudio8.getSelectedIndex() == 7) {
            if (audioFiltering != "") {
                audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
            }
            return (String)audioFiltering + " -map a?";
        }
        if (comboAudio1.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio1.getSelectedIndex() + "?";
        }
        if (comboAudio2.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio2.getSelectedIndex() + "?";
        }
        if (comboAudio3.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio3.getSelectedIndex() + "?";
        }
        if (comboAudio4.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio4.getSelectedIndex() + "?";
        }
        if (comboAudio5.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio5.getSelectedIndex() + "?";
        }
        if (comboAudio6.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio6.getSelectedIndex() + "?";
        }
        if (comboAudio7.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio7.getSelectedIndex() + "?";
        }
        if (comboAudio8.getSelectedIndex() != 16) {
            mapping = (String)mapping + " -map a:" + comboAudio8.getSelectedIndex() + "?";
        }
        if (audioFiltering != "") {
            audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
        }
        return mapping;
    }

    private static void lastActions(File fileOut) {
        FunctionUtils.cleanFunction(null, fileOut.toString(), fileOut, "");
        FunctionUtils.addFileForMail(fileOut.toString());
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
    }
}

