/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.RenderQueue;
import application.Shutter;
import application.VideoPlayer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Timecode;

public class BlackDetection
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < list.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)list.getElementAt(i)));
                    if (file == null) break;
                    try {
                        String fileName = file.getName();
                        lblCurrentEncoding.setText(fileName);
                        if (FunctionUtils.analyze(file, false)) {
                            if (VideoPlayer.caseApplyCutToAll.isSelected()) {
                                VideoPlayer.videoPath = file.toString();
                                VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(InputAndOutput.savedInPoint));
                                VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode((double)FFPROBE.totalLength / 1000.0 * FFPROBE.accurateFPS - InputAndOutput.savedOutPoint));
                                VideoPlayer.setFileList();
                            }
                            InputAndOutput.getInputAndOutput(VideoPlayer.getFileList(file.toString(), FFPROBE.totalLength));
                            String levels = "0.1";
                            if (FFPROBE.lumaLevel.equals("0-255")) {
                                levels = "0.0";
                            }
                            String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -an -vf blackdetect=d=0.0:pix_th=" + levels + " -f null -" : " -an -vf blackdetect=d=0.0:pix_th=" + levels + " -f null -\"";
                            FFMPEG.run(InputAndOutput.inPoint + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (!cancelled) {
                                BlackDetection.showDetection(file);
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && BlackDetection.lastActions(file, fileName)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    BlackDetection.endOfFunction();
                }
            }
        });
        thread.start();
    }

    private static void showDetection(File file) {
        if (!Shutter.cancelled && !FFMPEG.error) {
            if (comboFilter.getSelectedIndex() == 0) {
                if (FFMPEG.blackFrame.length() > 0) {
                    JOptionPane.showMessageDialog(frame, FFMPEG.blackFrame, Shutter.language.getProperty("functionBlackDetection"), 0);
                } else {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("noErrorDetected"), Shutter.language.getProperty("functionBlackDetection"), 1);
                }
            } else {
                String prefix = "";
                if (casePrefix.isSelected()) {
                    prefix = FunctionUtils.setPrefixSuffix(txtPrefix.getText(), false);
                }
                String extensionName = "";
                if (btnExtension.isSelected()) {
                    extensionName = FunctionUtils.setPrefixSuffix(txtExtension.getText(), false);
                }
                String fileOutputName = FunctionUtils.setOutputDestination("", file).replace("\\", "/") + "/" + prefix + file.getName() + extensionName;
                try {
                    PrintWriter writer = new PrintWriter(fileOutputName + ".txt", "UTF-8");
                    writer.println(Shutter.language.getProperty("analyzeOf") + " " + file.getName());
                    writer.println("");
                    if (FFMPEG.blackFrame.length() > 0) {
                        writer.println(FFMPEG.blackFrame);
                    } else {
                        writer.println(Shutter.language.getProperty("noErrorDetected"));
                    }
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean lastActions(File file, String fileName) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++FunctionUtils.completed;
        }
        lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
        FunctionUtils.addFileForMail(fileName);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            BlackDetection.main();
            return true;
        }
        return false;
    }
}

