/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.RenderQueue;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import functions.AudioNormalization;
import java.io.File;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.AudioSettings;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Timecode;
import settings.Transitions;

public class AudioEncoders
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < list.getSize()) {
                    block68: {
                        File file;
                        block69: {
                            if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) break block69;
                            boolean isSelected = false;
                            for (String input : Shutter.fileList.getSelectedValuesList()) {
                                if (!((String)list.getElementAt(i)).equals(input)) continue;
                                isSelected = true;
                            }
                            if (!isSelected) break block68;
                        }
                        if ((file = FunctionUtils.setInputFile(new File((String)list.getElementAt(i)))) == null) break;
                        try {
                            String fileOutputName;
                            File fileOut;
                            String fileName = file.getName();
                            String extension = fileName.substring(fileName.lastIndexOf("."));
                            lblCurrentEncoding.setText(fileName);
                            if (!FunctionUtils.analyze(file, false)) break block68;
                            if (VideoPlayer.caseApplyCutToAll.isSelected()) {
                                VideoPlayer.videoPath = file.toString();
                                VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(InputAndOutput.savedInPoint));
                                VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode((double)FFPROBE.totalLength / 1000.0 * FFPROBE.accurateFPS - InputAndOutput.savedOutPoint));
                                VideoPlayer.setFileList();
                            }
                            InputAndOutput.getInputAndOutput(VideoPlayer.getFileList(file.toString(), FFPROBE.totalLength));
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String prefix = "";
                            if (casePrefix.isSelected()) {
                                prefix = FunctionUtils.setPrefixSuffix(txtPrefix.getText(), false);
                            }
                            String extensionName = "";
                            if (btnExtension.isSelected()) {
                                extensionName = FunctionUtils.setPrefixSuffix(txtExtension.getText(), false);
                            }
                            String DRC = "";
                            if (FFPROBE.audioCodec != null && FFPROBE.audioCodec.equals("ac3") && !caseDRC.isSelected()) {
                                DRC = " -drc_scale 0";
                            }
                            String timecode = Timecode.setTimecode(file);
                            Object audioCodec = "";
                            Object container = "";
                            String noVideo = " -vn";
                            if (FFPROBE.attachedPic) {
                                noVideo = "";
                            }
                            boolean stereoOutput = false;
                            switch (comboFonctions.getSelectedItem().toString()) {
                                case "AAC": {
                                    audioCodec = System.getProperty("os.name").contains("Mac") ? "aac_at -b:a " + comboFilter.getSelectedItem().toString() + "k -vn -write_id3v2 1" : "aac -b:a " + comboFilter.getSelectedItem().toString() + "k -vn -write_id3v2 1";
                                    container = ".m4a";
                                    stereoOutput = false;
                                    break;
                                }
                                case "AC3": {
                                    audioCodec = "ac3 -b:a " + comboFilter.getSelectedItem().toString() + "k -write_id3v2 1";
                                    container = ".ac3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "AIFF": {
                                    audioCodec = comboFilter.getSelectedItem().toString().contains("Float") ? "pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "be" + noVideo + " -write_id3v2 1" : "pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "be" + noVideo + " -write_id3v2 1";
                                    stereoOutput = true;
                                    container = ".aif";
                                    break;
                                }
                                case "FLAC": {
                                    audioCodec = "flac -compression_level " + comboFilter.getSelectedItem().toString() + noVideo + " -write_id3v2 1";
                                    container = ".flac";
                                    stereoOutput = true;
                                    break;
                                }
                                case "ALAC": {
                                    audioCodec = "alac -sample_fmt s" + comboFilter.getSelectedItem().toString().replace(" Bits", "").replace("24", "32") + "p -vn -write_id3v2 1";
                                    container = ".m4a";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Vorbis": {
                                    audioCodec = "libvorbis -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    container = ".oga";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Dolby Digital Plus": {
                                    audioCodec = "eac3 -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    container = ".eac3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Dolby TrueHD": {
                                    audioCodec = "truehd -strict " + String.valueOf(Settings.comboStrict.getSelectedItem());
                                    container = ".thd";
                                    stereoOutput = true;
                                    break;
                                }
                                case "Opus": {
                                    audioCodec = "libopus -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    if (FFPROBE.surround && FFPROBE.channelLayout != "") {
                                        audioCodec = (String)audioCodec + " -channel_layout " + FFPROBE.channelLayout;
                                    }
                                    container = ".opus";
                                    stereoOutput = false;
                                    break;
                                }
                                case "MP3": {
                                    audioCodec = "libmp3lame -b:a " + comboFilter.getSelectedItem().toString() + "k" + noVideo + " -write_id3v2 1";
                                    container = ".mp3";
                                    stereoOutput = true;
                                    break;
                                }
                                case "WAV": {
                                    audioCodec = comboFilter.getSelectedItem().toString().contains("Float") ? "pcm_f" + comboFilter.getSelectedItem().toString().replace(" Float", "") + "le" + noVideo + " -write_bext 1 -write_id3v2 1" : "pcm_s" + comboFilter.getSelectedItem().toString().replace(" Bits", "") + "le" + noVideo + " -write_bext 1 -write_id3v2 1";
                                    container = ".wav";
                                    stereoOutput = true;
                                }
                            }
                            if (VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("splitMode"))) {
                                container = "_%03d" + (String)container;
                            }
                            if ((fileOut = new File(fileOutputName = labelOutput.replace("\\", "/") + "/" + prefix + fileName.replace(extension, extensionName + (String)container))).exists()) {
                                fileOut = FunctionUtils.fileReplacement(labelOutput, prefix + fileName, extension, extensionName + "_", (String)container);
                                if (fileOut == null) {
                                    cancelled = true;
                                    break;
                                }
                                if (fileOut.toString().equals("skip")) break block68;
                            }
                            String concat = FunctionUtils.setConcat(file, labelOutput);
                            if (Settings.btnSetBab.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) {
                                file = new File(labelOutput.replace("\\", "/") + "/" + fileName.replace(extension, ".txt"));
                            }
                            String audio = AudioEncoders.setAudio((String)audioCodec, stereoOutput, file);
                            if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
                                if (cancelled) break;
                                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                    AudioEncoders.enableAll();
                                }
                                lblCurrentEncoding.setText(file.getName());
                            }
                            if (caseSplitAudio.isSelected()) {
                                AudioEncoders.splitAudio((String)audioCodec, prefix, fileName, extension, file, labelOutput, fileOut.toString(), (String)container, DRC, timecode);
                            } else if (caseMixAudio.isSelected() && lblMix.getText().equals("2.1")) {
                                cmd = " " + audio + timecode + " -y ";
                                FFMPEG.run(InputAndOutput.inPoint + concat + DRC + " -i \"" + (String)list.getElementAt(0) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(1) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(2) + "\"" + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
                                cmd = " " + audio + timecode + " -y ";
                                FFMPEG.run(InputAndOutput.inPoint + concat + DRC + " -i \"" + (String)list.getElementAt(0) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(1) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(2) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(3) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(4) + "\"" + InputAndOutput.outPoint + DRC + " -i \"" + (String)list.getElementAt(5) + "\"" + InputAndOutput.outPoint + (String)cmd + "\"" + String.valueOf(fileOut) + "\"");
                            } else {
                                cmd = " " + audio + timecode + " -y ";
                                FFMPEG.run(InputAndOutput.inPoint + concat + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOut) + "\"");
                            }
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && caseMixAudio.isSelected() && !FFPROBE.surround || (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && !caseSplitAudio.isSelected() || !FFMPEG.saveCode && Settings.btnSetBab.isSelected() || !FFMPEG.saveCode && VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) && AudioEncoders.lastActions(file, fileName, fileOut, labelOutput)) {
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            FFMPEG.error = true;
                        }
                    }
                    ++i;
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    AudioEncoders.endOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setAudio(String codec, boolean stereoOutput, File file) {
        Object audio = "";
        Object audioFiltering = "";
        if (AudioSettings.setEQ((String)audioFiltering) != "") {
            audioFiltering = "," + AudioSettings.setEQ((String)audioFiltering);
        }
        if (Transitions.setAudioFadeIn(false) != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioSpeed();
        }
        if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
            AudioNormalization.main(file);
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (AudioNormalization.thread.isAlive());
            lblCurrentEncoding.setText(file.getName());
            audioFiltering = (String)audioFiltering + ",volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB";
        }
        if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo")) && FFPROBE.surround) {
            audio = (String)audio + "-af \"pan=stereo|FL=FC+0.30*FL+0.30*BL|FR=FC+0.30*FR+0.30*BR" + (String)audioFiltering + "\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("stereo"))) {
            int n = 1;
            while (n < list.size()) {
                audio = (String)audio + "-i \"" + (String)list.elementAt(n) + "\" ";
                ++n;
            }
            if (FFPROBE.stereo) {
                audio = (String)audio + "-filter_complex amerge=inputs=" + list.size() + (String)audioFiltering + " -ac 2 ";
            } else {
                audio = (String)audio + "-filter_complex \"";
                if (list.size() > 2) {
                    Object left = "";
                    int cl = 0;
                    Object right = "";
                    int cr = 0;
                    int n2 = 0;
                    while (n2 < list.size()) {
                        if (n2 % 2 == 0) {
                            left = (String)left + "[" + n2 + ":0]";
                            ++cl;
                        } else {
                            right = (String)right + "[" + n2 + ":0]";
                            ++cr;
                        }
                        ++n2;
                    }
                    audio = (String)audio + (String)left + "amix=inputs=" + cl + "[left];" + (String)right + "amix=inputs=" + cr + "[right];";
                    audio = (String)audio + "[left][right]amerge=inputs=2" + (String)audioFiltering + "[out]\" -map \"[out]\" -ac 2 ";
                } else {
                    audio = (String)audio + "[0:a][1:a]amerge=inputs=2" + (String)audioFiltering + "[out]\" -map \"[out]\" -ac 2 ";
                }
            }
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("2.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a]join=inputs=3:channel_layout=2.1" + (String)audioFiltering + "[a]\" -map \"[a]\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals("5.1")) {
            audio = "-filter_complex \"[0:a][1:a][2:a][3:a][4:a][5:a]join=inputs=6:channel_layout=5.1" + (String)audioFiltering + "[a]\" -map \"[a]\" ";
        } else if (caseMixAudio.isSelected() && lblMix.getText().equals(language.getProperty("mono"))) {
            int n = 1;
            while (n < list.size()) {
                audio = (String)audio + "-i \"" + (String)list.elementAt(n) + "\" ";
                ++n;
            }
            audio = (String)audio + "-filter_complex amerge=inputs=" + list.size() + (String)audioFiltering + " -ac 1 ";
        } else if (FFPROBE.stereo) {
            if (audioFiltering != "") {
                audio = ((String)audioFiltering).replaceFirst(",", " -filter_complex ") + " ";
            }
        } else if (FFPROBE.channels > 1) {
            audio = stereoOutput ? "-filter_complex \"[0:a:0][0:a:1]amerge=inputs=2" + (String)audioFiltering + "[a]\" -map \"[a]\" " : ((String)audioFiltering).replaceFirst(",", " -filter_complex ") + " -map a? ";
        } else if (audioFiltering != "") {
            audio = (String)audio + ((String)audioFiltering).replaceFirst(",", " -filter_complex ") + " ";
        }
        audio = (String)audio + "-c:a " + codec + " ";
        if (caseSampleRate.isSelected()) {
            audio = (String)audio + "-ar " + lbl48k.getSelectedItem().toString() + " ";
        }
        return audio;
    }

    private static void splitAudio(String codec, String prefix, String fileName, String extension, File file, String output, String fileOut, String container, String DRC, String timecode) throws InterruptedException {
        Object audioFiltering = "";
        if (AudioSettings.setEQ((String)audioFiltering) != "") {
            audioFiltering = "," + AudioSettings.setEQ((String)audioFiltering);
        }
        if (Transitions.setAudioFadeIn(false) != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            audioFiltering = (String)audioFiltering + "," + Transitions.setAudioSpeed();
        }
        if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
            audioFiltering = (String)audioFiltering + ",volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB";
        }
        Object sampleRate = "";
        if (caseSampleRate.isSelected()) {
            sampleRate = " -ar " + lbl48k.getSelectedItem().toString();
        }
        if (FFPROBE.surround) {
            if (audioFiltering != "") {
                audioFiltering = ((String)audioFiltering).substring(1, ((String)audioFiltering).length()) + ",";
            }
            if (lblSplit.getText().equals(language.getProperty("mono"))) {
                String cmd = " -filter_complex \"" + (String)audioFiltering + "channelsplit=channel_layout=5.1[FL][FR][FC][LFE][BL][BR]\"" + timecode + " -y ";
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + " -map \"[FL]\" -c:a " + codec + (String)sampleRate + " \"" + fileOut.replace(container, "_FL" + container) + "\" -map \"[FR]\" -c:a " + codec + (String)sampleRate + " \"" + fileOut.replace(container, "_FR" + container) + "\" -map \"[FC]\" -c:a " + codec + (String)sampleRate + " \"" + fileOut.replace(container, "_FC" + container) + "\" -map \"[LFE]\" -c:a " + codec + (String)sampleRate + " \"" + fileOut.replace(container, "_LFE" + container) + "\" -map \"[BL]\" -c:a " + codec + (String)sampleRate + " \"" + fileOut.replace(container, "_BL" + container) + "\" -map \"[BR]\" -c:a " + codec + (String)sampleRate + " \"" + fileOut.replace(container, "_BR" + container) + "\"");
            } else if (lblSplit.getText().equals(language.getProperty("stereo"))) {
                String cmd = " -af \"" + (String)audioFiltering + "pan=stereo|c0=FL|c1=FR\" -c:a " + codec + (String)sampleRate + timecode + " -y ";
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + fileOut + "\"");
            }
        } else if (FFPROBE.channels == 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < 3) {
                String yesno = " -y ";
                File fileOutput = new File(output + "/" + prefix + fileName.replace(extension, "_Audio_" + i + container));
                if (fileOutput.exists() && (fileOutput = FunctionUtils.fileReplacement(output, prefix + fileName, extension, "_Audio_" + i + "_", container)) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[a:0]pan=1c|c0=c" + (i - 1) + (String)audioFiltering + "[a" + (i - 1) + "]\" -map \"[a" + (i - 1) + "]\" -c:a " + codec + (String)sampleRate + timecode + yesno;
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOutput) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOutput, output)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels == 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("theFile") + " " + fileName + " " + Shutter.language.getProperty("isAlreadyStereo"), Shutter.language.getProperty("cantSplitAudio"), 0);
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(language.getProperty("mono"))) {
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOutput = new File(output + "/" + prefix + fileName.replace(extension, "_Audio_" + i + container));
                if (fileOutput.exists() && (fileOutput = FunctionUtils.fileReplacement(output, prefix + fileName, extension, "_Audio_" + i + "_", container)) == null) {
                    yesno = " -n ";
                }
                if (audioFiltering != "") {
                    audioFiltering = ((String)audioFiltering).replaceFirst(",", " -filter_complex ");
                }
                String cmd = (String)audioFiltering + " -map a:" + (i - 1) + " -c:a " + codec + (String)sampleRate + timecode + yesno;
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOutput) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOutput, output)) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (FFPROBE.channels > 1 && lblSplit.getText().equals(Shutter.language.getProperty("stereo"))) {
            int number = 1;
            int i = 1;
            while (i < FFPROBE.channels + 1) {
                String yesno = " -y ";
                File fileOutput = new File(output + "/" + prefix + fileName.replace(extension, "_Audio_" + number + container));
                if (fileOutput.exists() && (fileOutput = FunctionUtils.fileReplacement(output, prefix + fileName, extension, "_Audio_" + number + "_", container)) == null) {
                    yesno = " -n ";
                }
                String cmd = " -filter_complex \"[0:a:" + (i - 1) + "][0:a:" + i + "]amerge=inputs=2" + (String)audioFiltering + "[a]\" -map \"[a]\" -c:a " + codec + (String)sampleRate + timecode + yesno;
                FFMPEG.run(InputAndOutput.inPoint + DRC + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd + "\"" + String.valueOf(fileOutput) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
                if (FFMPEG.saveCode || btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) || !AudioEncoders.lastActions(file, fileName, fileOutput, output)) {
                    ++number;
                    i += 2;
                    continue;
                }
                break;
            }
        } else {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
    }

    private static boolean lastActions(File file, String fileName, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(file, fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Settings.btnSetBab.isSelected()) {
            return true;
        }
        if (caseMixAudio.isSelected() && !FFPROBE.surround) {
            return true;
        }
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            AudioEncoders.main();
            return true;
        }
        return false;
    }
}

