/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.filter.DefaultFilterChannel;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.filter.Channel;
import com.github.weisj.jsvg.nodes.filter.ChannelStorage;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterLayoutContext;
import com.github.weisj.jsvg.parser.AttributeNode;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class FilterPrimitiveBase {
    @NotNull
    final Length x;
    @NotNull
    final Length y;
    @NotNull
    final Length width;
    @NotNull
    final Length height;
    @NotNull
    private final Object inputChannel;
    @NotNull
    private final Object resultChannel;

    public FilterPrimitiveBase(@NotNull AttributeNode attributeNode) {
        this.x = attributeNode.getLength("x", Unit.PERCENTAGE.valueOf(0.0f));
        this.y = attributeNode.getLength("y", Unit.PERCENTAGE.valueOf(0.0f));
        this.width = attributeNode.getLength("width", Unit.PERCENTAGE.valueOf(100.0f));
        this.height = attributeNode.getLength("height", Unit.PERCENTAGE.valueOf(100.0f));
        Object in = attributeNode.getValue("in");
        if (in == null) {
            in = DefaultFilterChannel.LastResult;
        }
        this.inputChannel = in;
        Object result = attributeNode.getValue("result");
        if (result == null) {
            result = DefaultFilterChannel.LastResult;
        }
        this.resultChannel = result;
    }

    @NotNull
    public Channel channel(@NotNull Object channelName, @NotNull FilterContext context) {
        return context.getChannel(channelName);
    }

    @NotNull
    public Channel inputChannel(@NotNull FilterContext context) {
        return this.channel(this.inputChannel, context);
    }

    @NotNull
    public Rectangle2D layoutInput(@NotNull FilterLayoutContext context) {
        return context.resultChannels().get(this.inputChannel);
    }

    public void noop(@NotNull FilterContext context) {
        this.saveResult(this.inputChannel(context), context);
    }

    public void saveLayoutResult(@NotNull Rectangle2D outputBounds, @NotNull FilterLayoutContext filterLayoutContext) {
        this.saveResultImpl(outputBounds, filterLayoutContext.resultChannels());
    }

    public void saveResult(@NotNull Channel output, @NotNull FilterContext filterContext) {
        this.saveResultImpl(output, filterContext.resultChannels());
    }

    private <T> void saveResultImpl(@NotNull T value, @NotNull ChannelStorage<T> storage) {
        storage.addResult(this.resultChannel, value);
        if (this.resultChannel != DefaultFilterChannel.LastResult) {
            storage.addResult(DefaultFilterChannel.LastResult, value);
        }
    }
}

