/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import library.FFMPEG;
import library.FFPROBE;

public class RecordInputDevice {
    public static JDialog frame;
    static JComboBox<String> comboScreenVideo;
    static JComboBox<String> comboScreenAudio;
    static JComboBox<String> comboInputVideo;
    static JComboBox<String> comboInputAudio;
    public static Integer videoDeviceIndex;
    public static Integer audioDeviceIndex;
    public static Integer overlayAudioDeviceIndex;
    public static Integer screenWidth;
    public static Integer screenHeigth;
    public static String inputDeviceResolution;
    private static JLabel lblScreenRecord;
    public static JTextField txtScreenRecord;
    private static JLabel lblInputDevice;
    public static JTextField txtInputDevice;

    static {
        videoDeviceIndex = 0;
        audioDeviceIndex = -1;
        overlayAudioDeviceIndex = -1;
        screenWidth = 0;
        screenHeigth = 0;
        inputDeviceResolution = "";
        lblScreenRecord = new JLabel(Shutter.language.getProperty("lblScreenRecord"));
        txtScreenRecord = new JTextField();
        lblInputDevice = new JLabel(Shutter.language.getProperty("lblInputDevice"));
        txtInputDevice = new JTextField();
    }

    public RecordInputDevice() {
        frame = new JDialog();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setModal(true);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.setSize(350, 254);
        } else {
            frame.setSize(330, 150);
        }
        frame.setTitle(Shutter.language.getProperty("menuItemInputDevice"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(Utils.bg32);
        if (!System.getProperty("os.name").contains("Mac")) {
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        }
        frame.setDefaultCloseOperation(2);
        frame.setLocation(Shutter.frame.getLocation().x + Shutter.frame.getWidth() / 2 - frame.getWidth() / 2, Shutter.frame.getLocation().y + Shutter.frame.getHeight() / 3 - frame.getHeight() / 2);
        RecordInputDevice.devices();
        frame.setVisible(true);
    }

    private static void devices() {
        JLabel screenVideo = new JLabel(Shutter.language.getProperty("video") + Shutter.language.getProperty("colon"));
        screenVideo.setFont(new Font(Shutter.mainFont, 0, 12));
        screenVideo.setBounds(12, 12, 40, 14);
        frame.getContentPane().add(screenVideo);
        String[] firstInput = new String[FFMPEG.videoDevices.toString().split(":").length];
        int i = 0;
        String[] stringArray = FFMPEG.videoDevices.toString().split(":");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String videoDevice = stringArray[n2];
            firstInput[i] = videoDevice.replace(Shutter.language.getProperty("noVideo"), "Capture.current.screen");
            ++i;
            ++n2;
        }
        comboScreenVideo = new JComboBox<String>(firstInput);
        comboScreenVideo.setFont(new Font(Shutter.mainFont, 0, 10));
        comboScreenVideo.setEditable(false);
        comboScreenVideo.setMaximumRowCount(20);
        comboScreenVideo.setLocation(screenVideo.getX() + screenVideo.getWidth() + 4, screenVideo.getLocation().y - 3);
        if (System.getProperty("os.name").contains("Windows")) {
            comboScreenVideo.setSize(frame.getWidth() - screenVideo.getX() - screenVideo.getWidth() - 52, 22);
        } else {
            comboScreenVideo.setSize(frame.getWidth() - screenVideo.getX() - screenVideo.getWidth() - 42, 22);
        }
        frame.getContentPane().add(comboScreenVideo);
        comboScreenVideo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!comboScreenVideo.getSelectedItem().equals("Capture.current.screen")) {
                    comboInputVideo.setEnabled(false);
                    comboInputVideo.setSelectedIndex(0);
                    comboInputAudio.setEnabled(false);
                    comboInputAudio.setSelectedIndex(0);
                } else {
                    if (comboScreenAudio.getSelectedIndex() > 0) {
                        comboInputAudio.setEnabled(true);
                    }
                    comboInputVideo.setEnabled(true);
                }
            }
        });
        JLabel screenAudio = new JLabel(Shutter.language.getProperty("audio") + Shutter.language.getProperty("colon"));
        screenAudio.setFont(new Font(Shutter.mainFont, 0, 12));
        screenAudio.setBounds(12, screenVideo.getY() + screenVideo.getHeight() + 14, 40, 14);
        frame.getContentPane().add(screenAudio);
        comboScreenAudio = new JComboBox<String>(FFMPEG.audioDevices.toString().split(":"));
        comboScreenAudio.setFont(new Font(Shutter.mainFont, 0, 10));
        comboScreenAudio.setEditable(false);
        comboScreenAudio.setMaximumRowCount(20);
        comboScreenAudio.setBounds(comboScreenVideo.getX(), screenAudio.getLocation().y - 3, comboScreenVideo.getWidth(), 22);
        frame.getContentPane().add(comboScreenAudio);
        comboScreenAudio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboScreenAudio.getSelectedIndex() == 0 || !comboScreenVideo.getSelectedItem().equals("Capture.current.screen")) {
                    comboInputAudio.setEnabled(false);
                    comboInputAudio.setSelectedIndex(0);
                } else {
                    comboInputAudio.setEnabled(true);
                }
                if (comboScreenAudio.getSelectedIndex() >= 0 && System.getProperty("os.name").contains("Mac")) {
                    try {
                        Object pathToSwitchAudioSource = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        pathToSwitchAudioSource = ((String)pathToSwitchAudioSource).substring(0, ((String)pathToSwitchAudioSource).length() - 1);
                        pathToSwitchAudioSource = ((String)pathToSwitchAudioSource).substring(0, ((String)pathToSwitchAudioSource).lastIndexOf("/")).replace("%20", "\\ ") + "/Library/SwitchAudioSource";
                        ProcessBuilder switchAudioSource = new ProcessBuilder("/bin/bash", "-c", (String)pathToSwitchAudioSource + " -t input -s \"" + comboScreenAudio.getSelectedItem().toString() + "\"");
                        switchAudioSource.start();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        final JLabel iconScreenPreview = new JLabel(new FlatSVGIcon("contents/preview.svg", 16, 16));
        iconScreenPreview.setHorizontalAlignment(0);
        iconScreenPreview.setBounds(comboScreenVideo.getX() + comboScreenVideo.getWidth() + 8, RecordInputDevice.comboScreenVideo.getLocation().y + 3, 16, 16);
        iconScreenPreview.setToolTipText(Shutter.language.getProperty("preview"));
        frame.getContentPane().add(iconScreenPreview);
        iconScreenPreview.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Shutter.list.removeAllElements();
                if (comboScreenVideo.getSelectedItem().toString().equals("Capture.current.screen")) {
                    Shutter.list.addElement("Capture.current.screen");
                    if (comboInputVideo.getSelectedIndex() > 0 && System.getProperty("os.name").contains("Windows")) {
                        videoDeviceIndex = comboInputVideo.getSelectedIndex();
                    }
                } else {
                    Shutter.list.addElement("Capture.input.device");
                    videoDeviceIndex = System.getProperty("os.name").contains("Windows") ? Integer.valueOf(comboScreenVideo.getSelectedIndex()) : Integer.valueOf(comboScreenVideo.getSelectedIndex() - 1);
                }
                audioDeviceIndex = comboScreenAudio.getSelectedIndex() > 0 ? Integer.valueOf(comboScreenAudio.getSelectedIndex()) : Integer.valueOf(-1);
                RecordInputDevice.setInputDevices();
                String cmd = " -filter_complex \"scale=1080:-1\" -c:v rawvideo -pix_fmt rgb24 -an -f nut pipe:1";
                frame.setCursor(Cursor.getPredefinedCursor(3));
                FFMPEG.toFFPLAY(RecordInputDevice.setInputDevices() + cmd);
                Shutter.list.removeAllElements();
                Shutter.enableAll();
                Shutter.progressBar1.setValue(0);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                iconScreenPreview.setIcon(new FlatSVGIcon("contents/preview_hover.svg", 16, 16));
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                iconScreenPreview.setIcon(new FlatSVGIcon("contents/preview.svg", 16, 16));
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        JLabel inputVideo = new JLabel(Shutter.language.getProperty("video") + Shutter.language.getProperty("colon"));
        inputVideo.setFont(new Font(Shutter.mainFont, 0, 12));
        inputVideo.setBounds(12, screenAudio.getY() + screenAudio.getHeight() + 25, 40, 14);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(inputVideo);
        }
        comboInputVideo = new JComboBox<String>(FFMPEG.videoDevices.toString().split(":"));
        comboInputVideo.setFont(new Font(Shutter.mainFont, 0, 10));
        comboInputVideo.setEditable(false);
        comboInputVideo.setEnabled(true);
        comboInputVideo.setMaximumRowCount(20);
        comboInputVideo.setBounds(comboScreenVideo.getX(), inputVideo.getLocation().y - 3, comboScreenVideo.getWidth(), 22);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(comboInputVideo);
        }
        JLabel inputAudio = new JLabel(Shutter.language.getProperty("audio") + Shutter.language.getProperty("colon"));
        inputAudio.setFont(new Font(Shutter.mainFont, 0, 12));
        inputAudio.setBounds(12, inputVideo.getY() + inputVideo.getHeight() + 14, 40, 14);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(inputAudio);
        }
        comboInputAudio = new JComboBox<String>(FFMPEG.audioDevices.toString().split(":"));
        comboInputAudio.setFont(new Font(Shutter.mainFont, 0, 10));
        comboInputAudio.setEditable(false);
        comboInputAudio.setEnabled(false);
        comboInputAudio.setMaximumRowCount(20);
        comboInputAudio.setBounds(comboScreenVideo.getX(), inputAudio.getLocation().y - 3, comboScreenVideo.getWidth(), 22);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(comboInputAudio);
        }
        final JLabel iconDevicePreview = new JLabel(new FlatSVGIcon("contents/preview.svg", 16, 16));
        iconDevicePreview.setHorizontalAlignment(0);
        iconDevicePreview.setBounds(comboInputVideo.getX() + comboInputVideo.getWidth() + 8, RecordInputDevice.comboInputVideo.getLocation().y + 3, 16, 16);
        iconDevicePreview.setToolTipText(Shutter.language.getProperty("preview"));
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(iconDevicePreview);
        }
        iconDevicePreview.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (comboInputVideo.getSelectedIndex() > 0 || comboInputAudio.getSelectedIndex() > 0) {
                    Shutter.list.removeAllElements();
                    Shutter.list.addElement("Capture.input.device");
                    videoDeviceIndex = comboInputVideo.getSelectedIndex();
                    overlayAudioDeviceIndex = comboInputAudio.getSelectedIndex() > 0 ? Integer.valueOf(comboInputAudio.getSelectedIndex()) : Integer.valueOf(-1);
                    RecordInputDevice.setOverlayDevice();
                    String cmd = " -filter_complex \"scale=1080:-1\" -c:v rawvideo -pix_fmt rgb24 -an -f nut pipe:1";
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    if (comboInputVideo.getSelectedIndex() == 0 && comboInputAudio.getSelectedIndex() > 0) {
                        FFMPEG.toFFPLAY(RecordInputDevice.setOverlayDevice().replace("video=\"No video\":", "") + cmd);
                    } else {
                        FFMPEG.toFFPLAY(RecordInputDevice.setOverlayDevice() + cmd);
                    }
                    Shutter.list.removeAllElements();
                    Shutter.enableAll();
                    Shutter.progressBar1.setValue(0);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                iconDevicePreview.setIcon(new FlatSVGIcon("contents/preview_hover.svg", 16, 16));
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                iconDevicePreview.setIcon(new FlatSVGIcon("contents/preview.svg", 16, 16));
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        lblScreenRecord.setFont(new Font(Shutter.mainFont, 0, 12));
        lblScreenRecord.setSize(RecordInputDevice.lblScreenRecord.getPreferredSize().width, RecordInputDevice.lblScreenRecord.getPreferredSize().height);
        if (System.getProperty("os.name").contains("Windows")) {
            lblScreenRecord.setLocation(12, RecordInputDevice.comboInputAudio.getLocation().y + comboInputAudio.getHeight() + 10);
        } else {
            lblScreenRecord.setLocation(12, RecordInputDevice.comboScreenAudio.getLocation().y + comboScreenAudio.getHeight() + 10);
        }
        frame.getContentPane().add(lblScreenRecord);
        txtScreenRecord.setName("txtScreenRecord");
        txtScreenRecord.setHorizontalAlignment(0);
        txtScreenRecord.setFont(new Font(Shutter.mainFont, 0, 12));
        txtScreenRecord.setText("25");
        txtScreenRecord.setColumns(10);
        txtScreenRecord.setBounds(RecordInputDevice.lblScreenRecord.getLocation().x + lblScreenRecord.getWidth() + 6, RecordInputDevice.lblScreenRecord.getLocation().y - 4, 40, 21);
        frame.getContentPane().add(txtScreenRecord);
        txtScreenRecord.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtScreenRecord.getText().length() >= 3) {
                    txtScreenRecord.setText("");
                }
            }
        });
        lblInputDevice.setFont(new Font(Shutter.mainFont, 0, 12));
        lblInputDevice.setBounds(12, RecordInputDevice.lblScreenRecord.getLocation().y + lblScreenRecord.getHeight() + 10, RecordInputDevice.lblInputDevice.getPreferredSize().width, RecordInputDevice.lblInputDevice.getPreferredSize().height);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(lblInputDevice);
        }
        txtInputDevice.setName("txtInputDevice");
        txtInputDevice.setHorizontalAlignment(0);
        txtInputDevice.setFont(new Font(Shutter.mainFont, 0, 12));
        txtInputDevice.setText("25");
        txtInputDevice.setColumns(10);
        txtInputDevice.setBounds(RecordInputDevice.lblInputDevice.getLocation().x + lblInputDevice.getWidth() + 6, RecordInputDevice.lblInputDevice.getLocation().y - 4, 40, 21);
        if (System.getProperty("os.name").contains("Windows")) {
            frame.getContentPane().add(txtInputDevice);
        }
        txtInputDevice.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' && caracter != '.' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (txtInputDevice.getText().length() >= 5) {
                    txtInputDevice.setText("");
                }
            }
        });
        JButton btnOK = new JButton("OK");
        btnOK.setFont(new Font(Shutter.boldFont, 0, 12));
        btnOK.setSize(screenVideo.getWidth() + comboScreenVideo.getWidth() + 24, 21);
        if (System.getProperty("os.name").contains("Windows")) {
            btnOK.setLocation(12, lblInputDevice.getY() + lblInputDevice.getHeight() + 6);
        } else {
            btnOK.setLocation(12, lblScreenRecord.getY() + lblScreenRecord.getHeight() + 6);
        }
        frame.getContentPane().add(btnOK);
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Shutter.list.removeAllElements();
                if (comboScreenVideo.getSelectedItem().toString().equals("Capture.current.screen")) {
                    Shutter.list.addElement("Capture.current.screen");
                    if (comboInputVideo.getSelectedIndex() > 0 && System.getProperty("os.name").contains("Windows")) {
                        videoDeviceIndex = comboInputVideo.getSelectedIndex();
                    }
                } else {
                    Shutter.list.addElement("Capture.input.device");
                    videoDeviceIndex = System.getProperty("os.name").contains("Windows") ? Integer.valueOf(comboScreenVideo.getSelectedIndex()) : Integer.valueOf(comboScreenVideo.getSelectedIndex() - 1);
                }
                if (comboInputVideo.getSelectedIndex() > 0) {
                    Shutter.overlayDeviceIsRunning = true;
                }
                audioDeviceIndex = comboScreenAudio.getSelectedIndex() > 0 ? Integer.valueOf(comboScreenAudio.getSelectedIndex()) : Integer.valueOf(-1);
                overlayAudioDeviceIndex = comboInputAudio.getSelectedIndex() > 0 ? Integer.valueOf(comboInputAudio.getSelectedIndex()) : Integer.valueOf(-1);
                RecordInputDevice.setInputDevices();
                Shutter.inputDeviceIsRunning = true;
                Shutter.grpImageAdjustement.setEnabled(false);
                Component[] components = Shutter.grpImageAdjustement.getComponents();
                int i = 0;
                while (i < components.length) {
                    components[i].setEnabled(false);
                    ++i;
                }
                inputDeviceResolution = "";
                if (comboInputVideo.getSelectedIndex() > 0 || !comboScreenVideo.getSelectedItem().toString().equals("Capture.current.screen")) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        FFPROBE.Data("Capture.input.device");
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                inputDeviceResolution = FFPROBE.imageResolution;
                if (FFPROBE.interlaced == null) {
                    FFPROBE.interlaced = "0";
                }
                Shutter.addToList.setVisible(false);
                Shutter.case2pass.setSelected(false);
                Shutter.caseDisplay.setSelected(true);
                if (!Shutter.caseChangeFolder1.isSelected()) {
                    if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                        Shutter.lblDestination1.setText(System.getProperty("user.home") + "/Desktop");
                    } else {
                        Shutter.lblDestination1.setText(System.getProperty("user.home") + "\\Desktop");
                    }
                }
                Shutter.caseChangeFolder1.setSelected(true);
                Shutter.changeFilters();
                frame.dispose();
                VideoPlayer.setMedia();
            }
        });
    }

    public static String setInputDevices() {
        String videoDevice = "";
        if (Shutter.list.getElementAt(0).equals("Capture.input.device")) {
            String[] getVideoDevices = FFMPEG.videoDevices.toString().split(":");
            videoDevice = getVideoDevices[videoDeviceIndex];
        }
        Object setAudio = RecordInputDevice.setAudioDevice();
        Object setSecondAudio = "";
        if (videoDeviceIndex == 0 && System.getProperty("os.name").contains("Windows") && overlayAudioDeviceIndex > 0) {
            setSecondAudio = " -thread_queue_size 4096 -f dshow -i " + RecordInputDevice.setOverlayAudioDevice();
        }
        GraphicsConfiguration config = frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        AffineTransform transform = allScreens[screenIndex].getDefaultConfiguration().getDefaultTransform();
        if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
            screenWidth = allScreens[screenIndex].getDisplayMode().getWidth() * 2;
            screenHeigth = allScreens[screenIndex].getDisplayMode().getHeight() * 2;
        } else {
            screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
            screenHeigth = allScreens[screenIndex].getDisplayMode().getHeight();
        }
        Integer screenPositionX = allScreens[screenIndex].getDefaultConfiguration().getBounds().x;
        Integer screenPositionY = allScreens[screenIndex].getDefaultConfiguration().getBounds().y;
        if (Shutter.list.getElementAt(0).equals("Capture.current.screen")) {
            FFPROBE.imageWidth = screenWidth;
            FFPROBE.imageHeight = screenHeigth;
            FFPROBE.imageResolution = String.valueOf(screenWidth) + "x" + String.valueOf(screenHeigth);
            FFPROBE.interlaced = "0";
        }
        FFPROBE.currentFPS = Float.parseFloat(txtScreenRecord.getText());
        FFPROBE.audioOnly = false;
        if (System.getProperty("os.name").contains("Mac")) {
            if (Shutter.list.getElementAt(0).equals("Capture.current.screen")) {
                if (setAudio != "") {
                    return (String)setAudio + " -thread_queue_size 4096 -f avfoundation -pix_fmt uyvy422 -probesize 100M -rtbufsize 100M -capture_cursor 1 -framerate " + txtScreenRecord.getText() + " -i \"" + (FFMPEG.firstScreenIndex + screenIndex) + "\"";
                }
                return "-thread_queue_size 4096 -f avfoundation -pix_fmt uyvy422 -probesize 100M -rtbufsize 100M -capture_cursor 1 -framerate " + txtScreenRecord.getText() + " -i \"" + (FFMPEG.firstScreenIndex + screenIndex) + "\"";
            }
            return (String)setAudio + " -thread_queue_size 4096 -f avfoundation -pix_fmt uyvy422 -probesize 100M -rtbufsize 100M -framerate " + txtInputDevice.getText() + " -i \"" + String.valueOf(videoDeviceIndex) + "\"";
        }
        if (System.getProperty("os.name").contains("Windows")) {
            if (Shutter.list.getElementAt(0).equals("Capture.current.screen")) {
                if (setAudio != "") {
                    return "-thread_queue_size 4096 -f dshow -i " + (String)setAudio + " -thread_queue_size 4096 -f gdigrab -draw_mouse 1 -framerate " + txtScreenRecord.getText() + " -offset_x " + String.valueOf(screenPositionX) + " -offset_y " + String.valueOf(screenPositionY) + " -video_size " + String.valueOf(screenWidth) + "x" + String.valueOf(screenHeigth) + " -probesize 100M -rtbufsize 100M -i \"desktop\"" + (String)setSecondAudio;
                }
                return "-thread_queue_size 4096 -f gdigrab -draw_mouse 1 -framerate " + txtScreenRecord.getText() + " -offset_x " + String.valueOf(screenPositionX) + " -offset_y " + String.valueOf(screenPositionY) + " -video_size " + String.valueOf(screenWidth) + "x" + String.valueOf(screenHeigth) + " -probesize 100M -rtbufsize 100M -i \"desktop\"";
            }
            if (setAudio != "" && videoDeviceIndex > 0) {
                setAudio = ":" + (String)setAudio;
            }
            if (videoDeviceIndex > 0) {
                return "-thread_queue_size 4096 -f dshow -probesize 100M -rtbufsize 100M -framerate " + txtInputDevice.getText() + " -i video=\"" + videoDevice + "\"" + (String)setAudio;
            }
            return "-thread_queue_size 4096 -f dshow -probesize 100M -rtbufsize 100M -framerate " + txtInputDevice.getText() + " -i " + (String)setAudio;
        }
        return "-thread_queue_size 4096 -f x11grab -framerate " + txtScreenRecord.getText() + " -video_size " + String.valueOf(screenWidth) + "x" + String.valueOf(screenHeigth) + " -probesize 100M -rtbufsize 100M -i :0.0+" + String.valueOf(screenPositionX) + "," + String.valueOf(screenPositionY) + (String)setAudio;
    }

    public static String setOverlayDevice() {
        String[] getVideoDevices = FFMPEG.videoDevices.toString().split(":");
        String videoDevice = getVideoDevices[videoDeviceIndex];
        if (inputDeviceResolution != "") {
            FFPROBE.imageResolution = inputDeviceResolution;
            String[] splitx = inputDeviceResolution.split("x");
            int deviceWidth = Integer.parseInt(splitx[0]);
            int deviceHeight = Integer.parseInt(splitx[1]);
            FFPROBE.imageWidth = deviceWidth;
            FFPROBE.imageHeight = deviceHeight;
        }
        FFPROBE.audioOnly = false;
        if (System.getProperty("os.name").contains("Mac")) {
            return "-thread_queue_size 4096 -f avfoundation -pix_fmt uyvy422 -probesize 100M -rtbufsize 100M -framerate " + txtInputDevice.getText() + " -i \"" + String.valueOf(videoDeviceIndex) + "\"";
        }
        if (System.getProperty("os.name").contains("Windows")) {
            Object setAudio = RecordInputDevice.setOverlayAudioDevice();
            if (setAudio != "") {
                setAudio = ":" + (String)setAudio;
            }
            return "-thread_queue_size 4096 -f dshow -probesize 100M -rtbufsize 100M -framerate " + txtInputDevice.getText() + " -i video=\"" + videoDevice + "\"" + (String)setAudio;
        }
        return "";
    }

    public static String setAudioDevice() {
        Object setAudio = "";
        FFPROBE.channels = 0;
        FFPROBE.stereo = false;
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Windows")) {
            String[] getAudioDevices = FFMPEG.audioDevices.toString().split(":");
            if (audioDeviceIndex > 0) {
                String audioDevice = getAudioDevices[audioDeviceIndex];
                if (System.getProperty("os.name").contains("Mac")) {
                    setAudio = "-thread_queue_size 4096 -f openal -sample_rate 48k -i \"" + audioDevice + "\"";
                } else if (System.getProperty("os.name").contains("Windows")) {
                    setAudio = "audio=\"" + audioDevice + "\"";
                }
                FFPROBE.channels = 1;
                FFPROBE.stereo = true;
            }
        }
        return setAudio;
    }

    public static String setOverlayAudioDevice() {
        Object setAudio = "";
        FFPROBE.channels = 0;
        FFPROBE.stereo = false;
        String[] getAudioDevices = FFMPEG.audioDevices.toString().split(":");
        if (overlayAudioDeviceIndex > 0) {
            String audioDevice = getAudioDevices[overlayAudioDeviceIndex];
            if (System.getProperty("os.name").contains("Windows")) {
                setAudio = "audio=\"" + audioDevice + "\"";
            }
            FFPROBE.channels = audioDeviceIndex > 0 ? 2 : 1;
        } else if (audioDeviceIndex > 0) {
            FFPROBE.channels = 1;
        }
        FFPROBE.stereo = FFPROBE.channels == 1;
        return setAudio;
    }
}

