/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Settings;
import application.Shutter;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class FilesCellRenderer
extends JLabel
implements ListCellRenderer {
    FilesCellRenderer() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (Settings.btnHidePath.isSelected() && !Shutter.scanIsRunning) {
            this.setText(new File(value.toString()).getName());
        } else {
            this.setText(value.toString());
        }
        this.setIcon(new FlatSVGIcon("contents/item.svg", 10, 10));
        this.setToolTipText(value.toString());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setForeground(Color.LIGHT_GRAY);
        this.setOpaque(true);
        if (isSelected) {
            this.setBackground(new Color(75, 75, 80));
            this.setForeground(Utils.themeColor);
        } else if (index % 2 == 1) {
            this.setBackground(Utils.c35);
        } else {
            this.setBackground(new Color(Utils.c35.getRed() + 9, Utils.c35.getGreen() + 9, Utils.c35.getBlue() + 9));
        }
        return this;
    }
}

