/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Shutter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import library.FFPROBE;

public class Timecode
extends Shutter {
    public static String setTimecode(File file) {
        String dropFrame = ":";
        if (Timecode.isDropFrame()) {
            dropFrame = ";";
        }
        if (Shutter.caseConform.isSelected()) {
            dropFrame = Shutter.comboFPS.getSelectedItem().toString().equals("29,97") || Shutter.comboFPS.getSelectedItem().toString().equals("59,94") ? ";" : ":";
        }
        if (caseGenerateFromDate.isSelected()) {
            try {
                BasicFileAttributes attrs = Files.readAttributes(Paths.get(file.toString(), new String[0]), BasicFileAttributes.class, new LinkOption[0]);
                Instant creationTime = attrs.creationTime().toInstant();
                String date = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault()).format(creationTime);
                String[] s = date.split(":");
                return " -timecode \"" + s[0] + ":" + s[1] + ":" + s[2] + dropFrame + "00\"";
            }
            catch (IOException iOException) {}
        } else {
            if (caseSetTimecode.isSelected()) {
                return " -timecode \"" + TCset1.getText() + ":" + TCset2.getText() + ":" + TCset3.getText() + dropFrame + TCset4.getText() + "\"";
            }
            if (FFPROBE.timecode1 != "") {
                return " -timecode \"" + FFPROBE.timecode1 + ":" + FFPROBE.timecode2 + ":" + FFPROBE.timecode3 + dropFrame + FFPROBE.timecode4 + "\"";
            }
        }
        return "";
    }

    public static boolean isDropFrame() {
        return !FFPROBE.dropFrameTC.equals(":") && (FFPROBE.currentFPS == 29.97f || FFPROBE.currentFPS == 59.94f);
    }

    public static boolean isNonDropFrame() {
        return FFPROBE.dropFrameTC.equals(":") && (FFPROBE.currentFPS == 29.97f || FFPROBE.currentFPS == 59.94f) || FFPROBE.currentFPS == 23.98f;
    }

    public static double setNTSCtimecode(double currentFrame) {
        if (currentFrame > 0.0) {
            double currentTime = currentFrame * (1000.0 / (double)FFPROBE.currentFPS);
            if (FFPROBE.currentFPS == 23.98f) {
                currentFrame -= currentTime * 0.024 / 1000.0 - 1.0;
            } else if (FFPROBE.currentFPS == 29.97f) {
                currentFrame -= currentTime * 0.03 / 1000.0 - 1.0;
            } else if (FFPROBE.currentFPS == 59.94f) {
                currentFrame -= currentTime * 0.06 / 1000.0 - 1.0;
            }
        }
        return (float)Math.floor(currentFrame);
    }

    public static double getNTSCtimecode(double currentFrame) {
        double currentTime = currentFrame * (1000.0 / (double)FFPROBE.currentFPS);
        if (FFPROBE.currentFPS == 23.98f) {
            currentFrame += currentTime * 0.024 / 1000.0;
        } else if (FFPROBE.currentFPS == 29.97f) {
            currentFrame += currentTime * 0.03 / 1000.0;
        } else if (FFPROBE.currentFPS == 59.94f) {
            currentFrame += currentTime * 0.06 / 1000.0;
        }
        return (float)Math.floor(currentFrame);
    }
}

