/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Console;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Settings;
import application.Shutter;
import application.SubtitlesEmbed;
import application.SubtitlesTimeline;
import application.Utils;
import application.VideoPlayer;
import application.fileOverwriteWindow;
import functions.Transcribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.Clock;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import library.DCRAW;
import library.EXIFTOOL;
import library.FFMPEG;
import library.FFPROBE;
import library.MEDIAINFO;
import library.PDF;
import library.WHISPER;
import org.apache.commons.io.FileUtils;
import settings.AudioSettings;
import settings.Corrections;
import settings.InputAndOutput;
import settings.Transitions;

public class FunctionUtils
extends Shutter {
    public static int completed;
    public static StringBuilder watchFolder;
    public static boolean allowsInvalidCharacters;
    public static boolean yesToAll;
    public static boolean noToAll;
    public static boolean skipToAll;
    public static File OPAtomFolder;
    public static String silentTrack;
    public static int mergeDuration;
    public static boolean bestBitrateMode;
    public static boolean goodBitrateMode;
    public static boolean autoBitrateMode;
    public static boolean deleteSRT;
    private static StringBuilder mailFileList;

    static {
        watchFolder = new StringBuilder();
        allowsInvalidCharacters = false;
        yesToAll = false;
        noToAll = false;
        skipToAll = false;
        silentTrack = "";
        mergeDuration = 0;
        deleteSRT = false;
        mailFileList = new StringBuilder();
    }

    public static boolean analyze(File file, boolean isRaw) throws InterruptedException {
        btnStart.setEnabled(false);
        String extension = file.toString().substring(file.toString().lastIndexOf("."));
        if (caseGenerateFromDate.isSelected() || comboFonctions.getSelectedItem().toString().contains("JPEG") || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionPicture"))) {
            EXIFTOOL.run("\"" + file.toString() + "\"");
            do {
                Thread.sleep(100L);
            } while (EXIFTOOL.isRunning);
        }
        if (inputDeviceIsRunning) {
            btnStart.setEnabled(true);
        }
        if (!(inputDeviceIsRunning || isRaw || extension.toLowerCase().equals(".pdf"))) {
            FFPROBE.FrameData(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
        } else if (extension.toLowerCase().equals(".pdf")) {
            PDF.info(file.toString());
            do {
                Thread.sleep(100L);
            } while (PDF.isRunning);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
        }
        if (!isRaw && !extension.toLowerCase().equals(".pdf")) {
            FFPROBE.Data(file.toString());
            do {
                Thread.sleep(100L);
            } while (FFPROBE.isRunning);
            if (FunctionUtils.analyzeError(file.toString())) {
                return false;
            }
            FFMPEG.checkGPUCapabilities(file.toString());
            if (FFPROBE.timecode1 == "" || FFPROBE.interlaced == null) {
                MEDIAINFO.run(file.toString(), false);
                do {
                    Thread.sleep(100L);
                } while (MEDIAINFO.isRunning);
                if (FFPROBE.interlaced == null) {
                    FFPROBE.interlaced = "0";
                    FFPROBE.fieldOrder = "0";
                }
            }
        } else {
            if (isRaw) {
                DCRAW.run(" -i -v \"" + String.valueOf(file) + "\"");
                do {
                    Thread.sleep(100L);
                } while (DCRAW.isRunning);
            }
            if (FFPROBE.interlaced == null) {
                FFPROBE.interlaced = "0";
                FFPROBE.fieldOrder = "0";
            }
        }
        return true;
    }

    public static boolean analyzeError(String file) {
        if (FFMPEG.error) {
            errorList = new StringBuilder(file + System.lineSeparator() + String.valueOf(FFMPEG.errorLog) + System.lineSeparator());
            return true;
        }
        return false;
    }

    public static boolean waitFileCompleted(File file) {
        progressBar1.setIndeterminate(true);
        lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
        lblCurrentEncoding.setText(file.getName());
        tempsRestant.setVisible(false);
        btnStart.setEnabled(false);
        btnCancel.setEnabled(true);
        comboFonctions.setEnabled(false);
        long fileSize = 0L;
        do {
            fileSize = file.length();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((fileSize != file.length() || !FFMPEG.isReadable(file)) && !cancelled && file.exists());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar1.setIndeterminate(false);
            }
        });
        btnCancel.setEnabled(false);
        if (cancelled) {
            lblCurrentEncoding.setText(language.getProperty("lblEncodageEnCours"));
            btnStart.setEnabled(true);
            comboFonctions.setEnabled(true);
            return false;
        }
        return true;
    }

    public static File setInputFile(File input) {
        if (Shutter.scanIsRunning) {
            input = FunctionUtils.watchFolder();
            if (input == null) {
                return null;
            }
            btnStart.setEnabled(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressBar1.setIndeterminate(false);
                }
            });
        } else if (Settings.btnWaitFileComplete.isSelected() && !FunctionUtils.waitFileCompleted(input)) {
            return null;
        }
        return input;
    }

    /*
     * Unable to fully structure code
     */
    public static File watchFolder() {
        FunctionUtils.progressBar1.setIndeterminate(true);
        FunctionUtils.lblCurrentEncoding.setText(FunctionUtils.language.getProperty("waitingFiles"));
        FunctionUtils.tempsRestant.setVisible(false);
        FunctionUtils.disableAll();
        actualScanningFile = null;
        do {
            if (actualScanningFile != null) continue;
            i = 0;
            while (i < FunctionUtils.list.getSize()) {
                dir = new File((String)FunctionUtils.list.getElementAt(i));
                FunctionUtils.btnStart.setEnabled(false);
                var6_6 = dir.listFiles();
                var5_5 = var6_6.length;
                var4_4 = 0;
                while (var4_4 < var5_5) {
                    block14: {
                        block12: {
                            block11: {
                                block13: {
                                    file = var6_6[var4_4];
                                    if (file.isDirectory() || file.isHidden() || file.getName().equals("completed") || file.getName().equals("error")) break block11;
                                    if (!file.getName().contains(".")) break block12;
                                    allowed = true;
                                    if (!Settings.btnExclude.isSelected()) break block13;
                                    var11_12 = Settings.txtExclude.getText().split("\\*");
                                    var10_11 = var11_12.length;
                                    var9_10 = 0;
                                    while (var9_10 < var10_11) {
                                        excludeExt = var11_12[var9_10];
                                        s = file.toString().lastIndexOf(46);
                                        ext = file.toString().substring(s);
                                        if (excludeExt.contains(".") && ext.toLowerCase().equals(excludeExt.replace(",", "").toLowerCase())) {
                                            allowed = false;
                                        }
                                        ++var9_10;
                                    }
                                    if (!allowed) break block14;
                                }
                                if (FunctionUtils.getWatchFolderList(file)) break block12;
                                break block14;
                            }
                            if (file.isDirectory() && !file.isHidden() && !file.getName().equals("completed") && !file.getName().equals("error")) {
                                addFolder = true;
                                f = 0;
                                while (f < FunctionUtils.list.getSize()) {
                                    if (((String)FunctionUtils.list.getElementAt(f)).equals(file.toString())) {
                                        addFolder = false;
                                    }
                                    ++f;
                                }
                                if (addFolder) {
                                    FunctionUtils.list.addElement(file.toString());
                                    ** GOTO lbl56
                                }
                            }
                            break block14;
                        }
                        actualScanningFile = file;
                        FunctionUtils.progressBar1.setIndeterminate(true);
                        if (!FunctionUtils.waitFileCompleted(file)) {
                            return null;
                        }
                        if (actualScanningFile != null) {
                            return actualScanningFile;
                        }
                    }
                    ++var4_4;
                }
                ++i;
            }
        } while (FunctionUtils.scanIsRunning);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                progressBar1.setIndeterminate(false);
            }
        });
        FunctionUtils.enableAll();
        FunctionUtils.btnEmptyList.doClick();
        return null;
    }

    private static void setWatchFolderList(File input) {
        try {
            StringBuilder stb = new StringBuilder();
            if (watchFolder.length() > 0) {
                String[] stringArray = watchFolder.toString().split(System.lineSeparator());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    stb.append(file + System.lineSeparator());
                    ++n2;
                }
                watchFolder.setLength(0);
                boolean fileExists = false;
                String[] stringArray2 = stb.toString().split(System.lineSeparator());
                int n3 = stringArray2.length;
                n = 0;
                while (n < n3) {
                    String file = stringArray2[n];
                    if (file.equals(input.toString())) {
                        watchFolder.append(input.toString() + System.lineSeparator());
                        fileExists = true;
                    } else if (!file.equals("null")) {
                        watchFolder.append(file + System.lineSeparator());
                    }
                    ++n;
                }
                if (!fileExists) {
                    watchFolder.append(input.toString() + System.lineSeparator());
                }
            } else {
                watchFolder.append(input.toString() + System.lineSeparator());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean getWatchFolderList(File input) {
        try {
            if (watchFolder.length() <= 0) return true;
            String[] stringArray = watchFolder.toString().split(System.lineSeparator());
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String line = stringArray[n2];
                if (line.equals(input.toString())) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void moveScannedFiles(File file) {
        if (FFMPEG.error) {
            File fileToMove;
            File folder = new File(file.getParent() + "/error");
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((fileToMove = new File(String.valueOf(folder) + "/" + file.getName())).exists()) {
                int n = 1;
                String ext = file.getName().substring(file.getName().lastIndexOf("."));
                do {
                    fileToMove = new File(String.valueOf(folder) + "/" + file.getName().replace(ext, "") + "_" + n + ext);
                    ++n;
                } while (fileToMove.exists());
            }
            file.renameTo(fileToMove);
        } else {
            FunctionUtils.setWatchFolderList(file);
        }
    }

    public static String completedFiles(int number) {
        String labelName = number > 1 && number < 1000 ? number + " " + Shutter.language.getProperty("filesEnded") : (number <= 1 ? number + " " + Shutter.language.getProperty("fileEnded") : number / 1000 + "k " + Shutter.language.getProperty("filesEnded"));
        return labelName;
    }

    public static void listFilesForFolder(String file, File folder) {
        if (file == null) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ext;
                File fileEntry = fileArray[n2];
                if (fileEntry.isFile() && ((ext = fileEntry.toString().substring(fileEntry.toString().lastIndexOf("."))).equals(".log") || ext.equals(".xml") || ext.equals(".mpg") || ext.equals(".meta") || ext.equals(".mkv"))) {
                    File fileToDelete = new File(fileEntry.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n2;
            }
        } else {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File fileEntry = fileArray[n3];
                if (fileEntry.isFile() && fileEntry.getName().contains(file) && fileEntry.getName().contains(".log")) {
                    File fileToDelete = new File(fileEntry.getAbsolutePath());
                    fileToDelete.delete();
                }
                ++n3;
            }
        }
    }

    public static String setConcat(File file, String output) {
        String extension = file.toString().substring(file.toString().lastIndexOf("."));
        File concatFile = new File(output.replace("\\", "/") + "/" + file.getName().replace(extension, ".txt"));
        if (VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) {
            block5: {
                try {
                    PrintWriter writer = new PrintWriter(concatFile.toString(), "UTF-8");
                    DecimalFormat formatter = new DecimalFormat("00");
                    DecimalFormat formatFrame = new DecimalFormat("000");
                    int h = Integer.parseInt(VideoPlayer.caseInH.getText());
                    int m = Integer.parseInt(VideoPlayer.caseInM.getText());
                    int s = Integer.parseInt(VideoPlayer.caseInS.getText());
                    int f = (int)Math.floor((double)Integer.parseInt(VideoPlayer.caseInF.getText()) * (1000.0 / FFPROBE.accurateFPS));
                    writer.println("file '" + String.valueOf(file) + "'");
                    writer.println("outpoint " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f));
                    h = Integer.parseInt(VideoPlayer.caseOutH.getText());
                    m = Integer.parseInt(VideoPlayer.caseOutM.getText());
                    s = Integer.parseInt(VideoPlayer.caseOutS.getText());
                    f = (int)Math.floor((double)Integer.parseInt(VideoPlayer.caseOutF.getText()) * (1000.0 / FFPROBE.accurateFPS));
                    writer.println("file '" + String.valueOf(file) + "'");
                    writer.println("inpoint " + formatter.format(h) + ":" + formatter.format(m) + ":" + formatter.format(s) + "." + formatFrame.format(f));
                    InputAndOutput.inPoint = "";
                    InputAndOutput.outPoint = "";
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    FFMPEG.error = true;
                    if (!concatFile.exists()) break block5;
                    concatFile.delete();
                }
            }
            return " -safe 0 -f concat";
        }
        if (grpImageSequence.isVisible() && caseEnableSequence.isSelected() && !comboResolution.getSelectedItem().toString().contains("AI")) {
            FunctionUtils.setMerge(file.getName(), extension, output);
            return " -safe 0 -f concat -r " + caseSequenceFPS.getSelectedItem().toString().replace(",", ".");
        }
        if (Settings.btnSetBab.isSelected() || grpImageSequence.isVisible() && caseEnableSequence.isSelected() && !comboResolution.getSelectedItem().toString().contains("AI")) {
            FunctionUtils.setMerge(file.getName(), extension, output);
            return " -safe 0 -f concat";
        }
        return "";
    }

    public static void setMerge(String fileName, String extension, String output) {
        block12: {
            File concatFile = new File(output.replace("\\", "/") + "/" + fileName.replace(extension, ".txt"));
            try {
                mergeDuration = 0;
                frame.setCursor(Cursor.getPredefinedCursor(3));
                PrintWriter writer = new PrintWriter(concatFile, "UTF-8");
                int i = 0;
                while (i < list.getSize()) {
                    File file;
                    if (Settings.btnWaitFileComplete.isSelected() && !FunctionUtils.waitFileCompleted(file = new File((String)list.getElementAt(i)))) break;
                    if (Settings.btnSetBab.isSelected()) {
                        FFPROBE.Data((String)list.getElementAt(i));
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.totalLength == 0 && FFPROBE.isRunning);
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        mergeDuration += FFPROBE.totalLength;
                        FFPROBE.totalLength = 0;
                    } else if (grpImageSequence.isVisible() && caseEnableSequence.isSelected()) {
                        FFPROBE.currentFPS = 25.0f;
                        mergeDuration = (int)((float)Shutter.list.getSize() * (1000.0f / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString().replace(",", "."))));
                    }
                    writer.println("file '" + (String)list.getElementAt(i) + "'");
                    ++i;
                }
                writer.close();
                frame.setCursor(Cursor.getPredefinedCursor(0));
                progressBar1.setMaximum(mergeDuration / 1000);
                FFPROBE.totalLength = mergeDuration;
                VideoPlayer.fileDuration = mergeDuration;
                FFMPEG.fileLength = progressBar1.getMaximum();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
                FFMPEG.error = true;
                if (!concatFile.exists()) break block12;
                concatFile.delete();
            }
        }
    }

    public static String setOutputDestination(String output, File file) {
        if (caseChangeFolder1.isSelected()) {
            output = lblDestination1.getText();
            if (caseCreateTree.isSelected()) {
                File pathToFile = null;
                Object folderLevel = "";
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    String[] s = file.getParent().toString().replace("/Volumes", "").split("/");
                    int i = comboCreateTree.getSelectedIndex() + 1;
                    while (i < s.length) {
                        folderLevel = (String)folderLevel + "/" + s[i];
                        ++i;
                    }
                } else {
                    String[] s = file.getParent().toString().substring(2).split("\\\\");
                    int i = comboCreateTree.getSelectedIndex() + 1;
                    while (i < s.length) {
                        folderLevel = (String)folderLevel + "\\" + s[i];
                        ++i;
                    }
                }
                pathToFile = new File(lblDestination1.getText() + (String)folderLevel);
                if (!pathToFile.exists()) {
                    pathToFile.mkdirs();
                }
                output = pathToFile.toString();
            } else if (caseCreateOPATOM.isSelected() && lblOPATOM.getText().equals("OP-Atom") && (comboFonctions.getSelectedItem().toString().equals("DNxHD") || comboFonctions.getSelectedItem().toString().equals("DNxHR"))) {
                String number = new File(output).getName();
                if (number.matches("^[0-9]+$")) {
                    if (OPAtomFolder == null) {
                        OPAtomFolder = file.getName().contains(file.getParentFile().getName()) ? new File(file.getParentFile().getParent()) : new File(file.getParent());
                    } else if (file.getName().contains(file.getParentFile().getName())) {
                        if (!file.getParentFile().getParent().toString().equals(OPAtomFolder.toString())) {
                            File newFolder;
                            int n = Integer.parseInt(number) + 1;
                            do {
                                newFolder = new File(new File(output).getParent() + "/" + n);
                                ++n;
                            } while (newFolder.exists());
                            newFolder.mkdir();
                            lblDestination1.setText(newFolder.toString());
                            output = lblDestination1.getText();
                            OPAtomFolder = new File(file.getParentFile().getParent());
                        }
                    } else if (!file.getParent().toString().equals(OPAtomFolder.toString())) {
                        File newFolder;
                        int n = Integer.parseInt(number) + 1;
                        do {
                            newFolder = new File(new File(output).getParent() + "/" + n);
                            ++n;
                        } while (newFolder.exists());
                        newFolder.mkdir();
                        lblDestination1.setText(newFolder.toString());
                        output = lblDestination1.getText();
                        OPAtomFolder = new File(file.getParent());
                    }
                }
            } else if (caseSubFolder.isSelected() && !txtSubFolder.getText().equals("") && !new File(output = new File(lblDestination1.getText() + "/" + txtSubFolder.getText()).toString()).exists()) {
                new File(output).mkdirs();
            }
        } else {
            output = file.getParent();
            lblDestination1.setText(output);
            if (caseSubFolder.isSelected() && !txtSubFolder.getText().equals("") && !new File(output = new File(file.getParent() + "/" + txtSubFolder.getText()).toString()).exists()) {
                new File(output).mkdirs();
            }
        }
        return output;
    }

    public static String setPrefixSuffix(String text, boolean isOverlay) {
        if ((text = text.replace("[", "{").replace("]", "}")).contains("{")) {
            if (comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                if (text.contains("{resolution}")) {
                    text = text.replace("{resolution}", FFPROBE.imageWidth + "x" + FFPROBE.imageHeight);
                } else if (text.contains("{scale}")) {
                    text = text.replace("{scale}", FFPROBE.imageWidth + "x" + FFPROBE.imageHeight);
                }
                if (text.contains("{width}")) {
                    text = text.replace("{width}", String.valueOf(FFPROBE.imageWidth));
                }
                if (text.contains("{height}")) {
                    text = text.replace("{height}", String.valueOf(FFPROBE.imageHeight));
                }
                float or = (float)FFPROBE.imageWidth / (float)FFPROBE.imageHeight;
                if (text.contains("{ratio}")) {
                    text = text.replace("{ratio}", String.valueOf(or));
                } else if (text.contains("{aspect}")) {
                    text = text.replace("{aspect}", String.valueOf(or));
                }
            } else {
                String[] i = FFPROBE.imageResolution.split("x");
                String[] o = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    o[0] = String.valueOf(Math.round((double)Integer.parseInt(o[0]) * value));
                    o[1] = String.valueOf(Math.round((double)Integer.parseInt(o[1]) * value));
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    if (comboResolution.getSelectedItem().toString().contains("AI")) {
                        if (Shutter.comboResolution.getSelectedItem().toString().contains("2x")) {
                            o[0] = String.valueOf(Math.round(Integer.parseInt(o[0]) * 2));
                            o[1] = String.valueOf(Math.round(Integer.parseInt(o[1]) * 2));
                        } else {
                            o[0] = String.valueOf(Math.round(Integer.parseInt(o[0]) * 4));
                            o[1] = String.valueOf(Math.round(Integer.parseInt(o[1]) * 4));
                        }
                    } else {
                        o = comboResolution.getSelectedItem().toString().split("x");
                    }
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    o = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(o[0]);
                    int oh = Integer.parseInt(o[1]);
                    float ir = (float)iw / (float)ih;
                    if (o[0].toString().equals("1")) {
                        o[0] = String.valueOf(Math.round((float)oh * ir));
                    } else {
                        o[1] = String.valueOf(Math.round((float)ow / ir));
                    }
                }
                int ow = Integer.parseInt(o[0]);
                int oh = Integer.parseInt(o[1]);
                float or = (float)ow / (float)oh;
                if (text.contains("{resolution}")) {
                    text = text.replace("{resolution}", comboResolution.getSelectedItem().toString());
                } else if (text.contains("{scale}")) {
                    text = text.replace("{scale}", comboResolution.getSelectedItem().toString());
                }
                if (text.contains("{width}")) {
                    text = text.replace("{width}", String.valueOf(ow));
                }
                if (text.contains("{height}")) {
                    text = text.replace("{height}", String.valueOf(oh));
                }
                if (text.contains("{ratio}")) {
                    text = text.replace("{ratio}", String.valueOf(or));
                } else if (text.contains("{aspect}")) {
                    text = text.replace("{aspect}", String.valueOf(or));
                }
            }
            if (text.contains("{codec}")) {
                text = text.replace("{codec}", comboFonctions.getSelectedItem().toString());
            } else if (text.contains("{function}")) {
                text = text.replace("{function}", comboFonctions.getSelectedItem().toString());
            }
            if (text.contains("{date}")) {
                LocalDate currentDate = LocalDate.now();
                text = text.replace("{date}", currentDate.toString());
            }
            if (text.contains("{duration}")) {
                text = text.replace("{duration}", Shutter.formatter.format(VideoPlayer.durationH) + "." + Shutter.formatter.format(VideoPlayer.durationM) + "." + Shutter.formatter.format(VideoPlayer.durationS) + "." + Shutter.formatter.format(VideoPlayer.durationF));
            } else if (text.contains("{time}")) {
                text = text.replace("{time}", Shutter.formatter.format(VideoPlayer.durationH) + "." + Shutter.formatter.format(VideoPlayer.durationM) + "." + Shutter.formatter.format(VideoPlayer.durationS) + "." + Shutter.formatter.format(VideoPlayer.durationF));
            }
            if (text.contains("{framerate}")) {
                text = caseConform.isSelected() ? text.replace("{framerate}", comboFPS.getSelectedItem().toString()) : text.replace("{framerate}", String.valueOf(FFPROBE.currentFPS).replace(".0", ""));
            } else if (text.contains("{fps}")) {
                text = caseConform.isSelected() ? text.replace("{fps}", comboFPS.getSelectedItem().toString()) : text.replace("{fps}", String.valueOf(FFPROBE.currentFPS).replace(".0", ""));
            }
            if (text.contains("{preset}")) {
                text = text.replace("{preset}", Utils.currentPreset.replace(".enc", ""));
            }
            if (text.contains("{timecode}")) {
                text = text.replace("{timecode}", FFPROBE.timecode1 + FFPROBE.timecode2 + FFPROBE.timecode3 + FFPROBE.timecode4);
            }
            if (text.contains("{bitrate}")) {
                text = Shutter.grpBitrate.isVisible() ? text.replace("{bitrate}", FunctionUtils.setVideoBitrate() + "kbps") : text.replace("{bitrate}", "");
            }
        }
        return text;
    }

    public static String getRandomHexString() {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        while (sb.length() < 10) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, 10);
    }

    public static String setLoop(String extension) {
        block21: {
            if (caseEnableSequence.isSelected()) break block21;
            switch (extension) {
                case ".bmp": 
                case ".jpg": 
                case ".png": 
                case ".psd": 
                case ".tga": 
                case ".tif": 
                case ".jpeg": 
                case ".tiff": {
                    return " -loop 1 -t " + Settings.txtImageDuration.getText();
                }
            }
        }
        return "";
    }

    public static int setVideoBitrate() {
        bestBitrateMode = false;
        goodBitrateMode = false;
        autoBitrateMode = false;
        if (debitVideo.getSelectedItem().equals(language.getProperty("lblBest").toLowerCase()) || debitVideo.getSelectedItem().equals(language.getProperty("lblGood").toLowerCase()) || debitVideo.getSelectedItem().equals("auto")) {
            String function = comboFonctions.getSelectedItem().toString();
            Integer compValue = 165888;
            if ("MJPEG".equals(function)) {
                compValue = 16588;
            } else if ("MPEG-1".equals(function)) {
                compValue = 33177;
            } else if ("WMV".equals(function)) {
                compValue = 41472;
            } else if ("MPEG-2".equals(function) || "Xvid".equals(function) || "Theora".equals(function)) {
                compValue = 103680;
            } else if ("H.265".equals(function) || "VP9".equals(function)) {
                compValue = 331776;
            } else if ("AV1".equals(function) || "H.266".equals(function)) {
                compValue = 414720;
            }
            int pixels = FFPROBE.imageWidth * FFPROBE.imageHeight;
            if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                String[] i = FFPROBE.imageResolution.split("x");
                String[] o = FFPROBE.imageResolution.split("x");
                if (comboResolution.getSelectedItem().toString().contains("%")) {
                    double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                    o[0] = String.valueOf(Math.round((double)Integer.parseInt(o[0]) * value));
                    o[1] = String.valueOf(Math.round((double)Integer.parseInt(o[1]) * value));
                } else if (comboResolution.getSelectedItem().toString().contains("AI")) {
                    if (Shutter.comboResolution.getSelectedItem().toString().contains("2x")) {
                        o[0] = String.valueOf(FFPROBE.imageWidth * 2);
                        o[1] = String.valueOf(FFPROBE.imageHeight * 2);
                    } else {
                        o[0] = String.valueOf(FFPROBE.imageWidth * 4);
                        o[1] = String.valueOf(FFPROBE.imageHeight * 4);
                    }
                } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                    o = comboResolution.getSelectedItem().toString().split("x");
                } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                    o = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                    int iw = Integer.parseInt(i[0]);
                    int ih = Integer.parseInt(i[1]);
                    int ow = Integer.parseInt(o[0]);
                    int oh = Integer.parseInt(o[1]);
                    float ir = (float)iw / (float)ih;
                    if (o[0].toString().equals("1")) {
                        o[0] = String.valueOf(Math.round((float)oh * ir));
                    } else {
                        o[1] = String.valueOf(Math.round((float)ow / ir));
                    }
                }
                int ow = Integer.parseInt(o[0]);
                int oh = Integer.parseInt(o[1]);
                pixels = ow * oh;
            } else if (Shutter.grpCrop.isVisible() && caseEnableCrop.isSelected()) {
                int ow = Integer.parseInt(textCropWidth.getText());
                int oh = Integer.parseInt(textCropHeight.getText());
                pixels = ow * oh;
            }
            float framerate = FFPROBE.currentFPS;
            if (caseConform.isSelected()) {
                framerate = Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue();
            }
            int bitDepth = 8;
            if (caseColorspace.isSelected()) {
                if (comboColorspace.getSelectedItem().toString().contains("10bits")) {
                    bitDepth = 10;
                } else if (comboColorspace.getSelectedItem().toString().contains("12bits")) {
                    bitDepth = 12;
                }
            }
            Integer videoBitrate = Math.round((float)pixels * framerate * (float)bitDepth * 2.0f / (float)compValue.intValue());
            if (debitVideo.getSelectedItem().equals(language.getProperty("lblBest").toLowerCase())) {
                bestBitrateMode = true;
                videoBitrate = videoBitrate * 4;
            } else if (debitVideo.getSelectedItem().equals(language.getProperty("lblGood").toLowerCase())) {
                goodBitrateMode = true;
                videoBitrate = videoBitrate * 2;
            } else {
                autoBitrateMode = true;
            }
            return videoBitrate;
        }
        if (Shutter.isLocked) {
            FFPROBE.setFilesize();
        }
        return Integer.parseInt(debitVideo.getSelectedItem().toString());
    }

    public static String setStream() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "H.264": {
                if (!caseStream.isSelected()) break;
                if (caseLoop.isSelected()) {
                    return " -stream_loop -1 -re";
                }
                return " -re";
            }
        }
        return "";
    }

    public static String setMetadata() {
        Object metadata = " -metadata creation_time=\"" + String.valueOf(Clock.systemUTC().instant()) + "\"";
        if (casePreserveMetadata.isSelected()) {
            if (!FFPROBE.audioOnly) {
                metadata = " -map_metadata 0";
                if (!casePreserveSubs.isSelected()) {
                    metadata = (String)metadata + " -map_metadata:s:v 0:s:v";
                }
                if (FFPROBE.hasAudio && !casePreserveSubs.isSelected()) {
                    metadata = (String)metadata + " -map_metadata:s:a 0:s:a";
                }
            } else if (!casePreserveSubs.isSelected()) {
                metadata = " -map_metadata:s:a 0:s:a";
            }
            metadata = (String)metadata + " -movflags use_metadata_tags";
        }
        return metadata;
    }

    public static String setMapSubtitles() {
        int i = 0;
        if (Shutter.caseAddWatermark.isSelected()) {
            i = 1;
        }
        Object subsMapping = "";
        boolean addSub = false;
        Component[] componentArray = SubtitlesEmbed.frame.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextField) {
                if (((JTextField)c).getText().equals(language.getProperty("aucun"))) break;
                ++i;
                addSub = true;
            } else if (c instanceof JComboBox && addSub) {
                String[] languages = Locale.getISOLanguages();
                Locale loc = Locale.of(languages[((JComboBox)c).getSelectedIndex()]);
                subsMapping = Shutter.caseAddWatermark.isSelected() ? (String)subsMapping + " -map " + i + ":s -metadata:s:s:" + (i - 2) + " language=" + loc.getISO3Language().replace("zho", "chi") : (String)subsMapping + " -map " + i + ":s -metadata:s:s:" + (i - 1) + " language=" + loc.getISO3Language().replace("zho", "chi");
                addSub = false;
            }
            ++n2;
        }
        return subsMapping;
    }

    public static boolean checkPreviousFilter(String filter) {
        if (filter != "") {
            String[] s = filter.split(",");
            return s.length > 2 && s[s.length - 2].equals("hwdownload");
        }
        return true;
    }

    public static String setFilterComplex(String filterComplex, String audio, boolean picture) {
        block38: {
            block39: {
                block37: {
                    if (picture) {
                        if (filterComplex != "") {
                            filterComplex = " -filter_complex \"" + (String)filterComplex + "[out]\" -map \"[out]\"";
                        }
                        return filterComplex;
                    }
                    switch (comboFonctions.getSelectedItem().toString()) {
                        case "AV1": 
                        case "VP9": 
                        case "FFV1": 
                        case "H.264": 
                        case "H.265": 
                        case "H.266": {
                            if ((comboAccel.getSelectedItem().equals(language.getProperty("aucune").toLowerCase()) || !comboAccel.getSelectedItem().equals("VAAPI")) && !comboAccel.getSelectedItem().equals("Vulkan Video")) break;
                            if (filterComplex != "") {
                                filterComplex = (String)filterComplex + ",";
                            }
                            filterComplex = caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("10bits") ? (String)filterComplex + "format=p010,hwupload" : (String)filterComplex + "format=nv12,hwupload";
                        }
                    }
                    if (caseOPATOM.isSelected()) {
                        audio = "";
                    }
                    if (filterComplex != "") {
                        filterComplex = Shutter.caseAddWatermark.isSelected() || Shutter.caseAddSubtitles.isSelected() && subtitlesBurn ? " -filter_complex \"" + (String)filterComplex + "[out]" : " -filter_complex \"[0:v]" + (String)filterComplex + "[out]";
                        filterComplex = audio.contains("[a]") ? (String)filterComplex + audio + " -map \"[out]\" -map \"[a]\"" : (String)filterComplex + "\" -map \"[out]\"" + audio;
                    } else {
                        filterComplex = audio.contains("[a]") ? audio + " -map v:0 -map \"[a]\"" : " -map v:0" + audio;
                    }
                    if (!Shutter.caseAddSubtitles.isSelected() || subtitlesBurn) break block37;
                    filterComplex = comboFilter.getSelectedItem().toString().equals(".mkv") ? (String)filterComplex + " -c:s srt" + FunctionUtils.setMapSubtitles() : (String)filterComplex + " -c:s mov_text" + FunctionUtils.setMapSubtitles();
                    break block38;
                }
                if (!casePreserveSubs.isSelected()) break block38;
                if (FFPROBE.subtitlesCodec == "" || !FFPROBE.subtitlesCodec.equals("dvb_subtitle") && !FFPROBE.subtitlesCodec.equals("dvd_subtitle")) break block39;
                switch (comboFilter.getSelectedItem().toString()) {
                    case ".ts": 
                    case ".mkv": 
                    case ".mp4": {
                        if (FFPROBE.subtitlesCodec.equals("dvb_subtitle")) {
                            filterComplex = (String)filterComplex + " -c:s dvbsub -map s?";
                            break;
                        }
                        if (FFPROBE.subtitlesCodec.equals("dvd_subtitle")) {
                            filterComplex = (String)filterComplex + " -c:s dvdsub -map s?";
                            break;
                        }
                        break block38;
                    }
                    default: {
                        filterComplex = (String)filterComplex + " -c:s copy -map s?";
                        break;
                    }
                }
                break block38;
            }
            filterComplex = comboFilter.getSelectedItem().toString().equals(".mkv") ? (FFPROBE.subtitlesCodec != "" && (FFPROBE.subtitlesCodec.equals("hdmv_pgs_subtitle") || FFPROBE.subtitlesCodec.equals("ass")) ? (String)filterComplex + " -c:s copy -map s?" : (String)filterComplex + " -c:s srt -map s?") : (String)filterComplex + " -c:s mov_text -map s?";
        }
        return filterComplex;
    }

    public static String setFilterComplexBroadcastCodecs(String filterComplex, String audio) {
        Object mapping = "";
        Object audioFiltering = "";
        audioFiltering = AudioSettings.setEQ((String)audioFiltering);
        if (Transitions.setAudioFadeIn(false) != "") {
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + Transitions.setAudioFadeIn(false);
        }
        if (Transitions.setAudioFadeOut(false) != "") {
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + Transitions.setAudioFadeOut(false);
        }
        if (Transitions.setAudioSpeed() != "") {
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + Transitions.setAudioSpeed();
        }
        if (caseNormalizeAudio.isSelected() && caseNormalizeAudio.isVisible()) {
            if (audioFiltering != "") {
                audioFiltering = (String)audioFiltering + ",";
            }
            audioFiltering = (String)audioFiltering + "volume=" + String.valueOf(FFMPEG.newVolume).replace(",", ".") + "dB";
        }
        if (comboAudioCodec.getSelectedItem().equals(language.getProperty("noAudio"))) {
            mapping = Shutter.caseAddWatermark.isSelected() || Shutter.caseAddSubtitles.isSelected() && subtitlesBurn ? (String)mapping + " -filter_complex \"" + filterComplex + "[out]\" -map \"[out]\"" + audio : (filterComplex != "" ? (String)mapping + " -filter_complex \"[0:v]" + filterComplex + "[out]\" -map \"[out]\"" + audio : (String)mapping + " -map v:0" + audio);
            if (Shutter.caseAddSubtitles.isSelected() && !subtitlesBurn) {
                mapping = (String)mapping + " -c:s mov_text" + FunctionUtils.setMapSubtitles();
            }
            return mapping;
        }
        if (!comboAudioCodec.getSelectedItem().equals(language.getProperty("codecCopy"))) {
            int channels = 0;
            Component[] componentArray = grpSetAudio.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JComboBox && !c.getName().equals("comboAudioCodec") && !c.getName().equals("lblAudioMapping") && !c.getName().equals("comboNormalizeAudio") && ((JComboBox)c).getSelectedIndex() != 16) {
                    ++channels;
                }
                ++n2;
            }
            int m = 1;
            while (m < channels) {
                if (m <= FFPROBE.channels) {
                    if (inputDeviceIsRunning) {
                        mapping = ((String)list.getElementAt(0)).equals("Capture.current.screen") && RecordInputDevice.audioDeviceIndex > 0 && RecordInputDevice.overlayAudioDeviceIndex > 0 ? " -map a? -map 2?" : " -map a?";
                    } else if (FFPROBE.channels == 1) {
                        if (audioFiltering != "") {
                            audioFiltering = (String)audioFiltering + ",";
                        }
                        mapping = Shutter.caseAddWatermark.isSelected() || Shutter.caseAddSubtitles.isSelected() && subtitlesBurn ? (String)mapping + " -filter_complex \"" + filterComplex + "[out];[0:a]" + (String)audioFiltering + "channelsplit[a1][a2]\" -map \"[out]\" -map [a1] -map [a2]" + audio : (filterComplex != "" ? (String)mapping + " -filter_complex \"[0:v]" + filterComplex + "[out];[0:a]" + (String)audioFiltering + "channelsplit[a1][a2]\" -map \"[out]\" -map [a1] -map [a2]" + audio : (String)mapping + " -map v:0 -filter_complex [0:a]" + (String)audioFiltering + "channelsplit[a1][a2] -map [a1] -map [a2]" + audio);
                        ++m;
                    } else {
                        int i = 1;
                        int map = m;
                        Component[] componentArray2 = grpSetAudio.getComponents();
                        int n3 = componentArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Component c = componentArray2[n4];
                            if (c.getName() != null && c.getName().contains("comboAudio") && c instanceof JComboBox && !c.getName().equals("comboAudioCodec")) {
                                if (i == m) {
                                    map = ((JComboBox)c).getSelectedIndex() + 1;
                                    break;
                                }
                                ++i;
                            }
                            ++n4;
                        }
                        mapping = (String)mapping + " -map 0:" + map;
                    }
                } else {
                    silentTrack = " -f lavfi -i anullsrc=r=" + lbl48k.getSelectedItem().toString() + ":cl=mono";
                    if (comboFonctions.getSelectedItem().toString().contains("XDCAM")) {
                        silentTrack = String.valueOf(silentTrack) + " -shortest -map_metadata -1";
                    }
                    mapping = Shutter.caseAddWatermark.isSelected() && Shutter.caseAddSubtitles.isSelected() && subtitlesBurn ? (String)mapping + " -map 3" : (Shutter.caseAddWatermark.isSelected() || Shutter.caseAddSubtitles.isSelected() && subtitlesBurn ? (String)mapping + " -map 2" : (String)mapping + " -map 1");
                }
                ++m;
            }
        }
        if (FFPROBE.channels != 1) {
            if (audioFiltering != "") {
                audioFiltering = " -filter:a \"" + (String)audioFiltering + "\"";
            }
            mapping = Shutter.caseAddWatermark.isSelected() || Shutter.caseAddSubtitles.isSelected() && subtitlesBurn ? " -filter_complex \"" + filterComplex + "[out]\" -map \"[out]\"" + (String)audioFiltering + (String)mapping + audio : (filterComplex != "" ? " -filter_complex \"[0:v]" + filterComplex + "[out]\" -map \"[out]\"" + (String)audioFiltering + (String)mapping + audio : " -map v:0" + (String)audioFiltering + (String)mapping + audio);
        }
        if (Shutter.caseAddSubtitles.isSelected() && !subtitlesBurn) {
            mapping = (String)mapping + " -c:s mov_text" + FunctionUtils.setMapSubtitles();
        }
        return mapping;
    }

    public static File fileReplacement(String path, String file, String oldExt, String surname, String newExt) {
        int n = 1;
        File fileOut = new File(path + "/" + file.replace(oldExt, surname.substring(0, surname.length() - 1) + newExt));
        if (!caseChangeFolder1.isSelected() && file.equals(file.replace(oldExt.toLowerCase(), surname.substring(0, surname.length() - 1) + newExt)) || caseChangeFolder1.isSelected() && path.equals(new File(FFPROBE.analyzedMedia).getParent())) {
            do {
                fileOut = new File(path + "/" + file.replace(oldExt, surname + n + newExt));
                ++n;
            } while (fileOut.exists());
        } else {
            if (!(yesToAll || noToAll || skipToAll)) {
                new fileOverwriteWindow(fileOut.getName());
            }
            if (fileOverwriteWindow.value.equals("skip") && fileOverwriteWindow.caseApplyToAll.isSelected()) {
                skipToAll = true;
            }
            if (fileOverwriteWindow.value.equals("keep") && fileOverwriteWindow.caseApplyToAll.isSelected()) {
                noToAll = true;
            }
            if (fileOverwriteWindow.value.equals("overwrite") && fileOverwriteWindow.caseApplyToAll.isSelected()) {
                yesToAll = true;
            }
            if (fileOverwriteWindow.value.equals("keep") || noToAll) {
                do {
                    fileOut = new File(path + "/" + file.replace(oldExt, surname + n + newExt));
                    ++n;
                } while (fileOut.exists());
            } else if (fileOverwriteWindow.value.equals("skip") || skipToAll) {
                fileOut = new File("skip");
            } else if (fileOverwriteWindow.value.equals("cancel")) {
                if (!caseChangeFolder1.isSelected()) {
                    lblDestination1.setText(language.getProperty("sameAsSource"));
                }
                return null;
            }
        }
        return fileOut;
    }

    public static void addSubtitles(boolean add) {
        if (VideoPlayer.videoPath != null && add) {
            deleteSRT = false;
            if (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionSubtitles"))) {
                Shutter.subtitlesFile = System.getProperty("os.name").contains("Windows") ? new File(SubtitlesTimeline.srt.getName()) : new File(Shutter.dirTemp + SubtitlesTimeline.srt.getName());
                Object[] options = new Object[]{Shutter.language.getProperty("subtitlesBurn"), Shutter.language.getProperty("subtitlesEmbed")};
                int sub = JOptionPane.showOptionDialog(frame, Shutter.language.getProperty("chooseSubsIntegration"), Shutter.language.getProperty("caseSubtitles"), 1, 3, null, options, options[0]);
                if (sub == 0) {
                    Shutter.comboFonctions.setModel(new DefaultComboBoxModel<String>(Shutter.functionsList));
                    Shutter.comboFonctions.setSelectedItem("H.264");
                    VideoPlayer.setMedia();
                    caseAddSubtitles.setSelected(true);
                    Shutter.subtitlesBurn = true;
                    subtitlesFilePath = SubtitlesTimeline.srt;
                    VideoPlayer.writeSub(subtitlesFilePath.toString(), StandardCharsets.UTF_8);
                    subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)VideoPlayer.player.getHeight())), (int)((float)VideoPlayer.player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)VideoPlayer.player.getHeight())));
                    subsCanvas.setLocation((VideoPlayer.player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                    VideoPlayer.player.add(subsCanvas);
                    grpSubtitles.setSize(grpSubtitles.getWidth(), 131);
                    grpWatermark.setLocation(FunctionUtils.grpSubtitles.getLocation().x, FunctionUtils.grpSubtitles.getSize().height + FunctionUtils.grpSubtitles.getLocation().y + 6);
                    if (grpWatermark.getY() + grpWatermark.getHeight() >= 150) {
                        grpOverlay.setSize(grpOverlay.getWidth(), grpOverlay.getHeight() - 1);
                        grpSubtitles.setLocation(FunctionUtils.grpOverlay.getLocation().x, FunctionUtils.grpOverlay.getSize().height + FunctionUtils.grpOverlay.getLocation().y + 6);
                        grpWatermark.setLocation(FunctionUtils.grpSubtitles.getLocation().x, FunctionUtils.grpSubtitles.getSize().height + FunctionUtils.grpSubtitles.getLocation().y + 6);
                    }
                    Component[] componentArray = grpSubtitles.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        c.setEnabled(true);
                        ++n2;
                    }
                } else {
                    Shutter.subtitlesBurn = false;
                    subtitlesFilePath = new File(SubtitlesTimeline.srt.toString());
                    Shutter.caseDisplay.setSelected(false);
                    Thread copySRT = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block18: {
                                try {
                                    try {
                                        Shutter.disableAll();
                                        File fileIn = new File(VideoPlayer.videoPath);
                                        String extension = VideoPlayer.videoPath.toString().substring(fileIn.toString().lastIndexOf("."));
                                        File fileOut = new File(fileIn.toString().replace(extension, "_subs" + extension));
                                        String cmd = " -c copy -c:s mov_text -map v:0? -map a? -map 1:s -y ";
                                        if (extension.equals(".mkv")) {
                                            cmd = " -c copy -c:s srt -map v:0? -map a? -map 1:s -y ";
                                        }
                                        FFMPEG.run(" -i \"" + String.valueOf(fileIn) + "\" -i \"" + String.valueOf(subtitlesFilePath) + "\"" + cmd + "\"" + String.valueOf(fileOut) + "\"");
                                        lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                                        lblCurrentEncoding.setText(fileIn.getName());
                                        do {
                                            Thread.sleep(10L);
                                        } while (FFMPEG.runProcess.isAlive());
                                        if (FFMPEG.error || fileOut.length() == 0L) {
                                            FFMPEG.errorList.append(fileIn.getName());
                                            FFMPEG.errorList.append(System.lineSeparator());
                                            fileOut.delete();
                                        }
                                        if (Shutter.cancelled) {
                                            fileOut.delete();
                                        }
                                        if (!Shutter.cancelled && !FFMPEG.error) {
                                            lblFilesEnded.setText(FunctionUtils.completedFiles(1));
                                        }
                                        if (!caseOpenFolderAtEnd1.isSelected() || Shutter.cancelled || FFMPEG.error) break block18;
                                        if (System.getProperty("os.name").contains("Mac")) {
                                            try {
                                                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", "-R", fileOut.toString()});
                                            }
                                            catch (Exception exception) {}
                                            break block18;
                                        }
                                        if (System.getProperty("os.name").contains("Linux")) {
                                            try {
                                                Desktop.getDesktop().open(fileOut);
                                            }
                                            catch (Exception exception) {}
                                            break block18;
                                        }
                                        try {
                                            Runtime.getRuntime().exec("explorer.exe /select," + fileOut.toString());
                                        }
                                        catch (IOException iOException) {
                                        }
                                    }
                                    catch (Exception exception) {
                                        Shutter.enfOfFunction();
                                    }
                                }
                                finally {
                                    Shutter.enfOfFunction();
                                }
                            }
                        }
                    });
                    copySRT.start();
                }
            } else {
                File video = new File(((String)fileList.getSelectedValue()).toString());
                String ext = video.toString().substring(video.toString().lastIndexOf("."));
                char slash = '/';
                if (System.getProperty("os.name").contains("Windows")) {
                    slash = '\\';
                }
                FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseSubtitles"), 0);
                if (comboSubsSource.getSelectedIndex() == 0) {
                    if (new File(video.toString().replace(ext, ".srt")).exists()) {
                        dialog.setDirectory(video.getParent() + slash);
                        dialog.setFile(video.getName().replace(ext, ".srt"));
                    } else if (new File(video.toString().replace(ext, ".vtt")).exists()) {
                        dialog.setDirectory(video.getParent() + slash);
                        dialog.setFile(video.getName().replace(ext, ".vtt"));
                    } else if (new File(video.toString().replace(ext, ".ass")).exists()) {
                        dialog.setDirectory(video.getParent() + slash);
                        dialog.setFile(video.getName().replace(ext, ".ass"));
                    } else if (new File(video.toString().replace(ext, ".ssa")).exists()) {
                        dialog.setDirectory(video.getParent() + slash);
                        dialog.setFile(video.getName().replace(ext, ".ssa"));
                    } else if (new File(video.toString().replace(ext, ".scc")).exists()) {
                        dialog.setDirectory(video.getParent() + slash);
                        dialog.setFile(video.getName().replace(ext, ".scc"));
                    } else {
                        dialog.setDirectory(new File(VideoPlayer.videoPath).getParent());
                        dialog.setFile("*.srt;*.vtt;*.ass;*.ssa;*.scc");
                        dialog.setLocation(FunctionUtils.frame.getLocation().x - 50, FunctionUtils.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        dialog.setMultipleMode(false);
                        dialog.setVisible(true);
                    }
                } else if (comboSubsSource.getSelectedItem().toString().equals(Shutter.language.getProperty("functionTranscribe"))) {
                    new WHISPER();
                    if (WHISPER.whisperModel != null) {
                        Transcribe.main();
                    }
                } else {
                    try {
                        File srt = new File(video.toString().replace(ext, ".srt"));
                        FFMPEG.runSilently(" -i \"" + video.toString() + "\" -vn -an -map s:" + (comboSubsSource.getSelectedIndex() - 1) + "? -y \"" + video.toString().replace(ext, ".srt") + "\"");
                        do {
                            Thread.sleep(100L);
                        } while (FFMPEG.process.isAlive() && !FFMPEG.error);
                        if (srt.exists()) {
                            deleteSRT = true;
                        }
                    }
                    catch (InterruptedException srt) {
                        // empty catch block
                    }
                    dialog.setDirectory(video.getParent() + slash);
                    dialog.setFile(video.getName().replace(ext, ".srt"));
                }
                if (dialog.getFile() != null) {
                    String input = dialog.getFile().substring(dialog.getFile().lastIndexOf("."));
                    if (input.equals(".srt") || input.equals(".vtt") || input.equals(".ssa") || input.equals(".ass") || input.equals(".scc")) {
                        Shutter.subtitlesFile = System.getProperty("os.name").contains("Windows") ? new File(dialog.getFile()) : new File(Shutter.dirTemp + dialog.getFile());
                        if (input.equals(".srt") || input.equals(".vtt")) {
                            int sub = 0;
                            if (!autoBurn && !autoEmbed && comboSubsSource.getSelectedIndex() == 0) {
                                Object[] options = new Object[]{Shutter.language.getProperty("subtitlesBurn"), Shutter.language.getProperty("subtitlesEmbed")};
                                if (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap")) || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionCut"))) {
                                    sub = 1;
                                }
                                if (!(Shutter.comboFilter.getSelectedItem().toString().equals(".mxf") || Shutter.comboFonctions.getSelectedItem().toString().equals("XAVC") || Shutter.caseCreateOPATOM.isSelected() || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap")) || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionCut")))) {
                                    sub = JOptionPane.showOptionDialog(frame, Shutter.language.getProperty("chooseSubsIntegration"), Shutter.language.getProperty("caseAddSubtitles"), 1, 3, null, options, options[0]);
                                }
                            } else if (autoEmbed) {
                                sub = 1;
                            }
                            if (sub == 0) {
                                Shutter.subtitlesBurn = true;
                                if (input.equals(".vtt")) {
                                    subtitlesFilePath = new File(Shutter.subtitlesFile.toString().replace(".vtt", ".srt"));
                                    try {
                                        FFMPEG.runSilently(" -i \"" + dialog.getDirectory() + dialog.getFile().toString() + "\" -y \"" + subtitlesFilePath.toString().replace(".srt", "_vtt.srt") + "\"");
                                        do {
                                            Thread.sleep(100L);
                                        } while (FFMPEG.process.isAlive() && !FFMPEG.error);
                                    }
                                    catch (InterruptedException options) {
                                        // empty catch block
                                    }
                                    Shutter.subtitlesFile = new File(subtitlesFilePath.toString().replace(".srt", "_vtt.srt"));
                                } else {
                                    subtitlesFilePath = new File(dialog.getDirectory() + dialog.getFile().toString());
                                }
                                VideoPlayer.writeSub(subtitlesFilePath.toString(), StandardCharsets.UTF_8);
                                subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)VideoPlayer.player.getHeight())), (int)((float)VideoPlayer.player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)VideoPlayer.player.getHeight())));
                                subsCanvas.setLocation((VideoPlayer.player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                                VideoPlayer.player.add(subsCanvas);
                                Component[] componentArray = grpSubtitles.getComponents();
                                int n = componentArray.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    c = componentArray[n3];
                                    c.setEnabled(true);
                                    ++n3;
                                }
                            } else {
                                SubtitlesEmbed.subtitlesFile1.setText(dialog.getDirectory() + dialog.getFile().toString());
                                if (SubtitlesEmbed.frame == null) {
                                    new SubtitlesEmbed();
                                } else {
                                    Utils.changeDialogVisibility(SubtitlesEmbed.frame, false);
                                }
                                Shutter.subtitlesBurn = false;
                                Shutter.changeSections(false);
                                Shutter.caseDisplay.setSelected(false);
                                if (caseAddSubtitles.isSelected()) {
                                    Component[] componentArray = grpSubtitles.getComponents();
                                    int n = componentArray.length;
                                    int n4 = 0;
                                    while (n4 < n) {
                                        c = componentArray[n4];
                                        if (!(c instanceof JCheckBox)) {
                                            c.setEnabled(false);
                                        }
                                        ++n4;
                                    }
                                    if (!comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionRewrap"))) {
                                        comboSubsSource.setEnabled(true);
                                    }
                                }
                                if (!autoEmbed && caseAddSubtitles.isSelected()) {
                                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("previewNotAvailable"), Shutter.language.getProperty("caseSubtitles"), 1);
                                }
                            }
                            VideoPlayer.sliderSpeed.setEnabled(false);
                            VideoPlayer.sliderSpeed.setValue(2);
                            VideoPlayer.lblSpeed.setText("x1");
                            VideoPlayer.lblSpeed.setBounds(VideoPlayer.sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, VideoPlayer.sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                        } else {
                            Object[] options = new Object[]{Shutter.language.getProperty("subtitlesBurn"), Shutter.language.getProperty("subtitlesEmbed")};
                            int sub = 0;
                            if (!autoBurn && !autoEmbed) {
                                if (!(Shutter.comboFilter.getSelectedItem().toString().equals(".mxf") || Shutter.comboFonctions.getSelectedItem().toString().equals("XAVC") || Shutter.caseCreateOPATOM.isSelected())) {
                                    sub = JOptionPane.showOptionDialog(frame, Shutter.language.getProperty("chooseSubsIntegration"), Shutter.language.getProperty("caseAddSubtitles"), 1, 3, null, options, options[0]);
                                }
                            } else if (autoEmbed) {
                                sub = 1;
                            }
                            if (sub == 0) {
                                Shutter.subtitlesBurn = true;
                                try {
                                    FileUtils.copyFile(new File(dialog.getDirectory() + dialog.getFile().toString()), Shutter.subtitlesFile);
                                }
                                catch (IOException iOException) {}
                            } else {
                                SubtitlesEmbed.subtitlesFile1.setText(dialog.getDirectory() + dialog.getFile().toString());
                                if (SubtitlesEmbed.frame == null) {
                                    new SubtitlesEmbed();
                                } else {
                                    Utils.changeDialogVisibility(SubtitlesEmbed.frame, false);
                                }
                                Shutter.subtitlesBurn = false;
                                Shutter.changeSections(false);
                                Shutter.caseDisplay.setSelected(false);
                            }
                            Component[] componentArray = grpSubtitles.getComponents();
                            int n = componentArray.length;
                            int n5 = 0;
                            while (n5 < n) {
                                Component c = componentArray[n5];
                                if (!(c instanceof JCheckBox)) {
                                    c.setEnabled(false);
                                }
                                ++n5;
                            }
                            if (!comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionRewrap"))) {
                                comboSubsSource.setEnabled(true);
                            }
                            if (!autoEmbed && caseAddSubtitles.isSelected()) {
                                JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("previewNotAvailable"), Shutter.language.getProperty("caseSubtitles"), 1);
                            }
                        }
                        VideoPlayer.sliderSpeed.setEnabled(false);
                        VideoPlayer.sliderSpeed.setValue(2);
                        VideoPlayer.lblSpeed.setText("x1");
                        VideoPlayer.lblSpeed.setBounds(VideoPlayer.sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, VideoPlayer.sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                    } else {
                        JOptionPane.showConfirmDialog(frame, Shutter.language.getProperty("invalidSubtitles"), Shutter.language.getProperty("subtitlesFileError"), -1);
                        caseAddSubtitles.setSelected(false);
                    }
                } else {
                    caseAddSubtitles.setSelected(false);
                }
            }
            if (comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionRewrap")) || comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionCut")) || !subtitlesBurn) {
                Shutter.casePreserveSubs.setSelected(false);
            }
        } else if (!add) {
            if (deleteSRT && subtitlesFilePath != null) {
                subtitlesFilePath.delete();
            }
            Shutter.subtitlesBurn = true;
            FunctionUtils.changeSections(false);
            VideoPlayer.player.remove(subsCanvas);
            if (!autoBurn && !autoEmbed) {
                VideoPlayer.playerSetTime(VideoPlayer.playerCurrentFrame);
            }
            Component[] componentArray = grpSubtitles.getComponents();
            int n = componentArray.length;
            int n6 = 0;
            while (n6 < n) {
                Component c = componentArray[n6];
                if (!(c instanceof JCheckBox)) {
                    c.setEnabled(false);
                }
                ++n6;
            }
            if (!comboFonctions.getSelectedItem().toString().equals(language.getProperty("functionRewrap"))) {
                comboSubsSource.setEnabled(true);
            }
            VideoPlayer.sliderSpeed.setEnabled(true);
        }
    }

    public static void addFileForMail(String file) {
        String text = Shutter.language.getProperty("isEncoded");
        if (FFMPEG.error) {
            text = Shutter.language.getProperty("notEncoded");
        }
        if (caseChangeFolder3.isSelected()) {
            mailFileList.append(file + " " + text + " " + lblDestination1.getText() + " | " + lblDestination2.getText() + " | " + lblDestination3.getText() + System.lineSeparator());
        } else if (caseChangeFolder2.isSelected()) {
            mailFileList.append(file + " " + text + " " + lblDestination1.getText() + " | " + lblDestination2.getText() + System.lineSeparator());
        } else {
            mailFileList.append(file + " " + text + " " + lblDestination1.getText() + System.lineSeparator());
        }
    }

    public static void sendMail() {
        if (caseSendMail.isSelected() && mailFileList.length() != 0) {
            sendMailIsRunning = true;
            Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.host", "auth.smtp.1and1.fr");
            props.put("mail.smtp.port", "587");
            Session session = Session.getInstance(props, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("info@shutterencoder.com", "shutterencodermail");
                }
            });
            try {
                try {
                    MimeMessage message = new MimeMessage(session);
                    ((Message)message).setFrom(new InternetAddress("info@shutterencoder.com"));
                    ((Message)message).setRecipients(Message.RecipientType.TO, InternetAddress.parse(textMail.getText()));
                    if (FFMPEG.error) {
                        ((Message)message).setSubject(Shutter.language.getProperty("shutterEncodingError"));
                    } else {
                        ((Message)message).setSubject(Shutter.language.getProperty("shutterEncodingCompleted"));
                    }
                    message.setText(mailFileList.toString());
                    Transport.send(message);
                    Shutter.lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("mailSuccessful"));
                }
                catch (MessagingException e) {
                    Console.consoleFFMPEG.append(System.lineSeparator() + String.valueOf(e) + System.lineSeparator());
                    Shutter.lblCurrentEncoding.setForeground(Color.RED);
                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("mailFailed"));
                    Shutter.progressBar1.setValue(0);
                    sendMailIsRunning = false;
                    mailFileList.setLength(0);
                }
            }
            finally {
                sendMailIsRunning = false;
                mailFileList.setLength(0);
            }
        } else {
            mailFileList.setLength(0);
        }
    }

    public static void copyFile(File file) {
        FileOutputStream fout;
        FileInputStream fin;
        byte[] b;
        int r;
        long counter;
        long length;
        File fileout;
        File filein;
        if (caseChangeFolder2.isSelected()) {
            btnStart.setEnabled(false);
            grpDestination.setSelectedIndex(1);
            filein = file;
            fileout = new File(lblDestination2.getText() + "/" + file.getName());
            if (caseSubFolder.isSelected() && !txtSubFolder.getText().equals("")) {
                fileout = new File(lblDestination2.getText() + "/" + txtSubFolder.getText() + "/" + file.getName());
                if (!new File(lblDestination2.getText() + "/" + txtSubFolder.getText()).exists()) {
                    fileout.mkdirs();
                }
            }
            try {
                length = filein.length();
                progressBar1.setMaximum((int)length);
                counter = 0L;
                r = 0;
                b = new byte[1024];
                fin = new FileInputStream(filein);
                fout = new FileOutputStream(fileout);
                copyFileIsRunning = true;
                while ((r = fin.read(b)) != -1) {
                    progressBar1.setValue((int)(counter += (long)r));
                    fout.write(b, 0, r);
                    if (cancelled) break;
                }
                fin.close();
                fout.close();
                if (cancelled) {
                    fileout.delete();
                }
            }
            catch (Exception e) {
                copyFileIsRunning = false;
                fileout.delete();
            }
            copyFileIsRunning = false;
            btnStart.setEnabled(true);
        }
        if (caseChangeFolder3.isSelected()) {
            btnStart.setEnabled(false);
            grpDestination.setSelectedIndex(2);
            filein = file;
            fileout = new File(lblDestination3.getText() + "/" + file.getName());
            if (caseSubFolder.isSelected() && !txtSubFolder.getText().equals("")) {
                fileout = new File(lblDestination3.getText() + "/" + txtSubFolder.getText() + "/" + file.getName());
                if (!new File(lblDestination3.getText() + "/" + txtSubFolder.getText()).exists()) {
                    fileout.mkdirs();
                }
            }
            try {
                length = filein.length();
                progressBar1.setMaximum((int)length);
                counter = 0L;
                r = 0;
                b = new byte[1024];
                fin = new FileInputStream(filein);
                fout = new FileOutputStream(fileout);
                copyFileIsRunning = true;
                while ((r = fin.read(b)) != -1) {
                    progressBar1.setValue((int)(counter += (long)r));
                    fout.write(b, 0, r);
                    if (cancelled) break;
                }
                fin.close();
                fout.close();
                if (cancelled) {
                    fileout.delete();
                }
            }
            catch (Exception e) {
                copyFileIsRunning = false;
                fileout.delete();
            }
            copyFileIsRunning = false;
            btnStart.setEnabled(true);
        }
    }

    public static boolean cleanFunction(File file, String fileName, File fileOut, String output) {
        String extension = "";
        if (fileName != null && fileName != "" && fileName.contains(".")) {
            extension = fileName.substring(fileName.lastIndexOf("."));
        }
        if (FFMPEG.error || fileOut.exists() && fileOut.length() == 0L && !caseCreateSequence.isSelected() && !extension.equals(".pdf")) {
            errorList.append(fileName + System.lineSeparator() + String.valueOf(FFMPEG.errorLog) + System.lineSeparator());
            FFMPEG.errorLog.setLength(0);
            try {
                fileOut.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Corrections.vidstab != null) {
            if (Corrections.vidstab.exists()) {
                Corrections.vidstab.delete();
            }
            Corrections.vidstab = null;
        }
        if (Settings.btnSetBab.isSelected() || grpImageSequence.isVisible() && caseEnableSequence.isSelected() || VideoPlayer.comboMode.getSelectedItem().toString().equals(language.getProperty("removeMode"))) {
            File concatList = new File(output.replace("\\", "/") + "/" + fileName.replace(extension, ".txt"));
            if (RenderQueue.frame == null || !RenderQueue.frame.isVisible()) {
                concatList.delete();
            }
        }
        if (cancelled && !caseCreateSequence.isSelected() && !extension.equals(".pdf")) {
            try {
                fileOut.delete();
            }
            catch (Exception concatList) {
                // empty catch block
            }
            return true;
        }
        if (!cancelled && !FFMPEG.error) {
            lblFilesEnded.setText(FunctionUtils.completedFiles(++completed));
        }
        if (caseIncrementTimecode.isSelected()) {
            DecimalFormat formatter = new DecimalFormat("00");
            int timecodeToMs = Integer.parseInt(TCset1.getText()) * 3600000 + Integer.parseInt(TCset2.getText()) * 60000 + Integer.parseInt(TCset3.getText()) * 1000 + Integer.parseInt(TCset4.getText()) * (int)(1000.0f / FFPROBE.currentFPS);
            int millisecondsToTc = timecodeToMs + FFPROBE.totalLength;
            if (VideoPlayer.playerInMark > 0 || VideoPlayer.playerOutMark < VideoPlayer.waveformContainer.getWidth() - 2) {
                millisecondsToTc = timecodeToMs + VideoPlayer.durationH * 3600000 + VideoPlayer.durationM * 60000 + VideoPlayer.durationS * 1000 + VideoPlayer.durationF * (int)(1000.0f / FFPROBE.currentFPS);
            }
            if (caseEnableSequence.isSelected()) {
                millisecondsToTc = Shutter.list.getSize() * (int)(1000.0f / Float.parseFloat(caseSequenceFPS.getSelectedItem().toString()));
            }
            TCset1.setText(formatter.format(millisecondsToTc / 3600000));
            TCset2.setText(formatter.format(millisecondsToTc / 60000 % 60));
            TCset3.setText(formatter.format(millisecondsToTc / 1000 % 60));
            TCset4.setText(formatter.format((int)((float)millisecondsToTc / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
        }
        if (caseOpenFolderAtEnd1.isSelected() && !comboFonctions.getSelectedItem().equals(language.getProperty("functionMerge")) && !cancelled && !FFMPEG.error) {
            try {
                Desktop.getDesktop().open(new File(output));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (caseDeleteSourceFile.isSelected() && file != null && !cancelled && !FFMPEG.error) {
            file.delete();
        }
        return false;
    }
}

