/*
 * Decompiled with CFR 0.152.
 */
package library;

import application.Console;
import application.Shutter;
import application.Update;
import application.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Optional;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.filechooser.FileSystemView;
import library.FFPROBE;
import org.json.JSONObject;

public class WHISPER {
    public static boolean error = false;
    public static boolean isRunning = false;
    public static Thread runProcess;
    public static String PathToWHISPER;
    public static Process process;
    public static String whisperModel;
    public static String modelLink;
    public static String modelName;
    public static long modelSize;
    public static boolean useCPU;
    public static JComboBox<String> comboLanguage;
    public static String[][] WHISPER_LANGUAGES;

    static {
        modelLink = "";
        useCPU = false;
        WHISPER_LANGUAGES = new String[][]{{"af", "Afrikaans"}, {"am", "Amharic"}, {"ar", "Arabic"}, {"as", "Assamese"}, {"az", "Azerbaijani"}, {"ba", "Bashkir"}, {"be", "Belarusian"}, {"bg", "Bulgarian"}, {"bn", "Bengali"}, {"bo", "Tibetan"}, {"br", "Breton"}, {"bs", "Bosnian"}, {"ca", "Catalan"}, {"cs", "Czech"}, {"cy", "Welsh"}, {"da", "Danish"}, {"de", "German"}, {"el", "Greek"}, {"en", "English"}, {"es", "Spanish"}, {"et", "Estonian"}, {"eu", "Basque"}, {"fa", "Persian"}, {"fi", "Finnish"}, {"fo", "Faroese"}, {"fr", "French"}, {"gl", "Galician"}, {"gu", "Gujarati"}, {"haw", "Hawaiian"}, {"he", "Hebrew"}, {"hi", "Hindi"}, {"hr", "Croatian"}, {"ht", "Haitian Creole"}, {"hu", "Hungarian"}, {"hy", "Armenian"}, {"id", "Indonesian"}, {"is", "Icelandic"}, {"it", "Italian"}, {"ja", "Japanese"}, {"jw", "Javanese"}, {"ka", "Georgian"}, {"kk", "Kazakh"}, {"km", "Khmer"}, {"kn", "Kannada"}, {"ko", "Korean"}, {"la", "Latin"}, {"lb", "Luxembourgish"}, {"ln", "Lingala"}, {"lo", "Lao"}, {"lt", "Lithuanian"}, {"lv", "Latvian"}, {"mg", "Malagasy"}, {"mi", "Maori"}, {"mk", "Macedonian"}, {"ml", "Malayalam"}, {"mn", "Mongolian"}, {"mr", "Marathi"}, {"ms", "Malay"}, {"mt", "Maltese"}, {"my", "Burmese"}, {"ne", "Nepali"}, {"nl", "Dutch"}, {"nn", "Nynorsk"}, {"no", "Norwegian"}, {"oc", "Occitan"}, {"pa", "Punjabi"}, {"pl", "Polish"}, {"ps", "Pashto"}, {"pt", "Portuguese"}, {"ro", "Romanian"}, {"ru", "Russian"}, {"sa", "Sanskrit"}, {"sd", "Sindhi"}, {"si", "Sinhala"}, {"sk", "Slovak"}, {"sl", "Slovenian"}, {"sn", "Shona"}, {"so", "Somali"}, {"sq", "Albanian"}, {"sr", "Serbian"}, {"su", "Sundanese"}, {"sv", "Swedish"}, {"sw", "Swahili"}, {"ta", "Tamil"}, {"te", "Telugu"}, {"tg", "Tajik"}, {"th", "Thai"}, {"tk", "Turkmen"}, {"tl", "Tagalog"}, {"tr", "Turkish"}, {"tt", "Tatar"}, {"uk", "Ukrainian"}, {"ur", "Urdu"}, {"uz", "Uzbek"}, {"vi", "Vietnamese"}, {"yi", "Yiddish"}, {"yo", "Yoruba"}, {"zh", "Chinese"}};
    }

    public WHISPER() {
        File transcriberApp = null;
        if (System.getProperty("os.name").contains("Windows")) {
            transcriberApp = new File("C:\\Program Files\\Shutter Transcriber\\Shutter Transcriber.exe");
            if (transcriberApp.exists()) {
                PathToWHISPER = transcriberApp.getParent() + "/Library/whisper-cli.exe";
                WHISPER.detectVulkanVersion();
            } else {
                transcriberApp = null;
            }
        } else if (System.getProperty("os.name").contains("Mac")) {
            transcriberApp = new File("/Applications/Shutter Transcriber.app");
            if (transcriberApp.exists()) {
                PathToWHISPER = transcriberApp.toString() + "/Contents/Resources/Library/whisper-cli";
            } else {
                transcriberApp = null;
            }
        }
        if (transcriberApp != null) {
            WHISPER.downloadModel();
        } else {
            ImageIcon app = new ImageIcon(this.getClass().getClassLoader().getResource("contents/Shutter Transcriber.png"));
            Image scaled = app.getImage().getScaledInstance(420, -1, 4);
            ImageIcon icon = new ImageIcon(scaled);
            JLabel background = new JLabel(icon);
            background.setLayout(new BorderLayout());
            JLabel text = new JLabel("<html>" + Shutter.language.getProperty("shutterTranscriberRequired") + "<br>" + Shutter.language.getProperty("wantToDownload") + "</html>", 0);
            Image transcriber = new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon_transcriber.png")).getImage();
            Image newimg = transcriber.getScaledInstance(40, 40, 4);
            ImageIcon logo = new ImageIcon(newimg);
            text.setIcon(logo);
            text.setOpaque(false);
            text.setForeground(Color.WHITE);
            text.setFont(new Font(Shutter.mainFont, 1, 14));
            background.add((Component)text, "Center");
            int q = JOptionPane.showConfirmDialog(Shutter.frame, background, Shutter.language.getProperty("functionTranscribe"), 0, -1);
            if (q == 0) {
                if (System.getProperty("os.name").contains("Windows")) {
                    Thread download = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Desktop.getDesktop().browse(new URI("https://www.paypal.com/ncp/payment/8BT2G3JWLLZPU"));
                                File desktopDir = FileSystemView.getFileSystemView().getHomeDirectory();
                                File fileToUnlock = WHISPER.waitForFile(Paths.get(desktopDir.getAbsolutePath(), new String[0]), Paths.get(WHISPER.checkDownloadLocation(), new String[0]), "Shutter Transcriber");
                                ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-Command", "Unblock-File -Path '" + String.valueOf(fileToUnlock) + "'");
                                pb.start();
                                Desktop.getDesktop().open(fileToUnlock);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    download.start();
                } else {
                    try {
                        Desktop.getDesktop().browse(new URI("https://www.paypal.com/ncp/payment/WG4KV7R49DMY6"));
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            } else if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionTranscribe"))) {
                Shutter.comboFonctions.removeItem(Shutter.language.getProperty("functionTranscribe"));
            }
            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionTranscribe"))) {
                Shutter.comboFonctions.setSelectedItem("");
            }
        }
    }

    public static void getWhisperModel() {
        whisperModel = System.getProperty("os.name").contains("Windows") ? PathToWHISPER.replace("whisper-cli.exe", "models/" + modelName) : PathToWHISPER.replace("whisper-cli", "models/" + modelName);
    }

    public static void detectVulkanVersion() {
        File ggml_vulkan = new File(PathToWHISPER.replace("whisper-cli.exe", "ggml_vulkan.dll"));
        File ggml_cpu = new File(PathToWHISPER.replace("whisper-cli.exe", "ggml_cpu.dll"));
        File ggml = new File(PathToWHISPER.replace("whisper-cli.exe", "ggml.dll"));
        try {
            Process process = new ProcessBuilder("cmd.exe", "/c", "vulkaninfo | findstr \"Vulkan Instance Version\"").redirectErrorStream(true).start();
            String version = null;
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts;
                    if (!line.contains("Vulkan Instance Version") || (parts = line.split(":")).length <= 1) continue;
                    version = parts[1].trim();
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            process.waitFor();
            if (version == null) {
                useCPU = true;
            } else {
                int minor;
                String[] nums = version.split("\\.");
                int major = nums.length > 0 ? Integer.parseInt(nums[0]) : 0;
                int n = minor = nums.length > 1 ? Integer.parseInt(nums[1]) : 0;
                if (major > 1 || major == 1 && minor >= 2) {
                    if (ggml_vulkan.exists()) {
                        ggml.renameTo(ggml_cpu);
                        ggml_vulkan.renameTo(ggml);
                    }
                    useCPU = false;
                } else {
                    useCPU = true;
                }
            }
        }
        catch (Exception e) {
            useCPU = true;
        }
        if (useCPU && ggml_cpu.exists()) {
            ggml.renameTo(ggml_vulkan);
            ggml_cpu.renameTo(ggml);
        }
    }

    public static void run(final String cmd) {
        error = false;
        Shutter.progressBar1.setValue(0);
        Shutter.btnStart.setEnabled(false);
        runProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessBuilder processWHISPER;
                    if (System.getProperty("os.name").contains("Windows")) {
                        Object threads = "";
                        if (useCPU) {
                            threads = " -t " + Runtime.getRuntime().availableProcessors();
                        }
                        processWHISPER = new ProcessBuilder("\"" + PathToWHISPER + "\" -m \"" + whisperModel + "\"" + (String)threads + cmd);
                    } else {
                        processWHISPER = new ProcessBuilder("/bin/bash", "-c", PathToWHISPER.replace(" ", "\\ ") + " -m \"" + whisperModel + "\"" + cmd);
                    }
                    processWHISPER.redirectErrorStream(true);
                    Console.consoleWHISPER.append(Shutter.language.getProperty("command") + "  -m \"" + whisperModel + "\"" + cmd);
                    isRunning = true;
                    process = processWHISPER.start();
                    InputStreamReader isr = new InputStreamReader(process.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    Console.consoleWHISPER.append(System.lineSeparator());
                    Shutter.progressBar1.setMaximum(Math.round(FFPROBE.totalLength / 1000));
                    while (!Shutter.cancelled) {
                        String line = br.readLine();
                        if (line != null && line.contains(" --> ")) {
                            Console.consoleWHISPER.append(line + System.lineSeparator());
                            String[] s = line.split("]");
                            String[] s2 = s[0].split(" ");
                            String[] s3 = s2[2].split("\\.");
                            String[] s4 = s3[0].split(":");
                            int value = Integer.parseInt(s4[0]) * 3600 + Integer.parseInt(s4[1]) * 60 + Integer.parseInt(s4[2]);
                            Shutter.progressBar1.setValue(value);
                        }
                        if (line != null) continue;
                    }
                    process.waitFor();
                    Console.consoleWHISPER.append(System.lineSeparator());
                    isRunning = false;
                }
                catch (IOException | InterruptedException e) {
                    error = true;
                }
            }
        });
        runProcess.start();
    }

    public static void downloadModel() {
        JSlider slider = new JSlider(0, 2, 1);
        slider.setMajorTickSpacing(1);
        slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(0, new JLabel("Fast"));
        labels.put(1, new JLabel("Balanced"));
        labels.put(2, new JLabel("Accurate"));
        slider.setLabelTable(labels);
        slider.setPaintLabels(true);
        DefaultComboBoxModel<String> languages = new DefaultComboBoxModel<String>();
        languages.addElement("auto");
        String[][] stringArray = WHISPER_LANGUAGES;
        int n = WHISPER_LANGUAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] lang = stringArray[n2];
            languages.addElement(lang[1].toLowerCase());
            ++n2;
        }
        comboLanguage = new JComboBox(languages);
        comboLanguage.setSelectedIndex(0);
        comboLanguage.setSize(120, 26);
        JPanel panel = new JPanel();
        panel.add(slider);
        panel.add(comboLanguage);
        Object[] options = new Object[]{Shutter.language.getProperty("btnApply")};
        JOptionPane.showOptionDialog(Shutter.frame, panel, Shutter.language.getProperty("functionTranscribe"), -1, -1, null, options, options[0]);
        switch (slider.getValue()) {
            case 0: {
                modelLink = "https://huggingface.co/ggerganov/whisper.cpp/resolve/main/ggml-small.bin?download=true";
                modelName = "ggml-small.bin";
                modelSize = 487601967L;
                break;
            }
            case 1: {
                modelLink = "https://huggingface.co/ggerganov/whisper.cpp/resolve/main/ggml-large-v3-turbo-q8_0.bin?download=true";
                modelName = "ggml-large-v3-turbo-q8_0.bin";
                modelSize = 874188075L;
                break;
            }
            case 2: {
                modelLink = "https://huggingface.co/ggerganov/whisper.cpp/resolve/main/ggml-large-v3-q5_0.bin?download=true";
                modelName = "ggml-large-v3-q5_0.bin";
                modelSize = 1081140203L;
            }
        }
        WHISPER.getWhisperModel();
        final File model = new File(whisperModel);
        File modelPath = new File(model.getParent());
        if (!modelPath.exists()) {
            modelPath.mkdir();
        }
        try {
            if (model.exists() && Files.size(model.toPath()) != modelSize) {
                model.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!model.exists()) {
            new Update();
            if (Shutter.getLanguage.contains(Locale.of("ar").getDisplayLanguage())) {
                Update.lblNewVersion.setText(Shutter.language.getProperty("update"));
            } else {
                Update.lblNewVersion.setText(Shutter.language.getProperty("update") + "...");
            }
            Thread download = new Thread(new Runnable(){

                @Override
                public void run() {
                    Utils.changeFrameVisibility(Shutter.frame, true);
                    Update.HTTPDownload(modelLink, whisperModel);
                    Utils.changeFrameVisibility(Shutter.frame, false);
                    Shutter.frame.toFront();
                    Update.frame.dispose();
                    if (!model.exists() && Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionTranscribe"))) {
                        Shutter.comboFonctions.setSelectedItem("");
                    }
                }
            });
            download.start();
        }
    }

    public static String checkBrowser() throws Exception {
        String key = "HKCU\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice";
        Process process = new ProcessBuilder("reg", "query", key, "/v", "ProgId").redirectErrorStream(true).start();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            String progId = null;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!line.contains("ProgId") || (parts = line.trim().split("\\s+")).length < 3) continue;
                progId = parts[parts.length - 1].trim();
            }
            int exitCode = process.waitFor();
            if (exitCode == 0 && progId != null) {
                return WHISPER.resolveBrowser(progId);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private static String resolveBrowser(String progId) {
        switch (progId) {
            case "ChromeHTML": {
                return "Google Chrome";
            }
            case "MSEdgeHTMHTML": 
            case "MSEdgeHTM": {
                return "Microsoft Edge";
            }
            case "FirefoxURL": {
                return "Mozilla Firefox";
            }
            case "IE.HTTP": {
                return "Internet Explorer";
            }
        }
        return "Unknown (" + progId + ")";
    }

    public static String checkDownloadLocation() throws Exception {
        String defaultBrowser;
        String downloadFolder = switch (defaultBrowser = WHISPER.getDefaultBrowserProgId()) {
            case "ChromeHTML" -> WHISPER.getChromeOrEdgeDownloadFolder(Paths.get(System.getenv("LOCALAPPDATA"), "Google", "Chrome", "User Data", "Default", "Preferences"));
            case "MSEdgeHTMHTML", "MSEdgeHTM" -> WHISPER.getChromeOrEdgeDownloadFolder(Paths.get(System.getenv("LOCALAPPDATA"), "Microsoft", "Edge", "User Data", "Default", "Preferences"));
            case "FirefoxURL" -> WHISPER.getFirefoxDownloadFolder();
            case "IE.HTTP" -> WHISPER.getIEDownloadFolder();
            default -> System.getProperty("user.home") + "\\Downloads";
        };
        return downloadFolder;
    }

    private static String getDefaultBrowserProgId() throws Exception {
        String line;
        Process p = new ProcessBuilder("reg", "query", "HKCU\\Software\\Microsoft\\Windows\\Shell\\Associations\\UrlAssociations\\http\\UserChoice", "/v", "ProgId").start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            String[] parts;
            if (!(line = line.trim()).startsWith("ProgId") || (parts = line.split("\\s{2,}")).length < 3) continue;
            return parts[2];
        }
        p.waitFor();
        return "";
    }

    private static String getChromeOrEdgeDownloadFolder(Path prefsPath) {
        String fallback = System.getProperty("user.home") + "\\Downloads";
        try {
            String dir;
            if (!Files.exists(prefsPath, new LinkOption[0])) {
                return fallback;
            }
            String content = Files.readString(prefsPath, StandardCharsets.UTF_8);
            JSONObject json = new JSONObject(content);
            JSONObject download = json.optJSONObject("download");
            if (download != null && !(dir = download.optString("default_directory", "").trim()).isEmpty()) {
                return dir;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private static String getFirefoxDownloadFolder() {
        String fallback = System.getProperty("user.home") + "\\Downloads";
        try {
            Path appData = Paths.get(System.getenv("APPDATA"), "Mozilla", "Firefox", "Profiles");
            Optional<Path> profile = Files.list(appData).filter(path -> Files.isDirectory(path, new LinkOption[0])).findFirst();
            if (profile.isEmpty()) {
                return fallback;
            }
            Path prefsJs = profile.get().resolve("prefs.js");
            if (!Files.exists(prefsJs, new LinkOption[0])) {
                return fallback;
            }
            for (String line : Files.readAllLines(prefsJs, StandardCharsets.UTF_8)) {
                if (!(line = line.trim()).startsWith("user_pref(\"browser.download.dir\"")) continue;
                int firstQuote = line.indexOf(34, 27);
                int secondQuote = line.indexOf(34, firstQuote + 1);
                if (firstQuote <= 0 || secondQuote <= firstQuote) continue;
                return line.substring(firstQuote + 1, secondQuote);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private static String getIEDownloadFolder() {
        String fallback = System.getProperty("user.home") + "\\Downloads";
        try {
            String line;
            Process p = new ProcessBuilder("reg", "query", "HKCU\\Software\\Microsoft\\Internet Explorer\\Main", "/v", "Download Directory").start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!(line = line.trim()).startsWith("Download Directory") || (parts = line.split("\\s{2,}")).length < 3) continue;
                return parts[2];
            }
            p.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fallback;
    }

    private static File waitForFile(Path desktop, Path downloads, String keyword) throws InterruptedException {
        File f;
        while ((f = WHISPER.findMatch(desktop, keyword)) == null) {
            f = WHISPER.findMatch(downloads, keyword);
            if (f != null) {
                return f;
            }
            Thread.sleep(1000L);
        }
        return f;
    }

    private static File findMatch(Path folder, String keyword) {
        File[] matches;
        File dir = folder.toFile();
        if (dir.exists() && dir.isDirectory() && (matches = dir.listFiles((d, name) -> name.toLowerCase().contains(keyword.toLowerCase()) && name.toLowerCase().endsWith(".exe"))) != null && matches.length > 0) {
            return matches[0];
        }
        return null;
    }
}

