/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.RenderQueue;
import application.Shutter;
import application.VideoPlayer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Timecode;

public class OfflineDetection
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < list.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)list.getElementAt(i)));
                    if (file == null) break;
                    try {
                        String fileName = file.getName();
                        lblCurrentEncoding.setText(fileName);
                        if (FunctionUtils.analyze(file, false)) {
                            if (VideoPlayer.caseApplyCutToAll.isSelected()) {
                                VideoPlayer.videoPath = file.toString();
                                VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(InputAndOutput.savedInPoint));
                                VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode((double)FFPROBE.totalLength / 1000.0 * FFPROBE.accurateFPS - InputAndOutput.savedOutPoint));
                                VideoPlayer.setFileList();
                            }
                            InputAndOutput.getInputAndOutput(VideoPlayer.getFileList(file.toString(), FFPROBE.totalLength));
                            Object stats_file = System.getProperty("os.name").contains("Windows") ? "stats_file" : Shutter.dirTemp + "stats_file";
                            String cmd = " -i \"" + Shutter.dirTemp + "offline.png\" -lavfi \"[0:v]scale=1920x1080[source];[1:v]scale=1920x1080[reference];[source][reference]psnr=" + (String)stats_file + "\" -an -f null -";
                            if (System.getProperty("os.name").contains("Windows")) {
                                cmd = cmd + "\"";
                            }
                            FFMPEG.run(InputAndOutput.inPoint + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (!cancelled) {
                                OfflineDetection.showDetection(file);
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && OfflineDetection.lastActions(file, fileName)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    OfflineDetection.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static void showDetection(File file) {
        if (!Shutter.cancelled && !FFMPEG.error) {
            if (comboFilter.getSelectedIndex() == 0) {
                if (FFMPEG.mediaOfflineFrame.length() > 0) {
                    JOptionPane.showMessageDialog(frame, FFMPEG.mediaOfflineFrame, Shutter.language.getProperty("functionOfflineDetection"), 0);
                } else {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("noErrorDetected"), Shutter.language.getProperty("functionOfflineDetection"), 1);
                }
            } else {
                String prefix = "";
                if (casePrefix.isSelected()) {
                    prefix = FunctionUtils.setPrefixSuffix(txtPrefix.getText(), false);
                }
                String extensionName = "";
                if (btnExtension.isSelected()) {
                    extensionName = FunctionUtils.setPrefixSuffix(txtExtension.getText(), false);
                }
                String fileOutputName = FunctionUtils.setOutputDestination("", file).replace("\\", "/") + "/" + prefix + file.getName() + extensionName;
                try {
                    PrintWriter writer = new PrintWriter(fileOutputName + ".txt", "UTF-8");
                    writer.println(Shutter.language.getProperty("analyzeOf") + " " + file.getName());
                    writer.println("");
                    if (FFMPEG.mediaOfflineFrame.length() > 0) {
                        writer.println(FFMPEG.mediaOfflineFrame);
                    } else {
                        writer.println(Shutter.language.getProperty("noErrorDetected"));
                    }
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean lastActions(File file, String fileName) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++FunctionUtils.completed;
        }
        lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
        FunctionUtils.addFileForMail(fileName);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            OfflineDetection.main();
            return true;
        }
        return false;
    }
}

