/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.RenderQueue;
import application.Shutter;
import application.VideoPlayer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;
import settings.InputAndOutput;
import settings.Timecode;

public class LoudnessTruePeak
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < list.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)list.getElementAt(i)));
                    if (file == null) break;
                    try {
                        String fileName = file.getName();
                        lblCurrentEncoding.setText(fileName);
                        if (FunctionUtils.analyze(file, false)) {
                            if (VideoPlayer.caseApplyCutToAll.isSelected()) {
                                VideoPlayer.videoPath = file.toString();
                                VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(InputAndOutput.savedInPoint));
                                VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode((double)FFPROBE.totalLength / 1000.0 * FFPROBE.accurateFPS - InputAndOutput.savedOutPoint));
                                VideoPlayer.setFileList();
                            }
                            InputAndOutput.getInputAndOutput(VideoPlayer.getFileList(file.toString(), FFPROBE.totalLength));
                            String audio = LoudnessTruePeak.setAudio();
                            String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -vn" + audio + " -f null -" : " -vn" + audio + " -f null -\"";
                            FFMPEG.run(InputAndOutput.inPoint + " -i \"" + file.toString() + "\"" + InputAndOutput.outPoint + cmd);
                            do {
                                Thread.sleep(100L);
                            } while (FFMPEG.runProcess.isAlive());
                            if (!cancelled) {
                                LoudnessTruePeak.showDetection(file);
                            }
                            if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && LoudnessTruePeak.lastActions(file, fileName)) {
                                break;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    LoudnessTruePeak.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setAudio() {
        if (FFPROBE.stereo) {
            return " -af ebur128=peak=true";
        }
        if (FFPROBE.channels > 1) {
            if (FFPROBE.channels >= 4) {
                Object[] options = new String[]{"A1 & A2", "A3 & A4"};
                int q = JOptionPane.showOptionDialog(frame, language.getProperty("ChooseMultitrack"), language.getProperty("multitrack"), -1, 1, null, options, options[0]);
                if (q == 0) {
                    return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
                }
                return " -filter_complex \"[0:a:2][0:a:3]amerge=inputs=2[a];[a]ebur128=peak=true\"";
            }
            return " -filter_complex \"[0:a:0][0:a:1]amerge=inputs=2[a];[a]ebur128=peak=true\"";
        }
        return " -af ebur128=peak=true";
    }

    private static void showDetection(File file) {
        if (FFMPEG.analyseLufs != null && !Shutter.cancelled && !FFMPEG.error) {
            if (comboFilter.getSelectedIndex() == 0) {
                JOptionPane.showMessageDialog(frame, FFMPEG.analyseLufs, file.getName(), 1);
            } else {
                String prefix = "";
                if (casePrefix.isSelected()) {
                    prefix = FunctionUtils.setPrefixSuffix(txtPrefix.getText(), false);
                }
                String extensionName = "";
                if (btnExtension.isSelected()) {
                    extensionName = FunctionUtils.setPrefixSuffix(txtExtension.getText(), false);
                }
                String fileOutputName = FunctionUtils.setOutputDestination("", file).replace("\\", "/") + "/" + prefix + file.getName() + extensionName;
                try {
                    PrintWriter writer = new PrintWriter(fileOutputName + ".txt", "UTF-8");
                    writer.println(Shutter.language.getProperty("analyzeOf") + " " + file.getName());
                    writer.println("");
                    writer.println(FFMPEG.analyseLufs + System.lineSeparator() + System.lineSeparator() + String.valueOf(FFMPEG.shortTermValues));
                    writer.close();
                }
                catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean lastActions(File file, String fileName) {
        if (FFMPEG.error) {
            FFMPEG.errorList.append(fileName);
            FFMPEG.errorList.append(System.lineSeparator());
        }
        if (cancelled) {
            return true;
        }
        if (!FFMPEG.error) {
            ++FunctionUtils.completed;
        }
        lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
        FunctionUtils.addFileForMail(fileName);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            LoudnessTruePeak.main();
            return true;
        }
        return false;
    }
}

