/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Console;
import application.Ftp;
import application.RenderQueue;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import java.io.File;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;

public class DVDRIP
extends Shutter {
    public static void main() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                FunctionUtils.completed = 0;
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                File[] volumes = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? new File("/Volumes").listFiles() : File.listRoots();
                File dvdFolder = DVDRIP.setDVDFolder(volumes);
                if (dvdFolder == null) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("noDVD"), Shutter.language.getProperty("DVDMissing"), 0);
                    cancelled = true;
                } else {
                    String[] s;
                    Console.consoleFFMPEG.append(System.lineSeparator() + String.valueOf(dvdFolder) + System.lineSeparator());
                    String[] vobArray = new String[dvdFolder.listFiles().length];
                    int i = 0;
                    File[] fileArray = dvdFolder.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File VOB = fileArray[n2];
                        if (!VOB.isHidden()) {
                            String ext = VOB.toString().substring(VOB.toString().lastIndexOf("."));
                            if (VOB.getName().contains("VTS") && ext.equals(".VOB") && !(s = VOB.getName().split("_"))[2].replace(ext, "").equals("0")) {
                                vobArray[i] = VOB.toString();
                                ++i;
                            }
                        }
                        ++n2;
                    }
                    File concatFile = new File(lblDestination1.getText() + "/DVD_RIP.txt");
                    if (concatFile.exists()) {
                        concatFile.delete();
                    }
                    PrintWriter writer = null;
                    int vtsNumber = 1;
                    String VOB = null;
                    int dureeTotale = 0;
                    i = 0;
                    while (i < vobArray.length) {
                        VOB = vobArray[i];
                        if (VOB != null) {
                            s = new File(VOB).getName().split("_");
                            int actualVOB = Integer.valueOf(s[1]);
                            if (actualVOB == vtsNumber) {
                                if (!concatFile.exists()) {
                                    try {
                                        writer = new PrintWriter(concatFile, "UTF-8");
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                writer.println("file '" + VOB + "'");
                                FFPROBE.Data(VOB);
                                do {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (FFPROBE.isRunning);
                                dureeTotale += FFPROBE.totalLength;
                                Console.consoleFFMPEG.append(VOB + System.lineSeparator());
                            } else {
                                progressBar1.setMaximum(dureeTotale / 1000);
                                writer.close();
                                if (DVDRIP.runRIP(vtsNumber, concatFile, VOB)) break;
                                vtsNumber = actualVOB;
                                --i;
                                dureeTotale = 0;
                            }
                        }
                        ++i;
                    }
                    if (!cancelled) {
                        writer.close();
                        progressBar1.setMaximum(dureeTotale / 1000);
                        DVDRIP.runRIP(vtsNumber, concatFile, VOB);
                    }
                }
                if (btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    VideoPlayer.videoPath = null;
                    VideoPlayer.setMedia();
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (VideoPlayer.loadMedia.isAlive());
                    RenderQueue.frame.toFront();
                } else {
                    DVDRIP.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    protected static File setDVDFolder(File[] volumes) {
        File[] fileArray = volumes;
        int n = volumes.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            Console.consoleFFMPEG.append(String.valueOf(folder) + System.lineSeparator());
            try {
                File[] fileArray2 = folder.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File video_ts_folder = fileArray2[n4];
                    if (video_ts_folder.getName().equals("VIDEO_TS")) {
                        return video_ts_folder;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    private static boolean runRIP(int vtsNumber, File concatFile, String VOB) {
        try {
            int q;
            String videoName = "VIDEO_" + vtsNumber + ".VOB";
            lblCurrentEncoding.setText(videoName);
            String labelOutput = lblDestination1.getText();
            lblDestination1.setText(labelOutput);
            File fileOut = new File(labelOutput + "/" + videoName);
            if (fileOut.exists() && (q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("eraseFile"), Shutter.language.getProperty("theFile") + " " + videoName + " " + Shutter.language.getProperty("alreadyExist"), 0, -1)) == 1) {
                cancelled = true;
            }
            if (!cancelled) {
                String cmd = " -c:v copy -c:a copy -c:s copy -err_detect ignore_err -map v:0? -map a? -map s? -y ";
                FFMPEG.run(" -safe 0 -f concat -i \"" + concatFile.toString() + "\"" + cmd + "\"" + String.valueOf(fileOut) + "\"");
                do {
                    Thread.sleep(100L);
                } while (FFMPEG.runProcess.isAlive());
            } else {
                return true;
            }
            if (cancelled) {
                DVDRIP.lastActions(VOB, fileOut, labelOutput);
                concatFile.delete();
                return true;
            }
            try {
                if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender"))) {
                    DVDRIP.lastActions(VOB, fileOut, labelOutput);
                }
            }
            catch (InterruptedException e) {
                FFMPEG.error = true;
            }
        }
        finally {
            concatFile.delete();
        }
        return false;
    }

    private static void lastActions(String fileName, File fileOut, String output) {
        FunctionUtils.cleanFunction(null, fileName, fileOut, output);
        FunctionUtils.addFileForMail(fileName);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
    }
}

