/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.filter.ChannelStorage;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public final class FilterLayoutContext {
    @NotNull
    private final ChannelStorage<Rectangle2D> resultChannels = new ChannelStorage();
    @NotNull
    private final UnitType primitiveUnits;
    @NotNull
    private final Rectangle2D elementBounds;

    public FilterLayoutContext(@NotNull UnitType primitiveUnits, @NotNull Rectangle2D elementBounds) {
        this.primitiveUnits = primitiveUnits;
        this.elementBounds = elementBounds;
    }

    @NotNull
    public UnitType primitiveUnits() {
        return this.primitiveUnits;
    }

    @NotNull
    public Rectangle2D elementBounds() {
        return this.elementBounds;
    }

    @NotNull
    public Rectangle2D filterPrimitiveRegion(@NotNull MeasureContext context, @NotNull FilterPrimitive filterPrimitive) {
        return this.primitiveUnits.computeViewBounds(context, this.elementBounds, filterPrimitive.x(), filterPrimitive.y(), filterPrimitive.width(), filterPrimitive.height());
    }

    @NotNull
    public ChannelStorage<Rectangle2D> resultChannels() {
        return this.resultChannels;
    }
}

