/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AntiAliasedRoundRectangle;
import application.Settings;
import application.Shutter;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.ui.FlatLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import library.FFMPEG;
import library.YOUTUBEDL;
import settings.FunctionUtils;

public class VideoWeb {
    public static JDialog frame;
    private static int complete;
    private JLabel quit;
    private JLabel help;
    private JPanel topPanel;
    private JLabel topImage;
    private JPanel grpURL;
    private JLabel lblURL;
    private JTextArea textURL;
    private JTextField textVideoPass;
    private JTextField textUser;
    private JPasswordField textPass;
    private JLabel lblQualit;
    private JButton btnOK;
    private JCheckBox caseMP3;
    private JCheckBox caseWAV;
    private JCheckBox caseAuto;
    public static JCheckBox caseMetadata;
    public static JCheckBox caseTimecode;
    public static JTextField textTimecodeIn;
    public static JTextField textTimecodeOut;
    public static JCheckBox caseCookies;
    private JComboBox<String> comboCookies;
    private JCheckBox caseUser;
    private JCheckBox casePass;
    private JCheckBox caseVideoPass;
    private JComboBox<String> comboFormats;
    private static int MousePositionX;
    private static int MousePositionY;

    public VideoWeb() {
        frame = new JDialog();
        frame.getContentPane().setBackground(Utils.bg32);
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameVideoWeb"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(420, 360);
        frame.setResizable(false);
        frame.setModal(true);
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new AntiAliasedRoundRectangle(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(45, 45, 45)));
            if (!System.getProperty("os.name").contains("Mac")) {
                frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            }
            frame.setLocation(Shutter.frame.getX() + (Shutter.frame.getWidth() - frame.getWidth()) / 2, Shutter.frame.getY() + (Shutter.frame.getHeight() - frame.getHeight()) / 2);
        }
        if (System.getProperty("os.name").contains("Mac")) {
            Thread download = new Thread(new Runnable(){

                @Override
                public void run() {
                    Object PathToYOUTUBEDL = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    PathToYOUTUBEDL = ((String)PathToYOUTUBEDL).substring(0, ((String)PathToYOUTUBEDL).length() - 1);
                    if (!new File((String)(PathToYOUTUBEDL = ((String)PathToYOUTUBEDL).substring(0, ((String)PathToYOUTUBEDL).lastIndexOf("/")).replace("%20", " ") + "/Library/yt-dlp_macos")).exists()) {
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        YOUTUBEDL.HTTPDownload("https://github.com/yt-dlp/yt-dlp/releases/latest/download/yt-dlp_macos", (String)PathToYOUTUBEDL);
                        if (!new File((String)PathToYOUTUBEDL).exists()) {
                            Utils.changeDialogVisibility(frame, true);
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            });
            download.start();
        }
        this.topPanel();
        this.grpURL();
        if (Shutter.getLanguage.contains(Locale.of("ar").getDisplayLanguage())) {
            Component[] componentArray = frame.getContentPane().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JPanel) {
                    Component[] componentArray2 = ((JPanel)c).getComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component p = componentArray2[n4];
                        if (p instanceof JCheckBox) {
                            p.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        Utils.changeDialogVisibility(frame, false);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.topPanel.setBackground(Utils.bg32);
        this.topPanel.setBounds(0, 0, 420, 28);
        this.quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(VideoWeb.frame.getSize().width - 20, 4, 15, 15);
        this.topPanel.add(this.quit);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoWeb.this.quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    if (YOUTUBEDL.runProcess != null && YOUTUBEDL.runProcess.isAlive()) {
                        if (System.getProperty("os.name").contains("Windows")) {
                            try {
                                Process process = new ProcessBuilder("taskkill", "/F", "/IM", "yt-dlp.exe").start();
                            }
                            catch (Exception exception) {}
                        } else {
                            YOUTUBEDL.process.destroy();
                        }
                    }
                    Shutter.lblCurrentEncoding.setForeground(Color.RED);
                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("processCancelled"));
                    Shutter.progressBar1.setValue(0);
                    Utils.changeDialogVisibility(frame, true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoWeb.this.quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoWeb.this.quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        this.help = new JLabel(new FlatSVGIcon("contents/help.svg", 15, 15));
        this.help.setHorizontalAlignment(0);
        this.help.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.topPanel.add(this.help);
        this.help.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoWeb.this.help.setIcon(new FlatSVGIcon("contents/help_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    try {
                        Desktop.getDesktop().browse(new URL("https://rg3.github.io/youtube-dl/supportedsites.html").toURI());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoWeb.this.help.setIcon(new FlatSVGIcon("contents/help_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoWeb.this.help.setIcon(new FlatSVGIcon("contents/help.svg", 15, 15));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("panelWebVideo"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 24);
        title.setFont(new Font(Shutter.magnetoFont, 0, 17));
        this.topPanel.add(title);
        this.topImage = new JLabel();
        this.topImage.setBackground(new Color(35, 35, 40));
        this.topImage.setOpaque(true);
        this.topImage.setBorder(new MatteBorder(1, 0, 1, 0, new Color(45, 45, 45)));
        this.topImage.setBounds(title.getBounds());
        this.topPanel.add(this.topImage);
        frame.getContentPane().add(this.topPanel);
        this.topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionX = down.getPoint().x;
                MousePositionY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePositionX, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void grpURL() {
        this.grpURL = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Utils.c25);
                g2.fillRoundRect(2, 9, this.getWidth() - 4, this.getHeight() - 11, 10, 10);
                g2.dispose();
                super.paintComponent(g);
            }
        };
        this.grpURL.setLayout(null);
        this.grpURL.setLocation(6, 28);
        this.grpURL.setSize(408, frame.getHeight() - 34);
        this.grpURL.setBackground(Utils.c30);
        this.grpURL.setOpaque(false);
        this.grpURL.setBorder(BorderFactory.createTitledBorder(new FlatLineBorder(new Insets(0, 0, 0, 0), Utils.c42, 1.0f, 10), Shutter.language.getProperty("videoUrl") + " ", 0, 0, new Font(Shutter.boldFont, 0, 13), new Color(235, 235, 240)));
        this.lblURL = new JLabel(Shutter.language.getProperty("lblURL"));
        this.lblURL.setHorizontalAlignment(4);
        this.lblURL.setFont(new Font(Shutter.mainFont, 0, 12));
        this.lblURL.setBounds(26, 25, 35, 16);
        this.grpURL.add(this.lblURL);
        this.textURL = new JTextArea();
        this.textURL.setForeground(Color.LIGHT_GRAY);
        this.textURL.setFont(new Font("SansSerif", 2, 12));
        this.textURL.setText(Shutter.language.getProperty("textURL"));
        this.textURL.setBounds(66, 22, this.grpURL.getSize().width - (this.lblURL.getLocation().x + this.lblURL.getSize().width) - 17, 80);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem coller = new JMenuItem(Shutter.language.getProperty("MenuItemPaste"));
        coller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoWeb.this.PasteFromClipBoard(true);
            }
        });
        menu.add(coller);
        this.textURL.setComponentPopupMenu(menu);
        this.textURL.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (VideoWeb.this.textURL.getText().equals("") || VideoWeb.this.textURL.getText().equals(Shutter.language.getProperty("textURL"))) {
                    VideoWeb.this.btnOK.setEnabled(false);
                    if (!VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.caseAuto.doClick();
                    }
                    VideoWeb.this.caseAuto.setEnabled(false);
                } else {
                    VideoWeb.this.textURL.setForeground(Color.WHITE);
                    VideoWeb.this.textURL.setFont(new Font("SansSerif", 0, 12));
                    VideoWeb.this.btnOK.setEnabled(true);
                    if (VideoWeb.this.textURL.getLineCount() == 1) {
                        VideoWeb.this.caseAuto.setEnabled(true);
                    } else {
                        VideoWeb.this.caseAuto.setEnabled(false);
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 86 && (e.getModifiersEx() & 0x100) != 0 || e.getKeyCode() == 86 && (e.getModifiersEx() & 0x80) != 0) {
                    VideoWeb.this.PasteFromClipBoard(false);
                }
                if (e.getKeyCode() == 65 && (e.getModifiersEx() & 0x100) != 0 || e.getKeyCode() == 65 && (e.getModifiersEx() & 0x80) != 0) {
                    VideoWeb.this.textURL.selectAll();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JScrollPane scrollBar = new JScrollPane(this.textURL);
        scrollBar.setBounds(this.textURL.getBounds());
        this.grpURL.add((Component)scrollBar, "Center");
        this.caseAuto = new JCheckBox("Auto");
        this.caseAuto.setSelected(true);
        this.caseAuto.setFont(new Font(Shutter.mainFont, 0, 12));
        this.caseAuto.setBounds(66, 111, this.caseAuto.getPreferredSize().width, 16);
        this.caseAuto.setEnabled(false);
        this.grpURL.add(this.caseAuto);
        this.caseAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoWeb.this.comboFormats.removeAllItems();
                if (VideoWeb.this.caseAuto.isSelected()) {
                    if (YOUTUBEDL.runProcess != null) {
                        if (YOUTUBEDL.runProcess.isAlive()) {
                            if (System.getProperty("os.name").contains("Windows")) {
                                try {
                                    Process process = new ProcessBuilder("taskkill", "/F", "/IM", "yt-dlp.exe").start();
                                }
                                catch (Exception exception) {}
                            } else {
                                YOUTUBEDL.process.destroy();
                            }
                        }
                        Shutter.lblCurrentEncoding.setForeground(Color.RED);
                        Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("processCancelled"));
                        Shutter.progressBar1.setValue(0);
                    }
                    VideoWeb.this.comboFormats.addItem("default");
                    VideoWeb.this.comboFormats.addItem("bestvideo+bestaudio");
                    VideoWeb.this.comboFormats.addItem("up to 4K");
                    VideoWeb.this.comboFormats.addItem("up to 1440p");
                    VideoWeb.this.comboFormats.addItem("up to 1080p");
                    VideoWeb.this.comboFormats.addItem("up to 720p");
                    VideoWeb.this.comboFormats.addItem("up to 480p");
                    VideoWeb.this.comboFormats.addItem("up to 360p");
                    VideoWeb.this.comboFormats.addItem("up to 240p");
                    VideoWeb.this.comboFormats.addItem("bestvideo");
                    VideoWeb.this.comboFormats.addItem("bestaudio");
                    VideoWeb.this.btnOK.setEnabled(true);
                } else {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    Thread getFormats = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            (this).VideoWeb.this.btnOK.setEnabled(false);
                            (this).VideoWeb.this.comboFormats.addItem(Shutter.language.getProperty("getAvailableFormats") + "...");
                            YOUTUBEDL.getAvailableFormats((this).VideoWeb.this.textURL.getText(), VideoWeb.this.options());
                            do {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            } while (YOUTUBEDL.runProcess.isAlive() && !Shutter.cancelled);
                            if (!(this).VideoWeb.this.caseAuto.isSelected() && frame.isVisible()) {
                                if (!YOUTUBEDL.error) {
                                    (this).VideoWeb.this.comboFormats.removeAllItems();
                                    String allFormats = YOUTUBEDL.formatsOutput.substring(YOUTUBEDL.formatsOutput.lastIndexOf(":") + 2).replace("null", "").replace("DASH audio", "").replace("DASH video", "");
                                    String[] stringArray = allFormats.split(System.lineSeparator());
                                    int n = stringArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String format = stringArray[n2];
                                        if (!format.contains("format")) {
                                            (this).VideoWeb.this.comboFormats.addItem(format);
                                        }
                                        ++n2;
                                    }
                                } else {
                                    if (!(this).VideoWeb.this.caseAuto.isSelected()) {
                                        (this).VideoWeb.this.caseAuto.doClick();
                                    }
                                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("invalidUrl"), Shutter.language.getProperty("downloadError"), 0);
                                }
                            }
                            frame.setCursor(Cursor.getPredefinedCursor(0));
                            (this).VideoWeb.this.btnOK.setEnabled(true);
                        }
                    });
                    getFormats.start();
                }
            }
        });
        caseMetadata = new JCheckBox(Shutter.language.getProperty("casePreserveMetadata"));
        caseMetadata.setName("caseMetadata");
        if (Settings.videoWebCaseMetadata) {
            caseMetadata.setSelected(true);
        } else {
            caseMetadata.setSelected(false);
        }
        caseMetadata.setFont(new Font(Shutter.mainFont, 0, 12));
        caseMetadata.setBounds(66, this.caseAuto.getY() + 22, VideoWeb.caseMetadata.getPreferredSize().width, 16);
        this.grpURL.add(caseMetadata);
        caseTimecode = new JCheckBox(Shutter.language.getProperty("caseSetTimecode"));
        caseTimecode.setName("caseTimecode");
        caseTimecode.setFont(new Font(Shutter.mainFont, 0, 12));
        caseTimecode.setBounds(66, caseMetadata.getY() + 22, VideoWeb.caseTimecode.getPreferredSize().width, 16);
        this.grpURL.add(caseTimecode);
        caseTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caseTimecode.isSelected()) {
                    textTimecodeIn.setEnabled(true);
                    textTimecodeOut.setEnabled(true);
                } else {
                    textTimecodeIn.setEnabled(false);
                    textTimecodeOut.setEnabled(false);
                }
            }
        });
        textTimecodeIn = new JTextField("00:00:00");
        textTimecodeIn.setHorizontalAlignment(0);
        textTimecodeIn.setFont(new Font("SansSerif", 0, 12));
        textTimecodeIn.setBounds(VideoWeb.caseTimecode.getLocation().x + caseTimecode.getWidth() + 4, caseTimecode.getY() - 4, 70, 21);
        textTimecodeIn.setEnabled(false);
        this.grpURL.add(textTimecodeIn);
        textTimecodeIn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != ':' && caracter != '\uffff') {
                    e.consume();
                } else if (textTimecodeIn.getText().length() >= 8) {
                    textTimecodeIn.setText("");
                } else if ((textTimecodeIn.getText().length() == 2 || textTimecodeIn.getText().length() == 5) && caracter != ':') {
                    textTimecodeIn.setText(textTimecodeIn.getText() + ":");
                }
            }
        });
        textTimecodeOut = new JTextField("00:00:00");
        textTimecodeOut.setHorizontalAlignment(0);
        textTimecodeOut.setFont(new Font("SansSerif", 0, 12));
        textTimecodeOut.setBounds(VideoWeb.textTimecodeIn.getLocation().x + textTimecodeIn.getWidth() + 4, textTimecodeIn.getY(), textTimecodeIn.getWidth(), 21);
        textTimecodeOut.setEnabled(false);
        this.grpURL.add(textTimecodeOut);
        textTimecodeOut.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != ':' && caracter != '\uffff') {
                    e.consume();
                } else if (textTimecodeOut.getText().length() >= 8) {
                    textTimecodeOut.setText("");
                } else if ((textTimecodeOut.getText().length() == 2 || textTimecodeOut.getText().length() == 5) && caracter != ':') {
                    textTimecodeOut.setText(textTimecodeOut.getText() + ":");
                }
            }
        });
        caseCookies = new JCheckBox(Shutter.language.getProperty("caseCookies"));
        caseCookies.setName("caseCookies");
        caseCookies.setFont(new Font(Shutter.mainFont, 0, 12));
        caseCookies.setBounds(66, caseTimecode.getY() + 22, VideoWeb.caseCookies.getPreferredSize().width, 16);
        this.grpURL.add(caseCookies);
        caseCookies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseCookies.isSelected()) {
                    VideoWeb.this.comboCookies.setEnabled(true);
                } else {
                    VideoWeb.this.comboCookies.setEnabled(false);
                }
            }
        });
        this.comboCookies = new JComboBox();
        this.comboCookies.setEnabled(false);
        this.comboCookies.addItem("chrome");
        this.comboCookies.addItem("firefox");
        this.comboCookies.addItem("safari");
        this.comboCookies.addItem("brave");
        this.comboCookies.addItem("chromium");
        this.comboCookies.addItem("edge");
        this.comboCookies.addItem("opera");
        this.comboCookies.addItem("vivaldi");
        this.comboCookies.addItem("whale");
        this.comboCookies.setLocation(caseCookies.getX() + caseCookies.getWidth() + 4, caseCookies.getY() - 4);
        this.comboCookies.setSize(this.grpURL.getWidth() - this.comboCookies.getX() - 14, 22);
        this.comboCookies.setMaximumRowCount(10);
        this.grpURL.add(this.comboCookies);
        this.comboFormats = new JComboBox();
        this.comboFormats.addItem("default");
        this.comboFormats.addItem("bestvideo+bestaudio");
        this.comboFormats.addItem("up to 4K");
        this.comboFormats.addItem("up to 1440p");
        this.comboFormats.addItem("up to 1080p");
        this.comboFormats.addItem("up to 720p");
        this.comboFormats.addItem("up to 480p");
        this.comboFormats.addItem("up to 360p");
        this.comboFormats.addItem("up to 240p");
        this.comboFormats.addItem("bestvideo");
        this.comboFormats.addItem("bestaudio");
        this.comboFormats.setLocation(16, 268);
        this.comboFormats.setSize(380, 22);
        this.comboFormats.setMaximumRowCount(10);
        this.grpURL.add(this.comboFormats);
        this.comboFormats.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (VideoWeb.this.comboFormats.getPreferredSize().getWidth() > 380.0) {
                    VideoWeb.this.comboFormats.setSize(VideoWeb.this.comboFormats.getPreferredSize());
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                VideoWeb.this.comboFormats.setSize(380, 22);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.lblQualit = new JLabel(Shutter.language.getProperty("lblQualit"));
        this.lblQualit.setHorizontalAlignment(4);
        this.lblQualit.setFont(new Font(Shutter.mainFont, 0, 12));
        this.lblQualit.setSize(this.lblQualit.getPreferredSize().width, 16);
        this.lblQualit.setLocation(this.textURL.getX() - this.lblQualit.getWidth() - 5, 110);
        this.grpURL.add(this.lblQualit);
        this.btnOK = new JButton(Shutter.language.getProperty("btnStartFunction"));
        this.btnOK.setFont(new Font(Shutter.boldFont, 0, 12));
        this.btnOK.setBounds(this.comboFormats.getX(), this.comboFormats.getY() + this.comboFormats.getHeight() + 4, this.comboFormats.getWidth(), 21);
        this.btnOK.setEnabled(false);
        this.grpURL.add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoWeb.this.startDownload();
            }
        });
        this.caseMP3 = new JCheckBox(Shutter.language.getProperty("caseMP3"));
        this.caseMP3.setFont(new Font(Shutter.mainFont, 0, 12));
        this.caseMP3.setBounds(121, this.caseAuto.getY(), this.caseMP3.getPreferredSize().width + 4, 16);
        this.grpURL.add(this.caseMP3);
        this.caseMP3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoWeb.this.caseMP3.isSelected()) {
                    VideoWeb.this.caseWAV.setSelected(false);
                    if (VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.comboFormats.setSelectedItem("bestaudio");
                    }
                } else if (VideoWeb.this.caseAuto.isSelected()) {
                    VideoWeb.this.comboFormats.setSelectedIndex(0);
                }
            }
        });
        this.caseWAV = new JCheckBox(Shutter.language.getProperty("caseWAV"));
        this.caseWAV.setFont(new Font(Shutter.mainFont, 0, 12));
        this.caseWAV.setBounds(this.caseMP3.getX() + this.caseMP3.getWidth(), this.caseAuto.getY(), this.caseWAV.getPreferredSize().width + 4, 16);
        this.grpURL.add(this.caseWAV);
        this.caseWAV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (VideoWeb.this.caseWAV.isSelected()) {
                    VideoWeb.this.caseMP3.setSelected(false);
                    if (VideoWeb.this.caseAuto.isSelected()) {
                        VideoWeb.this.comboFormats.setSelectedItem("bestaudio");
                    }
                } else if (VideoWeb.this.caseAuto.isSelected()) {
                    VideoWeb.this.comboFormats.setSelectedIndex(0);
                }
            }
        });
        frame.getContentPane().add(this.grpURL);
        this.caseVideoPass = new JCheckBox(Shutter.language.getProperty("caseVideoPass"));
        this.caseVideoPass.setFont(new Font(Shutter.mainFont, 0, 12));
        this.caseVideoPass.setSize(this.caseVideoPass.getPreferredSize().width, 16);
        this.caseVideoPass.setLocation(66, 243);
        this.grpURL.add(this.caseVideoPass);
        this.caseVideoPass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (VideoWeb.this.caseVideoPass.isSelected()) {
                    VideoWeb.this.textVideoPass.setEnabled(true);
                } else {
                    VideoWeb.this.textVideoPass.setText("");
                    VideoWeb.this.textVideoPass.setEnabled(false);
                }
            }
        });
        this.textVideoPass = new JTextField();
        this.textVideoPass.setFont(new Font("SansSerif", 0, 12));
        this.textVideoPass.setBounds(this.caseVideoPass.getLocation().x + this.caseVideoPass.getWidth() + 4, this.caseVideoPass.getY() - 3, this.grpURL.getSize().width - (this.caseVideoPass.getLocation().x + this.caseVideoPass.getSize().width) - 17, 21);
        this.textVideoPass.setEnabled(false);
        this.textVideoPass.setColumns(10);
        this.grpURL.add(this.textVideoPass);
        this.caseUser = new JCheckBox(Shutter.language.getProperty("caseUser"));
        this.caseUser.setFont(new Font(Shutter.mainFont, 0, 12));
        this.caseUser.setBounds(this.caseVideoPass.getX(), caseCookies.getY() + 22, this.caseUser.getPreferredSize().width, 16);
        this.grpURL.add(this.caseUser);
        this.caseUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (VideoWeb.this.caseUser.isSelected()) {
                    VideoWeb.this.textUser.setEnabled(true);
                } else {
                    VideoWeb.this.textUser.setText("");
                    VideoWeb.this.textUser.setEnabled(false);
                }
            }
        });
        this.textUser = new JTextField();
        this.textUser.setEnabled(false);
        this.textUser.setText(null);
        this.textUser.setFont(new Font("SansSerif", 0, 12));
        this.textUser.setColumns(10);
        this.textUser.setBounds(this.caseVideoPass.getLocation().x + this.caseVideoPass.getWidth() + 4, this.caseUser.getY() - 3, this.grpURL.getSize().width - (this.caseVideoPass.getLocation().x + this.caseVideoPass.getSize().width) - 17, 21);
        this.grpURL.add(this.textUser);
        this.casePass = new JCheckBox(Shutter.language.getProperty("casePass"));
        this.casePass.setFont(new Font(Shutter.mainFont, 0, 12));
        this.casePass.setBounds(this.caseVideoPass.getX(), this.caseUser.getY() + 22, this.casePass.getPreferredSize().width, 16);
        this.grpURL.add(this.casePass);
        this.casePass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (VideoWeb.this.casePass.isSelected()) {
                    VideoWeb.this.textPass.setEnabled(true);
                } else {
                    VideoWeb.this.textPass.setText("");
                    VideoWeb.this.textPass.setEnabled(false);
                }
            }
        });
        this.textPass = new JPasswordField();
        this.textPass.setEnabled(false);
        this.textPass.setText(null);
        this.textPass.setFont(new Font("SansSerif", 0, 12));
        this.textPass.setColumns(10);
        this.textPass.setEchoChar('\u2022');
        this.textPass.setBounds(this.caseVideoPass.getLocation().x + this.caseVideoPass.getWidth() + 4, this.casePass.getY() - 3, this.grpURL.getSize().width - (this.caseVideoPass.getLocation().x + this.caseVideoPass.getSize().width) - 17, 21);
        this.grpURL.add(this.textPass);
    }

    private String options() {
        Object options = "";
        if (caseMetadata.isSelected()) {
            options = (String)options + " --embed-thumbnail --embed-metadata";
        }
        if (caseTimecode.isSelected()) {
            options = (String)options + " --download-sections \"*" + textTimecodeIn.getText() + "-" + textTimecodeOut.getText() + "\"";
        }
        if (caseCookies.isSelected()) {
            options = (String)options + " --cookies-from-browser " + this.comboCookies.getSelectedItem().toString();
        }
        if (this.caseUser.isSelected()) {
            options = (String)options + " --username \"" + this.textUser.getText() + "\"";
        }
        if (this.casePass.isSelected()) {
            options = (String)options + " --password \"" + new String(this.textPass.getPassword()) + "\"";
        }
        if (this.caseVideoPass.isSelected()) {
            options = (String)options + " --video-password \"" + this.textVideoPass.getText() + "\"";
        }
        return options;
    }

    private void startDownload() {
        Thread downloadProcess = new Thread(new Runnable(){

            @Override
            public void run() {
                block45: {
                    complete = 0;
                    Shutter.lblFilesEnded.setText(FunctionUtils.completedFiles(complete));
                    try {
                        if (VideoWeb.this.textURL.getText().toLowerCase().equals("update")) {
                            FFMPEG.disableAll();
                            Shutter.btnStart.setEnabled(false);
                            Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("update"));
                            YOUTUBEDL.update();
                            Shutter.progressBar1.setIndeterminate(true);
                            do {
                                Thread.sleep(100L);
                            } while (YOUTUBEDL.isRunning);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Shutter.progressBar1.setIndeterminate(false);
                                }
                            });
                            FFMPEG.enableAll();
                            FFMPEG.enfOfFunction();
                            break block45;
                        }
                        String[] stringArray = VideoWeb.this.textURL.getText().split("\n");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line;
                            block48: {
                                block46: {
                                    block49: {
                                        block47: {
                                            line = stringArray[n2];
                                            if (!VideoWeb.this.caseAuto.isSelected()) break block46;
                                            if (!VideoWeb.this.comboFormats.getSelectedItem().toString().equals("default")) break block47;
                                            YOUTUBEDL.format = "";
                                            break block48;
                                        }
                                        if (!VideoWeb.this.comboFormats.getSelectedItem().toString().contains("up to ")) break block49;
                                        switch (VideoWeb.this.comboFormats.getSelectedItem().toString().replace("up to ", "")) {
                                            case "4K": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?4096][height<=?2160]+bestaudio/best[width<=?4096][height<=?2160]\"";
                                                break;
                                            }
                                            case "1440p": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?2560][height<=?1440]+bestaudio/best[width<=?2560][height<=?1440]\"";
                                                break;
                                            }
                                            case "1080p": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?1920][height<=?1080]+bestaudio/best[width<=?1920][height<=?1080]\"";
                                                break;
                                            }
                                            case "720p": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?1280][height<=?720]+bestaudio/best[width<=?1280][height<=?720]\"";
                                                break;
                                            }
                                            case "480p": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?854][height<=?480]+bestaudio/best[width<=?854][height<=?480]\"";
                                                break;
                                            }
                                            case "360p": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?640][height<=?360]+bestaudio/best[width<=?640][height<=?360]\"";
                                                break;
                                            }
                                            case "240p": {
                                                YOUTUBEDL.format = "-f \"bestvideo[width<=?426][height<=?240]+bestaudio/best[width<=?426][height<=?240]\"";
                                            }
                                        }
                                        break block48;
                                    }
                                    YOUTUBEDL.format = "-f " + VideoWeb.this.comboFormats.getSelectedItem().toString();
                                    break block48;
                                }
                                String[] f = VideoWeb.this.comboFormats.getSelectedItem().toString().split(" ");
                                YOUTUBEDL.format = "-f " + f[0];
                            }
                            FFMPEG.disableAll();
                            Shutter.btnStart.setEnabled(false);
                            YOUTUBEDL.run("\"" + line + "\"", VideoWeb.this.options());
                            do {
                                Thread.sleep(100L);
                            } while (YOUTUBEDL.runProcess.isAlive() && !FFMPEG.cancelled);
                            if (Shutter.cancelled) {
                                if (YOUTUBEDL.outputFile.exists()) {
                                    YOUTUBEDL.outputFile.delete();
                                }
                            } else {
                                Shutter.tempsRestant.setVisible(false);
                                String ext = YOUTUBEDL.outputFile.toString().substring(YOUTUBEDL.outputFile.toString().lastIndexOf("."));
                                if (VideoWeb.this.caseWAV.isSelected()) {
                                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("convertToWAV"));
                                    cmd = " -vn -y ";
                                    FFMPEG.run(" -i \"" + YOUTUBEDL.outputFile.toString() + "\"" + cmd + "\"" + YOUTUBEDL.outputFile.toString().replace(ext, ".wav") + "\"");
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.isRunning && !FFMPEG.cancelled);
                                    if (Shutter.cancelled) {
                                        audioFile = new File(YOUTUBEDL.outputFile.toString().replace(ext, ".wav"));
                                        audioFile.delete();
                                    }
                                } else if (VideoWeb.this.caseMP3.isSelected()) {
                                    Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("convertToMP3"));
                                    cmd = " -vn -c:a mp3 -b:a 256k -y ";
                                    FFMPEG.run(" -i \"" + YOUTUBEDL.outputFile.toString() + "\"" + cmd + "\"" + YOUTUBEDL.outputFile.toString().replace(ext, ".mp3") + "\"");
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.isRunning && !FFMPEG.cancelled);
                                    if (Shutter.cancelled) {
                                        audioFile = new File(YOUTUBEDL.outputFile.toString().replace(ext, ".mp3"));
                                        audioFile.delete();
                                    }
                                }
                            }
                            if (!Shutter.cancelled) {
                                Shutter.lblFilesEnded.setText(FunctionUtils.completedFiles(++complete));
                                if (Shutter.caseOpenFolderAtEnd1.isSelected()) {
                                    try {
                                        Desktop.getDesktop().open(new File(Shutter.lblDestination1.getText()));
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            FFMPEG.enableAll();
                            FFMPEG.enfOfFunction();
                            FunctionUtils.addFileForMail(YOUTUBEDL.outputFile.toString());
                            ++n2;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        downloadProcess.start();
        Utils.changeDialogVisibility(frame, true);
    }

    private void PasteFromClipBoard(boolean mouse) {
        Clipboard sysClip;
        Transferable clipTf;
        if (this.textURL.getText().equals(Shutter.language.getProperty("textURL"))) {
            this.textURL.setText("");
        }
        this.textURL.setFont(new Font("SansSerif", 0, 12));
        this.textURL.setForeground(Color.WHITE);
        this.btnOK.setEnabled(true);
        if (!this.caseAuto.isSelected()) {
            this.caseAuto.doClick();
        }
        if (this.textURL.getLineCount() == 1) {
            this.caseAuto.setEnabled(true);
        } else {
            this.caseAuto.setEnabled(false);
        }
        if (mouse && (clipTf = (sysClip = Toolkit.getDefaultToolkit().getSystemClipboard()).getContents(null)) != null && clipTf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                this.textURL.setText(this.textURL.getText() + (String)clipTf.getTransferData(DataFlavor.stringFlavor));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

