/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AntiAliasedRoundRectangle;
import application.Console;
import application.ListFileTransferHandler;
import application.RecordInputDevice;
import application.RenderQueue;
import application.Settings;
import application.Shutter;
import application.SubtitlesTimeline;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import functions.VideoEncoders;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import library.DCRAW;
import library.FFMPEG;
import library.FFPROBE;
import library.MEDIAINFO;
import library.NCNN;
import library.PDF;
import settings.AdvancedFeatures;
import settings.AudioSettings;
import settings.Colorimetry;
import settings.Corrections;
import settings.FunctionUtils;
import settings.ImageSequence;
import settings.InputAndOutput;
import settings.Timecode;
import settings.Transitions;

public class VideoPlayer {
    public static JPanel player;
    public static Process playerVideo;
    public static Process bufferVideo;
    public static Process playerAudio;
    private static BufferedInputStream videoInputStream;
    private static InputStream audio;
    private static AudioInputStream audioInputStream;
    private static SourceDataLine line;
    private static FloatControl gainControl;
    private static double offsetVideo;
    private static double offsetAudio;
    private static Thread playerThread;
    public static Thread loadMedia;
    public static Thread setTime;
    public static double playerCurrentFrame;
    public static double bufferCurrentFrame;
    private static long fpsTime;
    private static int fps;
    private static int displayCurrentFPS;
    private static JLabel showFPS;
    public static JLabel showScale;
    public static JComboBox<String> comboAudioTrack;
    public static int playerInMark;
    public static int playerOutMark;
    public static ArrayList<Image> bufferedFrames;
    public static int maxBufferedFrames;
    public static BufferedImage frameVideo;
    private static BufferedImage fullSizeWatermark;
    public static double screenRefreshRate;
    private static long lastEvTime;
    public static boolean playerLoop;
    public static boolean frameIsComplete;
    public static boolean playerPlayVideo;
    public static boolean audioSetTimeIsRunning;
    public static boolean sliderChange;
    public static JLabel lblVolume;
    public static JSlider sliderVolume;
    public static JLabel lblPosition;
    public static JLabel lblDuration;
    private static JLabel lblMode;
    public static JComboBox<Object> comboMode;
    public static JLabel lblSpeed;
    public static JSlider sliderSpeed;
    private static boolean showInfoMessage;
    public static boolean playTransition;
    private static boolean closeAudioStream;
    public static boolean isPiping;
    private static boolean previewUpscale;
    public static boolean fullscreenPlayer;
    private static Thread mouseClickThread;
    private static String freezeFrame;
    public static double fileDuration;
    private static int waveformZoom;
    public static JLabel btnPreview;
    public static JTextField splitValue;
    private static JLabel lblSplitSec;
    public static JButton btnPrevious;
    public static boolean previousFrame;
    public static JButton btnNext;
    public static JButton btnStop;
    public static JButton btnPlay;
    public static JButton btnMarkIn;
    public static JButton btnMarkOut;
    public static JButton btnGoToIn;
    public static JButton btnGoToOut;
    private static JPanel panelForButtons;
    public static JSlider slider;
    public static JCheckBox caseApplyCutToAll;
    public static JCheckBox caseShowWaveform;
    public static JCheckBox caseVuMeter;
    public static JCheckBox casePlaySound;
    public static JCheckBox caseInternalTc;
    public static String videoPath;
    public static double inputFramerateMS;
    public static double totalFrames;
    public static JTextField caseInH;
    public static JTextField caseInM;
    public static JTextField caseInS;
    public static JTextField caseInF;
    public static JTextField caseOutH;
    public static JTextField caseOutM;
    public static JTextField caseOutS;
    public static JTextField caseOutF;
    public static double offset;
    public static int durationH;
    public static int durationM;
    public static int durationS;
    public static int durationF;
    public static boolean frameControl;
    public static boolean seekOnKeyFrames;
    private static Thread addWaveform;
    public static boolean addWaveformIsRunning;
    public static BufferedImage waveform;
    public static JLabel waveformIcon;
    public static JLabel waveformContainer;
    private static JScrollPane waveformScrollPane;
    public static JPanel cursorHead;
    public static JPanel cursorWaveform;
    public static JPanel cursorCurrentFrame;
    public static boolean mouseIsPressed;
    public static BufferedImage preview;
    public static Thread runProcess;
    public static StringBuilder fileList;
    public static int MousePositionX;
    public static int MousePositionY;

    static {
        audio = null;
        audioInputStream = null;
        offsetVideo = 0.0;
        offsetAudio = 0.0;
        playerCurrentFrame = 0.0;
        bufferCurrentFrame = 0.0;
        fpsTime = 0L;
        fps = 0;
        displayCurrentFPS = 0;
        playerInMark = 0;
        playerOutMark = 0;
        bufferedFrames = new ArrayList();
        maxBufferedFrames = 500;
        screenRefreshRate = 16.7;
        lastEvTime = 0L;
        playerLoop = false;
        frameIsComplete = false;
        playerPlayVideo = true;
        audioSetTimeIsRunning = false;
        sliderChange = false;
        sliderVolume = new JSlider();
        comboMode = new JComboBox<String>(new String[]{Shutter.language.getProperty("cutUpper"), Shutter.language.getProperty("removeMode"), Shutter.language.getProperty("splitMode")});
        showInfoMessage = true;
        playTransition = false;
        closeAudioStream = false;
        isPiping = false;
        previewUpscale = false;
        fullscreenPlayer = false;
        freezeFrame = "";
        fileDuration = 0.0;
        waveformZoom = 1;
        previousFrame = false;
        caseApplyCutToAll = new JCheckBox(Shutter.language.getProperty("caseApplyToAll"));
        caseShowWaveform = new JCheckBox(Shutter.language.getProperty("caseShowWaveform"));
        caseVuMeter = new JCheckBox(Shutter.language.getProperty("caseVuMeter"));
        casePlaySound = new JCheckBox(Shutter.language.getProperty("casePlaySound"));
        videoPath = null;
        inputFramerateMS = 40.0;
        offset = 0.0;
        durationH = 0;
        durationM = 0;
        durationS = 0;
        durationF = 0;
        frameControl = false;
        seekOnKeyFrames = false;
        addWaveform = new Thread();
        addWaveformIsRunning = false;
        waveform = null;
        mouseIsPressed = false;
        preview = null;
        runProcess = new Thread();
        fileList = new StringBuilder();
    }

    public VideoPlayer() {
        showInfoMessage = true;
        GraphicsConfiguration config = Shutter.frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        DisplayMode dm = allScreens[screenIndex].getDisplayMode();
        int refreshRate = dm.getRefreshRate();
        screenRefreshRate = refreshRate == 0 ? 16.666666 : 1000.0 / (double)refreshRate;
        this.player();
        this.buttons();
        this.sliders();
        this.grpIn();
        this.grpOut();
        this.playerOptions();
        lblPosition = new JLabel();
        lblPosition.setHorizontalAlignment(2);
        lblPosition.setFont(new Font(Shutter.mainFont, 0, 13));
        lblPosition.setForeground(new Color(230, 75, 60));
        Shutter.frame.getContentPane().add(lblPosition);
        caseApplyCutToAll.setName("caseApplyCutToAll");
        caseApplyCutToAll.setFont(new Font(Shutter.mainFont, 0, 12));
        caseApplyCutToAll.setSelected(false);
        caseApplyCutToAll.setSize(VideoPlayer.caseApplyCutToAll.getPreferredSize().width, 23);
        Shutter.frame.getContentPane().add(caseApplyCutToAll);
        caseApplyCutToAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseApplyCutToAll.isSelected()) {
                    double timeIn = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    InputAndOutput.savedInPoint = Math.ceil(timeIn);
                    if (playerOutMark < waveformContainer.getWidth() - 2) {
                        double total;
                        double totalOut = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                        InputAndOutput.savedOutPoint = total = totalFrames - totalOut;
                    }
                    if (caseInH.isVisible()) {
                        caseInH.setEnabled(false);
                        caseInM.setEnabled(false);
                        caseInS.setEnabled(false);
                        caseInF.setEnabled(false);
                    }
                    if (caseOutH.isVisible()) {
                        caseOutH.setEnabled(false);
                        caseOutM.setEnabled(false);
                        caseOutS.setEnabled(false);
                        caseOutF.setEnabled(false);
                    }
                } else {
                    InputAndOutput.savedInPoint = 0.0;
                    InputAndOutput.savedOutPoint = 0.0;
                    if (caseInH.isVisible()) {
                        caseInH.setEnabled(true);
                        caseInM.setEnabled(true);
                        caseInS.setEnabled(true);
                        caseInF.setEnabled(true);
                    }
                    if (caseOutH.isVisible()) {
                        caseOutH.setEnabled(true);
                        caseOutM.setEnabled(true);
                        caseOutS.setEnabled(true);
                        caseOutF.setEnabled(true);
                    }
                }
                waveformContainer.repaint();
            }
        });
        lblDuration = new JLabel();
        lblDuration.setHorizontalAlignment(4);
        lblDuration.setFont(new Font(Shutter.mainFont, 0, 13));
        lblDuration.setForeground(Utils.themeColor);
        Shutter.frame.getContentPane().add(lblDuration);
        VideoPlayer.setMedia();
        VideoPlayer.totalDuration();
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent e = (KeyEvent)event;
                if (Shutter.caseAddWatermark.isSelected()) {
                    if (e.getID() == 401) {
                        boolean update = false;
                        if (e.getKeyCode() == 38) {
                            Shutter.logo.setLocation(Shutter.logo.getLocation().x, Shutter.logo.getLocation().y - 1);
                            update = true;
                        }
                        if (e.getKeyCode() == 40) {
                            Shutter.logo.setLocation(Shutter.logo.getLocation().x, Shutter.logo.getLocation().y + 1);
                            update = true;
                        }
                        if (e.getKeyCode() == 37) {
                            Shutter.logo.setLocation(Shutter.logo.getLocation().x - 1, Shutter.logo.getLocation().y);
                            update = true;
                        }
                        if (e.getKeyCode() == 39) {
                            Shutter.logo.setLocation(Shutter.logo.getLocation().x + 1, Shutter.logo.getLocation().y);
                            update = true;
                        }
                        if (update) {
                            Shutter.textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)Shutter.logo.getLocation().x * Shutter.playerRatio))));
                            Shutter.textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)Shutter.logo.getLocation().y * Shutter.playerRatio))));
                            Shutter.logoLocX = Shutter.logo.getLocation().x;
                            Shutter.logoLocY = Shutter.logo.getLocation().y;
                            Shutter.watermarkPreset = null;
                        }
                    }
                } else {
                    int mouseInPictureX = MouseInfo.getPointerInfo().getLocation().x - Shutter.frame.getLocation().x - Shutter.frameCropX;
                    int mouseInPictureY = MouseInfo.getPointerInfo().getLocation().y - Shutter.frame.getLocation().y - Shutter.frameCropY;
                    if (mouseInPictureX > 0 && mouseInPictureX < player.getWidth() && mouseInPictureY > 0 && mouseInPictureY < player.getHeight() && e.getID() == 401) {
                        if (e.getKeyCode() == 16) {
                            Shutter.shift = true;
                        }
                        if (e.getKeyCode() == 18 || e.getKeyCode() == 65406) {
                            Shutter.alt = true;
                        }
                        if (e.getKeyCode() == 17) {
                            Shutter.ctrl = true;
                        }
                        if (e.getKeyCode() == 38) {
                            Shutter.selection.setLocation(Shutter.selection.getLocation().x, Shutter.selection.getLocation().y - 1);
                        }
                        if (e.getKeyCode() == 40) {
                            Shutter.selection.setLocation(Shutter.selection.getLocation().x, Shutter.selection.getLocation().y + 1);
                        }
                        if (e.getKeyCode() == 37) {
                            Shutter.selection.setLocation(Shutter.selection.getLocation().x - 1, Shutter.selection.getLocation().y);
                        }
                        if (e.getKeyCode() == 39) {
                            Shutter.selection.setLocation(Shutter.selection.getLocation().x + 1, Shutter.selection.getLocation().y);
                        }
                        if (e.getKeyCode() == 27) {
                            Shutter.selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
                            Shutter.anchorRight = Shutter.selection.getLocation().x + Shutter.selection.getWidth();
                            Shutter.anchorBottom = Shutter.selection.getLocation().y + Shutter.selection.getHeight();
                        }
                        VideoPlayer.checkSelection();
                    }
                    if (e.getID() == 402) {
                        if (e.getKeyCode() == 16) {
                            Shutter.shift = false;
                        }
                        if (e.getKeyCode() == 18 || e.getKeyCode() == 65406) {
                            Shutter.alt = false;
                        }
                        if (e.getKeyCode() == 17) {
                            Shutter.ctrl = false;
                        }
                    }
                }
            }
        }, 8L);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 109 || e.getKeyCode() == 107) {
                    boolean resfreshSliderSpeed = false;
                    if (e.getKeyCode() == 107 && sliderSpeed.getValue() < 4) {
                        sliderSpeed.setValue(sliderSpeed.getValue() + 1);
                        resfreshSliderSpeed = true;
                    }
                    if (e.getKeyCode() == 109 && sliderSpeed.getValue() > 0) {
                        sliderSpeed.setValue(sliderSpeed.getValue() - 1);
                        resfreshSliderSpeed = true;
                    }
                    if (resfreshSliderSpeed) {
                        if (sliderSpeed.getValue() == 0) {
                            lblSpeed.setText("x0.25");
                        } else if (sliderSpeed.getValue() == 1) {
                            lblSpeed.setText("x0.5");
                        } else if (sliderSpeed.getValue() == 2) {
                            lblSpeed.setText("x1");
                        } else if (sliderSpeed.getValue() == 3) {
                            lblSpeed.setText("x1.5");
                        } else if (sliderSpeed.getValue() == 4) {
                            lblSpeed.setText("x2");
                        }
                        lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                        if (slider.getValue() > 0) {
                            frameIsComplete = false;
                            VideoPlayer.playerSetTime(playerCurrentFrame);
                        }
                    }
                }
                if (e.getKeyCode() == 75 || e.getKeyCode() == 32) {
                    e.consume();
                    btnPlay.doClick();
                }
                if (Shutter.shift) {
                    if (e.getKeyCode() == 96) {
                        e.consume();
                        VideoPlayer.playerSetTime(0.0);
                    } else if (e.getKeyCode() == 97) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 1.0);
                    } else if (e.getKeyCode() == 98) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 2.0);
                    } else if (e.getKeyCode() == 99) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 3.0);
                    } else if (e.getKeyCode() == 100) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 4.0);
                    } else if (e.getKeyCode() == 101) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 5.0);
                    } else if (e.getKeyCode() == 102) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 6.0);
                    } else if (e.getKeyCode() == 103) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 7.0);
                    } else if (e.getKeyCode() == 104) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 8.0);
                    } else if (e.getKeyCode() == 105) {
                        e.consume();
                        VideoPlayer.playerSetTime(totalFrames / 10.0 * 9.0);
                    }
                }
                if (e.getKeyCode() == 74) {
                    previousFrame = true;
                    VideoPlayer.playerSetTime(playerCurrentFrame - 10.0);
                }
                if (e.getKeyCode() == 76) {
                    previousFrame = true;
                    VideoPlayer.playerSetTime(playerCurrentFrame + 10.0);
                }
                if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    if (e.getID() == 401 && e.getKeyCode() == 16) {
                        Shutter.shift = true;
                    }
                    if (e.getKeyCode() == 73) {
                        if (Shutter.shift) {
                            btnGoToIn.doClick();
                        } else {
                            btnMarkIn.doClick();
                        }
                    }
                    if (e.getKeyCode() == 79) {
                        if (Shutter.shift) {
                            btnGoToOut.doClick();
                        } else if (cursorWaveform.getX() > playerInMark) {
                            btnMarkOut.doClick();
                        }
                    }
                }
                if (playerVideo != null) {
                    if (e.getKeyCode() == 37) {
                        waveformContainer.requestFocus();
                        btnPrevious.doClick();
                        waveformScrollPane.getHorizontalScrollBar().setValue(waveformScrollPane.getHorizontalScrollBar().getValue() + 10);
                    }
                    if (e.getKeyCode() == 39) {
                        waveformContainer.requestFocus();
                        btnNext.doClick();
                        waveformScrollPane.getHorizontalScrollBar().setValue(waveformScrollPane.getHorizontalScrollBar().getValue() - 10);
                    }
                    if (e.getKeyCode() == 38) {
                        btnGoToOut.doClick();
                    }
                    if (e.getKeyCode() == 40) {
                        btnGoToIn.doClick();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getID() == 402 && e.getKeyCode() == 16) {
                    Shutter.shift = false;
                }
            }
        };
        Component[] componentArray = Shutter.frame.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.addKeyListener(keyListener);
            ++n2;
        }
        waveformContainer.addKeyListener(keyListener);
        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void playerProcess(final double inputTime) {
        try {
            if (System.getProperty("os.name").contains("Windows")) {
                pbv = new ProcessBuilder("cmd.exe", "/c", "\"" + FFMPEG.PathToFFMPEG + "\"" + VideoPlayer.setVideoCommand(inputTime, player.getWidth(), player.getHeight(), playerPlayVideo));
                playerVideo = pbv.start();
            } else {
                pbv = new ProcessBuilder("/bin/bash", "-c", FFMPEG.PathToFFMPEG + VideoPlayer.setVideoCommand(inputTime, player.getWidth(), player.getHeight(), playerPlayVideo));
                playerVideo = pbv.start();
            }
            final InputStream video = playerVideo.getInputStream();
            videoInputStream = new BufferedInputStream(video);
            if (casePlaySound.isSelected() && (!mouseIsPressed || FFPROBE.audioOnly) || !mouseIsPressed) {
                if (System.getProperty("os.name").contains("Windows")) {
                    pba = new ProcessBuilder("cmd.exe", "/c", "\"" + FFMPEG.PathToFFMPEG + "\"" + VideoPlayer.setAudioCommand(inputTime, false));
                    playerAudio = pba.start();
                } else {
                    pba = new ProcessBuilder("/bin/bash", "-c", FFMPEG.PathToFFMPEG + VideoPlayer.setAudioCommand(inputTime, false));
                    playerAudio = pba.start();
                }
                try {
                    audio = playerAudio.getInputStream();
                    audioInputStream = null;
                    audioInputStream = AudioSystem.getAudioInputStream(audio);
                    AudioFormat audioFormat = audioInputStream.getFormat();
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                    line = (SourceDataLine)AudioSystem.getLine(info);
                    line.open(audioFormat);
                    gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                    float gain = (float)sliderVolume.getValue() / 100.0f;
                    float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0) + (float)sliderVolume.getValue() / 16.666666f;
                    gainControl.setValue(dB);
                    line.start();
                }
                catch (Exception audioFormat) {
                    // empty catch block
                }
            }
            playerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        long startTime = System.nanoTime() + (long)((int)(inputFramerateMS * 1000000.0));
                        if (playerLoop) {
                            long time3;
                            long delay;
                            block33: {
                                Throwable throwable2;
                                block35: {
                                    long time2;
                                    block34: {
                                        try {
                                            try {
                                                if (playerCurrentFrame >= offsetVideo || !Shutter.caseAudioOffset.isSelected()) {
                                                    frameVideo = Shutter.inputDeviceIsRunning ? VideoPlayer.readFrame(videoInputStream, FFPROBE.imageWidth, FFPROBE.imageHeight, false) : (Shutter.windowDrag && !fullscreenPlayer ? VideoPlayer.readFrame(videoInputStream, frameVideo.getWidth(), frameVideo.getHeight(), false) : VideoPlayer.readFrame(videoInputStream, player.getWidth(), player.getHeight(), false));
                                                    VideoPlayer.playerRepaint();
                                                    ++fps;
                                                }
                                                VideoPlayer.updateCurrentFrame();
                                                break block33;
                                            }
                                            catch (Exception exception) {
                                                if (frameControl && !Shutter.inputDeviceIsRunning) {
                                                    playerLoop = false;
                                                    VideoPlayer.getTimePoint(playerCurrentFrame);
                                                    break block34;
                                                }
                                                if (!playerPlayVideo || (delay = startTime - System.nanoTime()) <= 0L) break block34;
                                                try {
                                                    Thread.sleep((int)(delay / 1500000L));
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                                delay = startTime - System.nanoTime();
                                                time3 = System.nanoTime();
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            if (frameControl && !Shutter.inputDeviceIsRunning) {
                                                playerLoop = false;
                                                VideoPlayer.getTimePoint(playerCurrentFrame);
                                                break block35;
                                            }
                                            if (!playerPlayVideo || (delay = startTime - System.nanoTime()) <= 0L) break block35;
                                            try {
                                                Thread.sleep((int)(delay / 1500000L));
                                            }
                                            catch (InterruptedException time3) {
                                                // empty catch block
                                            }
                                            delay = startTime - System.nanoTime();
                                            time2 = System.nanoTime();
                                        }
                                        while (System.nanoTime() - time3 < delay) {
                                        }
                                    }
                                    frameIsComplete = true;
                                    continue;
                                    while (System.nanoTime() - time2 < delay) {
                                    }
                                }
                                frameIsComplete = true;
                                throw throwable2;
                            }
                            if (frameControl && !Shutter.inputDeviceIsRunning) {
                                playerLoop = false;
                                VideoPlayer.getTimePoint(playerCurrentFrame);
                            } else if (playerPlayVideo && (delay = startTime - System.nanoTime()) > 0L) {
                                try {
                                    Thread.sleep((int)(delay / 1500000L));
                                }
                                catch (InterruptedException time2) {
                                    // empty catch block
                                }
                                delay = startTime - System.nanoTime();
                                time3 = System.nanoTime();
                                while (System.nanoTime() - time3 < delay) {
                                }
                            }
                            frameIsComplete = true;
                            continue;
                        }
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!playerLoop && playerVideo.isAlive());
                    } while (playerVideo.isAlive());
                    try {
                        video.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        videoInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (audio != null && audioInputStream != null && closeAudioStream) {
                        try {
                            audio.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            audioInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        line.flush();
                    }
                }
            });
            playerThread.setPriority(10);
            playerThread.start();
            Thread playerAudiothread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] buffer = new byte[4096];
                    int bytesRead = 0;
                    boolean forceLoop = frameControl;
                    boolean inputAudioStreamIsDone = false;
                    if (Shutter.caseAudioOffset.isSelected()) {
                        offsetVideo = (long)inputTime - (long)Integer.parseInt(Shutter.txtAudioOffset.getText());
                        offsetAudio = (long)inputTime + (long)Integer.parseInt(Shutter.txtAudioOffset.getText());
                    }
                    double inputVideoFrameToSeconds = inputTime / FFPROBE.accurateFPS;
                    do {
                        if (playerLoop && (forceLoop || VideoPlayer.playerIsPlaying())) {
                            block20: {
                                if (VideoPlayer.playerIsPlaying()) {
                                    long time = System.currentTimeMillis();
                                    while (!frameIsComplete) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        if (frameVideo != null && System.currentTimeMillis() - time <= 5000L) continue;
                                        frameIsComplete = true;
                                    }
                                }
                                if (!(audioInputStream == null || audioSetTimeIsRunning || !casePlaySound.isSelected() && !VideoPlayer.playerIsPlaying() || mouseIsPressed && !FFPROBE.audioOnly)) {
                                    closeAudioStream = true;
                                    if (playerCurrentFrame >= offsetAudio && !inputAudioStreamIsDone) {
                                        try {
                                            bytesRead = audioInputStream.read(buffer, 0, buffer.length);
                                            line.write(buffer, 0, bytesRead);
                                            if (!playerPlayVideo || FFPROBE.audioOnly) break block20;
                                            if (audioSetTimeIsRunning) {
                                                inputVideoFrameToSeconds = playerCurrentFrame / FFPROBE.accurateFPS - (double)line.getLongFramePosition() / 48000.0;
                                            }
                                            double videoClock = playerCurrentFrame / FFPROBE.accurateFPS * 1000.0;
                                            double audioClock = ((double)line.getLongFramePosition() / 48000.0 + inputVideoFrameToSeconds) * 1000.0;
                                            double delay = audioClock - videoClock;
                                            if (!(delay >= 50.0)) break block20;
                                            try {
                                                Thread.sleep(Math.round(delay));
                                            }
                                            catch (InterruptedException interruptedException) {
                                            }
                                        }
                                        catch (Exception e) {
                                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio")) && Shutter.comboFilter.getSelectedItem().toString().equals(Shutter.language.getProperty("longest"))) {
                                                inputAudioStreamIsDone = true;
                                            }
                                        }
                                    }
                                } else {
                                    closeAudioStream = false;
                                }
                            }
                            forceLoop = false;
                            continue;
                        }
                        if (line != null && closeAudioStream && !sliderChange && !frameControl) {
                            line.flush();
                        }
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (!playerLoop && playerVideo.isAlive());
                    } while (playerThread.isAlive());
                }
            });
            playerAudiothread.setPriority(10);
            playerAudiothread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage readFrame(BufferedInputStream is, int width, int height, boolean RGB2) throws IOException {
        int frameSize;
        if (Shutter.comboResolution.getSelectedItem().toString().equals(Shutter.language.getProperty("source")) && Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 1 || Shutter.comboRotate.getSelectedIndex() == 2)) {
            int h;
            int w = width;
            width = h = height;
            height = w;
        }
        if (FFPROBE.hasAlpha) {
            frameSize = width * height * 4;
            byte[] rgba = new byte[frameSize];
            int read = is.readNBytes(rgba, 0, frameSize);
            if (read != frameSize) {
                return null;
            }
            BufferedImage img = new BufferedImage(width, height, 6);
            byte[] abgr = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            int p = 0;
            int i = 0;
            while (i < frameSize) {
                abgr[p++] = rgba[i + 3];
                abgr[p++] = rgba[i + 2];
                abgr[p++] = rgba[i + 1];
                abgr[p++] = rgba[i];
                i += 4;
            }
            return img;
        }
        if (RGB2) {
            frameSize = width * height * 3;
            byte[] rgb = new byte[frameSize];
            int read = is.readNBytes(rgb, 0, frameSize);
            if (read != frameSize) {
                return null;
            }
            BufferedImage img = new BufferedImage(width, height, 5);
            byte[] bgr = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            int p = 0;
            int i = 0;
            while (i < frameSize) {
                bgr[p++] = rgb[i + 2];
                bgr[p++] = rgb[i + 1];
                bgr[p++] = rgb[i];
                i += 3;
            }
            return img;
        }
        frameSize = width * height * 3 / 2;
        byte[] yuv = new byte[frameSize];
        int read = is.readNBytes(yuv, 0, frameSize);
        if (read != frameSize) {
            return null;
        }
        BufferedImage img = new BufferedImage(width, height, 5);
        byte[] rgb = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        int frameSizeY = width * height;
        int frameSizeU = frameSizeY / 4;
        int yIndex = 0;
        int uIndex = frameSizeY;
        int vIndex = frameSizeY + frameSizeU;
        int rgbIndex = 0;
        int y = 0;
        while (y < height) {
            int uvRow = y / 2 * (width / 2);
            int x = 0;
            while (x < width) {
                int Y = yuv[yIndex + y * width + x] & 0xFF;
                int U = yuv[uIndex + uvRow + x / 2] & 0xFF;
                int V = yuv[vIndex + uvRow + x / 2] & 0xFF;
                int C2 = Y - 16;
                int D = U - 128;
                int E = V - 128;
                int R = VideoPlayer.clamp(298 * C2 + 409 * E + 128 >> 8);
                int G = VideoPlayer.clamp(298 * C2 - 100 * D - 208 * E + 128 >> 8);
                int B = VideoPlayer.clamp(298 * C2 + 516 * D + 128 >> 8);
                rgb[rgbIndex++] = (byte)B;
                rgb[rgbIndex++] = (byte)G;
                rgb[rgbIndex++] = (byte)R;
                ++x;
            }
            ++y;
        }
        return img;
    }

    private static int clamp(int val) {
        return val < 0 ? 0 : (val > 255 ? 255 : val);
    }

    private static void playerPlayAudioOnly(double inputTime) {
        if (casePlaySound.isSelected() && FFPROBE.hasAudio && !mouseIsPressed) {
            if (line != null) {
                line.flush();
            }
            try {
                Process playerAudio;
                if (System.getProperty("os.name").contains("Windows")) {
                    pba = new ProcessBuilder("cmd.exe", "/c", "\"" + FFMPEG.PathToFFMPEG + "\"" + VideoPlayer.setAudioCommand(inputTime, true));
                    playerAudio = pba.start();
                } else {
                    pba = new ProcessBuilder("/bin/bash", "-c", FFMPEG.PathToFFMPEG + VideoPlayer.setAudioCommand(inputTime, true));
                    playerAudio = pba.start();
                }
                InputStream audio = playerAudio.getInputStream();
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audio);
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                line.start();
                byte[] bytes = new byte[4096];
                int bytesRead = 0;
                float gain = (float)sliderVolume.getValue() / 100.0f;
                float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0) + (float)sliderVolume.getValue() / 16.666666f;
                gainControl.setValue(dB);
                bytesRead = audioInputStream.read(bytes, 0, bytes.length);
                line.write(bytes, 0, bytesRead);
                try {
                    audio.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    audioInputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void playerPlay() {
        if (playerVideo == null || !playerVideo.isAlive()) {
            VideoPlayer.playerProcess(playerCurrentFrame);
        }
    }

    public static void playerStop() {
        playerLoop = false;
        if (playerVideo != null) {
            playerVideo.destroy();
            try {
                playerThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (playerAudio != null) {
            playerAudio.destroy();
        }
    }

    public static void playerRepaint() {
        long time;
        if (frameVideo != null && (double)((time = System.currentTimeMillis()) - lastEvTime) >= screenRefreshRate) {
            lastEvTime = time;
            player.repaint();
            VideoPlayer.getTimePoint(playerCurrentFrame);
        }
    }

    public static boolean playerIsPlaying() {
        return btnPlay.getName().equals("pause");
    }

    public static void playerSetTime(final double time) {
        if (!(setTime != null && setTime.isAlive() || frameVideo == null && !(playerCurrentFrame > 0.0) || playerThread == null || Shutter.doNotLoadImage || !(time < totalFrames) || videoPath == null)) {
            setTime = new Thread(new Runnable(){

                @Override
                public void run() {
                    previewUpscale = false;
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                    int t = (int)Math.ceil(time);
                    if (t < 0) {
                        t = 0;
                    }
                    boolean useBuffer = false;
                    if (preview != null || Shutter.caseAddSubtitles.isSelected()) {
                        preview = null;
                    } else if (!FFPROBE.audioOnly && (mouseIsPressed || frameControl) && !VideoPlayer.playerIsPlaying() && playerCurrentFrame != time && freezeFrame == "") {
                        useBuffer = true;
                    }
                    int framesToSkip = (int)(time - playerCurrentFrame);
                    int framesToSkipBackward = (int)(time - bufferCurrentFrame);
                    if (bufferedFrames.size() > 0 && time < bufferCurrentFrame + 1.0 && framesToSkip >= 0 && useBuffer) {
                        int framesToRead = (int)(bufferCurrentFrame - playerCurrentFrame - (double)framesToSkip + 1.0);
                        frameVideo = (BufferedImage)bufferedFrames.get(bufferedFrames.size() - framesToRead);
                        VideoPlayer.playerPlayAudioOnly(time);
                        VideoPlayer.getTimePoint(playerCurrentFrame += (double)framesToSkip);
                        player.repaint();
                    } else if (framesToSkip < 60 && framesToSkip >= 0 && useBuffer) {
                        try {
                            int i = 0;
                            do {
                                ++i;
                                frameVideo = VideoPlayer.readFrame(videoInputStream, player.getWidth(), player.getHeight(), false);
                                VideoPlayer.updateCurrentFrame();
                                if (bufferedFrames.size() > maxBufferedFrames) {
                                    bufferedFrames.remove(0);
                                }
                                bufferedFrames.add(frameVideo);
                                if (i != framesToSkip) continue;
                                VideoPlayer.playerPlayAudioOnly(time);
                                VideoPlayer.playerRepaint();
                                bufferCurrentFrame = playerCurrentFrame;
                            } while (i < framesToSkip);
                        }
                        catch (Exception i) {}
                    } else if (bufferedFrames.size() > 1 && 0 - framesToSkipBackward < bufferedFrames.size() && framesToSkip < 0 && useBuffer) {
                        frameVideo = (BufferedImage)bufferedFrames.get(bufferedFrames.size() + framesToSkipBackward);
                        VideoPlayer.playerPlayAudioOnly(time + 1.0);
                        VideoPlayer.getTimePoint(playerCurrentFrame += (double)(framesToSkip + 1));
                        player.repaint();
                    } else if (framesToSkip != 0 || framesToSkip == 0 && !mouseIsPressed) {
                        if (!(bufferedFrames.size() <= 0 || playerCurrentFrame == time || framesToSkip < 60 && 0 - framesToSkipBackward < bufferedFrames.size() && useBuffer)) {
                            bufferedFrames.clear();
                            ++t;
                        } else if (bufferedFrames.size() > 0) {
                            while (bufferCurrentFrame > playerCurrentFrame && bufferedFrames.size() > 0) {
                                bufferedFrames.remove(bufferedFrames.size() - 1);
                                bufferCurrentFrame -= 1.0;
                            }
                        }
                        VideoPlayer.writeCurrentSubs(t, false);
                        playerPlayVideo = false;
                        boolean playback = VideoPlayer.playerIsPlaying();
                        VideoPlayer.playerStop();
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (playerThread.isAlive());
                        frameControl = true;
                        frameIsComplete = false;
                        playerLoop = true;
                        VideoPlayer.playerProcess(t);
                        long time2 = System.currentTimeMillis();
                        do {
                            playerLoop = true;
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (frameVideo != null && System.currentTimeMillis() - time2 <= 5000L) continue;
                            frameIsComplete = true;
                        } while (!frameIsComplete);
                        playerLoop = playback && !mouseIsPressed;
                        playerCurrentFrame = t;
                        VideoPlayer.getTimePoint(playerCurrentFrame);
                        Shutter.timecode.repaint();
                        frameControl = false;
                        playerPlayVideo = true;
                    }
                    Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                    Shutter.windowDrag = false;
                }
            });
            setTime.start();
        }
    }

    public static void playerAudioSetTime(double inputTime) {
        if (playerAudio != null) {
            playerAudio.destroy();
            audioSetTimeIsRunning = true;
            if (line != null) {
                line.flush();
            }
            try {
                if (casePlaySound.isSelected() && (!mouseIsPressed || FFPROBE.audioOnly) || !mouseIsPressed) {
                    if (System.getProperty("os.name").contains("Windows")) {
                        ProcessBuilder pba = new ProcessBuilder("cmd.exe", "/c", "\"" + FFMPEG.PathToFFMPEG + "\"" + VideoPlayer.setAudioCommand(inputTime, false));
                        playerAudio = pba.start();
                    } else {
                        ProcessBuilder pba = new ProcessBuilder("/bin/bash", "-c", FFMPEG.PathToFFMPEG + VideoPlayer.setAudioCommand(inputTime, false));
                        playerAudio = pba.start();
                    }
                    try {
                        audio = playerAudio.getInputStream();
                        audioInputStream = null;
                        audioInputStream = AudioSystem.getAudioInputStream(audio);
                    }
                    catch (Exception pba) {
                        // empty catch block
                    }
                }
                if (VideoPlayer.playerIsPlaying()) {
                    playerLoop = true;
                }
            }
            catch (Exception e) {
                playerAudio.destroy();
            }
            audioSetTimeIsRunning = false;
        }
    }

    public static void playerFreeze() {
        if (!(setTime != null && setTime.isAlive() || playerVideo != null && playerVideo.isAlive())) {
            setTime = new Thread(new Runnable(){

                @Override
                public void run() {
                    frameVideo = null;
                    playerPlayVideo = false;
                    VideoPlayer.writeCurrentSubs(0.0, false);
                    if (playerThread != null) {
                        VideoPlayer.playerStop();
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (playerThread.isAlive());
                    }
                    frameControl = true;
                    frameIsComplete = false;
                    playerLoop = true;
                    VideoPlayer.playerProcess(playerCurrentFrame);
                    long time = System.currentTimeMillis();
                    do {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - time <= 5000L) continue;
                        frameIsComplete = true;
                    } while (!frameIsComplete);
                    if (playerCurrentFrame > 0.0) {
                        playerCurrentFrame -= 1.0;
                    }
                    VideoPlayer.getTimePoint(playerCurrentFrame);
                    frameControl = false;
                    playerPlayVideo = true;
                }
            });
            setTime.start();
        }
    }

    public static void setMedia() {
        loadMedia = new Thread(new Runnable(){

            @Override
            public void run() {
                block112: {
                    block116: {
                        block113: {
                            block114: {
                                if (FFMPEG.isRunning && (Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction")) || Shutter.btnStart.getText().equals(Shutter.language.getProperty("resume")) || Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnStopRecording")))) break block112;
                                if (Shutter.list.getSize() <= 0) break block113;
                                if (Shutter.fileList.getSelectedIndices().length == 0) {
                                    Shutter.fileList.setSelectedIndex(0);
                                }
                                VideoPlayer.refreshTimecodeAndText();
                                if (Shutter.scanIsRunning) {
                                    File dir = new File(Shutter.list.firstElement());
                                    File[] fileArray = dir.listFiles();
                                    int n = fileArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        File f = fileArray[n2];
                                        if (!f.isHidden() && f.isFile()) {
                                            videoPath = f.toString();
                                            break;
                                        }
                                        ++n2;
                                    }
                                } else if (Shutter.inputDeviceIsRunning) {
                                    videoPath = Shutter.list.firstElement();
                                    VideoPlayer.setInfo();
                                }
                                if (Shutter.fileList.getSelectedValue().equals(videoPath) || !new File(Shutter.fileList.getSelectedValue()).isFile() && !Shutter.scanIsRunning) break block114;
                                if (bufferedFrames.size() > 0) {
                                    bufferedFrames.clear();
                                }
                                if (FFPROBE.isRunning) {
                                    do {
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException dir) {
                                            // empty catch block
                                        }
                                    } while (FFPROBE.isRunning);
                                }
                                if (!Shutter.scanIsRunning) {
                                    videoPath = Shutter.fileList.getSelectedValue();
                                }
                                if (frameVideo != null) {
                                    frameVideo = null;
                                }
                                if (preview != null) {
                                    preview = null;
                                }
                                if (waveform != null) {
                                    waveform = null;
                                    waveformIcon.setIcon(null);
                                    waveformIcon.repaint();
                                }
                                waveformZoom = 1;
                                if (addWaveformIsRunning && FFMPEG.waveformWriter != null) {
                                    try {
                                        FFMPEG.waveformWriter.write(113);
                                        FFMPEG.waveformWriter.flush();
                                        FFMPEG.waveformWriter.close();
                                    }
                                    catch (IOException dir) {
                                        // empty catch block
                                    }
                                    FFMPEG.waveformProcess.destroy();
                                }
                                String extension = videoPath.substring(videoPath.lastIndexOf("."));
                                boolean isRaw = false;
                                switch (extension.toLowerCase()) {
                                    case ".3fr": 
                                    case ".arw": 
                                    case ".cr2": 
                                    case ".cr3": 
                                    case ".crw": 
                                    case ".dng": 
                                    case ".kdc": 
                                    case ".mrw": 
                                    case ".nef": 
                                    case ".nrw": 
                                    case ".orf": 
                                    case ".pef": 
                                    case ".r3d": 
                                    case ".ptx": 
                                    case ".raf": 
                                    case ".rw2": 
                                    case ".srw": 
                                    case ".x3f": {
                                        isRaw = true;
                                        FFPROBE.totalLength = 0;
                                    }
                                }
                                try {
                                    FunctionUtils.analyze(new File(videoPath), isRaw);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                btnStop.doClick();
                                Shutter.fileList.repaint();
                                fileDuration = FFPROBE.totalLength;
                                if (isRaw) {
                                    Shutter.btnStart.setEnabled(true);
                                }
                                cursorCurrentFrame.setBounds(0, 0, 1, waveformContainer.getHeight());
                                VideoPlayer.setPlayerButtons(true);
                                seekOnKeyFrames = false;
                                if (!FFPROBE.audioOnly && (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionCut")) || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap")) || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionConform")))) {
                                    FFPROBE.AnalyzeGOP(videoPath, false);
                                    do {
                                        try {
                                            Thread.sleep(10L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        if (FFPROBE.gopCount <= 2) continue;
                                        seekOnKeyFrames = true;
                                        FFPROBE.process.destroy();
                                        break;
                                    } while (FFPROBE.isRunning);
                                } else {
                                    Shutter.caseEnableCrop.setEnabled(true);
                                    Shutter.caseAddWatermark.setEnabled(true);
                                    Shutter.caseSafeArea.setEnabled(true);
                                }
                                if (Shutter.caseEnableCrop.isSelected() && Shutter.comboPreset.getSelectedIndex() == 1) {
                                    FFMPEG.setCropDetect(new File(videoPath));
                                }
                                if (Shutter.caseAddSubtitles.isSelected()) {
                                    if (Shutter.subtitlesBurn) {
                                        Shutter.autoBurn = true;
                                    } else {
                                        Shutter.autoEmbed = true;
                                    }
                                    String ext = videoPath.substring(videoPath.lastIndexOf("."));
                                    if (new File(videoPath.replace(ext, ".srt")).exists() || new File(videoPath.replace(ext, ".vtt")).exists() || new File(videoPath.replace(ext, ".ass")).exists() || new File(videoPath.replace(ext, ".ssa")).exists() || new File(videoPath.replace(ext, ".scc")).exists() || Shutter.comboSubsSource.getSelectedIndex() != 0) {
                                        FunctionUtils.addSubtitles(false);
                                        if (runProcess != null) {
                                            do {
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                            } while (runProcess.isAlive());
                                        }
                                        FunctionUtils.addSubtitles(true);
                                    }
                                    Shutter.autoBurn = false;
                                    Shutter.autoEmbed = false;
                                    try {
                                        do {
                                            Thread.sleep(100L);
                                        } while (FFMPEG.isRunning);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                if (System.getProperty("os.name").contains("Mac") && Shutter.arch.equals("x86_64") || System.getProperty("os.name").contains("Linux")) {
                                    if (FFPROBE.subtitleStreams != Shutter.comboSubsSource.getItemCount() - 1) {
                                        Shutter.comboSubsSource.removeAllItems();
                                        Shutter.comboSubsSource.addItem(Shutter.language.getProperty("file"));
                                        int i = 0;
                                        while (i < FFPROBE.subtitleStreams) {
                                            Shutter.comboSubsSource.addItem(Shutter.language.getProperty("source") + " #" + (i + 1));
                                            ++i;
                                        }
                                    }
                                } else if (FFPROBE.subtitleStreams != Shutter.comboSubsSource.getItemCount() - 2) {
                                    Shutter.comboSubsSource.removeAllItems();
                                    Shutter.comboSubsSource.addItem(Shutter.language.getProperty("file"));
                                    int i = 0;
                                    while (i < FFPROBE.subtitleStreams) {
                                        Shutter.comboSubsSource.addItem(Shutter.language.getProperty("source") + " #" + (i + 1));
                                        ++i;
                                    }
                                    Shutter.comboSubsSource.addItem(Shutter.language.getProperty("functionTranscribe"));
                                }
                                if (Shutter.caseEnableSequence.isSelected()) {
                                    FunctionUtils.setConcat(new File("concat.txt"), Shutter.dirTemp);
                                    inputFramerateMS = Float.parseFloat(Shutter.caseSequenceFPS.getSelectedItem().toString().replace(",", "."));
                                } else {
                                    inputFramerateMS = 1000.0 / FFPROBE.accurateFPS;
                                }
                                playerCurrentFrame = 0.0;
                                caseInternalTc.setEnabled(true);
                                Shutter.caseShowTimecode.setEnabled(true);
                                Shutter.textSubsWidth.setText(String.valueOf(FFPROBE.imageWidth));
                                VideoPlayer.setInfo();
                                btnPlay.setEnabled(true);
                                btnPrevious.setEnabled(true);
                                btnNext.setEnabled(true);
                                btnStop.setEnabled(true);
                                btnMarkIn.setEnabled(true);
                                btnMarkOut.setEnabled(true);
                                btnGoToIn.setEnabled(true);
                                btnGoToOut.setEnabled(true);
                                if (!caseApplyCutToAll.isVisible() || !caseApplyCutToAll.isSelected()) {
                                    caseInH.setEnabled(true);
                                    caseInM.setEnabled(true);
                                    caseInS.setEnabled(true);
                                    caseInF.setEnabled(true);
                                    caseOutH.setEnabled(true);
                                    caseOutM.setEnabled(true);
                                    caseOutS.setEnabled(true);
                                    caseOutF.setEnabled(true);
                                }
                                if (fileDuration > 40.0 && !Shutter.caseEnableSequence.isSelected() && Shutter.frame.getSize().width > 654) {
                                    lblPosition.setVisible(true);
                                    lblDuration.setVisible(true);
                                }
                                totalFrames = fileDuration / 1000.0 * FFPROBE.accurateFPS;
                                slider.setMaximum((int)totalFrames);
                                if (caseApplyCutToAll.isVisible() && caseApplyCutToAll.isSelected()) {
                                    VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(InputAndOutput.savedInPoint));
                                    VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode(totalFrames - InputAndOutput.savedOutPoint));
                                } else {
                                    VideoPlayer.updateGrpIn(0.0);
                                    VideoPlayer.updateGrpOut(totalFrames);
                                    playerInMark = 0;
                                    playerOutMark = waveformContainer.getWidth() - 2;
                                }
                                waveformContainer.repaint();
                                if (!caseApplyCutToAll.isVisible() || !caseApplyCutToAll.isSelected()) {
                                    VideoPlayer.getFileList(videoPath, fileDuration);
                                }
                                VideoPlayer.setFileList();
                                double scale = 0.0;
                                if (FFPROBE.previousImageWidth > 0 && (scale = (double)FFPROBE.imageWidth / (double)FFPROBE.previousImageWidth) != 0.0) {
                                    if (Shutter.caseShowTimecode.isSelected() || Shutter.caseAddTimecode.isSelected()) {
                                        Shutter.textTcSize.setText(String.valueOf(Math.round((double)Integer.parseInt(Shutter.textTcSize.getText()) * scale)));
                                    }
                                    if (Shutter.caseShowFileName.isSelected() || Shutter.caseAddText.isSelected()) {
                                        Shutter.textNameSize.setText(String.valueOf(Math.round((double)Integer.parseInt(Shutter.textNameSize.getText()) * scale)));
                                    }
                                    if (Shutter.caseAddWatermark.isSelected() && (FFPROBE.imageWidth != FFPROBE.previousImageWidth || FFPROBE.imageHeight != FFPROBE.previousImageHeight)) {
                                        Shutter.textWatermarkSize.setText(String.valueOf(Math.round((double)Integer.parseInt(Shutter.textWatermarkSize.getText()) * scale)));
                                    }
                                    VideoPlayer.resizeAll();
                                }
                            }
                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                            break block116;
                        }
                        btnStop.doClick();
                        videoPath = null;
                        showScale.setVisible(false);
                        VideoPlayer.playerStop();
                        slider.setValue(0);
                        btnPlay.setIcon(new FlatSVGIcon("contents/play.svg", 15, 15));
                        btnPlay.setName("play");
                        btnPlay.setEnabled(false);
                        btnPrevious.setEnabled(false);
                        btnNext.setEnabled(false);
                        btnStop.setEnabled(false);
                        btnMarkIn.setEnabled(false);
                        btnMarkOut.setEnabled(false);
                        btnGoToIn.setEnabled(false);
                        btnGoToOut.setEnabled(false);
                        caseInH.setEnabled(false);
                        caseInM.setEnabled(false);
                        caseInS.setEnabled(false);
                        caseInF.setEnabled(false);
                        caseOutH.setEnabled(false);
                        caseOutM.setEnabled(false);
                        caseOutS.setEnabled(false);
                        caseOutF.setEnabled(false);
                        caseInternalTc.setEnabled(false);
                        caseInternalTc.setSelected(false);
                        lblPosition.setVisible(false);
                        lblDuration.setVisible(false);
                        if (waveform != null) {
                            waveform = null;
                            waveformIcon.setIcon(null);
                            waveformIcon.repaint();
                        }
                    }
                    if (Shutter.lblCurrentEncoding.getText().equals(Shutter.language.getProperty("processEnded"))) {
                        Shutter.progressBar1.setValue(Shutter.progressBar1.getMaximum());
                    }
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        caseInH.setVisible(false);
                        caseInM.setVisible(false);
                        caseInS.setVisible(false);
                        caseInF.setVisible(false);
                        caseOutH.setVisible(false);
                        caseOutM.setVisible(false);
                        caseOutS.setVisible(false);
                        caseOutF.setVisible(false);
                    } else if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
                        if (!Settings.btnDisableVideoPlayer.isSelected()) {
                            caseInH.setVisible(true);
                            caseInM.setVisible(true);
                            caseInS.setVisible(true);
                            caseInF.setVisible(true);
                        }
                        caseOutH.setVisible(false);
                        caseOutM.setVisible(false);
                        caseOutS.setVisible(false);
                        caseOutF.setVisible(false);
                    } else if (waveformScrollPane.isVisible()) {
                        caseInH.setVisible(true);
                        caseInM.setVisible(true);
                        caseInS.setVisible(true);
                        caseInF.setVisible(true);
                        caseOutH.setVisible(true);
                        caseOutM.setVisible(true);
                        caseOutS.setVisible(true);
                        caseOutF.setVisible(true);
                    }
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && videoPath != null) {
                        File video = new File(videoPath);
                        String videoWithoutExt = video.getName().substring(0, video.getName().lastIndexOf("."));
                        SubtitlesTimeline.srt = new File(video.getParent() + "/" + videoWithoutExt + ".srt");
                        SubtitlesTimeline.timelineScrollBar.setMaximum(slider.getMaximum());
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        Shutter.frame.setLocation(Shutter.frame.getLocation().x, dim.height / 3 - Shutter.frame.getHeight() / 2);
                        if (Shutter.caseAddSubtitles.isSelected()) {
                            player.remove(Shutter.subsCanvas);
                            Shutter.caseAddSubtitles.setSelected(false);
                        }
                        if (SubtitlesTimeline.frame == null) {
                            new SubtitlesTimeline();
                        } else {
                            SubtitlesTimeline.frame.setVisible(true);
                            SubtitlesTimeline.frame.setLocation(Shutter.frame.getLocation().x + Shutter.frame.getWidth() / 2 - SubtitlesTimeline.frame.getWidth() / 2, Shutter.frame.getLocation().y + Shutter.frame.getHeight() + 7);
                            SubtitlesTimeline.subtitlesNumber();
                            SubtitlesTimeline.timeline.remove(SubtitlesTimeline.waveform);
                            SubtitlesTimeline.repaintTimeline();
                            SubtitlesTimeline.timeline.removeAll();
                            SubtitlesTimeline.setSubtitles(SubtitlesTimeline.srt);
                        }
                        VideoPlayer.playerFreeze();
                        Shutter.btnStart.setEnabled(false);
                        Shutter.comboFonctions.setEnabled(false);
                        Shutter.frame.setVisible(false);
                        Shutter.frame.setVisible(true);
                    } else {
                        VideoPlayer.resizeAll();
                    }
                    if (!Shutter.fileList.hasFocus()) {
                        waveformContainer.requestFocus();
                    }
                }
            }
        });
        loadMedia.start();
    }

    public static void setInfo() {
        String tff = "";
        if (FFPROBE.interlaced != null && FFPROBE.interlaced.equals("1")) {
            tff = FFPROBE.fieldOrder.equals("0") ? " TFF" : " BFF";
        }
        if (FFPROBE.videoCodec != null && fileDuration > 40.0 && !Shutter.inputDeviceIsRunning) {
            String vcodec = FFPROBE.videoCodec.replace("video", "");
            String[] stringArray = Shutter.functionsList;
            int n = Shutter.functionsList.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (vcodec.toLowerCase().equals(s.replace(".", "").replace("-", "").toLowerCase()) || s.toLowerCase().contains(vcodec.toLowerCase())) {
                    vcodec = s;
                    break;
                }
                vcodec = vcodec.toUpperCase();
                ++n2;
            }
            showScale.setText(FFPROBE.imageResolution + " " + vcodec + tff + " " + FFPROBE.imageDepth + "-bit");
        } else {
            showScale.setText(FFPROBE.imageResolution + tff);
        }
        showScale.repaint();
        showFPS.repaint();
    }

    public static void setPlayerButtons(boolean enable) {
        if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
            waveformScrollPane.setVisible(true);
            waveformIcon.setVisible(true);
            cursorHead.setVisible(true);
            caseInH.setVisible(false);
            caseInM.setVisible(false);
            caseInS.setVisible(false);
            caseInF.setVisible(false);
            caseOutH.setVisible(false);
            caseOutM.setVisible(false);
            caseOutS.setVisible(false);
            caseOutF.setVisible(false);
            lblDuration.setVisible(false);
            if (Shutter.list.getSize() > 0) {
                lblPosition.setVisible(true);
            } else {
                lblPosition.setVisible(false);
            }
            lblVolume.setVisible(true);
            sliderVolume.setVisible(true);
            lblSpeed.setVisible(true);
            sliderSpeed.setVisible(true);
            lblMode.setVisible(false);
            comboMode.setVisible(false);
            btnPreview.setVisible(false);
            splitValue.setVisible(false);
            lblSplitSec.setVisible(false);
            btnGoToIn.setVisible(false);
            btnMarkIn.setVisible(false);
            btnPlay.setVisible(true);
            btnPrevious.setVisible(true);
            btnNext.setVisible(true);
            btnStop.setVisible(true);
            btnMarkOut.setVisible(false);
            btnGoToOut.setVisible(false);
            panelForButtons.setVisible(true);
            caseApplyCutToAll.setVisible(false);
            caseInternalTc.setVisible(false);
            caseShowWaveform.setVisible(false);
            caseVuMeter.setVisible(true);
            casePlaySound.setVisible(true);
            showScale.setVisible(false);
            comboAudioTrack.setVisible(false);
        } else if (fileDuration <= 40.0 || Shutter.caseEnableSequence.isSelected() || !enable) {
            waveformScrollPane.setVisible(false);
            waveformIcon.setVisible(false);
            cursorHead.setVisible(false);
            caseInH.setVisible(false);
            caseInM.setVisible(false);
            caseInS.setVisible(false);
            caseInF.setVisible(false);
            caseOutH.setVisible(false);
            caseOutM.setVisible(false);
            caseOutS.setVisible(false);
            caseOutF.setVisible(false);
            lblDuration.setVisible(false);
            lblPosition.setVisible(false);
            lblVolume.setVisible(false);
            sliderVolume.setVisible(false);
            lblSpeed.setVisible(false);
            sliderSpeed.setVisible(false);
            lblMode.setVisible(false);
            comboMode.setVisible(false);
            btnPreview.setVisible(false);
            splitValue.setVisible(false);
            lblSplitSec.setVisible(false);
            btnGoToIn.setVisible(false);
            btnMarkIn.setVisible(false);
            if (!(Shutter.list.getSize() <= 0 || videoPath == null || fullscreenPlayer || isPiping || Settings.btnDisableVideoPlayer.isSelected())) {
                showScale.setVisible(true);
            } else {
                showScale.setVisible(false);
            }
            showFPS.setVisible(false);
            if (Shutter.caseEnableSequence.isSelected() && enable) {
                btnPlay.setVisible(true);
            } else {
                btnPlay.setVisible(false);
            }
            btnPrevious.setVisible(false);
            btnNext.setVisible(false);
            if (Shutter.caseEnableSequence.isSelected() && enable) {
                btnStop.setVisible(true);
            } else {
                btnStop.setVisible(false);
            }
            btnMarkOut.setVisible(false);
            btnGoToOut.setVisible(false);
            panelForButtons.setVisible(false);
            caseApplyCutToAll.setVisible(false);
            caseInternalTc.setVisible(false);
            caseShowWaveform.setVisible(false);
            caseVuMeter.setVisible(false);
            casePlaySound.setVisible(false);
            comboAudioTrack.setVisible(false);
            if (Shutter.caseEnableSequence.isSelected() && enable) {
                Shutter.caseAddSubtitles.setEnabled(true);
            }
        } else if (Shutter.frame.getSize().width > 654) {
            if (FFPROBE.audioOnly) {
                Shutter.caseVideoFadeIn.setEnabled(false);
                Shutter.caseVideoFadeOut.setEnabled(false);
            } else {
                Shutter.caseVideoFadeIn.setEnabled(true);
                if (Shutter.caseVideoFadeIn.isSelected()) {
                    Shutter.spinnerVideoFadeIn.setEnabled(true);
                }
                Shutter.caseVideoFadeOut.setEnabled(true);
                if (Shutter.caseVideoFadeOut.isSelected()) {
                    Shutter.spinnerVideoFadeOut.setEnabled(true);
                }
            }
            caseInH.setVisible(true);
            caseInM.setVisible(true);
            caseInS.setVisible(true);
            caseInF.setVisible(true);
            caseOutH.setVisible(true);
            caseOutM.setVisible(true);
            caseOutS.setVisible(true);
            caseOutF.setVisible(true);
            if (Shutter.list.getSize() > 0) {
                lblDuration.setVisible(true);
                lblPosition.setVisible(true);
            } else {
                lblDuration.setVisible(false);
                lblPosition.setVisible(false);
            }
            if (Shutter.frame.getWidth() >= 1320) {
                lblVolume.setVisible(true);
                sliderVolume.setVisible(true);
                lblSpeed.setVisible(true);
                sliderSpeed.setVisible(true);
            }
            lblMode.setVisible(true);
            comboMode.setVisible(true);
            if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                btnPreview.setVisible(true);
                splitValue.setVisible(false);
                lblSplitSec.setVisible(false);
            } else if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("splitMode"))) {
                btnPreview.setVisible(false);
                splitValue.setVisible(true);
                lblSplitSec.setVisible(true);
            } else {
                btnPreview.setVisible(true);
                splitValue.setVisible(false);
                lblSplitSec.setVisible(false);
            }
            btnGoToIn.setVisible(true);
            btnMarkIn.setVisible(true);
            btnPlay.setVisible(true);
            btnPrevious.setVisible(true);
            btnNext.setVisible(true);
            btnStop.setVisible(true);
            btnMarkOut.setVisible(true);
            btnGoToOut.setVisible(true);
            panelForButtons.setVisible(true);
            waveformScrollPane.setVisible(true);
            cursorHead.setVisible(true);
            if (Shutter.caseEnableSequence.isSelected()) {
                caseApplyCutToAll.setVisible(false);
            } else {
                caseApplyCutToAll.setVisible(true);
            }
            if (FFPROBE.hasAudio) {
                caseShowWaveform.setVisible(true);
                caseVuMeter.setVisible(true);
                casePlaySound.setVisible(true);
                if (caseShowWaveform.isSelected()) {
                    waveformIcon.setVisible(true);
                }
                comboAudioTrack.removeAllItems();
                if (FFPROBE.channels > 1 && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
                    int i = 0;
                    while (i < FFPROBE.channels) {
                        comboAudioTrack.addItem(Shutter.language.getProperty("audio").toUpperCase().substring(0, 1) + (i + 1));
                        ++i;
                    }
                    comboAudioTrack.addItem("Mix");
                    comboAudioTrack.setVisible(true);
                } else {
                    comboAudioTrack.setVisible(false);
                }
            } else {
                caseShowWaveform.setVisible(false);
                caseVuMeter.setVisible(false);
                casePlaySound.setVisible(false);
                waveformIcon.setVisible(false);
                comboAudioTrack.setVisible(false);
            }
            if (FFPROBE.audioOnly || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                caseInternalTc.setVisible(false);
                casePlaySound.setBounds(caseInternalTc.getX(), caseInternalTc.getY(), VideoPlayer.casePlaySound.getPreferredSize().width, 23);
                showScale.setVisible(false);
                showFPS.setVisible(false);
            } else {
                caseInternalTc.setVisible(true);
                caseInternalTc.setBounds(caseInH.getX() - 2, btnPrevious.getY() + btnPrevious.getHeight() + 6, VideoPlayer.caseInternalTc.getPreferredSize().width, 23);
                casePlaySound.setBounds(caseInternalTc.getX() + caseInternalTc.getWidth() + 4, caseInternalTc.getY(), VideoPlayer.casePlaySound.getPreferredSize().width, 23);
                if (Shutter.list.getSize() > 0 && !Settings.btnDisableVideoPlayer.isSelected()) {
                    showScale.setVisible(true);
                }
            }
            Shutter.caseAddSubtitles.setEnabled(true);
            if (Shutter.caseShowTimecode.isSelected() || caseInternalTc.isSelected()) {
                if (FFPROBE.timecode1.equals("")) {
                    if (Shutter.caseShowTimecode.isSelected()) {
                        Shutter.caseShowTimecode.setSelected(false);
                        Shutter.caseAddTimecode.doClick();
                    }
                    if (caseInternalTc.isSelected()) {
                        caseInternalTc.setSelected(false);
                        offset = 0.0;
                    }
                } else {
                    if (Shutter.caseShowTimecode.isSelected()) {
                        Shutter.TC1.setEnabled(false);
                        Shutter.TC2.setEnabled(false);
                        Shutter.TC3.setEnabled(false);
                        Shutter.TC4.setEnabled(false);
                        Shutter.caseAddTimecode.setSelected(false);
                        player.add(Shutter.timecode);
                        if (Shutter.caseEnableCrop.isSelected()) {
                            player.remove(Shutter.selection);
                            player.remove(Shutter.overImage);
                            player.add(Shutter.selection);
                            player.add(Shutter.overImage);
                        }
                    }
                    if (caseInternalTc.isSelected()) {
                        offset = (double)(Integer.valueOf(FFPROBE.timecode1) * 3600) * FFPROBE.accurateFPS + (double)(Integer.valueOf(FFPROBE.timecode2) * 60) * FFPROBE.accurateFPS + (double)Integer.valueOf(FFPROBE.timecode3).intValue() * FFPROBE.accurateFPS + (double)Integer.valueOf(FFPROBE.timecode4).intValue();
                    }
                }
            }
        }
    }

    public static String setVideoCommand(double inputTime, int width, int height, boolean isPlaying) throws InterruptedException {
        String cmd;
        String colorFormat;
        block34: {
            if (FFPROBE.audioOnly) {
                FFPROBE.accurateFPS = 25.0;
                Object filter = "";
                if (caseVuMeter.isSelected()) {
                    Object aspeed = "";
                    if (sliderSpeed.getValue() != 2) {
                        aspeed = sliderSpeed.getValue() != 0 ? (String)aspeed + "atempo=" + (double)sliderSpeed.getValue() / 2.0 + "," : (String)aspeed + "atempo=0.5,atempo=0.5,";
                    }
                    Object channels = "";
                    Object audioOutput = "";
                    int i = 0;
                    while (i < FFPROBE.channels) {
                        channels = (String)channels + "[0:a:" + i + "]" + (String)aspeed + "showvolume=f=0:w=" + width + ":h=" + Math.round(height / 30) + ":b=4:s=0[a" + i + "];";
                        audioOutput = (String)audioOutput + "[a" + i + "]";
                        ++i;
                    }
                    if (FFPROBE.channels > 1) {
                        audioOutput = (String)audioOutput + "vstack=" + i + "[volume];";
                        filter = " -filter_complex \"" + (String)channels + (String)audioOutput + "[1:v][volume]overlay=W*0.5-w*0.5:H*0.5-h*0.5\"";
                    } else {
                        audioOutput = ((String)audioOutput).replace("[a0]", "");
                        filter = " -filter_complex \"" + (String)channels + (String)audioOutput + "[1:v][a0]overlay=W*0.5-w*0.5:H*0.5-h*0.5\"";
                    }
                }
                return " -v quiet -hide_banner -ss " + (long)(inputTime * inputFramerateMS) + "ms -i \"" + videoPath + "\" -f lavfi -i \"color=c=black:r=25:s=" + width + "x" + height + "\"" + (String)filter + " -c:v rawvideo -pix_fmt yuv420p -an -f rawvideo -";
            }
            Object video = videoPath;
            String concat = "";
            if (Shutter.caseEnableSequence.isSelected()) {
                concat = FunctionUtils.setConcat(new File("concat.txt"), Shutter.dirTemp);
                video = Shutter.dirTemp + "concat.txt";
            }
            String gpuDecoding = "";
            if (!(Shutter.comboGPUDecoding.getSelectedItem().toString().equals(Shutter.language.getProperty("aucun")) || mouseIsPressed || previousFrame || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")))) {
                gpuDecoding = FFMPEG.setGPUDevice(VideoPlayer.setFilter(false, false));
            }
            String extension = videoPath.substring(videoPath.lastIndexOf("."));
            int framesToSkip = (int)((double)slider.getValue() - playerCurrentFrame);
            freezeFrame = mouseIsPressed && (framesToSkip > 60 || framesToSkip < 0) ? " -analyzeduration 0 -probesize 32 -frames:v 1" : "";
            colorFormat = "yuv420p";
            if (FFPROBE.hasAlpha) {
                colorFormat = "rgba";
            }
            cmd = gpuDecoding + Colorimetry.setInputCodec(extension) + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -v quiet -hide_banner -ss " + (long)(inputTime * inputFramerateMS) + "ms" + concat + " -i \"" + (String)video + "\"" + VideoPlayer.setFilter(false, false) + " -r " + FFPROBE.currentFPS + freezeFrame + " -c:v rawvideo -pix_fmt " + colorFormat + " -an -f rawvideo -";
            Object codec = "";
            if (!Settings.btnPreviewOutput.isSelected() || VideoEncoders.setCodec() == "" || Shutter.comboFonctions.getSelectedItem().toString().equals("QT Animation") || Shutter.comboFonctions.getSelectedItem().toString().equals("AVC-Intra 100")) break block34;
            String format = "matroska";
            if (Shutter.comboFonctions.getSelectedItem().toString().equals("XAVC")) {
                format = "mxf";
            }
            Object deinterlace = AdvancedFeatures.setDeinterlace(true, Settings.btnPreviewOutput.isSelected());
            if (mouseIsPressed) {
                deinterlace = "";
            }
            if (deinterlace != "") {
                deinterlace = " -vf " + (String)deinterlace;
            }
            String device = "";
            if (Shutter.comboAccel.getSelectedItem().equals("Vulkan Video") || Shutter.comboGPUDecoding.getSelectedItem().toString().equals("vulkan") || Shutter.comboGPUFilter.getSelectedItem().toString().equals("vulkan")) {
                device = FFMPEG.GPUCount > 1 ? " -init_hw_device vulkan=gpu:1" : " -init_hw_device vulkan=gpu:0";
            } else if (Shutter.comboAccel.getSelectedItem().equals("VAAPI")) {
                device = " -vaapi_device /dev/dri/renderD128";
            }
            String hwupload = "";
            switch (Shutter.comboFonctions.getSelectedItem().toString()) {
                case "AV1": 
                case "VP9": 
                case "FFV1": 
                case "H.264": 
                case "H.265": 
                case "H.266": {
                    if ((Shutter.comboAccel.getSelectedItem().equals(Shutter.language.getProperty("aucune").toLowerCase()) || !Shutter.comboAccel.getSelectedItem().equals("VAAPI")) && !Shutter.comboAccel.getSelectedItem().equals("Vulkan Video")) break;
                    hwupload = deinterlace != "" ? ",format=nv12,hwupload" : " -vf format=nv12,hwupload";
                }
            }
            String pixelFormat = "";
            if (!Shutter.comboAccel.getSelectedItem().equals(Shutter.language.getProperty("aucune").toLowerCase())) {
                pixelFormat = " -pix_fmt yuv420p";
            }
            codec = VideoEncoders.setCodec() + VideoEncoders.setBitrate() + AdvancedFeatures.setPreset() + (String)deinterlace + hwupload + freezeFrame + pixelFormat + " -f " + format + " pipe:1 | ";
            codec = System.getProperty("os.name").contains("Windows") ? (String)codec + "\"" + FFMPEG.PathToFFMPEG + "\"" : (String)codec + FFMPEG.PathToFFMPEG;
            codec = (String)codec + " -v quiet -hide_banner -i pipe:0" + VideoPlayer.setFilter(false, true);
            cmd = device + Colorimetry.setInputCodec(extension) + " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -v quiet -hide_banner -ss " + (long)(inputTime * inputFramerateMS) + "ms" + concat + " -i \"" + (String)video + "\" -r " + FFPROBE.currentFPS + (String)codec + freezeFrame + " -c:v rawvideo -pix_fmt " + colorFormat + " -an -f rawvideo -";
        }
        if (Shutter.inputDeviceIsRunning) {
            cmd = " -strict " + String.valueOf(Settings.comboStrict.getSelectedItem()) + " -v quiet -hide_banner " + RecordInputDevice.setInputDevices() + VideoPlayer.setFilter(false, false) + " -c:v rawvideo -pix_fmt " + colorFormat + " -an -f rawvideo -";
        }
        Console.consoleFFMPEG.append(cmd + System.lineSeparator());
        return cmd;
    }

    public static String setAudioCommand(double inputTime, boolean frameByFrame) {
        Object duration = "";
        if (frameByFrame) {
            duration = " -t " + (int)inputFramerateMS + "ms";
        }
        if (playTransition) {
            playTransition = false;
        }
        if (!(FFPROBE.hasAudio || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio")) && Shutter.list.getSize() != 1)) {
            return " -v quiet -hide_banner -f lavfi -i \"anullsrc=channel_layout=stereo:sample_rate=48000\"" + VideoPlayer.setAudioFilter() + (String)duration + " -vn -c:a pcm_s16le -ar 48k -ac 1 -f wav -";
        }
        Object input = " -i \"" + videoPath + "\"";
        Object mapping = "";
        if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio")) && Shutter.fileList.getSelectedIndex() + 1 < Shutter.list.getSize()) {
            input = Shutter.list.getElementAt(Shutter.fileList.getSelectedIndex() + 1).contains("lavfi") ? " -f lavfi -i \"anullsrc=channel_layout=stereo:sample_rate=48000\"" : " -i \"" + Shutter.list.getElementAt(Shutter.fileList.getSelectedIndex() + 1) + "\"";
        } else {
            mapping = FFPROBE.channels > 0 && comboAudioTrack.isVisible() ? (comboAudioTrack.getSelectedItem() != null && comboAudioTrack.getSelectedItem().equals("Mix") ? " -filter_complex amerge=inputs=" + FFPROBE.channels + VideoPlayer.setAudioFilter().replace(" -filter:a ", ",") : " -map a:" + comboAudioTrack.getSelectedIndex() + VideoPlayer.setAudioFilter()) : VideoPlayer.setAudioFilter();
        }
        return " -v quiet -hide_banner -ss " + (long)(inputTime * inputFramerateMS) + "ms" + (String)input + (String)duration + " -vn -c:a pcm_s16le -ar 48k -ac 1" + (String)mapping + " -f wav -";
    }

    private static void updateCurrentFrame() {
        playerCurrentFrame = sliderSpeed.getValue() != 2 ? (sliderSpeed.getValue() != 0 ? (playerCurrentFrame += 1.0 * ((double)sliderSpeed.getValue() / 2.0)) : (playerCurrentFrame += 0.25)) : (playerCurrentFrame += 1.0);
    }

    public static void addWaveform(final boolean newWaveform) {
        if (caseShowWaveform.isSelected() && FFPROBE.hasAudio && !addWaveformIsRunning && Shutter.frame.getSize().width > 654 && !Settings.btnDisableVideoPlayer.isSelected()) {
            addWaveformIsRunning = true;
            if (newWaveform || waveform == null) {
                Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                waveformIcon.setVisible(false);
                if (newWaveform) {
                    waveform = null;
                }
            }
            addWaveform = new Thread(new Runnable(){

                @Override
                public void run() {
                    block20: {
                        if (newWaveform || waveform == null) {
                            long size = 2000L;
                            Object start = "";
                            Object duration = "";
                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                do {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (SubtitlesTimeline.frame == null);
                                if (SubtitlesTimeline.waveform == null) {
                                    SubtitlesTimeline.waveform = new JLabel();
                                }
                                long time = (long)((double)SubtitlesTimeline.timelineScrollBar.getValue() / SubtitlesTimeline.zoom);
                                String h = Shutter.formatter.format(Math.floor(time / 1000L) / 3600.0);
                                String m = Shutter.formatter.format(Math.floor(time / 1000L) / 60.0 % 60.0);
                                String s = Shutter.formatter.format(Math.floor(time / 1000L) % 60.0);
                                String f = Shutter.formatterToMs.format(time % 1000L);
                                start = " -ss " + h + ":" + m + ":" + s + "." + f;
                                duration = "atrim=duration=" + SubtitlesTimeline.frame.getWidth() / 100 + ",";
                                size = (long)((double)(SubtitlesTimeline.frame.getWidth() * 10) * SubtitlesTimeline.zoom);
                            }
                            if (size > 549944L) {
                                size = 549944L;
                            }
                            if (FFPROBE.channels > 1 && comboAudioTrack.isVisible()) {
                                if (comboAudioTrack.getSelectedItem() != null && comboAudioTrack.getSelectedItem().equals("Mix")) {
                                    FFMPEG.playerWaveform((String)start + " -v quiet -hide_banner -i \"" + videoPath + "\" -filter_complex \"[0:a]amerge=inputs=" + FFPROBE.channels + ",aresample=1000," + (String)duration + "aformat=channel_layouts=mono,compand,showwavespic=size=" + size + "x360:colors=green|green,format=rgba,colorkey=black:0.01\" -vn -frames:v 1 -c:v png -f image2pipe -");
                                } else {
                                    FFMPEG.playerWaveform((String)start + " -v quiet -hide_banner -i \"" + videoPath + "\" -filter_complex \"[0:a:" + comboAudioTrack.getSelectedIndex() + "]aresample=1000," + (String)duration + "aformat=channel_layouts=mono,compand,showwavespic=size=" + size + "x360:colors=green|green,format=rgba,colorkey=black:0.01\" -vn -frames:v 1 -c:v png -f image2pipe -");
                                }
                            } else {
                                FFMPEG.playerWaveform((String)start + " -v quiet -hide_banner -i \"" + videoPath + "\" -filter_complex \"[0:a]aresample=1000," + (String)duration + "aformat=channel_layouts=mono,compand,showwavespic=size=" + size + "x360:colors=green|green,format=rgba,colorkey=black:0.01\" -vn -frames:v 1 -c:v png -f image2pipe -");
                            }
                            if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                            } else {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                            }
                        }
                        try {
                            try {
                                if (Shutter.list.getSize() <= 0 || isPiping || waveform == null) break block20;
                                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                    ImageIcon resizedWaveform = new ImageIcon(new ImageIcon(waveform).getImage().getScaledInstance((int)((double)(SubtitlesTimeline.frame.getWidth() * 10) * SubtitlesTimeline.zoom), SubtitlesTimeline.timeline.getHeight(), 16));
                                    waveformIcon.setIcon(null);
                                    waveformIcon.repaint();
                                    SubtitlesTimeline.waveform.setIcon(resizedWaveform);
                                    SubtitlesTimeline.waveform.setBounds(SubtitlesTimeline.timelineScrollBar.getValue(), SubtitlesTimeline.waveform.getY(), (int)((double)(SubtitlesTimeline.frame.getWidth() * 10) * SubtitlesTimeline.zoom), SubtitlesTimeline.timeline.getHeight());
                                    SubtitlesTimeline.waveform.repaint();
                                    break block20;
                                }
                                waveformIcon.setSize(waveformContainer.getSize());
                                ImageIcon resizedWaveform = new ImageIcon(new ImageIcon(waveform).getImage().getScaledInstance(waveformContainer.getWidth(), waveformContainer.getHeight(), 16));
                                waveformIcon.setIcon(resizedWaveform);
                                waveformIcon.repaint();
                                if (RenderQueue.frame != null && RenderQueue.frame.isVisible() && FFMPEG.isRunning || isPiping || videoPath == null) {
                                    waveformIcon.setVisible(false);
                                    break block20;
                                }
                                waveformIcon.setVisible(true);
                            }
                            catch (Exception exception) {
                                addWaveformIsRunning = false;
                                Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        }
                        finally {
                            addWaveformIsRunning = false;
                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                }
            });
            addWaveform.start();
        }
    }

    private void buttons() {
        btnPrevious = new JButton("<");
        btnPrevious.setFont(new Font(Shutter.mainFont, 1, 12));
        btnPrevious.setBackground(new Color(30, 30, 35, 0));
        btnPrevious.setBorder(null);
        Shutter.frame.getContentPane().add(btnPrevious);
        btnPrevious.addActionListener(new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                previousFrame = true;
                ++this.i;
                if (this.i <= 1) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (sliderSpeed.getValue() != 2) {
                                sliderSpeed.setValue(2);
                                lblSpeed.setText("x1");
                                lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                                VideoPlayer.playerSetTime(playerCurrentFrame - 1.0);
                            }
                            frameControl = true;
                            if (playerVideo != null) {
                                if (playerLoop) {
                                    btnPlay.setIcon(new FlatSVGIcon("contents/play.svg", 15, 15));
                                    btnPlay.setName("play");
                                    playerLoop = false;
                                }
                                frameIsComplete = false;
                                if (seekOnKeyFrames && !FFPROBE.isRunning) {
                                    FFPROBE.Keyframes(videoPath, (playerCurrentFrame - 2.0) * inputFramerateMS, false);
                                    do {
                                        try {
                                            Thread.sleep(10L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    } while (FFPROBE.isRunning);
                                    if (FFPROBE.keyFrame > 0.0) {
                                        VideoPlayer.playerSetTime(FFPROBE.keyFrame);
                                    }
                                } else if (bufferedFrames.size() > 0) {
                                    VideoPlayer.playerSetTime(playerCurrentFrame - 2.0);
                                } else {
                                    VideoPlayer.playerSetTime(playerCurrentFrame - 1.0);
                                    while (setTime.isAlive()) {
                                        try {
                                            Thread.sleep(1L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            i = 0;
                        }
                    });
                    t.start();
                }
            }
        });
        btnNext = new JButton(">");
        btnNext.setFont(new Font(Shutter.mainFont, 1, 12));
        btnNext.setBackground(new Color(30, 30, 35, 0));
        btnNext.setBorder(null);
        Shutter.frame.getContentPane().add(btnNext);
        btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sliderSpeed.getValue() != 2) {
                    sliderSpeed.setValue(2);
                    lblSpeed.setText("x1");
                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                    VideoPlayer.playerSetTime(playerCurrentFrame + 1.0);
                }
                if (preview != null || Shutter.caseAddSubtitles.isSelected()) {
                    VideoPlayer.playerSetTime(playerCurrentFrame + 1.0);
                }
                frameControl = true;
                if (playerVideo != null) {
                    if (playerLoop) {
                        btnPlay.setIcon(new FlatSVGIcon("contents/play.svg", 15, 15));
                        btnPlay.setName("play");
                        playerLoop = false;
                    }
                    if (seekOnKeyFrames && !FFPROBE.isRunning) {
                        FFPROBE.Keyframes(videoPath, (playerCurrentFrame + 1.0) * inputFramerateMS, true);
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        if (FFPROBE.keyFrame > 0.0) {
                            VideoPlayer.playerSetTime(FFPROBE.keyFrame);
                        }
                    } else {
                        VideoPlayer.playerSetTime(playerCurrentFrame + 1.0);
                    }
                }
            }
        });
        btnPlay = new JButton(new FlatSVGIcon("contents/play.svg", 15, 15));
        btnPlay.setMargin(new Insets(0, 0, 0, 0));
        btnPlay.setBackground(new Color(30, 30, 35, 0));
        btnPlay.setBorder(null);
        Shutter.frame.getContentPane().add(btnPlay);
        btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (setTime != null) {
                    while (setTime.isAlive()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (btnPlay.getName().equals("pause")) {
                    btnPlay.setIcon(new FlatSVGIcon("contents/play.svg", 15, 15));
                    btnPlay.setName("play");
                    playerLoop = false;
                    showFPS.setVisible(false);
                    if (sliderSpeed.getValue() != 2) {
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    } else if (!Timecode.isDropFrame()) {
                        VideoPlayer.getTimePoint(playerCurrentFrame);
                    }
                } else if (btnPlay.getName().equals("play")) {
                    if (bufferedFrames.size() > 0 || preview != null || Shutter.caseAddSubtitles.isSelected() || previousFrame) {
                        if (bufferedFrames.size() > 0 || preview != null || Shutter.caseAddSubtitles.isSelected()) {
                            bufferedFrames.clear();
                        }
                        if (previousFrame) {
                            previousFrame = false;
                        }
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                    if (playerCurrentFrame >= totalFrames - 2.0) {
                        VideoPlayer.playerSetTime(0.0);
                        btnPlay.doClick();
                    }
                    frameControl = false;
                    btnPlay.setIcon(new FlatSVGIcon("contents/pause.svg", 15, 15));
                    btnPlay.setName("pause");
                    playerLoop = true;
                    fpsTime = System.nanoTime();
                    displayCurrentFPS = 0;
                }
            }
        });
        btnStop = new JButton(new FlatSVGIcon("contents/stop.svg", 15, 15));
        btnStop.setMargin(new Insets(0, 0, 0, 0));
        btnStop.setBackground(new Color(30, 30, 35, 0));
        btnStop.setBorder(null);
        Shutter.frame.getContentPane().add(btnStop);
        btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (playerVideo != null) {
                    playerCurrentFrame = 0.0;
                    long time = System.currentTimeMillis();
                    if (playerVideo != null) {
                        VideoPlayer.playerStop();
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() - time <= 5000L && playerVideo.isAlive());
                        slider.setValue(0);
                    }
                    VideoPlayer.resizeAll();
                    btnPlay.setIcon(new FlatSVGIcon("contents/play.svg", 15, 15));
                    btnPlay.setName("play");
                    playerLoop = false;
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        SubtitlesTimeline.actualSubOut = 0L;
                    }
                    playerCurrentFrame = 0.0;
                    waveformScrollPane.getHorizontalScrollBar().setValue(0);
                } else if (fileDuration <= 40.0 || Shutter.caseEnableSequence.isSelected()) {
                    VideoPlayer.resizeAll();
                }
            }
        });
        btnMarkIn = new JButton("[");
        btnMarkIn.setFont(new Font(Shutter.mainFont, 1, 12));
        btnMarkIn.setBackground(new Color(30, 30, 35, 0));
        btnMarkIn.setBorder(null);
        Shutter.frame.getContentPane().add(btnMarkIn);
        btnMarkIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!caseApplyCutToAll.isVisible() || !caseApplyCutToAll.isSelected()) {
                    playerInMark = cursorWaveform.getX();
                    waveformContainer.repaint();
                    VideoPlayer.updateGrpIn(playerCurrentFrame);
                    Shutter.timecode.repaint();
                    VideoPlayer.setFileList();
                }
            }
        });
        btnGoToIn = new JButton("[<");
        btnGoToIn.setMargin(new Insets(0, 0, 0, 0));
        btnGoToIn.setFont(new Font(Shutter.mainFont, 1, 12));
        btnGoToIn.setBackground(new Color(30, 30, 35, 0));
        btnGoToIn.setBorder(null);
        Shutter.frame.getContentPane().add(btnGoToIn);
        btnGoToIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                playTransition = true;
                playerCurrentFrame = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                VideoPlayer.playerSetTime(playerCurrentFrame);
            }
        });
        btnMarkOut = new JButton("]");
        btnMarkOut.setFont(new Font(Shutter.mainFont, 1, 12));
        btnMarkOut.setBackground(new Color(30, 30, 35, 0));
        btnMarkOut.setBorder(null);
        Shutter.frame.getContentPane().add(btnMarkOut);
        btnMarkOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!caseApplyCutToAll.isVisible() || !caseApplyCutToAll.isSelected()) {
                    playerOutMark = cursorWaveform.getX();
                    waveformContainer.repaint();
                    VideoPlayer.updateGrpOut(playerCurrentFrame + 1.0);
                    double timeOut = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                    playerOutMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeOut / (double)slider.getMaximum());
                    VideoPlayer.setFileList();
                }
            }
        });
        btnGoToOut = new JButton(">]");
        btnGoToOut.setMargin(new Insets(0, 0, 0, 0));
        btnGoToOut.setFont(new Font(Shutter.mainFont, 1, 12));
        btnGoToOut.setBackground(new Color(30, 30, 35, 0));
        btnGoToOut.setBorder(null);
        Shutter.frame.getContentPane().add(btnGoToOut);
        btnGoToOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                playerCurrentFrame = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                VideoPlayer.playerSetTime(playerCurrentFrame - 1.0);
            }
        });
        panelForButtons = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Utils.c42);
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    g2d.fillRoundRect(0, 0, btnStop.getX() + btnStop.getWidth() - btnPlay.getX() - 4, 21, 15, 15);
                } else {
                    g2d.fillRoundRect(0, 0, btnGoToOut.getX() + btnGoToOut.getWidth() - btnGoToIn.getX() - 4, 21, 15, 15);
                }
                g2d.setColor(new Color(25, 25, 25));
                g2d.drawLine(this.getWidth() / 2, 5, this.getWidth() / 2, this.getHeight() - 6);
            }
        };
        Shutter.frame.getContentPane().add(panelForButtons);
        showFPS = new JLabel("25 fps");
        showFPS.setVisible(false);
        showFPS.setFont(new Font(Shutter.mainFont, 1, 12));
        showFPS.setHorizontalAlignment(4);
        Shutter.frame.getContentPane().add(showFPS);
        showScale = new JLabel("1920x1080");
        showScale.setVisible(false);
        showScale.setEnabled(false);
        showScale.setFont(new Font(Shutter.mainFont, 1, 12));
        showScale.setHorizontalAlignment(2);
        Shutter.frame.getContentPane().add(showScale);
        comboAudioTrack = new JComboBox<String>(new String[]{Shutter.language.getProperty("audio").toUpperCase().substring(0, 1) + "1"});
        comboAudioTrack.setName("comboAudioTrack");
        comboAudioTrack.setOpaque(false);
        comboAudioTrack.setVisible(false);
        comboAudioTrack.setEditable(false);
        comboAudioTrack.setBorder(null);
        comboAudioTrack.setBackground(new Color(comboAudioTrack.getBackground().getRed(), comboAudioTrack.getBackground().getGreen(), comboAudioTrack.getBackground().getBlue(), 0));
        comboAudioTrack.setFont(new Font(Shutter.mainFont, 0, 11));
        comboAudioTrack.setMaximumRowCount(16);
        comboAudioTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.addWaveform(true);
                VideoPlayer.playerSetTime(playerCurrentFrame);
            }
        });
    }

    private void player() {
        player = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                if (FFPROBE.hasAlpha) {
                    this.drawCheckerboard((Graphics2D)g);
                }
                g2.setColor(Color.BLACK);
                if (VideoPlayer.playerIsPlaying() && frameVideo == null) {
                    long time = System.currentTimeMillis();
                    do {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() - time <= 5000L && frameVideo == null && VideoPlayer.playerIsPlaying());
                }
                if (frameVideo == null || Shutter.list.getSize() == 0 || Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction")) && !Shutter.caseDisplay.isSelected()) {
                    g2.fillRect(0, 0, player.getWidth(), player.getHeight());
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.drawImage(frameVideo, 0, 0, player.getWidth(), player.getHeight(), this);
                    cursorCurrentFrame.setBounds((int)Math.round((double)waveformContainer.getWidth() * Timecode.setNTSCtimecode(playerCurrentFrame) / (double)slider.getMaximum()), 0, 1, waveformContainer.getHeight());
                }
                if (!FFPROBE.audioOnly && fileDuration > 40.0) {
                    if (System.nanoTime() - fpsTime >= 1000000000L) {
                        displayCurrentFPS = fps;
                        fpsTime = System.nanoTime();
                        fps = 0;
                    }
                    if (displayCurrentFPS > 0 && playerLoop && sliderSpeed.getValue() == 2 && !fullscreenPlayer && !mouseIsPressed && !Shutter.inputDeviceIsRunning) {
                        showFPS.setVisible(true);
                        if ((double)displayCurrentFPS >= (double)FFPROBE.currentFPS) {
                            showFPS.setForeground(Color.GREEN);
                            String[] fps = String.valueOf(FFPROBE.currentFPS).split("\\.");
                            if (fps[1].equals("0")) {
                                showFPS.setText(String.valueOf(FFPROBE.currentFPS).replace(".0", "") + " " + Shutter.language.getProperty("fps"));
                            } else {
                                showFPS.setText(String.valueOf(FFPROBE.currentFPS) + " " + Shutter.language.getProperty("fps"));
                            }
                        } else {
                            showFPS.setForeground(Color.RED);
                            showFPS.setText(String.valueOf(displayCurrentFPS) + " " + Shutter.language.getProperty("fps"));
                        }
                    } else {
                        showFPS.setVisible(false);
                    }
                }
                if (previewUpscale && preview != null && fileDuration > 40.0) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2.setColor(Color.WHITE);
                    g2.setFont(new Font("SansSerif", 2, (int)Math.floor(player.getHeight() / 16)));
                    FontMetrics metrics = g.getFontMetrics(g2.getFont());
                    int x = (player.getWidth() - metrics.stringWidth(Shutter.language.getProperty("preview"))) / 2;
                    int y = player.getHeight() - player.getHeight() / 24;
                    g2.drawString(Shutter.language.getProperty("preview"), x, y);
                }
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    SubtitlesTimeline.refreshData();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    String[] text = SubtitlesTimeline.txtSubtitles.getText().split("\\r?\\n");
                    if (text[0].contains("i>") && text[0].contains("b>")) {
                        g2.setFont(new Font("SansSerif", 3, (int)Math.floor(player.getHeight() / 16)));
                    } else if (text[0].contains("i>")) {
                        g2.setFont(new Font("SansSerif", 2, (int)Math.floor(player.getHeight() / 16)));
                    } else if (text[0].contains("b>")) {
                        g2.setFont(new Font("SansSerif", 1, (int)Math.floor(player.getHeight() / 16)));
                    } else {
                        g2.setFont(new Font("SansSerif", 0, (int)Math.floor(player.getHeight() / 16)));
                    }
                    String firstLine = text[0].replace("<i>", "").replace("</i>", "").replace("<b>", "").replace("</b>", "");
                    FontMetrics metrics = g.getFontMetrics(g2.getFont());
                    int x = (player.getWidth() - metrics.stringWidth(firstLine)) / 2;
                    int y = player.getHeight() - player.getHeight() / 24;
                    if (text.length > 1 && text[1].length() > 0) {
                        y = player.getHeight() - (int)((double)player.getHeight() / 9.5);
                        g2.setColor(Color.BLACK);
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                        g2.setColor(Color.WHITE);
                        g2.drawString(firstLine, x, y);
                        if (text[1].contains("i>") && text[1].contains("b>")) {
                            g2.setFont(new Font("SansSerif", 3, (int)Math.floor(player.getHeight() / 16)));
                        } else if (text[1].contains("i>")) {
                            g2.setFont(new Font("SansSerif", 2, (int)Math.floor(player.getHeight() / 16)));
                        } else if (text[1].contains("b>")) {
                            g2.setFont(new Font("SansSerif", 1, (int)Math.floor(player.getHeight() / 16)));
                        } else {
                            g2.setFont(new Font("SansSerif", 0, (int)Math.floor(player.getHeight() / 16)));
                        }
                        String secondLine = text[1].replace("<i>", "").replace("</i>", "").replace("<b>", "").replace("</b>", "");
                        x = (player.getWidth() - metrics.stringWidth(secondLine)) / 2;
                        y = player.getHeight() - player.getHeight() / 24;
                        g2.setColor(Color.BLACK);
                        g2.drawString(secondLine, this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(secondLine, this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                        g2.drawString(secondLine, this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(secondLine, this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                        g2.setColor(Color.WHITE);
                        g2.drawString(secondLine, x, y);
                    } else if (firstLine.length() > 0) {
                        g2.setColor(Color.BLACK);
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                        g2.setColor(Color.WHITE);
                        g2.drawString(firstLine, x, y);
                    }
                }
            }

            private void drawCheckerboard(Graphics2D g2d) {
                int tileSize = 8;
                Color c1 = new Color(200, 200, 200);
                Color c2 = new Color(255, 255, 255);
                int y = 0;
                while (y < this.getHeight()) {
                    int x = 0;
                    while (x < this.getWidth()) {
                        g2d.setColor((x / tileSize + y / tileSize) % 2 == 0 ? c1 : c2);
                        g2d.fillRect(x, y, tileSize, tileSize);
                        x += tileSize;
                    }
                    y += tileSize;
                }
            }

            int ShiftNorth(int p, int distance) {
                return p - distance;
            }

            int ShiftSouth(int p, int distance) {
                return p + distance;
            }

            int ShiftEast(int p, int distance) {
                return p + distance;
            }

            int ShiftWest(int p, int distance) {
                return p - distance;
            }
        };
        player.setTransferHandler(new ListFileTransferHandler());
        player.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !Shutter.noSettings) {
                    Shutter.windowDrag = true;
                    if (fullscreenPlayer) {
                        fullscreenPlayer = false;
                        Shutter.topPanel.setVisible(true);
                        Shutter.grpChooseFiles.setVisible(true);
                        Shutter.grpChooseFunction.setVisible(true);
                        Shutter.grpDestination.setVisible(true);
                        Shutter.grpProgression.setVisible(true);
                        Shutter.statusBar.setVisible(true);
                        Shutter.frame.getContentPane().setBackground(Utils.bg32);
                        Shutter.changeSections(false);
                        if (!isPiping) {
                            VideoPlayer.setPlayerButtons(true);
                            mouseIsPressed = false;
                            VideoPlayer.playerSetTime(playerCurrentFrame);
                        }
                        VideoPlayer.resizeAll();
                        Area shape1 = new Area(new AntiAliasedRoundRectangle(0.0, 0.0, Shutter.frame.getWidth(), Shutter.frame.getHeight(), 15.0, 15.0));
                        Area shape2 = new Area(new Rectangle(0, Shutter.frame.getHeight() - 15, Shutter.frame.getWidth(), 15));
                        shape1.add(shape2);
                        Shutter.frame.setShape(shape1);
                        if (!isPiping) {
                            btnPlay.requestFocus();
                        }
                    } else {
                        fullscreenPlayer = true;
                        VideoPlayer.resizeAll();
                        Shutter.frame.setShape(null);
                        if (!isPiping) {
                            if (fileDuration <= 40.0 || Shutter.comboResolution.getSelectedItem().toString().contains("AI")) {
                                if (preview != null) {
                                    preview = null;
                                }
                                VideoPlayer.loadImage(true);
                            } else {
                                VideoPlayer.playerSetTime(playerCurrentFrame);
                            }
                            if (fileDuration <= 40.0 || Shutter.caseEnableSequence.isSelected()) {
                                do {
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (runProcess.isAlive());
                            } else {
                                do {
                                    try {
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (setTime.isAlive());
                            }
                        }
                        Shutter.frame.requestFocus();
                        Shutter.topPanel.setVisible(false);
                        Shutter.grpChooseFiles.setVisible(false);
                        Shutter.grpChooseFunction.setVisible(false);
                        Shutter.grpDestination.setVisible(false);
                        Shutter.grpProgression.setVisible(false);
                        Shutter.statusBar.setVisible(false);
                        Shutter.frame.getContentPane().setBackground(new Color(0, 0, 0));
                        VideoPlayer.setPlayerButtons(false);
                        Shutter.grpResolution.setVisible(false);
                        Shutter.grpBitrate.setVisible(false);
                        Shutter.grpSetAudio.setVisible(false);
                        Shutter.grpAudio.setVisible(false);
                        Shutter.grpCrop.setVisible(false);
                        Shutter.grpOverlay.setVisible(false);
                        Shutter.grpSubtitles.setVisible(false);
                        Shutter.grpWatermark.setVisible(false);
                        Shutter.grpAudio.setVisible(false);
                        Shutter.grpColorimetry.setVisible(false);
                        Shutter.grpImageAdjustement.setVisible(false);
                        Shutter.grpCorrections.setVisible(false);
                        Shutter.grpTransitions.setVisible(false);
                        Shutter.grpImageSequence.setVisible(false);
                        Shutter.grpImageFilter.setVisible(false);
                        Shutter.grpSetTimecode.setVisible(false);
                        Shutter.grpAdvanced.setVisible(false);
                        Shutter.btnReset.setVisible(false);
                    }
                    Shutter.windowDrag = false;
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                if (fullscreenPlayer && !isPiping) {
                    mouseIsPressed = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (fullscreenPlayer && !isPiping) {
                    if (e.getClickCount() < 2) {
                        mouseClickThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(500L);
                                    mouseIsPressed = false;
                                    sliderChange = false;
                                    if (setTime != null) {
                                        do {
                                            Thread.sleep(1L);
                                        } while (setTime.isAlive());
                                    }
                                    VideoPlayer.playerSetTime(playerCurrentFrame);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        });
                        mouseClickThread.start();
                    } else if (mouseClickThread != null && mouseClickThread.isAlive()) {
                        mouseClickThread.interrupt();
                    }
                }
            }
        });
        player.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (fullscreenPlayer && !isPiping) {
                    double value = (double)slider.getMaximum() * (double)VideoPlayer.cursorWaveform.getLocation().x / (double)VideoPlayer.waveformContainer.getSize().width;
                    sliderChange = true;
                    cursorWaveform.setLocation(e.getX(), VideoPlayer.cursorWaveform.getLocation().y);
                    cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                    if (value < totalFrames) {
                        slider.setValue((int)value);
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        player.setLayout(null);
        player.setBackground(Color.BLACK);
        Shutter.frame.getContentPane().add(player);
    }

    private void sliders() {
        slider = new JSlider();
        slider.setPaintLabels(true);
        slider.setValue(0);
        slider.setVisible(false);
        slider.setBounds(Shutter.grpChooseFiles.getWidth() + 20, player.getY() + player.getHeight() + 26, Shutter.frame.getWidth() - 40 - Shutter.grpChooseFiles.getWidth() * 2, 40);
        Shutter.frame.getContentPane().add(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (playerVideo != null && sliderChange) {
                    if (slider.getValue() > 0) {
                        VideoPlayer.playerSetTime(slider.getValue());
                    } else {
                        VideoPlayer.playerSetTime(0.0);
                    }
                }
            }
        });
        waveformContainer = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(55, 55, 55));
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
                if (Shutter.list.getSize() > 0 && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    if (caseApplyCutToAll.isSelected()) {
                        g2.setColor(Color.GRAY);
                    } else {
                        g2.setColor(Utils.themeColor);
                    }
                    if (playerOutMark > waveformContainer.getWidth() - 2) {
                        playerOutMark = waveformContainer.getWidth() - 2;
                    }
                    if (playerInMark < 0) {
                        playerInMark = 0;
                    }
                    g2.drawRoundRect(playerInMark + 1, 0, playerOutMark - playerInMark, this.getHeight() - 1, 5, 5);
                    if (comboMode.isVisible() && comboMode.getSelectedItem().equals(Shutter.language.getProperty("splitMode"))) {
                        g2.setColor(Utils.themeColor);
                        int alpha = 255;
                        int splitTime = (int)((double)playerInMark + Math.floor((double)(VideoPlayer.waveformContainer.getSize().width * Integer.parseInt(splitValue.getText())) * FFPROBE.accurateFPS / totalFrames));
                        do {
                            g2.fillRect(splitTime + 1, 0, 1, this.getHeight() - 1);
                            splitTime = (int)((double)splitTime + Math.floor((double)(VideoPlayer.waveformContainer.getSize().width * Integer.parseInt(splitValue.getText())) * FFPROBE.accurateFPS / totalFrames));
                            g2.setColor(new Color(Utils.themeColor.getRed(), Utils.themeColor.getGreen(), Utils.themeColor.getBlue(), alpha));
                        } while ((alpha -= 10) >= 0 && splitTime < playerOutMark);
                    }
                    g2.setColor(new Color(35, 35, 40, 120));
                    if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                        g2.fillRoundRect(playerInMark + 2, 1, playerOutMark - playerInMark - 1, this.getHeight() - 2, 5, 5);
                    } else {
                        g2.fillRoundRect(0, 0, playerInMark + 1, this.getHeight() - 1, 5, 5);
                        g2.fillRoundRect(playerOutMark + 2, 0, this.getWidth() - playerOutMark - 2, this.getHeight() - 1, 5, 5);
                    }
                    VideoPlayer.totalDuration();
                }
            }
        };
        waveformContainer.setSize(slider.getWidth() * waveformZoom, slider.getHeight());
        waveformContainer.setPreferredSize(new Dimension(waveformContainer.getWidth(), waveformContainer.getHeight()));
        waveformContainer.setLayout(null);
        Shutter.frame.getContentPane().add(waveformContainer);
        waveformContainer.add(comboAudioTrack);
        cursorHead = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                super.paintComponent(grphcs);
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setColor(new Color(230, 75, 60));
                int[] nArray = new int[3];
                nArray[1] = 5;
                nArray[2] = 10;
                int[] nArray2 = new int[3];
                nArray2[1] = 8;
                g2d.fillPolygon(nArray, nArray2, 3);
            }
        };
        cursorHead.setOpaque(false);
        cursorHead.setSize(10, 10);
        waveformContainer.add(cursorHead);
        cursorWaveform = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                super.paintComponent(grphcs);
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setColor(new Color(230, 75, 60));
                g2d.drawLine(0, 1, 0, waveformContainer.getHeight());
            }
        };
        cursorWaveform.setBounds(0, 0, 1, VideoPlayer.waveformContainer.getSize().height);
        waveformContainer.add(cursorWaveform);
        waveformIcon = new JLabel();
        waveformIcon.setOpaque(false);
        waveformIcon.setLayout(null);
        waveformIcon.setSize(waveformContainer.getSize());
        waveformContainer.add(waveformIcon);
        playerOutMark = waveformContainer.getWidth() - 2;
        waveformContainer.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                mouseIsPressed = true;
                if (NCNN.isRunning) {
                    NCNN.process.destroy();
                    if (preview != null) {
                        preview = null;
                    }
                }
                if (Shutter.list.getSize() > 0) {
                    waveformContainer.requestFocus();
                    sliderChange = true;
                    if (VideoPlayer.playerIsPlaying()) {
                        btnPlay.setIcon(new FlatSVGIcon("contents/pause.svg", 15, 15));
                        btnPlay.setName("pause");
                    }
                    if (e.getX() >= 0 && e.getX() <= waveformContainer.getWidth() - 2) {
                        cursorWaveform.setLocation(e.getX(), VideoPlayer.cursorWaveform.getLocation().y);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        slider.setValue((int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width));
                    } else if (e.getX() < 0) {
                        cursorWaveform.setLocation(0, VideoPlayer.cursorWaveform.getLocation().y);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        slider.setValue((int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width));
                    } else if (e.getX() > waveformContainer.getWidth() - 2) {
                        cursorWaveform.setLocation(waveformContainer.getWidth() - 2, VideoPlayer.cursorWaveform.getLocation().y);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        slider.setValue((int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width));
                    }
                    while (setTime.isAlive()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                mouseIsPressed = false;
                if (Shutter.list.getSize() > 0) {
                    while (setTime.isAlive()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    double timeIn = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    double timeOut = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                    playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeIn / (double)slider.getMaximum());
                    playerOutMark = (int)Timecode.getNTSCtimecode(timeOut) < (int)totalFrames ? (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeOut / (double)slider.getMaximum()) : waveformContainer.getWidth();
                    if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && cursorWaveform.getX() < playerOutMark && mouseIsPressed) {
                        cursorWaveform.setLocation(playerInMark, 0);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        VideoPlayer.updateGrpIn(playerCurrentFrame);
                    } else if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && cursorWaveform.getX() > playerInMark && mouseIsPressed) {
                        cursorWaveform.setLocation(playerOutMark, 0);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        VideoPlayer.updateGrpOut(playerCurrentFrame);
                    }
                    sliderChange = false;
                    do {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (setTime.isAlive());
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    waveformContainer.repaint();
                    waveformContainer.setCursor(Cursor.getPredefinedCursor(0));
                    VideoPlayer.setFileList();
                }
            }
        });
        waveformContainer.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Shutter.list.getSize() > 0) {
                    if (e.getX() > 0 && e.getX() <= waveformContainer.getWidth() - 2) {
                        double value = (double)slider.getMaximum() * (double)VideoPlayer.cursorWaveform.getLocation().x / (double)VideoPlayer.waveformContainer.getSize().width;
                        sliderChange = true;
                        cursorWaveform.setLocation(e.getX(), VideoPlayer.cursorWaveform.getLocation().y);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        if (value < totalFrames) {
                            slider.setValue((int)value);
                        }
                    } else if (e.getX() <= 0) {
                        sliderChange = true;
                        cursorWaveform.setLocation(0, VideoPlayer.cursorWaveform.getLocation().y);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        slider.setValue(0);
                        VideoPlayer.playerSetTime(0.0);
                    } else if (e.getX() > waveformContainer.getWidth() - 2) {
                        sliderChange = true;
                        cursorWaveform.setLocation(waveformContainer.getWidth() - 2, VideoPlayer.cursorWaveform.getLocation().y);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                        slider.setValue((int)totalFrames);
                        VideoPlayer.playerSetTime(totalFrames);
                    }
                    if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && cursorWaveform.getX() < playerOutMark && mouseIsPressed) {
                        playerInMark = cursorWaveform.getX();
                        waveformContainer.repaint();
                    } else if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && cursorWaveform.getX() > playerInMark && mouseIsPressed) {
                        playerOutMark = cursorWaveform.getX();
                        waveformContainer.repaint();
                    }
                    if (cursorWaveform.getX() > waveformScrollPane.getWidth() + waveformScrollPane.getHorizontalScrollBar().getValue()) {
                        waveformScrollPane.getHorizontalScrollBar().setValue(cursorWaveform.getX() - slider.getWidth() + 1);
                    } else if (cursorWaveform.getX() < waveformScrollPane.getHorizontalScrollBar().getValue()) {
                        waveformScrollPane.getHorizontalScrollBar().setValue(cursorWaveform.getX());
                    }
                    cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!caseApplyCutToAll.isVisible() || !caseApplyCutToAll.isSelected()) {
                    if (e.getX() >= playerInMark - 5 && e.getX() <= playerInMark + 5) {
                        waveformContainer.setCursor(Cursor.getPredefinedCursor(10));
                    } else if (e.getX() >= playerOutMark - 5 && e.getX() <= playerOutMark + 5) {
                        waveformContainer.setCursor(Cursor.getPredefinedCursor(11));
                    } else {
                        waveformContainer.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        waveformContainer.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getPreciseWheelRotation() < 0.0) {
                    if (waveformZoom < 100) {
                        waveformZoom = waveformZoom >= 20 ? (waveformZoom += 10) : ++waveformZoom;
                    }
                } else if (waveformZoom > 1) {
                    waveformZoom = waveformZoom >= 20 ? (waveformZoom -= 10) : --waveformZoom;
                }
                waveformContainer.setSize(slider.getWidth() * waveformZoom, slider.getHeight());
                waveformContainer.setPreferredSize(new Dimension(waveformContainer.getWidth(), waveformContainer.getHeight()));
                double timeIn = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                double timeOut = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeIn / (double)slider.getMaximum());
                playerOutMark = (int)Timecode.getNTSCtimecode(timeOut) < (int)totalFrames ? (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeOut / (double)slider.getMaximum()) : waveformContainer.getWidth();
                waveformContainer.repaint();
                cursorWaveform.setBounds((int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * Timecode.setNTSCtimecode(slider.getValue()) / (double)slider.getMaximum()), 0, 1, VideoPlayer.waveformContainer.getSize().height);
                cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                cursorCurrentFrame.setBounds((int)Math.round((double)waveformContainer.getWidth() * Timecode.setNTSCtimecode(playerCurrentFrame) / (double)slider.getMaximum()), 0, 1, waveformContainer.getHeight());
                if (waveformIcon.isVisible() && waveformIcon.getIcon() != null) {
                    waveformIcon.setSize(waveformContainer.getSize());
                    ImageIcon resizedWaveform = new ImageIcon(new ImageIcon(waveform).getImage().getScaledInstance(waveformContainer.getWidth(), waveformContainer.getHeight(), 16));
                    waveformIcon.setIcon(resizedWaveform);
                    waveformIcon.repaint();
                }
                int viewportWidth = waveformScrollPane.getViewport().getWidth();
                int newViewPosX = cursorWaveform.getX() - viewportWidth / 2;
                int maxViewPosX = waveformContainer.getWidth() - viewportWidth;
                newViewPosX = Math.max(0, Math.min(newViewPosX, maxViewPosX));
                waveformScrollPane.getViewport().setViewPosition(new Point(newViewPosX, 0));
            }
        });
        cursorCurrentFrame = new JPanel(){

            @Override
            protected void paintComponent(Graphics grphcs) {
                super.paintComponent(grphcs);
                Graphics2D g2d = (Graphics2D)grphcs;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g2d.setColor(Color.WHITE);
                g2d.drawLine(0, 1, 0, waveformContainer.getHeight());
            }
        };
        waveformContainer.add(cursorCurrentFrame);
        waveformScrollPane = new JScrollPane();
        waveformScrollPane.getViewport().add(waveformContainer);
        waveformScrollPane.setHorizontalScrollBarPolicy(32);
        waveformScrollPane.setVerticalScrollBarPolicy(21);
        waveformScrollPane.getViewport().setOpaque(false);
        waveformScrollPane.setBorder(null);
        Shutter.frame.getContentPane().add((Component)waveformScrollPane, "Center");
        sliderVolume.setName("sliderVolume");
        sliderVolume.setVisible(false);
        sliderVolume.setValue(50);
        Shutter.frame.getContentPane().add(sliderVolume);
        sliderVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (playerAudio != null && playerAudio.isAlive()) {
                    float gain = (float)sliderVolume.getValue() / 100.0f;
                    float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0) + (float)sliderVolume.getValue() / 16.666666f;
                    if (gainControl != null) {
                        gainControl.setValue(dB);
                    }
                }
            }
        });
        lblVolume = new JLabel(new FlatSVGIcon("contents/volume.svg", 15, 15));
        lblVolume.setFont(new Font("", 0, 12));
        lblVolume.setVisible(false);
        lblVolume.setSize(VideoPlayer.lblVolume.getPreferredSize().width + 3, 16);
        lblVolume.setLocation(btnGoToOut.getX() + btnGoToOut.getWidth() + 7, sliderVolume.getY() + 2);
        lblVolume.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (sliderVolume.getValue() > 0) {
                    sliderVolume.setValue(0);
                } else {
                    sliderVolume.setValue(50);
                }
            }
        });
        Shutter.frame.getContentPane().add(lblVolume);
    }

    private void grpIn() {
        caseInH = new JTextField();
        caseInH.setName("caseInH");
        caseInH.setText("00");
        caseInH.setHorizontalAlignment(4);
        caseInH.setFont(new Font(Shutter.mainFont, 0, 13));
        caseInH.setColumns(10);
        Shutter.frame.getContentPane().add(caseInH);
        caseInM = new JTextField();
        caseInM.setName("caseInM");
        caseInM.setText("00");
        caseInM.setHorizontalAlignment(4);
        caseInM.setFont(new Font(Shutter.mainFont, 0, 13));
        caseInM.setColumns(10);
        Shutter.frame.getContentPane().add(caseInM);
        caseInS = new JTextField();
        caseInS.setName("caseInS");
        caseInS.setText("00");
        caseInS.setHorizontalAlignment(4);
        caseInS.setFont(new Font(Shutter.mainFont, 0, 13));
        caseInS.setColumns(10);
        caseInS.setBounds(caseInM.getX() + caseInM.getWidth() + 2, 17, 21, 21);
        Shutter.frame.getContentPane().add(caseInS);
        caseInF = new JTextField();
        caseInF.setName("caseInF");
        caseInF.setText("00");
        caseInF.setHorizontalAlignment(4);
        caseInF.setFont(new Font(Shutter.mainFont, 0, 13));
        caseInF.setColumns(10);
        Shutter.frame.getContentPane().add(caseInF);
        caseInH.setBounds(slider.getX() - 2, btnPrevious.getY(), 21, 21);
        caseInM.setBounds(caseInH.getX() + caseInH.getWidth(), caseInH.getY(), 21, 21);
        caseInS.setBounds(caseInM.getX() + caseInM.getWidth(), caseInH.getY(), 21, 21);
        caseInF.setBounds(caseInS.getX() + caseInS.getWidth(), caseInH.getY(), 21, 21);
        sliderSpeed = new JSlider();
        sliderSpeed.setMaximum(4);
        sliderSpeed.setValue(2);
        sliderSpeed.setVisible(false);
        sliderSpeed.setMinorTickSpacing(1);
        sliderSpeed.setMajorTickSpacing(1);
        sliderSpeed.setSize(80, 22);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            Shutter.frame.getContentPane().add(sliderSpeed);
        }
        sliderSpeed.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (sliderSpeed.isEnabled()) {
                    if (e.getX() < 20) {
                        sliderSpeed.setValue(0);
                        lblSpeed.setText("x0.25");
                    } else if (e.getX() > 10 && e.getX() < 30) {
                        sliderSpeed.setValue(1);
                        lblSpeed.setText("x0.5");
                    } else if (e.getX() > 30 && e.getX() < 50) {
                        sliderSpeed.setValue(2);
                        lblSpeed.setText("x1");
                    } else if (e.getX() > 50 && e.getX() < 70) {
                        sliderSpeed.setValue(3);
                        lblSpeed.setText("x1.5");
                    } else if (e.getX() > 70) {
                        sliderSpeed.setValue(4);
                        lblSpeed.setText("x2");
                    }
                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        sliderSpeed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && sliderSpeed.isEnabled()) {
                    sliderSpeed.setValue(2);
                    lblSpeed.setText("x1");
                    if (slider.getValue() > 0) {
                        frameIsComplete = false;
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (sliderSpeed.isEnabled()) {
                    if (e.getX() < 20) {
                        sliderSpeed.setValue(0);
                        lblSpeed.setText("x0.25");
                    } else if (e.getX() > 10 && e.getX() < 30) {
                        sliderSpeed.setValue(1);
                        lblSpeed.setText("x0.5");
                    } else if (e.getX() > 30 && e.getX() < 50) {
                        sliderSpeed.setValue(2);
                        lblSpeed.setText("x1");
                    } else if (e.getX() > 50 && e.getX() < 70) {
                        sliderSpeed.setValue(3);
                        lblSpeed.setText("x1.5");
                    } else if (e.getX() > 70) {
                        sliderSpeed.setValue(4);
                        lblSpeed.setText("x2");
                    }
                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                    if (slider.getValue() > 0) {
                        frameIsComplete = false;
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                }
            }
        });
        lblSpeed = new JLabel("x1");
        lblSpeed.setHorizontalAlignment(4);
        lblSpeed.setFont(new Font(Shutter.mainFont, 0, 13));
        lblSpeed.setVisible(false);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            Shutter.frame.getContentPane().add(lblSpeed);
        }
        caseInH.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInH.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInH.setText(String.valueOf(Integer.parseInt(caseInH.getText()) + 1));
                        if (caseInH.getText().length() == 1) {
                            caseInH.setText("0" + caseInH.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInH.setText(String.valueOf(Integer.parseInt(caseInH.getText()) - 1));
                        if (caseInH.getText().length() == 1) {
                            caseInH.setText("0" + caseInH.getText());
                        }
                    }
                }
                if (caseInH.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInH.getText().length() == 1) {
                        caseInH.setText("0" + caseInH.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInH.getText().length() >= 2) {
                    caseInH.setText("");
                }
            }
        });
        caseInH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInH.getText().length() == 1) {
                    caseInH.setText("0" + caseInH.getText());
                }
            }
        });
        caseInM.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInM.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInM.setText(String.valueOf(Integer.parseInt(caseInM.getText()) + 1));
                        if (caseInM.getText().length() == 1) {
                            caseInM.setText("0" + caseInM.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInM.setText(String.valueOf(Integer.parseInt(caseInM.getText()) - 1));
                        if (caseInM.getText().length() == 1) {
                            caseInM.setText("0" + caseInM.getText());
                        }
                    }
                }
                if (caseInM.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInM.getText().length() == 1) {
                        caseInM.setText("0" + caseInM.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInM.getText().length() >= 2) {
                    caseInM.setText("");
                }
            }
        });
        caseInM.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInM.getText().length() == 1) {
                    caseInM.setText("0" + caseInM.getText());
                }
            }
        });
        caseInS.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInS.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInS.setText(String.valueOf(Integer.parseInt(caseInS.getText()) + 1));
                        if (caseInS.getText().length() == 1) {
                            caseInS.setText("0" + caseInS.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInS.setText(String.valueOf(Integer.parseInt(caseInS.getText()) - 1));
                        if (caseInS.getText().length() == 1) {
                            caseInS.setText("0" + caseInS.getText());
                        }
                    }
                }
                if (caseInS.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInS.getText().length() == 1) {
                        caseInS.setText("0" + caseInS.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInS.getText().length() >= 2) {
                    caseInS.setText("");
                }
            }
        });
        caseInS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInS.getText().length() == 1) {
                    caseInS.setText("0" + caseInS.getText());
                }
            }
        });
        caseInF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInF.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInF.setText(String.valueOf(Integer.parseInt(caseInF.getText()) + 1));
                        if (caseInF.getText().length() == 1) {
                            caseInF.setText("0" + caseInF.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInF.setText(String.valueOf(Integer.parseInt(caseInF.getText()) - 1));
                        if (caseInF.getText().length() == 1) {
                            caseInF.setText("0" + caseInF.getText());
                        }
                    }
                }
                if (caseInF.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInF.getText().length() == 1) {
                        caseInF.setText("0" + caseInF.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInF.getText().length() >= 2) {
                    caseInF.setText("");
                }
            }
        });
        caseInF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInF.getText().length() == 1) {
                    caseInF.setText("0" + caseInF.getText());
                }
            }
        });
    }

    public static void updateGrpIn(double timeIn) {
        if (timeIn > 0.0) {
            timeIn = Timecode.setNTSCtimecode(timeIn);
        }
        caseInH.setText(Shutter.formatter.format(Math.floor(timeIn / FFPROBE.accurateFPS / 3600.0)));
        caseInM.setText(Shutter.formatter.format(Math.floor(timeIn / FFPROBE.accurateFPS / 60.0) % 60.0));
        caseInS.setText(Shutter.formatter.format(Math.floor(timeIn / FFPROBE.accurateFPS) % 60.0));
        caseInF.setText(Shutter.formatter.format(Math.floor(timeIn % FFPROBE.accurateFPS)));
        if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            Shutter.txtAudioOffset.setText(String.valueOf((int)timeIn));
            if (timeIn > 0.0) {
                if (!Shutter.caseAudioOffset.isSelected()) {
                    Shutter.caseAudioOffset.doClick();
                }
            } else if (Shutter.caseAudioOffset.isSelected()) {
                Shutter.caseAudioOffset.doClick();
            }
        }
    }

    private void grpOut() {
        caseOutH = new JTextField();
        caseOutH.setName("caseOutH");
        caseOutH.setText("00");
        caseOutH.setHorizontalAlignment(4);
        caseOutH.setFont(new Font(Shutter.mainFont, 0, 13));
        caseOutH.setColumns(10);
        Shutter.frame.getContentPane().add(caseOutH);
        caseOutM = new JTextField();
        caseOutM.setName("caseOutM");
        caseOutM.setText("00");
        caseOutM.setHorizontalAlignment(4);
        caseOutM.setFont(new Font(Shutter.mainFont, 0, 13));
        caseOutM.setColumns(10);
        Shutter.frame.getContentPane().add(caseOutM);
        caseOutS = new JTextField();
        caseOutS.setName("caseOutS");
        caseOutS.setText("00");
        caseOutS.setHorizontalAlignment(4);
        caseOutS.setFont(new Font(Shutter.mainFont, 0, 13));
        caseOutS.setColumns(10);
        Shutter.frame.getContentPane().add(caseOutS);
        caseOutF = new JTextField();
        caseOutF.setName("caseOutF");
        caseOutF.setText("00");
        caseOutF.setHorizontalAlignment(4);
        caseOutF.setFont(new Font(Shutter.mainFont, 0, 13));
        caseOutF.setColumns(10);
        Shutter.frame.getContentPane().add(caseOutF);
        caseOutH.setBounds(slider.getX() + slider.getWidth() - 84, caseInH.getY(), 21, 21);
        caseOutM.setBounds(caseOutH.getX() + caseOutH.getWidth(), caseOutH.getY(), 21, 21);
        caseOutS.setBounds(caseOutM.getX() + caseOutM.getWidth(), caseOutH.getY(), 21, 21);
        caseOutF.setBounds(caseOutS.getX() + caseOutS.getWidth(), caseOutH.getY(), 21, 21);
        caseOutH.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutH.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutH.setText(String.valueOf(Integer.parseInt(caseOutH.getText()) + 1));
                        if (caseOutH.getText().length() == 1) {
                            caseOutH.setText("0" + caseOutH.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutH.setText(String.valueOf(Integer.parseInt(caseOutH.getText()) - 1));
                        if (caseOutH.getText().length() == 1) {
                            caseOutH.setText("0" + caseOutH.getText());
                        }
                    }
                }
                if (caseOutH.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutH.getText().length() == 1) {
                        caseOutH.setText("0" + caseOutH.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText()) - 1.0;
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutH.getText().length() >= 2) {
                    caseOutH.setText("");
                }
            }
        });
        caseOutH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutH.getText().length() == 1) {
                    caseOutH.setText("0" + caseOutH.getText());
                }
            }
        });
        caseOutM.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutM.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutM.setText(String.valueOf(Integer.parseInt(caseOutM.getText()) + 1));
                        if (caseOutM.getText().length() == 1) {
                            caseOutM.setText("0" + caseOutM.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutM.setText(String.valueOf(Integer.parseInt(caseOutM.getText()) - 1));
                        if (caseOutM.getText().length() == 1) {
                            caseOutM.setText("0" + caseOutM.getText());
                        }
                    }
                }
                if (caseOutM.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutM.getText().length() == 1) {
                        caseOutM.setText("0" + caseOutM.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText()) - 1.0;
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutM.getText().length() >= 2) {
                    caseOutM.setText("");
                }
            }
        });
        caseOutM.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutM.getText().length() == 1) {
                    caseOutM.setText("0" + caseOutM.getText());
                }
            }
        });
        caseOutS.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutS.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutS.setText(String.valueOf(Integer.parseInt(caseOutS.getText()) + 1));
                        if (caseOutS.getText().length() == 1) {
                            caseOutS.setText("0" + caseOutS.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutS.setText(String.valueOf(Integer.parseInt(caseOutS.getText()) - 1));
                        if (caseOutS.getText().length() == 1) {
                            caseOutS.setText("0" + caseOutS.getText());
                        }
                    }
                }
                if (caseOutS.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutS.getText().length() == 1) {
                        caseOutS.setText("0" + caseOutS.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText()) - 1.0;
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutS.getText().length() >= 2) {
                    caseOutS.setText("");
                }
            }
        });
        caseOutS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutS.getText().length() == 1) {
                    caseOutS.setText("0" + caseOutS.getText());
                }
            }
        });
        caseOutF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutF.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutF.setText(String.valueOf(Integer.parseInt(caseOutF.getText()) + 1));
                        if (caseOutF.getText().length() == 1) {
                            caseOutF.setText("0" + caseOutF.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutF.setText(String.valueOf(Integer.parseInt(caseOutF.getText()) - 1));
                        if (caseOutF.getText().length() == 1) {
                            caseOutF.setText("0" + caseOutF.getText());
                        }
                    }
                }
                if (caseOutF.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutF.getText().length() == 1) {
                        caseOutF.setText("0" + caseOutF.getText());
                    }
                    playerCurrentFrame = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText()) - 1.0;
                    playerCurrentFrame = Timecode.getNTSCtimecode(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (double)slider.getMaximum());
                    waveformContainer.repaint();
                    VideoPlayer.setFileList();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutF.getText().length() >= 2) {
                    caseOutF.setText("");
                }
            }
        });
        caseOutF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutF.getText().length() == 1) {
                    caseOutF.setText("0" + caseOutF.getText());
                }
            }
        });
    }

    public static void updateGrpOut(double timeOut) {
        timeOut = playerOutMark < waveformContainer.getWidth() - 2 ? Timecode.setNTSCtimecode(timeOut) : Timecode.setNTSCtimecode(totalFrames);
        caseOutH.setText(Shutter.formatter.format(Math.floor(timeOut / FFPROBE.accurateFPS / 3600.0)));
        caseOutM.setText(Shutter.formatter.format(Math.floor(timeOut / FFPROBE.accurateFPS / 60.0) % 60.0));
        caseOutS.setText(Shutter.formatter.format(Math.floor(timeOut / FFPROBE.accurateFPS) % 60.0));
        caseOutF.setText(Shutter.formatter.format(Math.floor(timeOut % FFPROBE.accurateFPS)));
    }

    private void playerOptions() {
        caseShowWaveform.setName("caseShowWaveform");
        caseShowWaveform.setFont(new Font(Shutter.mainFont, 0, 12));
        caseShowWaveform.setSelected(true);
        Shutter.frame.getContentPane().add(caseShowWaveform);
        caseShowWaveform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseShowWaveform.isSelected()) {
                    if (waveform != null) {
                        VideoPlayer.addWaveform(false);
                    } else {
                        VideoPlayer.addWaveform(true);
                    }
                } else {
                    if (addWaveformIsRunning) {
                        try {
                            FFMPEG.waveformWriter.write(113);
                            FFMPEG.waveformWriter.flush();
                            FFMPEG.waveformWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        FFMPEG.waveformProcess.destroy();
                    }
                    waveformIcon.setVisible(false);
                }
            }
        });
        caseVuMeter.setName("caseVuMeter");
        caseVuMeter.setFont(new Font(Shutter.mainFont, 0, 12));
        caseVuMeter.setSelected(true);
        Shutter.frame.getContentPane().add(caseVuMeter);
        caseVuMeter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (bufferedFrames.size() > 0) {
                    bufferedFrames.clear();
                }
                frameIsComplete = false;
                VideoPlayer.playerSetTime(playerCurrentFrame);
            }
        });
        casePlaySound.setName("casePlaySound");
        casePlaySound.setFont(new Font(Shutter.mainFont, 0, 12));
        casePlaySound.setSelected(true);
        Shutter.frame.getContentPane().add(casePlaySound);
        caseInternalTc = new JCheckBox(Shutter.language.getProperty("caseTcInterne"));
        caseInternalTc.setFont(new Font(Shutter.mainFont, 0, 12));
        Shutter.frame.getContentPane().add(caseInternalTc);
        btnPreview = new JLabel(new FlatSVGIcon("contents/preview.svg", 16, 16));
        btnPreview.setHorizontalAlignment(0);
        btnPreview.setToolTipText(Shutter.language.getProperty("preview"));
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            Shutter.frame.getContentPane().add(btnPreview);
        }
        btnPreview.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FFMPEG.toSDL(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                btnPreview.setIcon(new FlatSVGIcon("contents/preview_hover.svg", 16, 16));
                Shutter.frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btnPreview.setIcon(new FlatSVGIcon("contents/preview.svg", 16, 16));
                Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        splitValue = new JTextField();
        splitValue.setName("splitValue");
        splitValue.setText("10");
        splitValue.setVisible(false);
        splitValue.setHorizontalAlignment(4);
        splitValue.setFont(new Font(Shutter.mainFont, 0, 12));
        splitValue.setColumns(10);
        Shutter.frame.getContentPane().add(splitValue);
        splitValue.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (splitValue.getText().length() > 0 && e.getKeyCode() == 10) {
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (splitValue.getText().length() >= 4) {
                    splitValue.setText("");
                }
            }
        });
        lblSplitSec = new JLabel(Shutter.language.getProperty("lblSec"));
        lblSplitSec.setHorizontalAlignment(4);
        lblSplitSec.setFont(new Font(Shutter.mainFont, 0, 12));
        lblSplitSec.setVisible(false);
        lblSplitSec.setBounds(splitValue.getX() + splitValue.getWidth() + 2, splitValue.getY(), VideoPlayer.lblSplitSec.getPreferredSize().width, 16);
        Shutter.frame.getContentPane().add(lblSplitSec);
        comboMode.setName("comboMode");
        comboMode.setFont(new Font(Shutter.mainFont, 0, 11));
        comboMode.setMaximumRowCount(3);
        comboMode.setSize(76, 22);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            Shutter.frame.getContentPane().add(comboMode);
        }
        comboMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                btnPreview.setBounds(slider.getX() + slider.getWidth() - 16, caseInternalTc.getY() + 2, 16, 16);
                lblSplitSec.setBounds(btnPreview.getX() + 10, caseInternalTc.getY() + 2, VideoPlayer.lblSplitSec.getPreferredSize().width, 16);
                splitValue.setBounds(lblSplitSec.getX() - splitValue.getWidth() - 2, caseInternalTc.getY() + 2, 34, 16);
                if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                    if (showInfoMessage) {
                        JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("mayNotWorkWithGOP"), Shutter.language.getProperty("mode") + " " + Shutter.language.getProperty("removeMode"), 1);
                        showInfoMessage = false;
                    }
                    btnPreview.setVisible(true);
                    splitValue.setVisible(false);
                    lblSplitSec.setVisible(false);
                    comboMode.setLocation(btnPreview.getX() - comboMode.getWidth() - 4, caseInternalTc.getY() - 1);
                    caseApplyCutToAll.setEnabled(false);
                    caseApplyCutToAll.setSelected(false);
                } else if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("splitMode"))) {
                    btnPreview.setVisible(false);
                    splitValue.setVisible(true);
                    lblSplitSec.setVisible(true);
                    comboMode.setLocation(splitValue.getX() - comboMode.getWidth() - 4, caseInternalTc.getY() - 1);
                    caseApplyCutToAll.setEnabled(true);
                } else {
                    btnPreview.setVisible(true);
                    splitValue.setVisible(false);
                    lblSplitSec.setVisible(false);
                    comboMode.setLocation(btnPreview.getX() - comboMode.getWidth() - 4, caseInternalTc.getY() - 1);
                    caseApplyCutToAll.setEnabled(true);
                }
                lblMode.setBounds(comboMode.getX() - VideoPlayer.lblMode.getPreferredSize().width - 4, caseInternalTc.getY() + 3, VideoPlayer.lblMode.getPreferredSize().width, 16);
                caseVuMeter.setBounds(lblMode.getX() - VideoPlayer.caseVuMeter.getPreferredSize().width - 5, caseInternalTc.getY(), VideoPlayer.caseVuMeter.getPreferredSize().width, 23);
                caseShowWaveform.setBounds(caseVuMeter.getX() - VideoPlayer.caseShowWaveform.getPreferredSize().width - 5, caseVuMeter.getY(), VideoPlayer.caseShowWaveform.getPreferredSize().width, 23);
                waveformContainer.repaint();
            }
        });
        lblMode = new JLabel(Shutter.language.getProperty("mode"));
        lblMode.setHorizontalAlignment(4);
        lblMode.setFont(new Font(Shutter.mainFont, 0, 13));
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            Shutter.frame.getContentPane().add(lblMode);
        }
        caseInternalTc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseInternalTc.isSelected()) {
                    FFPROBE.Data(videoPath);
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    if (FFPROBE.timecode1.equals("")) {
                        MEDIAINFO.run(videoPath, false);
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (MEDIAINFO.isRunning);
                    }
                    if (FFPROBE.timecode1.equals("")) {
                        caseInternalTc.setSelected(false);
                        offset = 0.0;
                    } else {
                        offset = (double)(Integer.valueOf(FFPROBE.timecode1) * 3600) * FFPROBE.accurateFPS + (double)(Integer.valueOf(FFPROBE.timecode2) * 60) * FFPROBE.accurateFPS + (double)Integer.valueOf(FFPROBE.timecode3).intValue() * FFPROBE.accurateFPS + (double)Integer.valueOf(FFPROBE.timecode4).intValue();
                    }
                } else {
                    offset = 0.0;
                }
                sliderChange = true;
                VideoPlayer.getTimePoint(playerCurrentFrame);
                sliderChange = false;
            }
        });
    }

    public static void checkSelection() {
        double ratioW = (double)FFPROBE.imageWidth / (double)player.getWidth();
        double ratioH = (double)FFPROBE.imageHeight / (double)player.getHeight();
        int outW = (int)Math.round((double)Shutter.selection.getWidth() * ratioW);
        int outH = (int)Math.round((double)Shutter.selection.getHeight() * ratioH);
        int Px = (int)Math.round((double)Shutter.selection.getLocation().x * ratioW);
        int Py = (int)Math.round((double)Shutter.selection.getLocation().y * ratioH);
        if (Shutter.textCropWidth.getText().matches("[0-9]+") && Shutter.textCropHeight.getText().matches("[0-9]+")) {
            if (Px + Integer.valueOf(Shutter.textCropWidth.getText()) > FFPROBE.imageWidth) {
                Px += FFPROBE.imageWidth - (Px + Integer.valueOf(Shutter.textCropWidth.getText()));
            }
            if (Py + Integer.valueOf(Shutter.textCropHeight.getText()) > FFPROBE.imageHeight) {
                Py += FFPROBE.imageHeight - (Py + Integer.valueOf(Shutter.textCropHeight.getText()));
            }
            if (Integer.valueOf(Shutter.textCropWidth.getText()) != FFPROBE.imageWidth) {
                Shutter.textCropPosX.setText(String.valueOf(Px));
            }
            if (Integer.valueOf(Shutter.textCropHeight.getText()) != FFPROBE.imageHeight) {
                Shutter.textCropPosY.setText(String.valueOf(Py));
            }
        } else {
            Shutter.textCropPosX.setText(String.valueOf(Px));
            Shutter.textCropPosY.setText(String.valueOf(Py));
        }
        if (Shutter.frame.getCursor() != Cursor.getPredefinedCursor(13)) {
            Shutter.textCropWidth.setText(String.valueOf(outW));
            Shutter.textCropHeight.setText(String.valueOf(outH));
        }
    }

    public static void refreshTimecodeAndText() {
        String c;
        if (Shutter.foregroundColor != null) {
            c = Integer.toHexString(Shutter.foregroundColor.getRGB()).substring(2);
            Shutter.foregroundHex = c.substring(0, 2) + c.substring(2, 4) + c.substring(4, 6);
        } else {
            Shutter.foregroundColor = new Color(255, 255, 255);
        }
        if (Shutter.backgroundColor != null) {
            c = Integer.toHexString(Shutter.backgroundColor.getRGB()).substring(2);
            Shutter.backgroundHex = c.substring(0, 2) + c.substring(2, 4) + c.substring(4, 6);
        } else {
            Shutter.backgroundColor = new Color(0, 0, 0);
        }
        if (Shutter.lblTcBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
            Shutter.backgroundTcAlpha = Integer.toHexString((int)((double)(Integer.parseInt(Shutter.textTcOpacity.getText()) * 255)) / 100);
            Shutter.foregroundTcAlpha = "ff";
            Shutter.backgroundNameAlpha = Integer.toHexString((int)((double)(Integer.parseInt(Shutter.textNameOpacity.getText()) * 255)) / 100);
            Shutter.foregroundNameAlpha = "ff";
        } else {
            Shutter.backgroundTcAlpha = "0";
            Shutter.foregroundTcAlpha = Integer.toHexString((int)((double)(Integer.parseInt(Shutter.textTcOpacity.getText()) * 255)) / 100);
            Shutter.backgroundNameAlpha = "0";
            Shutter.foregroundNameAlpha = Integer.toHexString((int)((double)(Integer.parseInt(Shutter.textNameOpacity.getText()) * 255)) / 100);
        }
        if (Shutter.backgroundTcAlpha.length() < 2) {
            Shutter.backgroundTcAlpha = "0" + Shutter.backgroundTcAlpha;
        }
        if (Shutter.foregroundTcAlpha.length() < 2) {
            Shutter.foregroundTcAlpha = "0" + Shutter.foregroundTcAlpha;
        }
        if (Shutter.backgroundNameAlpha.length() < 2) {
            Shutter.backgroundNameAlpha = "0" + Shutter.backgroundNameAlpha;
        }
        if (Shutter.foregroundNameAlpha.length() < 2) {
            Shutter.foregroundNameAlpha = "0" + Shutter.foregroundNameAlpha;
        }
        if (Shutter.caseAddTimecode.isSelected() || Shutter.caseShowTimecode.isSelected()) {
            Shutter.textTcPosX.setText(String.valueOf(Math.round((float)Shutter.timecode.getLocation().x * Shutter.playerRatio)));
            Shutter.textTcPosY.setText(String.valueOf(Math.round((float)Shutter.timecode.getLocation().y * Shutter.playerRatio)));
        } else {
            Shutter.textTcPosX.setText("0");
            Shutter.textTcPosY.setText("0");
        }
        if (Shutter.caseShowFileName.isSelected() || Shutter.caseAddText.isSelected()) {
            Shutter.textNamePosX.setText(String.valueOf(Math.round((float)Shutter.fileName.getLocation().x * Shutter.playerRatio)));
            Shutter.textNamePosY.setText(String.valueOf(Math.round((float)Shutter.fileName.getLocation().y * Shutter.playerRatio)));
        } else {
            Shutter.textNamePosX.setText("0");
            Shutter.textNamePosY.setText("0");
        }
    }

    public static void refreshSubtitles() {
        if (Shutter.alphaHeight == 0) {
            Shutter.alphaHeight = FFPROBE.imageHeight;
        }
        int v = Integer.parseInt(Shutter.textSubtitlesPosition.getText());
        int sz = Integer.parseInt(Shutter.textSubsSize.getText());
        int newValue = (int)Math.round((double)sz * ((double)Shutter.alphaHeight / (double)(FFPROBE.imageHeight + v)));
        if (newValue > 0) {
            Shutter.textSubsSize.setText(String.valueOf(newValue));
        }
        Shutter.alphaHeight = FFPROBE.imageHeight + v;
        if (Integer.parseInt(Shutter.textSubsWidth.getText()) >= FFPROBE.imageWidth) {
            Shutter.subsCanvas.setBounds(0, 0, player.getWidth(), (int)((double)player.getHeight() + (double)Integer.parseInt(Shutter.textSubtitlesPosition.getText()) / ((double)FFPROBE.imageHeight / (double)player.getHeight())));
        } else {
            Shutter.subsCanvas.setSize((int)((double)Integer.parseInt(Shutter.textSubsWidth.getText()) / ((double)FFPROBE.imageHeight / (double)player.getHeight())), (int)((double)player.getHeight() + (double)Integer.parseInt(Shutter.textSubtitlesPosition.getText()) / ((double)FFPROBE.imageHeight / (double)player.getHeight())));
            Shutter.subsCanvas.setLocation((player.getWidth() - Shutter.subsCanvas.getWidth()) / 2, 0);
        }
        VideoPlayer.loadImage(false);
    }

    public static void writeCurrentSubs(double inputTime, boolean firstSub) {
        if (Shutter.caseAddSubtitles.isSelected() && Shutter.subtitlesFilePath.exists() && Shutter.subtitlesFile.toString().substring(Shutter.subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
            try {
                String line;
                BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(Shutter.subtitlesFilePath.toString(), new String[0]), StandardCharsets.UTF_8);
                BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(Shutter.subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                Integer subsOffset = 0;
                int subNumber = 0;
                boolean startWriting = false;
                while ((line = bufferedReader.readLine()) != null) {
                    if ((line = line.replace("\ufeff", "")).contains("-->")) {
                        if (subNumber == 0) {
                            String[] s = line.split(":");
                            subsOffset = Integer.parseInt(s[0]);
                        }
                        String[] split = line.split("-->");
                        String[] inTimecode = split[0].replace(",", ":").replace(" ", "").split(":");
                        String[] outTimecode = split[1].replace(",", ":").replace(" ", "").split(":");
                        int inH = (Integer.parseInt(inTimecode[0]) - subsOffset) * 3600;
                        int inM = Integer.parseInt(inTimecode[1]) * 60;
                        int inS = Integer.parseInt(inTimecode[2]);
                        int inF = Integer.parseInt(inTimecode[3]);
                        double subsInTime = (double)(inH + inM + inS) * FFPROBE.accurateFPS + (double)inF / inputFramerateMS;
                        if (subNumber == 0 && firstSub) {
                            VideoPlayer.playerSetTime(subsInTime);
                            break;
                        }
                        int outH = (Integer.parseInt(outTimecode[0]) - subsOffset) * 3600;
                        int outM = Integer.parseInt(outTimecode[1]) * 60;
                        int outS = Integer.parseInt(outTimecode[2]);
                        int outF = Integer.parseInt(outTimecode[3]);
                        double subsOuTime = (double)(outH + outM + outS) * FFPROBE.accurateFPS + (double)outF / inputFramerateMS;
                        long inOffset = (long)(subsInTime - inputTime);
                        long outOffset = (long)(subsOuTime - inputTime);
                        if (outOffset <= 0L) continue;
                        if (inOffset < 0L) {
                            inOffset = 0L;
                        }
                        startWriting = true;
                        bufferedWriter.write(String.valueOf(++subNumber));
                        bufferedWriter.newLine();
                        String iH = Shutter.formatter.format(Math.floor((double)inOffset / FFPROBE.accurateFPS / 3600.0));
                        String iM = Shutter.formatter.format(Math.floor((double)inOffset / FFPROBE.accurateFPS / 60.0) % 60.0);
                        String iS = Shutter.formatter.format(Math.floor((double)inOffset / FFPROBE.accurateFPS) % 60.0);
                        String iF = Shutter.formatterToMs.format(Math.floor((double)inOffset % FFPROBE.accurateFPS * inputFramerateMS));
                        String oH = Shutter.formatter.format(Math.floor((double)outOffset / FFPROBE.accurateFPS / 3600.0));
                        String oM = Shutter.formatter.format(Math.floor((double)outOffset / FFPROBE.accurateFPS / 60.0) % 60.0);
                        String oS = Shutter.formatter.format(Math.floor((double)outOffset / FFPROBE.accurateFPS) % 60.0);
                        String oF = Shutter.formatterToMs.format(Math.floor((double)outOffset % FFPROBE.accurateFPS * inputFramerateMS));
                        bufferedWriter.write(iH + ":" + iM + ":" + iS + "," + iF + " --> " + oH + ":" + oM + ":" + oS + "," + oF);
                        bufferedWriter.newLine();
                        continue;
                    }
                    if (!(firstSub || !startWriting || line.contains("-->") || line.matches("[0-9]+") || line.isEmpty())) {
                        if (Shutter.lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                            bufferedWriter.write("\\h" + line + "\\h");
                        } else {
                            bufferedWriter.write(line);
                        }
                        bufferedWriter.newLine();
                        continue;
                    }
                    if (firstSub || !startWriting || !line.isEmpty()) continue;
                    bufferedWriter.newLine();
                }
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean loadWatermark(int size) {
        block31: {
            if (FFPROBE.imageWidth != FFPROBE.previousImageWidth || FFPROBE.imageHeight != FFPROBE.previousImageHeight || Shutter.logoPNG == null) {
                try {
                    try {
                        if (Shutter.logoPNG == null) {
                            int previousImageWidth = FFPROBE.previousImageWidth;
                            if (FFPROBE.isRunning) {
                                do {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (FFPROBE.isRunning);
                            }
                            FFPROBE.previousImageWidth = previousImageWidth;
                            if (Shutter.overlayDeviceIsRunning) {
                                RecordInputDevice.setOverlayDevice();
                            } else {
                                FFPROBE.Data(Shutter.logoFile);
                                do {
                                    try {
                                        Thread.sleep(10L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (FFPROBE.isRunning);
                            }
                            Shutter.logoWidth = FFPROBE.imageWidth;
                            Shutter.logoHeight = FFPROBE.imageHeight;
                            FunctionUtils.analyze(new File(videoPath), false);
                        }
                        int logoFinalSizeWidth = (int)Math.floor((double)Shutter.logoWidth / (double)Shutter.playerRatio);
                        int logoFinalSizeHeight = (int)Math.floor((double)Shutter.logoHeight / (double)Shutter.playerRatio);
                        logoFinalSizeWidth = (int)Math.floor((double)logoFinalSizeWidth * ((double)size / 100.0));
                        logoFinalSizeHeight = (int)Math.floor((double)logoFinalSizeHeight * ((double)size / 100.0));
                        if (logoFinalSizeWidth < 1) {
                            logoFinalSizeWidth = 1;
                        }
                        if (logoFinalSizeHeight < 1) {
                            logoFinalSizeHeight = 1;
                        }
                        int newPosX = (int)Math.floor((Shutter.logo.getWidth() - logoFinalSizeWidth) / 2);
                        int newPosY = (int)Math.floor((Shutter.logo.getHeight() - logoFinalSizeHeight) / 2);
                        if (Shutter.logoPNG == null) {
                            int frameSize;
                            byte[] frameData;
                            if (Shutter.overlayDeviceIsRunning) {
                                FFMPEG.run(" -v quiet -hide_banner " + RecordInputDevice.setOverlayDevice() + " -frames:v 1 -an -c:v rawvideo -pix_fmt rgba -sws_flags fast_bilinear -f rawvideo -");
                            } else if (Shutter.logoPNG == null) {
                                FFMPEG.run(" -v quiet -hide_banner -i \"" + Shutter.logoFile + "\" -frames:v 1 -an -c:v rawvideo -pix_fmt rgba -sws_flags fast_bilinear -f rawvideo -");
                            }
                            do {
                                Thread.sleep(10L);
                            } while (!FFMPEG.process.isAlive());
                            InputStream videoInput = FFMPEG.process.getInputStream();
                            BufferedInputStream is = new BufferedInputStream(videoInput);
                            int read = is.readNBytes(frameData = new byte[frameSize = Shutter.logoWidth * Shutter.logoHeight * 4], 0, frameData.length);
                            if (read == frameData.length) {
                                BufferedImage frame = new BufferedImage(Shutter.logoWidth, Shutter.logoHeight, 6);
                                frame.getRaster().setDataElements(0, 0, Shutter.logoWidth, Shutter.logoHeight, frameData);
                                fullSizeWatermark = frame;
                            }
                        }
                        Shutter.logoPNG = new ImageIcon(fullSizeWatermark).getImage().getScaledInstance(logoFinalSizeWidth, logoFinalSizeHeight, 16);
                        if (Shutter.logo.getWidth() == 0) {
                            Shutter.logo.setLocation((int)Math.floor(player.getWidth() / 2 - logoFinalSizeWidth / 2), (int)Math.floor(player.getHeight() / 2 - logoFinalSizeHeight / 2));
                        } else {
                            Shutter.logo.setLocation(Shutter.logo.getLocation().x + newPosX, Shutter.logo.getLocation().y + newPosY);
                        }
                        Shutter.logo.setSize(logoFinalSizeWidth, logoFinalSizeHeight);
                        Shutter.textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)Shutter.logo.getLocation().x * Shutter.playerRatio))));
                        Shutter.textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)Shutter.logo.getLocation().y * Shutter.playerRatio))));
                        Shutter.logoLocX = Shutter.logo.getLocation().x;
                        Shutter.logoLocY = Shutter.logo.getLocation().y;
                        Shutter.logo.repaint();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("cantLoadFile"), Shutter.language.getProperty("error"), 0);
                        if (Shutter.watermarkPreset != null) {
                            VideoPlayer.watermarkPositions(Shutter.watermarkPreset);
                        }
                        Shutter.btnStart.setEnabled(true);
                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                            break block31;
                        }
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                    }
                }
                finally {
                    if (Shutter.watermarkPreset != null) {
                        VideoPlayer.watermarkPositions(Shutter.watermarkPreset);
                    }
                    Shutter.btnStart.setEnabled(true);
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                    } else {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                    }
                }
            }
        }
        return true;
    }

    public static void watermarkPositions(String preset) {
        Shutter.watermarkPreset = preset;
        int offsetX = (int)((double)player.getWidth() * 0.036);
        int offsetY = (int)((double)player.getHeight() * 0.036);
        if (preset.equals("watermarkTopLeft")) {
            Shutter.logo.setLocation(offsetX, offsetY);
        } else if (preset.equals("watermarkLeft")) {
            Shutter.logo.setLocation(offsetX, (int)Math.floor(player.getHeight() / 2 - Shutter.logo.getHeight() / 2));
        } else if (preset.equals("watermarkBottomLeft")) {
            Shutter.logo.setLocation(offsetX, (int)Math.floor(player.getHeight() - Shutter.logo.getHeight()) - offsetY);
        } else if (preset.equals("watermarkTop")) {
            Shutter.logo.setLocation((int)Math.floor(player.getWidth() / 2 - Shutter.logo.getWidth() / 2), offsetY);
        } else if (preset.equals("watermarkCenter")) {
            Shutter.logo.setLocation((int)Math.floor(player.getWidth() / 2 - Shutter.logo.getWidth() / 2), (int)Math.floor(player.getHeight() / 2 - Shutter.logo.getHeight() / 2));
        } else if (preset.equals("watermarkBottom")) {
            Shutter.logo.setLocation((int)Math.floor(player.getWidth() / 2 - Shutter.logo.getWidth() / 2), (int)Math.floor(player.getHeight() - Shutter.logo.getHeight()) - offsetY);
        } else if (preset.equals("watermarkTopRight")) {
            Shutter.logo.setLocation((int)Math.floor(player.getWidth() - Shutter.logo.getWidth()) - offsetX, offsetY);
        } else if (preset.equals("watermarkRight")) {
            Shutter.logo.setLocation((int)Math.floor(player.getWidth() - Shutter.logo.getWidth()) - offsetX, (int)Math.floor(player.getHeight() / 2 - Shutter.logo.getHeight() / 2));
        } else if (preset.equals("watermarkBottomRight")) {
            Shutter.logo.setLocation((int)Math.floor(player.getWidth() - Shutter.logo.getWidth()) - offsetX, (int)Math.floor(player.getHeight() - Shutter.logo.getHeight()) - offsetY);
        }
        Shutter.logoLocX = Shutter.logo.getLocation().x;
        Shutter.logoLocY = Shutter.logo.getLocation().y;
        Shutter.textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)Shutter.logo.getLocation().x * Shutter.playerRatio))));
        Shutter.textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)Shutter.logo.getLocation().y * Shutter.playerRatio))));
    }

    public static void loadImage(boolean forceRefresh) {
        if (forceRefresh && videoPath != null) {
            Thread waitProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (runProcess.isAlive()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            });
            waitProcess.start();
        }
        if (!(!forceRefresh && runProcess.isAlive() || videoPath == null || Shutter.list.getSize() <= 0 || Shutter.doNotLoadImage)) {
            runProcess = new Thread(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    block90: {
                        if (VideoPlayer.bufferedFrames.size() > 0) {
                            VideoPlayer.bufferedFrames.clear();
                        }
                        if (VideoPlayer.playerIsPlaying()) {
                            VideoPlayer.btnPlay.doClick();
                        }
                        try {
                            try {
                                block89: {
                                    do {
                                        Thread.sleep(10L);
                                    } while (VideoPlayer.videoPath == null);
                                    file = new File(VideoPlayer.videoPath);
                                    extension = file.toString().substring(file.toString().lastIndexOf("."));
                                    isRaw = false;
                                    var4_5 = extension.toLowerCase();
                                    tmp = -1;
                                    switch (var4_5.hashCode()) {
                                        case 0x15B551: {
                                            if (var4_5.equals(".3fr")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1467256: {
                                            if (var4_5.equals(".arw")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1469109: {
                                            if (var4_5.equals(".cr2")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1469110: {
                                            if (var4_5.equals(".cr3")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1469178: {
                                            if (var4_5.equals(".crw")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1469999: {
                                            if (var4_5.equals(".dng")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1476412: {
                                            if (var4_5.equals(".kdc")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1478788: {
                                            if (var4_5.equals(".mrw")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1479329: {
                                            if (var4_5.equals(".nef")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1479749: {
                                            if (var4_5.equals(".nrw")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1480693: {
                                            if (var4_5.equals(".orf")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1481251: {
                                            if (var4_5.equals(".pef")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1481621: {
                                            if (var4_5.equals(".r3d")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1481734: {
                                            if (var4_5.equals(".ptx")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1483049: {
                                            if (var4_5.equals(".raf")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1483679: {
                                            if (var4_5.equals(".rw2")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1484554: {
                                            if (var4_5.equals(".srw")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                        case 1487389: {
                                            if (var4_5.equals(".x3f")) {
                                                tmp = 1;
                                            }
                                            break;
                                        }
                                    }
                                    switch (tmp) {
                                        case 1: {
                                            isRaw = true;
                                        }
                                    }
                                    if (Shutter.caseShowTimecode.isSelected() && FFPROBE.timecode1.equals("")) {
                                        Shutter.caseShowTimecode.setSelected(false);
                                        Shutter.caseShowTimecode.setEnabled(false);
                                        Shutter.caseAddTimecode.setSelected(true);
                                        Shutter.TC1.setEnabled(true);
                                        Shutter.TC2.setEnabled(true);
                                        Shutter.TC3.setEnabled(true);
                                        Shutter.TC4.setEnabled(true);
                                    }
                                    deinterlace = "";
                                    colorFormat = "rgb24";
                                    if (FFPROBE.hasAlpha) {
                                        colorFormat = "rgba";
                                    }
                                    if (!isRaw && !extension.toLowerCase().equals(".pdf") && FFPROBE.interlaced != null && FFPROBE.interlaced.equals("1")) {
                                        deinterlace = " -vf bwdif=0:" + FFPROBE.fieldOrder + ":0";
                                    }
                                    inputPoint = " -ss " + (long)(VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS) + "ms";
                                    if (VideoPlayer.fileDuration <= 40.0 || Shutter.caseEnableSequence.isSelected()) {
                                        inputPoint = "";
                                    }
                                    tiles = "";
                                    tilesNumber = FFPROBE.gridRows * FFPROBE.gridCols;
                                    if ((extension.toLowerCase().equals(".heic") || extension.toLowerCase().equals(".heif")) && FFPROBE.gridRows != 0 && FFPROBE.gridCols != 0) {
                                        i = 0;
                                        while (i < tilesNumber) {
                                            tiles = (String)tiles + "[0:v:" + i + "]";
                                            ++i;
                                        }
                                        scale = FFPROBE.imageWidth + ":" + FFPROBE.imageHeight + ":0:0";
                                        if (FFPROBE.isRotated) {
                                            scale = FFPROBE.imageHeight + ":" + FFPROBE.imageWidth + ":0:0,transpose=1";
                                        }
                                        tiles = " -filter_complex \"" + (String)tiles + "concat=n=" + tilesNumber + ",tile=" + FFPROBE.gridRows + "x" + FFPROBE.gridCols + ",crop=" + scale + "\"";
                                    }
                                    cmd = (String)deinterlace + (String)tiles + " -frames:v 1 -an -s " + VideoPlayer.player.getWidth() + "x" + VideoPlayer.player.getHeight() + " -sws_flags bicubic -y ";
                                    if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 1 || Shutter.comboRotate.getSelectedIndex() == 2)) {
                                        cmd = (String)deinterlace + (String)tiles + " -frames:v 1 -an -s " + VideoPlayer.player.getHeight() + "x" + VideoPlayer.player.getWidth() + " -sws_flags bicubic -y ";
                                    }
                                    if (VideoPlayer.preview == null && !Shutter.caseAddSubtitles.isSelected()) {
                                        if (extension.toLowerCase().equals(".pdf")) {
                                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                                            PDF.run(file, 0);
                                            do {
                                                Thread.sleep(10L);
                                            } while (PDF.isRunning && !PDF.error);
                                        } else if (isRaw) {
                                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                                            DCRAW.run(" -v -w -c -q 0 -o 1 -g 2.4 12.92 \"" + file.toString() + "\" | PathToFFMPEG -i -" + cmd + " -c:v rawvideo -pix_fmt " + colorFormat + " -f rawvideo -");
                                            do {
                                                Thread.sleep(10L);
                                            } while (DCRAW.isRunning && !DCRAW.error);
                                        } else if (Shutter.comboResolution.getSelectedItem().toString().contains("AI")) {
                                            Shutter.frame.setCursor(Cursor.getPredefinedCursor(3));
                                            preview = new File(Shutter.dirTemp + "preview.png");
                                            FFMPEG.run(Colorimetry.setInputCodec(extension) + (String)inputPoint + " -v quiet -hide_banner -i \"" + file.toString() + "\"" + (String)deinterlace + " -frames:v 1 -an \"" + String.valueOf(preview) + "\"");
                                            do {
                                                Thread.sleep(10L);
                                            } while (FFMPEG.isRunning && !FFMPEG.error);
                                            model = "realesr-general-wdn-x4v3";
                                            if (Shutter.comboResolution.getSelectedItem().toString().contains("animation")) {
                                                model = "realesrgan-x4plus-anime";
                                            }
                                            Shutter.lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                                            Shutter.lblCurrentEncoding.setText(new File(VideoPlayer.videoPath).getName());
                                            NCNN.run(" -v -i \"" + String.valueOf(preview) + "\" -m \"" + NCNN.modelsPath + "\" -n " + model + " -o \"" + String.valueOf(preview) + "\"", true);
                                            do {
                                                Thread.sleep(10L);
                                            } while (NCNN.isRunning);
                                            Shutter.progressBar1.setValue(0);
                                            Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("lblEncodageEnCours"));
                                            if (preview.exists()) {
                                                VideoPlayer.generatePreview(" -v quiet -hide_banner -i \"" + String.valueOf(preview) + "\"" + cmd + " -c:v rawvideo -pix_fmt " + colorFormat + " -f rawvideo -");
                                                if (!VideoPlayer.mouseIsPressed) {
                                                    VideoPlayer.previewUpscale = true;
                                                }
                                            } else {
                                                VideoPlayer.generatePreview(Colorimetry.setInputCodec(extension) + (String)inputPoint + " -v quiet -hide_banner -i \"" + file.toString() + "\"" + cmd + "\" -c:v rawvideo -pix_fmt " + colorFormat + " -f rawvideo -");
                                            }
                                            if (preview.exists()) {
                                                preview.delete();
                                            }
                                        } else {
                                            VideoPlayer.generatePreview(Colorimetry.setInputCodec(extension) + (String)inputPoint + " -v quiet -hide_banner -i \"" + file.toString() + "\"" + cmd + " -c:v rawvideo -pix_fmt " + colorFormat + " -an -f rawvideo -");
                                        }
                                        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                    if (VideoPlayer.preview == null && !Shutter.caseAddSubtitles.isSelected()) ** GOTO lbl231
                                    if (!Shutter.caseAddSubtitles.isSelected()) break block89;
                                    VideoPlayer.generatePreview(Colorimetry.setInputCodec(extension) + " -v quiet -hide_banner" + (String)inputPoint + " -i \"" + VideoPlayer.videoPath + "\"" + VideoPlayer.setFilter(true, true) + " -frames:v 1 -c:v rawvideo -pix_fmt " + colorFormat + " -an -f rawvideo -");
                                    ** GOTO lbl231
                                }
                                inputFormat = "bgr24";
                                if (FFPROBE.hasAlpha) {
                                    inputFormat = "abgr";
                                }
                                VideoPlayer.generatePreview(" -v quiet -hide_banner -f rawvideo -pixel_format " + inputFormat + " -video_size " + VideoPlayer.player.getWidth() + "x" + VideoPlayer.player.getHeight() + " -i pipe:0" + VideoPlayer.setFilter(true, true) + " -frames:v 1 -c:v rawvideo -pix_fmt " + colorFormat + " -f rawvideo -");
                                if (true) ** GOTO lbl231
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ** while (FFMPEG.isRunning)
                            }
                        }
                        catch (Throwable var12_17) {
                            ** while (FFMPEG.isRunning)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException var13_14) {
                                // empty catch block
                            }
                            continue;
                        }
lbl207:
                        // 1 sources

                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        } else {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                        break block90;
lbl-1000:
                        // 1 sources

                        {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException var13_15) {
                                // empty catch block
                            }
                            continue;
                        }
lbl220:
                        // 1 sources

                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        } else {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                        throw var12_17;
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException var13_16) {
                                // empty catch block
                            }
lbl231:
                            // 5 sources

                        } while (FFMPEG.isRunning);
                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        } else {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                    }
                }
            });
            runProcess.start();
        }
    }

    private static void generatePreview(String cmd) {
        try {
            Process process;
            if (System.getProperty("os.name").contains("Windows")) {
                pbv = new ProcessBuilder("cmd.exe", "/c", "\"" + FFMPEG.PathToFFMPEG + "\"" + cmd);
                process = pbv.start();
            } else {
                pbv = new ProcessBuilder("/bin/bash", "-c", FFMPEG.PathToFFMPEG + cmd);
                process = pbv.start();
            }
            Console.consoleFFMPEG.append(cmd + System.lineSeparator());
            if (preview != null) {
                OutputStream outputStream = process.getOutputStream();
                byte[] frame = ((DataBufferByte)preview.getRaster().getDataBuffer()).getData();
                outputStream.write(frame);
                outputStream.close();
            }
            InputStream is = process.getInputStream();
            BufferedInputStream inputStream = new BufferedInputStream(is);
            frameVideo = preview == null && !Shutter.caseAddSubtitles.isSelected() ? (preview = VideoPlayer.readFrame(inputStream, player.getWidth(), player.getHeight(), true)) : VideoPlayer.readFrame(inputStream, player.getWidth(), player.getHeight(), true);
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (frameVideo != null) {
            player.repaint();
        }
    }

    public static void writeSub(String srt, Charset encoding) {
        try {
            VideoPlayer.writeCurrentSubs(playerCurrentFrame, true);
        }
        catch (Exception e) {
            if (encoding == StandardCharsets.UTF_8) {
                VideoPlayer.writeSub(srt, StandardCharsets.ISO_8859_1);
            }
            Shutter.caseAddSubtitles.setSelected(false);
            player.remove(Shutter.subsCanvas);
        }
    }

    private static String setFilter(boolean noGPU, boolean noDeinterlacing) {
        if (Settings.btnPreviewOutput.isSelected() || mouseIsPressed) {
            noGPU = true;
        }
        Object background = "";
        if (Shutter.caseAddSubtitles.isSelected() && Shutter.subtitlesFile.toString().substring(Shutter.subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
            String c;
            if (Shutter.fontSubsColor != null) {
                c = Integer.toHexString(Shutter.fontSubsColor.getRGB()).substring(2);
                Shutter.subsHex = c.substring(4, 6) + c.substring(2, 4) + c.substring(0, 2);
            }
            if (Shutter.backgroundSubsColor != null) {
                c = Integer.toHexString(Shutter.backgroundSubsColor.getRGB()).substring(2);
                Shutter.subsHex2 = c.substring(4, 6) + c.substring(2, 4) + c.substring(0, 2);
            }
            Shutter.subsAlpha = "00";
            Shutter.outline = "1";
            if (Shutter.lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                int o = (int)(255.0 - (double)(Integer.valueOf(Shutter.textSubsOutline.getText()) * 255) / 100.0);
                Shutter.subsAlpha = Integer.toHexString(o);
            } else {
                Shutter.outline = String.valueOf((double)Integer.valueOf(Shutter.textSubsOutline.getText()).intValue() * 2.0 / 100.0);
            }
            background = Shutter.lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + Shutter.subsAlpha + Shutter.subsHex2 + "&,outline=0" : ",outline=" + Shutter.outline + ",outlineColour=&H" + Shutter.subsAlpha + Shutter.subsHex2 + "&";
            if (Shutter.btnG.getForeground() != Color.BLACK) {
                background = (String)background + ",Bold=1";
            }
            if (Shutter.btnI.getForeground() != Color.BLACK) {
                background = (String)background + ",Italic=1";
            }
        }
        String deinterlace = "";
        if (!noDeinterlacing && !mouseIsPressed) {
            deinterlace = AdvancedFeatures.setDeinterlace(true, noGPU);
        }
        Object filter = "";
        if (deinterlace != "") {
            filter = (String)filter + deinterlace;
        }
        int width = player.getWidth();
        int height = player.getHeight();
        String bitDepth = "nv12";
        if (FFPROBE.imageDepth == 10) {
            bitDepth = "p010";
        }
        if (!(Shutter.comboResolution.getSelectedItem().toString().equals(Shutter.language.getProperty("source")) || Shutter.comboResolution.getSelectedItem().toString().contains("AI") || noGPU || Shutter.inputDeviceIsRunning)) {
            if (((String)(filter = settings.Image.setScale((String)filter, false, noGPU))).contains("scale")) {
                filter = (String)filter + settings.Image.setPad("", false, noGPU);
            }
        } else if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 1 || Shutter.comboRotate.getSelectedIndex() == 2)) {
            width = player.getHeight();
            height = player.getWidth();
        }
        if (Shutter.caseEnableColorimetry.isSelected() && Shutter.sliderZoom.getValue() != 0) {
            filter = Colorimetry.setZoom((String)filter, false);
        }
        if (Shutter.grpColorimetry.isVisible() && Shutter.caseColormatrix.isSelected() && !Shutter.comboInColormatrix.getSelectedItem().equals("HDR")) {
            width -= width % 4;
            height -= height % 4;
        }
        if (preview == null) {
            filter = ImageSequence.setBlend((String)filter);
            filter = ImageSequence.setMotionBlur((String)filter);
        }
        filter = Colorimetry.setLUT((String)filter);
        filter = Colorimetry.setLevels((String)filter);
        filter = Colorimetry.setMetadata((String)filter);
        if (!Shutter.caseLevels.isSelected() && fileDuration > 40.0 && FFPROBE.lumaLevel.equals("0-255")) {
            if (filter != "") {
                filter = (String)filter + ",";
            }
            filter = (String)filter + "scale=in_range=full:out_range=full";
        }
        filter = Colorimetry.setColormatrix((String)filter);
        if (Shutter.caseRotate.isSelected() || Shutter.caseMiror.isSelected()) {
            filter = settings.Image.setRotate((String)filter, noGPU);
        }
        if (Shutter.caseEnableColorimetry.isSelected()) {
            String color = Colorimetry.setEQ(false);
            if (filter != "" && color != "") {
                filter = (String)filter + "," + color;
            } else if (color != "") {
                filter = (String)filter + color;
            }
            if (Shutter.sliderAngle.getValue() != 0) {
                filter = ((String)filter).contains("scale") ? ((String)filter).replace("scale=" + FFPROBE.imageWidth + ":" + FFPROBE.imageHeight, "scale=" + player.getWidth() + ":" + player.getHeight()) : (String)filter + ",scale=" + player.getWidth() + ":" + player.getHeight();
            }
        }
        filter = Corrections.setDeflicker((String)filter);
        filter = Corrections.setDeband((String)filter);
        filter = Corrections.setDetails((String)filter);
        filter = Corrections.setDenoiser((String)filter, noGPU);
        if (preview == null) {
            filter = Corrections.setSmoothExposure((String)filter);
        }
        filter = Corrections.setLimiter((String)filter);
        if (Shutter.caseVideoFadeIn.isSelected() || Shutter.caseVideoFadeOut.isSelected()) {
            filter = Transitions.setVideoFade((String)filter, true);
        }
        String algorithm = "bilinear";
        if (mouseIsPressed) {
            algorithm = "neighbor";
        }
        boolean filterGPU = FunctionUtils.checkPreviousFilter((String)filter);
        if (Shutter.inputDeviceIsRunning) {
            filter = (String)filter + "null";
        } else if (!(!filterGPU || noGPU || FFPROBE.isRotated || previousFrame || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || Shutter.comboGPUFilter.getSelectedItem().toString().equals(Shutter.language.getProperty("aucun")))) {
            if (filter != "") {
                filter = (String)filter + ",";
            }
            if (FFMPEG.autoCUDA || FFMPEG.cudaAvailable && Shutter.comboGPUFilter.getSelectedItem().toString().equals("cuda")) {
                filter = ((String)filter).replace(",hwdownload,format=" + bitDepth, "");
                filter = (String)filter + "scale_cuda=" + width + ":" + height + ":interp_algo=" + algorithm.replace("neighbor", "nearest").replace("bilinear", "bicubic") + ",hwdownload,format=" + bitDepth;
            } else if ((FFMPEG.autoAMF || FFMPEG.amfAvailable && Shutter.comboGPUFilter.getSelectedItem().toString().equals("amf")) && deinterlace == "") {
                filter = ((String)filter).replace(",hwdownload,format=" + bitDepth, "");
                filter = (String)filter + "vpp_amf=" + width + ":" + height + ",hwdownload,format=" + bitDepth;
            } else if (FFMPEG.autoQSV || FFMPEG.qsvAvailable && Shutter.comboGPUFilter.getSelectedItem().toString().equals("qsv")) {
                filter = ((String)filter).replace(",hwdownload,format=" + bitDepth, "");
                filter = (String)filter + "scale_qsv=" + width + ":" + height + ",hwdownload,format=" + bitDepth;
            } else if ((FFMPEG.autoVIDEOTOOLBOX || FFMPEG.videotoolboxAvailable && Shutter.comboGPUFilter.getSelectedItem().toString().equals("videotoolbox")) && deinterlace == "") {
                filter = ((String)filter).replace(",hwdownload,format=" + bitDepth, "");
                filter = (String)filter + "scale_vt=" + width + ":" + height + ",hwdownload,format=" + bitDepth;
            } else if (FFMPEG.autoVULKAN || FFMPEG.vulkanAvailable && Shutter.comboGPUFilter.getSelectedItem().toString().equals("vulkan")) {
                filter = ((String)filter).replace(",hwdownload,format=" + bitDepth, "");
                filter = (String)filter + "scale_vulkan=" + width + ":" + height + ",hwdownload,format=" + bitDepth;
            } else {
                filter = (String)filter + "scale=" + width + ":" + height + ":sws_flags=" + algorithm + ":sws_dither=none";
            }
        } else {
            if (filter != "") {
                filter = (String)filter + ",";
            }
            filter = (String)filter + "scale=" + width + ":" + height + ":sws_flags=" + algorithm + ":sws_dither=none";
        }
        if (sliderSpeed.getValue() != 2) {
            filter = sliderSpeed.getValue() != 0 ? (String)filter + ",setpts=" + 1.0 / ((double)sliderSpeed.getValue() / 2.0) + "*PTS" : (String)filter + ",setpts=4*PTS";
        }
        filter = " -vf \"" + (String)filter;
        if (caseVuMeter.isSelected() && FFPROBE.hasAudio && !Shutter.caseAddSubtitles.isSelected() && preview == null) {
            Object aspeed = "";
            if (sliderSpeed.getValue() != 2) {
                aspeed = sliderSpeed.getValue() != 0 ? (String)aspeed + "atempo=" + (double)sliderSpeed.getValue() / 2.0 + "," : (String)aspeed + "atempo=0.5,atempo=0.5,";
            }
            Object channels = "";
            Object audioOutput = "";
            int i = 0;
            while (i < FFPROBE.channels) {
                channels = (String)channels + "[0:a:" + i + "]" + (String)aspeed + "showvolume=f=0:w=" + player.getWidth() + ":h=" + Math.round(player.getHeight() / 90) + ":t=0:b=0:v=0:o=v:s=0:p=0.5[a" + i + "];";
                audioOutput = (String)audioOutput + "[a" + i + "]";
                ++i;
            }
            if (FFPROBE.channels > 1) {
                audioOutput = (String)audioOutput + "hstack=" + i + "[volume];";
            } else {
                audioOutput = ((String)audioOutput).replace("[a0]", "");
                channels = ((String)channels).replace("[a0]", "[volume]");
            }
            filter = " -filter_complex \"[0:v]" + ((String)filter).replace(" -vf ", "").replace("\"", "") + "[v];" + (String)channels + (String)audioOutput + "[v][volume]overlay=W-w:H-h";
        }
        filter = (String)filter + "\"";
        if (Shutter.caseAddSubtitles.isSelected() && Shutter.subtitlesBurn && Shutter.subtitlesFile.toString().substring(Shutter.subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
            caseVuMeter.setEnabled(false);
            int subsWidth = (int)((float)Integer.parseInt(Shutter.textSubsWidth.getText()) / Shutter.playerRatio);
            int subsPosY = (int)((double)Integer.parseInt(Shutter.textSubtitlesPosition.getText()) / (double)Shutter.playerRatio);
            filter = " -f lavfi -i \"color=black@0.0,format=rgba,scale=" + subsWidth + ":" + player.getHeight() + "+" + subsPosY + ",subtitles='" + Shutter.subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + Shutter.comboSubsFont.getSelectedItem().toString() + ",FontSize=" + Shutter.textSubsSize.getText() + ",PrimaryColour=&H" + Shutter.subsHex + "&" + (String)background + "'\" -filter_complex \"[0:v]" + ((String)filter).replace(" -vf ", "").replace("\"", "") + "[v];[v][1:v]overlay=x=" + (player.getWidth() - subsWidth) / 2 + ",scale=" + player.getWidth() + ":" + player.getHeight() + "\"";
        } else {
            caseVuMeter.setEnabled(true);
        }
        return filter;
    }

    private static String setAudioFilter() {
        Object filter = "";
        filter = AudioSettings.setEQ((String)filter);
        if (sliderSpeed.getValue() != 2) {
            if (filter != "") {
                filter = (String)filter + ",";
            }
            filter = sliderSpeed.getValue() != 0 ? (String)filter + "atempo=" + (double)sliderSpeed.getValue() / 2.0 : (String)filter + "atempo=0.5,atempo=0.5";
        }
        if (Shutter.caseAudioFadeIn.isSelected() || Shutter.caseAudioFadeOut.isSelected()) {
            if (filter != "") {
                filter = (String)filter + ",";
            }
            filter = (String)filter + Transitions.setAudioFadeIn(true);
            if (Transitions.setAudioFadeIn(true) != "" && Transitions.setAudioFadeOut(true) != "") {
                filter = (String)filter + ",";
            }
            filter = (String)filter + Transitions.setAudioFadeOut(true);
        }
        if (filter != "") {
            filter = " -filter:a " + (String)filter;
        }
        return filter;
    }

    public static boolean getFileList(String file, double fileDuration) {
        try {
            if (fileList.length() > 0 && fileDuration > 40.0 && !Shutter.caseEnableSequence.isSelected()) {
                boolean fileExists = false;
                String[] stringArray = fileList.toString().split(System.lineSeparator());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    String[] s = line.split("\\|");
                    String[] in = s[1].split(":");
                    String[] out = s[2].split(":");
                    totalFrames = fileDuration / 1000.0 * FFPROBE.accurateFPS;
                    if (s[0].equals(file)) {
                        caseInH.setText(in[0]);
                        caseInM.setText(in[1]);
                        caseInS.setText(in[2]);
                        caseInF.setText(in[3]);
                        caseOutH.setText(out[0]);
                        caseOutM.setText(out[1]);
                        caseOutS.setText(out[2]);
                        caseOutF.setText(out[3]);
                        fileExists = true;
                        break;
                    }
                    VideoPlayer.updateGrpIn(0.0);
                    VideoPlayer.updateGrpOut(totalFrames);
                    fileExists = false;
                    ++n2;
                }
                double timeIn = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                double timeOut = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                inputFramerateMS = Shutter.caseEnableSequence.isSelected() ? (double)Float.parseFloat(Shutter.caseSequenceFPS.getSelectedItem().toString().replace(",", ".")) : 1000.0 / FFPROBE.accurateFPS;
                slider.setMaximum((int)totalFrames);
                playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeIn / (double)slider.getMaximum());
                playerOutMark = (int)Timecode.getNTSCtimecode(timeOut) < (int)totalFrames ? (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeOut / (double)slider.getMaximum()) : waveformContainer.getWidth();
                waveformContainer.repaint();
                VideoPlayer.totalDuration();
                return fileExists;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void setFileList() {
        try {
            StringBuilder stb = new StringBuilder();
            if (fileList.length() > 0 && fileDuration > 40.0 && !Shutter.caseEnableSequence.isSelected()) {
                String[] stringArray = fileList.toString().split(System.lineSeparator());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    stb.append(file + System.lineSeparator());
                    ++n2;
                }
                fileList.setLength(0);
                boolean fileExists = false;
                String[] stringArray2 = stb.toString().split(System.lineSeparator());
                int n3 = stringArray2.length;
                n = 0;
                while (n < n3) {
                    String file = stringArray2[n];
                    String[] s = file.split("\\|");
                    if (s[0].equals(videoPath)) {
                        fileList.append(videoPath + "|" + caseInH.getText() + ":" + caseInM.getText() + ":" + caseInS.getText() + ":" + caseInF.getText() + "|" + caseOutH.getText() + ":" + caseOutM.getText() + ":" + caseOutS.getText() + ":" + caseOutF.getText() + System.lineSeparator());
                        fileExists = true;
                    } else if (!file.equals("null")) {
                        fileList.append(file + System.lineSeparator());
                    }
                    ++n;
                }
                if (!fileExists) {
                    fileList.append(videoPath + "|" + caseInH.getText() + ":" + caseInM.getText() + ":" + caseInS.getText() + ":" + caseInF.getText() + "|" + caseOutH.getText() + ":" + caseOutM.getText() + ":" + caseOutS.getText() + ":" + caseOutF.getText() + System.lineSeparator());
                }
            } else if (fileDuration > 40.0 && !Shutter.caseEnableSequence.isSelected()) {
                fileList.append(videoPath + "|" + caseInH.getText() + ":" + caseInM.getText() + ":" + caseInS.getText() + ":" + caseInF.getText() + "|" + caseOutH.getText() + ":" + caseOutM.getText() + ":" + caseOutS.getText() + ":" + caseOutF.getText() + System.lineSeparator());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void resizeAll() {
        if (Shutter.frame.getWidth() > 332 && !Shutter.doNotLoadImage) {
            if (bufferedFrames.size() > 0) {
                bufferedFrames.clear();
            }
            isPiping = false;
            if (Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction")) || Shutter.btnStart.getText().equals(Shutter.language.getProperty("resume")) || Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnStopRecording"))) {
                isPiping = true;
                VideoPlayer.setPlayerButtons(false);
            }
            double ratio = FFPROBE.imageRatio;
            if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 1 || Shutter.comboRotate.getSelectedIndex() == 2)) {
                ratio = (double)FFPROBE.imageHeight / (double)FFPROBE.imageWidth;
            }
            if (Shutter.caseForcerDAR.isSelected()) {
                if (Shutter.comboDAR.getSelectedItem().toString().contains(":")) {
                    s = Shutter.comboDAR.getSelectedItem().toString().split(":");
                    ratio = (double)Integer.parseInt(s[0]) / (double)Integer.parseInt(s[1]);
                } else {
                    ratio = Float.parseFloat(Shutter.comboDAR.getSelectedItem().toString());
                }
            } else if (!Shutter.comboResolution.getSelectedItem().toString().equals(Shutter.language.getProperty("source")) && !Shutter.btnNoUpscale.isSelected() && Shutter.comboResolution.getSelectedItem().toString().contains("x") && !Shutter.comboResolution.getSelectedItem().toString().contains("AI")) {
                s = Shutter.comboResolution.getSelectedItem().toString().split("x");
                ratio = (double)Integer.parseInt(s[0]) / (double)Integer.parseInt(s[1]);
            } else if (Shutter.caseEnableCrop.isSelected() && isPiping) {
                ratio = (double)Integer.parseInt(Shutter.textCropWidth.getText()) / (double)Integer.parseInt(Shutter.textCropHeight.getText());
            }
            int maxWidth = Shutter.frame.getWidth() - 40 - Shutter.grpChooseFiles.getWidth() * 2;
            if (Shutter.noSettings) {
                maxWidth = Shutter.frame.getWidth() - 40 - Shutter.grpChooseFiles.getWidth();
            }
            if (fullscreenPlayer) {
                maxWidth = Shutter.frame.getWidth();
            }
            int maxHeight = Shutter.frame.getHeight() - (Shutter.topPanel.getHeight() + Shutter.statusBar.getHeight()) - 40;
            if (fileDuration <= 40.0 && !Shutter.caseEnableSequence.isSelected() || isPiping) {
                maxHeight = Shutter.frame.getHeight() - (Shutter.grpChooseFiles.getY() + 8) - (Shutter.frame.getHeight() - (Shutter.grpProgression.getY() + Shutter.grpProgression.getHeight()));
            }
            if (fullscreenPlayer) {
                maxHeight = Shutter.frame.getHeight();
            }
            int width = (int)((double)maxHeight * ratio);
            int height = (int)((double)maxWidth / ratio);
            if (width <= maxWidth) {
                player.setSize(width, maxHeight);
            } else {
                player.setSize(maxWidth, height);
            }
            if (!fullscreenPlayer && Shutter.frame.getHeight() - player.getHeight() < 220 && (fileDuration > 40.0 || Shutter.caseEnableSequence.isSelected())) {
                int p = 220 - (Shutter.frame.getHeight() - player.getHeight());
                player.setSize((int)((double)player.getWidth() - (double)p * ratio), player.getHeight() - p);
            }
            int y = Shutter.frame.getHeight() / 2 - player.getHeight() / 2 - 58;
            if (fileDuration <= 40.0 && !Shutter.caseEnableSequence.isSelected() || isPiping || Shutter.inputDeviceIsRunning) {
                y = Shutter.frame.getHeight() / 2 - player.getHeight() / 2;
            }
            if (Shutter.noSettings) {
                player.setLocation((1350 - VideoPlayer.player.getSize().width) / 2, y);
            } else if (fullscreenPlayer) {
                player.setLocation(Shutter.frame.getWidth() / 2 - player.getWidth() / 2, Shutter.frame.getHeight() / 2 - player.getHeight() / 2);
            } else {
                player.setLocation((Shutter.frame.getWidth() - VideoPlayer.player.getSize().width) / 2, y);
            }
            player.setSize(player.getWidth() - player.getWidth() % 4, player.getHeight() - player.getHeight() % 4);
            maxBufferedFrames = (int)((double)(Shutter.availableMemory / 3L) / (double)(player.getWidth() * player.getHeight() * 3));
            Shutter.playerRatio = (float)FFPROBE.imageWidth / (float)player.getWidth();
            if (Shutter.noSettings) {
                slider.setBounds(Shutter.grpChooseFiles.getWidth() + 20, player.getY() + player.getHeight() + 26, Shutter.frame.getWidth() - 40 - Shutter.grpChooseFiles.getWidth(), 40);
            } else {
                slider.setBounds(Shutter.grpChooseFiles.getWidth() + 20, player.getY() + player.getHeight() + 26, Shutter.frame.getWidth() - 40 - Shutter.grpChooseFiles.getWidth() * 2, 40);
            }
            waveformContainer.setSize(slider.getWidth() * waveformZoom, slider.getHeight());
            waveformContainer.setPreferredSize(new Dimension(waveformContainer.getWidth(), waveformContainer.getHeight()));
            waveformIcon.setSize(waveformContainer.getSize());
            waveformScrollPane.setBounds(slider.getX(), slider.getY(), slider.getWidth(), slider.getHeight() + waveformScrollPane.getHorizontalScrollBar().getHeight());
            if (!(fullscreenPlayer || isPiping || Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction")) || Shutter.list.getSize() <= 0 || addWaveform.isAlive())) {
                VideoPlayer.addWaveform(false);
            }
            if (playerCurrentFrame <= 1.0) {
                cursorWaveform.setBounds(0, 0, 1, VideoPlayer.waveformContainer.getSize().height);
                cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
            } else if (cursorWaveform.getX() > waveformContainer.getWidth() - 2) {
                cursorWaveform.setLocation(waveformContainer.getWidth() - 2, 0);
                cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
            } else {
                cursorWaveform.setBounds((int)Math.floor((double)(VideoPlayer.waveformContainer.getSize().width * slider.getValue()) / (double)slider.getMaximum()), 0, 1, VideoPlayer.waveformContainer.getSize().height);
                cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
            }
            if (!isPiping) {
                try {
                    double timeIn = (double)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseInF.getText());
                    double timeOut = (double)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.accurateFPS + (double)Integer.parseInt(caseOutF.getText());
                    playerInMark = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeIn / (double)slider.getMaximum());
                    playerOutMark = (int)Timecode.getNTSCtimecode(timeOut) < (int)totalFrames ? (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * timeOut / (double)slider.getMaximum()) : waveformContainer.getWidth();
                }
                catch (Exception timeIn) {
                    // empty catch block
                }
                waveformContainer.repaint();
            }
            lblPosition.setBounds(slider.getX(), slider.getY() - 22, slider.getWidth(), 16);
            lblDuration.setBounds(slider.getX(), lblPosition.getY(), slider.getWidth(), 16);
            if (Shutter.caseAddSubtitles.isSelected()) {
                if (Integer.parseInt(Shutter.textSubsWidth.getText()) >= FFPROBE.imageWidth) {
                    Shutter.subsCanvas.setBounds(0, 0, player.getWidth(), (int)((double)player.getHeight() + (double)Integer.parseInt(Shutter.textSubtitlesPosition.getText()) / ((double)FFPROBE.imageHeight / (double)player.getHeight())));
                } else {
                    Shutter.subsCanvas.setSize((int)((double)Integer.parseInt(Shutter.textSubsWidth.getText()) / ((double)FFPROBE.imageHeight / (double)player.getHeight())), (int)((double)player.getHeight() + (double)Integer.parseInt(Shutter.textSubtitlesPosition.getText()) / ((double)FFPROBE.imageHeight / (double)player.getHeight())));
                    Shutter.subsCanvas.setLocation((player.getWidth() - Shutter.subsCanvas.getWidth()) / 2, 0);
                }
            }
            if (RecordInputDevice.comboInputVideo != null && RecordInputDevice.comboInputVideo.getSelectedIndex() > 0) {
                Shutter.caseAddWatermark.setSelected(true);
            }
            if (Shutter.caseAddWatermark.isSelected() && !Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction")) && !Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnStopRecording"))) {
                VideoPlayer.loadWatermark(Integer.parseInt(Shutter.textWatermarkSize.getText()));
                if (Shutter.watermarkPreset != null) {
                    Shutter.logo.setLocation(Math.round((float)Integer.valueOf(Shutter.textWatermarkPosX.getText()).intValue() / Shutter.playerRatio), Math.round((float)Integer.valueOf(Shutter.textWatermarkPosY.getText()).intValue() / Shutter.playerRatio));
                }
            }
            Shutter.frameCropX = VideoPlayer.player.getLocation().x;
            Shutter.frameCropY = VideoPlayer.player.getLocation().y;
            if (Shutter.caseEnableCrop.isSelected()) {
                Shutter.selection.setLocation(Math.round((float)Integer.valueOf(Shutter.textCropPosX.getText()).intValue() / Shutter.playerRatio), Math.round((float)Integer.valueOf(Shutter.textCropPosY.getText()).intValue() / Shutter.playerRatio));
                int w = (int)Math.round((double)(Integer.valueOf(Shutter.textCropWidth.getText()) * player.getHeight()) / (double)FFPROBE.imageHeight);
                int h = (int)Math.round((double)(Integer.valueOf(Shutter.textCropHeight.getText()) * player.getHeight()) / (double)FFPROBE.imageHeight);
                if (w > player.getWidth()) {
                    w = player.getWidth();
                }
                if (h > player.getHeight()) {
                    h = player.getHeight();
                }
                Shutter.selection.setSize(w, h);
            } else {
                Shutter.selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
                Shutter.anchorRight = Shutter.selection.getLocation().x + Shutter.selection.getWidth();
                Shutter.anchorBottom = Shutter.selection.getLocation().y + Shutter.selection.getHeight();
            }
            if (Shutter.windowDrag) {
                if (Shutter.caseAddTimecode.isSelected() || Shutter.caseShowTimecode.isSelected()) {
                    Shutter.timecode.setLocation(Math.round((float)Integer.valueOf(Shutter.textTcPosX.getText()).intValue() / Shutter.playerRatio), Math.round((float)Integer.valueOf(Shutter.textTcPosY.getText()).intValue() / Shutter.playerRatio));
                    Shutter.tcLocX = Shutter.timecode.getLocation().x;
                    Shutter.tcLocY = Shutter.timecode.getLocation().y;
                }
                if (Shutter.caseAddText.isSelected() || Shutter.caseShowFileName.isSelected()) {
                    Shutter.fileName.setLocation(Math.round((float)Integer.valueOf(Shutter.textNamePosX.getText()).intValue() / Shutter.playerRatio), Math.round((float)Integer.valueOf(Shutter.textNamePosY.getText()).intValue() / Shutter.playerRatio));
                    Shutter.fileLocX = Shutter.fileName.getLocation().x;
                    Shutter.fileLocY = Shutter.fileName.getLocation().y;
                }
            }
            btnPrevious.setBounds(VideoPlayer.player.getLocation().x + VideoPlayer.player.getSize().width / 2 - 21 - 4, slider.getY() + slider.getHeight() + 10, 22, 21);
            btnNext.setBounds(VideoPlayer.player.getLocation().x + VideoPlayer.player.getSize().width / 2 + 4, VideoPlayer.btnPrevious.getLocation().y, 22, 21);
            btnPlay.setBounds(VideoPlayer.btnPrevious.getLocation().x - 40 - 4, VideoPlayer.btnPrevious.getLocation().y, 40, 21);
            btnStop.setBounds(VideoPlayer.btnNext.getLocation().x + VideoPlayer.btnNext.getSize().width + 4, VideoPlayer.btnNext.getLocation().y, 40, 21);
            btnMarkIn.setBounds(VideoPlayer.btnPlay.getLocation().x - 22 - 4, VideoPlayer.btnPlay.getLocation().y, 22, 21);
            btnGoToIn.setBounds(VideoPlayer.btnMarkIn.getLocation().x - 40 - 4, VideoPlayer.btnMarkIn.getLocation().y, 40, 21);
            btnMarkOut.setBounds(VideoPlayer.btnStop.getLocation().x + VideoPlayer.btnStop.getSize().width + 4, VideoPlayer.btnStop.getLocation().y, 22, 21);
            btnGoToOut.setBounds(VideoPlayer.btnMarkOut.getLocation().x + VideoPlayer.btnMarkOut.getSize().width + 4, VideoPlayer.btnMarkOut.getLocation().y, 40, 21);
            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                panelForButtons.setBounds(btnPlay.getX() + 2, btnPlay.getY(), btnStop.getX() + btnStop.getWidth() - btnPlay.getX() - 4, 21);
            } else {
                panelForButtons.setBounds(btnGoToIn.getX() + 2, btnPlay.getY(), btnGoToOut.getX() + btnGoToOut.getWidth() - btnGoToIn.getX() - 4, 21);
            }
            showFPS.setBounds(player.getX() + player.getWidth() / 2, player.getY() - 18, player.getWidth() / 2, VideoPlayer.showFPS.getPreferredSize().height);
            showScale.setBounds(player.getX(), showFPS.getY(), player.getWidth() / 2, VideoPlayer.showScale.getPreferredSize().height);
            comboAudioTrack.setBounds(7, waveformContainer.getHeight() / 2 - 8, 40, 16);
            if (showScale.getY() < Shutter.topPanel.getHeight() || FFPROBE.audioOnly || videoPath == null || Shutter.frame.getSize().width <= 654 || fullscreenPlayer) {
                showScale.setVisible(false);
            } else if (!(Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || Shutter.list.getSize() <= 0 || isPiping || Settings.btnDisableVideoPlayer.isSelected())) {
                showScale.setVisible(true);
            }
            showScale.repaint();
            showFPS.repaint();
            caseInH.setBounds(slider.getX() - 2, btnPrevious.getY(), 21, 21);
            caseInM.setBounds(caseInH.getX() + caseInH.getWidth(), caseInH.getY(), 21, 21);
            caseInS.setBounds(caseInM.getX() + caseInM.getWidth(), caseInH.getY(), 21, 21);
            caseInF.setBounds(caseInS.getX() + caseInS.getWidth(), caseInH.getY(), 21, 21);
            caseOutH.setBounds(slider.getX() + slider.getWidth() - 84, caseInH.getY(), 21, 21);
            caseOutM.setBounds(caseOutH.getX() + caseOutH.getWidth(), caseOutH.getY(), 21, 21);
            caseOutS.setBounds(caseOutM.getX() + caseOutM.getWidth(), caseOutH.getY(), 21, 21);
            caseOutF.setBounds(caseOutS.getX() + caseOutS.getWidth(), caseOutH.getY(), 21, 21);
            caseInternalTc.setBounds(caseInH.getX() - 2, btnPrevious.getY() + btnPrevious.getHeight() + 6, VideoPlayer.caseInternalTc.getPreferredSize().width, 23);
            if (caseInternalTc.isVisible()) {
                casePlaySound.setBounds(caseInternalTc.getX() + caseInternalTc.getWidth() + 4, caseInternalTc.getY(), VideoPlayer.casePlaySound.getPreferredSize().width, 23);
            } else {
                casePlaySound.setBounds(caseInternalTc.getX(), caseInternalTc.getY(), VideoPlayer.casePlaySound.getPreferredSize().width, 23);
            }
            btnPreview.setBounds(slider.getX() + slider.getWidth() - 16, caseInternalTc.getY() + 2, 16, 16);
            lblSplitSec.setBounds(btnPreview.getX() + 10, caseInternalTc.getY() + 2, VideoPlayer.lblSplitSec.getPreferredSize().width, 16);
            splitValue.setBounds(lblSplitSec.getX() - splitValue.getWidth() - 2, caseInternalTc.getY() + 2, 34, 16);
            if (splitValue.isVisible()) {
                comboMode.setLocation(splitValue.getX() - comboMode.getWidth() - 4, caseInternalTc.getY() - 1);
            } else {
                comboMode.setLocation(btnPreview.getX() - comboMode.getWidth() - 4, caseInternalTc.getY() - 1);
            }
            lblMode.setBounds(comboMode.getX() - VideoPlayer.lblMode.getPreferredSize().width - 4, caseInternalTc.getY() + 3, VideoPlayer.lblMode.getPreferredSize().width, 16);
            sliderSpeed.setLocation(btnGoToIn.getX() - sliderSpeed.getWidth() - 4, btnPrevious.getY() + 1);
            lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
            lblVolume.setLocation(btnGoToOut.getX() + btnGoToOut.getWidth() + 7, lblSpeed.getY());
            if (Shutter.frame.getWidth() < 1320 && !Shutter.noSettings) {
                caseShowWaveform.setBounds(caseInternalTc.getX(), caseInternalTc.getY() + caseInternalTc.getHeight(), VideoPlayer.caseShowWaveform.getPreferredSize().width, 23);
                caseVuMeter.setBounds(caseShowWaveform.getX() + caseShowWaveform.getWidth() + 4, caseShowWaveform.getY(), VideoPlayer.caseVuMeter.getPreferredSize().width, 23);
                sliderVolume.setBounds(lblVolume.getX() + lblVolume.getWidth() - lblVolume.getWidth(), sliderSpeed.getY(), sliderSpeed.getWidth(), 22);
                caseApplyCutToAll.setLocation(lblPosition.getX() + slider.getWidth() / 2 - caseApplyCutToAll.getWidth(), lblPosition.getY() - 3);
            } else {
                caseVuMeter.setBounds(lblMode.getX() - VideoPlayer.caseVuMeter.getPreferredSize().width - 5, caseInternalTc.getY(), VideoPlayer.caseVuMeter.getPreferredSize().width, 23);
                caseShowWaveform.setBounds(caseVuMeter.getX() - VideoPlayer.caseShowWaveform.getPreferredSize().width - 5, caseVuMeter.getY(), VideoPlayer.caseShowWaveform.getPreferredSize().width, 23);
                sliderVolume.setBounds(lblVolume.getX() + lblVolume.getWidth() + 1, sliderSpeed.getY(), sliderSpeed.getWidth(), 22);
                caseApplyCutToAll.setLocation(lblPosition.getX() + slider.getWidth() / 2 - caseApplyCutToAll.getWidth() / 2, lblPosition.getY() - 3);
            }
            if (!Shutter.windowDrag && videoPath != null && !isPiping) {
                if (preview != null && fileDuration > 40.0) {
                    preview = null;
                }
                if (Shutter.inputDeviceIsRunning) {
                    VideoPlayer.playerFreeze();
                } else if (fileDuration <= 40.0) {
                    VideoPlayer.loadImage(false);
                    waveformIcon.setVisible(false);
                } else if (btnPlay.isEnabled()) {
                    VideoPlayer.playerFreeze();
                }
            }
            if (Shutter.list.getSize() == 0 || videoPath == null) {
                VideoPlayer.setPlayerButtons(false);
            }
        }
        if (Shutter.caseAddTimecode.isSelected() || Shutter.caseShowTimecode.isSelected() || Shutter.caseAddText.isSelected() || Shutter.caseShowFileName.isSelected()) {
            VideoPlayer.refreshTimecodeAndText();
        }
        Shutter.statusBar.setBounds(0, Shutter.frame.getHeight() - 23, Shutter.frame.getWidth(), 22);
        if (Shutter.frame.getWidth() >= 1130) {
            Shutter.lblArrows.setLocation(Shutter.statusBar.getWidth() / 2 - Shutter.lblArrows.getWidth() / 2, Shutter.lblArrows.getY());
            Shutter.lblYears.setVisible(true);
        } else {
            Shutter.lblArrows.setLocation(Shutter.frame.getWidth() - Shutter.lblArrows.getWidth() - 7, Shutter.lblArrows.getY());
            Shutter.lblYears.setVisible(false);
        }
        Shutter.lblYears.setLocation(Shutter.frame.getWidth() - Shutter.lblYears.getWidth() - 8, Shutter.lblBy.getY());
    }

    public static void getTimePoint(double time) {
        if (time >= totalFrames) {
            sliderChange = true;
            slider.setValue(slider.getMaximum());
            sliderChange = false;
        }
        time = Timecode.setNTSCtimecode(time);
        if (caseInternalTc.isSelected()) {
            time += offset;
        }
        if (playerVideo != null && time - offset < totalFrames) {
            String h = Shutter.formatter.format(Math.floor(time / FFPROBE.accurateFPS / 3600.0));
            String m = Shutter.formatter.format(Math.floor(time / FFPROBE.accurateFPS / 60.0) % 60.0);
            String s = Shutter.formatter.format(Math.floor(time / FFPROBE.accurateFPS) % 60.0);
            String f = Shutter.formatter.format(Math.floor(time % FFPROBE.accurateFPS));
            String dropFrame = ":";
            lblPosition.setText(h + ":" + m + ":" + s + dropFrame + f + "\u00a0| " + Math.round(playerCurrentFrame));
            if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && mouseIsPressed) {
                VideoPlayer.updateGrpIn(Timecode.getNTSCtimecode(time) - offset);
            }
            if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && mouseIsPressed) {
                VideoPlayer.updateGrpOut(Timecode.getNTSCtimecode(time) - offset + 1.0);
            }
            if (!sliderChange && !Shutter.windowDrag) {
                slider.setValue((int)playerCurrentFrame);
                int newValue = (int)Math.floor((double)VideoPlayer.waveformContainer.getSize().width * (time - offset) / (double)slider.getMaximum());
                if (cursorWaveform != null) {
                    if (playerCurrentFrame <= 1.0) {
                        cursorWaveform.setLocation(0, 0);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                    } else if (cursorWaveform.getX() > waveformContainer.getWidth() - 2) {
                        cursorWaveform.setLocation(waveformContainer.getWidth() - 2, 0);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                    } else if (newValue != cursorWaveform.getX()) {
                        cursorWaveform.setLocation(newValue, 0);
                        cursorHead.setLocation(cursorWaveform.getX() - 5, cursorWaveform.getY());
                    }
                    if (cursorWaveform.getX() > waveformScrollPane.getWidth() + waveformScrollPane.getHorizontalScrollBar().getValue()) {
                        waveformScrollPane.getHorizontalScrollBar().setValue(cursorWaveform.getX() - slider.getWidth() + 1);
                    } else if (cursorWaveform.getX() < waveformScrollPane.getHorizontalScrollBar().getValue()) {
                        waveformScrollPane.getHorizontalScrollBar().setValue(cursorWaveform.getX());
                    }
                }
            }
        }
        if (time - offset >= totalFrames - 2.0) {
            btnPlay.setIcon(new FlatSVGIcon("contents/play.svg", 15, 15));
            btnPlay.setName("play");
        }
    }

    public static void totalDuration() {
        block35: {
            try {
                int inH = Integer.parseInt(caseInH.getText());
                int inM = Integer.parseInt(caseInM.getText());
                int inS = Integer.parseInt(caseInS.getText());
                int inF = Integer.parseInt(caseInF.getText());
                int outH = Integer.parseInt(caseOutH.getText());
                int outM = Integer.parseInt(caseOutM.getText());
                int outS = Integer.parseInt(caseOutS.getText());
                int outF = Integer.parseInt(caseOutF.getText());
                double totalIn = (double)(inH * 3600 + inM * 60 + inS) * FFPROBE.accurateFPS + (double)inF;
                double totalOut = (double)(outH * 3600 + outM * 60 + outS) * FFPROBE.accurateFPS + (double)outF;
                double total = Math.ceil(totalOut - totalIn);
                if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                    total = totalFrames - total;
                }
                durationH = (int)Math.floor(total / FFPROBE.accurateFPS / 3600.0);
                durationM = (int)Math.floor(total / FFPROBE.accurateFPS / 60.0) % 60;
                durationS = (int)Math.floor(total / FFPROBE.accurateFPS) % 60;
                durationF = (int)Math.floor(total % FFPROBE.accurateFPS);
                lblDuration.setText(Shutter.language.getProperty("lblBitrateTimecode") + " " + Shutter.formatter.format(durationH) + ":" + Shutter.formatter.format(durationM) + ":" + Shutter.formatter.format(durationS) + ":" + Shutter.formatter.format(durationF) + " | " + (int)Timecode.getNTSCtimecode(total) + " " + Shutter.language.getProperty("lblTotalFrames"));
                if (total <= 0.0) {
                    lblDuration.setVisible(false);
                    break block35;
                }
                if (!waveformScrollPane.isVisible() || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || Shutter.caseEnableSequence.isSelected()) break block35;
                lblDuration.setVisible(true);
                switch (Shutter.comboFonctions.getSelectedItem().toString()) {
                    case "MPEG-1": 
                    case "MPEG-2": 
                    case "Theora": 
                    case "AV1": 
                    case "VP8": 
                    case "VP9": 
                    case "WMV": 
                    case "Xvid": 
                    case "H.264": 
                    case "H.265": 
                    case "H.266": 
                    case "MJPEG": 
                    case "Blu-ray": {
                        FFPROBE.setFilesize();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

