/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Renamer {
    public static JDialog frame;
    private JLabel lblReplace;
    private JTextField txtReplace;
    private JLabel lblBy;
    private JTextField txtBy;
    private JButton Rename;
    private JLabel lblExample;
    private JCheckBox btnLimit;
    private JSpinner spinnerLimit;
    private JCheckBox btnIncrement;
    private JSpinner spinnerIncrement;
    private JCheckBox btnAddBefore;
    private JTextField txtAddBefore;
    private JCheckBox btnAddAfter;
    private JTextField txtAddAfter;
    private JCheckBox convertToLower;
    private JCheckBox convertToUpper;
    private JCheckBox removeSpecialCharacters;
    private static StringBuilder errorList;
    private String fichier;
    private String ext;

    public Renamer() {
        frame = new JDialog();
        frame.getContentPane().setLayout(null);
        frame.setResizable(false);
        frame.setModal(true);
        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
            frame.setSize(541, 153);
        } else {
            frame.setSize(551, 163);
        }
        frame.setTitle(Shutter.language.getProperty("frameRenommage"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setBackground(Utils.bg32);
        if (!System.getProperty("os.name").contains("Mac")) {
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        }
        frame.setDefaultCloseOperation(2);
        frame.setBackground(Utils.c30);
        frame.setLocation(Shutter.frame.getX() + (Shutter.frame.getWidth() - frame.getWidth()) / 2, Shutter.frame.getY() + (Shutter.frame.getHeight() / 2 - frame.getHeight()));
        String fullName = new File(Shutter.fileList.getSelectedValuesList().get(0)).getName();
        this.ext = fullName.substring(fullName.lastIndexOf("."));
        this.fichier = new File(fullName).getName().replace(this.ext, "");
        this.btnLimit = new JCheckBox(Shutter.language.getProperty("btnLimit"));
        this.btnLimit.setFont(new Font(Shutter.mainFont, 0, 12));
        this.btnLimit.setBounds(7, 12, 211, 16);
        frame.getContentPane().add(this.btnLimit);
        this.btnLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnLimit.isSelected()) {
                    Renamer.this.spinnerLimit.setEnabled(true);
                } else {
                    Renamer.this.spinnerLimit.setEnabled(false);
                }
            }
        });
        this.spinnerLimit = new JSpinner(new SpinnerNumberModel(this.fichier.length(), 1, this.fichier.length(), 1));
        this.spinnerLimit.setFont(new Font(Shutter.mainFont, 0, 11));
        this.spinnerLimit.setEnabled(false);
        this.spinnerLimit.setBounds(226, 10, 46, 20);
        frame.getContentPane().add(this.spinnerLimit);
        this.btnIncrement = new JCheckBox(Shutter.language.getProperty("btnIncrementer"));
        this.btnIncrement.setFont(new Font(Shutter.mainFont, 0, 12));
        this.btnIncrement.setBounds(7, 34, this.btnIncrement.getPreferredSize().width, 16);
        frame.getContentPane().add(this.btnIncrement);
        this.btnIncrement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnIncrement.isSelected()) {
                    Renamer.this.spinnerIncrement.setEnabled(true);
                } else {
                    Renamer.this.spinnerIncrement.setEnabled(false);
                }
            }
        });
        this.spinnerIncrement = new JSpinner(new SpinnerNumberModel(0, 0, 99999999, 1));
        this.spinnerIncrement.setFont(new Font(Shutter.mainFont, 0, 11));
        this.spinnerIncrement.setEnabled(false);
        this.spinnerIncrement.setBounds(166, 33, 106, 20);
        frame.getContentPane().add(this.spinnerIncrement);
        this.lblReplace = new JLabel(Shutter.language.getProperty("lblRemplacer"));
        this.lblReplace.setFont(new Font(Shutter.mainFont, 0, 12));
        this.lblReplace.setBounds(12, 80, 70, 14);
        frame.getContentPane().add(this.lblReplace);
        this.txtReplace = new JTextField();
        this.txtReplace.setColumns(10);
        this.txtReplace.setFont(new Font("SansSerif", 0, 12));
        this.txtReplace.setBounds(84, 77, 130, 21);
        frame.getContentPane().add(this.txtReplace);
        this.lblBy = new JLabel(Shutter.language.getProperty("lblPar"));
        this.lblBy.setFont(new Font(Shutter.mainFont, 0, 12));
        this.lblBy.setBounds(226, 80, this.lblBy.getPreferredSize().width, 14);
        frame.getContentPane().add(this.lblBy);
        this.txtBy = new JTextField();
        this.txtBy.setColumns(10);
        this.txtBy.setFont(new Font("SansSerif", 0, 12));
        this.txtBy.setBounds(267, 77, this.txtReplace.getWidth(), 21);
        frame.getContentPane().add(this.txtBy);
        this.lblExample = new JLabel(Shutter.language.getProperty("lblExemple") + " " + this.fichier + this.ext);
        this.lblExample.setForeground(Utils.themeColor);
        this.lblExample.setFont(new Font("SansSerif", 0, 12));
        this.lblExample.setBounds(12, 104, 481, 14);
        frame.getContentPane().add(this.lblExample);
        this.Rename = new JButton(Shutter.language.getProperty("renommer"));
        this.Rename.setBounds(410, 77, 108, 21);
        this.Rename.setMargin(new Insets(0, 0, 0, 0));
        this.Rename.setFont(new Font(Shutter.boldFont, 0, 12));
        frame.getContentPane().add(this.Rename);
        this.btnAddBefore = new JCheckBox(Shutter.language.getProperty("btnAjouterAvant"));
        this.btnAddBefore.setFont(new Font(Shutter.mainFont, 0, 12));
        this.btnAddBefore.setBounds(280, 12, 130, 16);
        frame.getContentPane().add(this.btnAddBefore);
        this.btnAddBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnAddBefore.isSelected()) {
                    Renamer.this.txtAddBefore.setEnabled(true);
                } else {
                    Renamer.this.txtAddBefore.setEnabled(false);
                }
            }
        });
        this.txtAddBefore = new JTextField();
        this.txtAddBefore.setEnabled(false);
        this.txtAddBefore.setFont(new Font("SansSerif", 0, 12));
        this.txtAddBefore.setColumns(10);
        this.txtAddBefore.setBounds(410, 10, 108, 21);
        frame.getContentPane().add(this.txtAddBefore);
        this.btnAddAfter = new JCheckBox(Shutter.language.getProperty("btnAjouterApres"));
        this.btnAddAfter.setFont(new Font(Shutter.mainFont, 0, 12));
        this.btnAddAfter.setBounds(280, 34, 130, 16);
        frame.getContentPane().add(this.btnAddAfter);
        this.btnAddAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.btnAddAfter.isSelected()) {
                    Renamer.this.txtAddAfter.setEnabled(true);
                } else {
                    Renamer.this.txtAddAfter.setEnabled(false);
                }
            }
        });
        this.txtAddAfter = new JTextField();
        this.txtAddAfter.setEnabled(false);
        this.txtAddAfter.setFont(new Font("SansSerif", 0, 12));
        this.txtAddAfter.setColumns(10);
        this.txtAddAfter.setBounds(410, 32, 108, 21);
        frame.getContentPane().add(this.txtAddAfter);
        this.convertToLower = new JCheckBox(Shutter.language.getProperty("convertToLower"));
        this.convertToLower.setFont(new Font(Shutter.mainFont, 0, 12));
        this.convertToLower.setBounds(7, 57, this.convertToLower.getPreferredSize().width, 16);
        frame.getContentPane().add(this.convertToLower);
        this.convertToLower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.convertToLower.isSelected()) {
                    Renamer.this.convertToUpper.setSelected(false);
                }
                Renamer.this.update();
            }
        });
        this.convertToUpper = new JCheckBox(Shutter.language.getProperty("convertToUpper"));
        this.convertToUpper.setFont(new Font(Shutter.mainFont, 0, 12));
        this.convertToUpper.setBounds(this.convertToLower.getWidth() + this.convertToLower.getLocation().x + 7, 57, this.convertToUpper.getPreferredSize().width, 16);
        frame.getContentPane().add(this.convertToUpper);
        this.convertToUpper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Renamer.this.convertToUpper.isSelected()) {
                    Renamer.this.convertToLower.setSelected(false);
                }
                Renamer.this.update();
            }
        });
        this.removeSpecialCharacters = new JCheckBox(Shutter.language.getProperty("removeSpecialCharacters"));
        this.removeSpecialCharacters.setFont(new Font(Shutter.mainFont, 0, 12));
        this.removeSpecialCharacters.setBounds(this.convertToUpper.getWidth() + this.convertToUpper.getLocation().x + 7, 57, this.removeSpecialCharacters.getPreferredSize().width, 16);
        frame.getContentPane().add(this.removeSpecialCharacters);
        this.removeSpecialCharacters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Renamer.this.update();
            }
        });
        KeyAdapter key = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                Renamer.this.update();
            }
        };
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Renamer.this.update();
            }
        };
        ChangeListener change = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Renamer.this.update();
            }
        };
        this.txtReplace.addKeyListener(key);
        this.txtBy.addKeyListener(key);
        this.txtAddBefore.addKeyListener(key);
        this.txtAddAfter.addKeyListener(key);
        this.btnAddBefore.addActionListener(action);
        this.btnAddAfter.addActionListener(action);
        this.btnIncrement.addActionListener(action);
        this.btnLimit.addActionListener(action);
        this.spinnerLimit.addChangeListener(change);
        this.spinnerIncrement.addChangeListener(change);
        this.Rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                errorList = new StringBuilder();
                String count = String.valueOf(Shutter.fileList.getSelectedIndices().length);
                Object format = "";
                int i = 0;
                while (i < count.length()) {
                    format = (String)format + "0";
                    ++i;
                }
                final DecimalFormat formatter = new DecimalFormat((String)format);
                Thread rename = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int number = (Integer)(this).Renamer.this.spinnerIncrement.getValue();
                        block0: for (String item : Shutter.fileList.getSelectedValuesList()) {
                            (this).Renamer.this.ext = item.substring(item.lastIndexOf("."));
                            (this).Renamer.this.fichier = new File(item).getName().replace((this).Renamer.this.ext, "");
                            Object newName = (this).Renamer.this.btnLimit.isSelected() ? (this).Renamer.this.fichier.replace((this).Renamer.this.txtReplace.getText(), (this).Renamer.this.txtBy.getText()).substring(0, (Integer)(this).Renamer.this.spinnerLimit.getValue()) : (this).Renamer.this.fichier.replace((this).Renamer.this.txtReplace.getText(), (this).Renamer.this.txtBy.getText());
                            if ((this).Renamer.this.btnAddBefore.isSelected()) {
                                newName = (this).Renamer.this.txtAddBefore.getText() + (String)newName;
                            }
                            if ((this).Renamer.this.btnAddAfter.isSelected()) {
                                newName = (String)newName + (this).Renamer.this.txtAddAfter.getText();
                            }
                            if ((this).Renamer.this.btnIncrement.isSelected()) {
                                newName = (String)newName + formatter.format(number);
                            }
                            if ((this).Renamer.this.convertToLower.isSelected()) {
                                newName = ((String)newName).toLowerCase();
                            }
                            if ((this).Renamer.this.convertToUpper.isSelected()) {
                                newName = ((String)newName).toUpperCase();
                            }
                            if ((this).Renamer.this.removeSpecialCharacters.isSelected()) {
                                newName = Normalizer.normalize((CharSequence)newName, Normalizer.Form.NFD).replace(" ", "_").replaceAll("[^\\w\\s]+", "");
                            }
                            newName = (String)newName + (this).Renamer.this.ext.replace((this).Renamer.this.txtReplace.getText(), (this).Renamer.this.txtBy.getText());
                            ++number;
                            File file = new File(item);
                            File newFile = new File(file.getParent() + "/" + (String)newName);
                            if (newFile.exists() && !(this).Renamer.this.convertToLower.isSelected() && !(this).Renamer.this.convertToUpper.isSelected()) {
                                if (file.toString().equals(newFile.toString())) continue;
                                errorList.append(file.getName());
                                errorList.append(System.lineSeparator());
                                continue;
                            }
                            file.renameTo(newFile);
                            (this).Renamer.this.lblExample.setText(newFile.getName());
                            int i = 0;
                            while (i < Shutter.list.getSize()) {
                                if (Shutter.list.getElementAt(i).equals(item)) {
                                    Shutter.list.add(i, newFile.toString());
                                    Shutter.list.remove(i + 1);
                                    continue block0;
                                }
                                ++i;
                            }
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        if (errorList.length() != 0) {
                            JOptionPane.showMessageDialog(Shutter.frame, Shutter.language.getProperty("notProcessedFiles") + " \n\n" + errorList.toString(), Shutter.language.getProperty("filesAlreadyExists"), 1);
                        }
                        errorList.setLength(0);
                        Shutter.lblFiles.setText(Utils.filesNumber());
                        frame.dispose();
                        Shutter.fileList.clearSelection();
                    }
                });
                rename.start();
            }
        });
        if (Shutter.getLanguage.contains(Locale.of("ar").getDisplayLanguage())) {
            Component[] componentArray = frame.getContentPane().getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JCheckBox) {
                    c.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
                ++n2;
            }
        }
        frame.setVisible(true);
    }

    private void update() {
        String count = String.valueOf(Shutter.fileList.getSelectedIndices().length);
        Object format = "";
        int i = 0;
        while (i < count.length()) {
            format = (String)format + "0";
            ++i;
        }
        DecimalFormat formatter = new DecimalFormat((String)format);
        String exemple = Shutter.language.getProperty("lblExemple") + " ";
        if (this.btnLimit.isSelected()) {
            this.lblExample.setText(this.fichier.replace(this.txtReplace.getText(), this.txtBy.getText()).substring(0, (Integer)this.spinnerLimit.getValue()));
        } else {
            this.lblExample.setText(this.fichier.replace(this.txtReplace.getText(), this.txtBy.getText()));
        }
        if (this.btnAddBefore.isSelected()) {
            this.lblExample.setText(this.txtAddBefore.getText() + this.lblExample.getText());
        }
        if (this.btnAddAfter.isSelected()) {
            this.lblExample.setText(this.lblExample.getText() + this.txtAddAfter.getText());
        }
        if (this.btnIncrement.isSelected()) {
            this.lblExample.setText(this.lblExample.getText() + formatter.format(this.spinnerIncrement.getValue()));
        }
        if (this.convertToLower.isSelected()) {
            this.lblExample.setText(this.lblExample.getText().toLowerCase());
        }
        if (this.convertToUpper.isSelected()) {
            this.lblExample.setText(this.lblExample.getText().toUpperCase());
        }
        if (this.removeSpecialCharacters.isSelected()) {
            this.lblExample.setText(Normalizer.normalize(this.lblExample.getText(), Normalizer.Form.NFD).replace(" ", "_").replaceAll("[^\\w\\s]+", ""));
        }
        this.lblExample.setText(exemple + this.lblExample.getText());
        this.lblExample.setText(this.lblExample.getText() + this.ext.replace(this.txtReplace.getText(), this.txtBy.getText()));
    }
}

