/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AntiAliasedRoundRectangle;
import application.Shutter;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.border.MatteBorder;
import library.FFMPEG;

public class HashGenerator {
    private static JDialog frame;
    private static JLabel quit;
    private static JPanel topPanel;
    private static JLabel topImage;
    private static JRadioButton MD5;
    private static JRadioButton SHA1;
    private static JRadioButton SHA256;
    private static JTextField txtGenerate;
    private static int MousePositionX;
    private static int MousePositionY;

    public HashGenerator() {
        frame = new JDialog();
        frame.getContentPane().setBackground(Utils.bg32);
        frame.setTitle(Shutter.language.getProperty("menuItemHash"));
        frame.setModal(true);
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(null);
        frame.setSize(600, 143);
        frame.setResizable(false);
        if (!System.getProperty("os.name").contains("Mac")) {
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        }
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new AntiAliasedRoundRectangle(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(45, 45, 45)));
            if (!System.getProperty("os.name").contains("Mac")) {
                frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            }
        }
        frame.setLocation(Shutter.frame.getX() + (Shutter.frame.getWidth() - frame.getWidth()) / 2, Shutter.frame.getY() + (Shutter.frame.getHeight() / 2 - frame.getHeight()));
        this.topPanel();
        JPanel panelHash = new JPanel();
        MD5 = new JRadioButton("MD5");
        MD5.setSelected(true);
        MD5.setFont(new Font(Shutter.boldFont, 0, 12));
        MD5.setForeground(new Color(235, 235, 240));
        MD5.setBounds(0, 0, HashGenerator.MD5.getPreferredSize().width + 4, 21);
        panelHash.add(MD5);
        SHA1 = new JRadioButton("SHA-1");
        SHA1.setSelected(false);
        SHA1.setFont(new Font(Shutter.boldFont, 0, 12));
        SHA1.setForeground(new Color(235, 235, 240));
        SHA1.setBounds(MD5.getX() + MD5.getWidth() + 7, 0, HashGenerator.SHA1.getPreferredSize().width + 4, 21);
        panelHash.add(SHA1);
        SHA256 = new JRadioButton("SHA-256");
        SHA256.setSelected(false);
        SHA256.setFont(new Font(Shutter.boldFont, 0, 12));
        SHA256.setForeground(new Color(235, 235, 240));
        SHA256.setBounds(SHA1.getX() + SHA1.getWidth() + 7, 0, HashGenerator.SHA256.getPreferredSize().width + 4, 21);
        panelHash.add(SHA256);
        panelHash.setLayout(null);
        panelHash.setSize(MD5.getWidth() + SHA1.getWidth() + SHA256.getWidth() + 14, 21);
        panelHash.setLocation(frame.getWidth() / 2 - panelHash.getWidth() / 2 - 7, topPanel.getY() + topPanel.getHeight() + 2);
        frame.getContentPane().add(panelHash);
        JLabel btnBrowse = new JLabel();
        btnBrowse.setIcon(new FlatSVGIcon("contents/drop.svg", 21, 21));
        btnBrowse.setFont(new Font(Shutter.boldFont, 0, 12));
        btnBrowse.setLocation(7, panelHash.getY() + panelHash.getHeight() + 5);
        btnBrowse.setSize(btnBrowse.getPreferredSize().width, 21);
        frame.getContentPane().add(btnBrowse);
        final JTextField txtFile = new JTextField();
        if (Shutter.fileList.getSelectedIndices().length > 0) {
            txtFile.setFont(new Font("SansSerif", 0, 12));
            txtFile.setForeground(new Color(235, 235, 240));
            txtFile.setText(Shutter.fileList.getSelectedValue());
        } else {
            txtFile.setFont(new Font("SansSerif", 2, 12));
            txtFile.setForeground(Color.LIGHT_GRAY);
            txtFile.setText(Shutter.language.getProperty("dropFilesHere"));
        }
        txtFile.setLocation(btnBrowse.getX() + btnBrowse.getWidth() + 7, btnBrowse.getY());
        txtFile.setSize(frame.getWidth() - txtFile.getX() - 9, 21);
        frame.getContentPane().add(txtFile);
        txtFile.setTransferHandler(new FileTransferHandler());
        JLabel btnGenerate = new JLabel();
        btnGenerate.setIcon(new FlatSVGIcon("contents/generate.svg", 18, 18));
        btnGenerate.setFont(new Font(Shutter.boldFont, 0, 12));
        btnGenerate.setSize(80, btnBrowse.getPreferredSize().height);
        btnGenerate.setBounds(9, btnBrowse.getY() + btnBrowse.getHeight() + 7, btnBrowse.getWidth(), btnBrowse.getHeight());
        frame.getContentPane().add(btnGenerate);
        txtGenerate = new JTextField();
        txtGenerate.setEditable(false);
        txtGenerate.setFont(new Font("SansSerif", 0, 12));
        txtGenerate.setLocation(txtFile.getX(), btnGenerate.getY());
        txtGenerate.setSize(txtFile.getSize());
        txtGenerate.setForeground(new Color(235, 235, 240));
        frame.getContentPane().add(txtGenerate);
        JLabel btnCheck = new JLabel();
        btnCheck.setIcon(new FlatSVGIcon("contents/check.svg", 21, 21));
        btnCheck.setFont(new Font(Shutter.boldFont, 0, 12));
        btnCheck.setBounds(7, btnGenerate.getY() + btnGenerate.getHeight() + 7, btnBrowse.getWidth(), btnBrowse.getHeight());
        frame.getContentPane().add(btnCheck);
        final JTextField txtCheck = new JTextField();
        txtCheck.setFont(new Font("SansSerif", 0, 12));
        txtCheck.setLocation(txtFile.getX(), btnCheck.getY());
        txtCheck.setSize(txtFile.getSize());
        txtCheck.setForeground(new Color(235, 235, 240));
        frame.getContentPane().add(txtCheck);
        MD5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MD5.isSelected()) {
                    SHA1.setSelected(false);
                    SHA256.setSelected(false);
                    txtGenerate.setText("");
                    txtGenerate.setForeground(new Color(235, 235, 240));
                } else {
                    MD5.setSelected(true);
                }
            }
        });
        SHA1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SHA1.isSelected()) {
                    MD5.setSelected(false);
                    SHA256.setSelected(false);
                    txtGenerate.setText("");
                    txtGenerate.setForeground(new Color(235, 235, 240));
                } else {
                    SHA1.setSelected(true);
                }
            }
        });
        SHA256.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SHA256.isSelected()) {
                    SHA1.setSelected(false);
                    MD5.setSelected(false);
                    txtGenerate.setText("");
                    txtGenerate.setForeground(new Color(235, 235, 240));
                } else {
                    SHA256.setSelected(true);
                }
            }
        });
        btnGenerate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                txtGenerate.setForeground(new Color(235, 235, 240));
                txtCheck.setForeground(new Color(235, 235, 240));
                final String filePath = txtFile.getText();
                if (!filePath.isEmpty()) {
                    final File file = new File(filePath);
                    Shutter.cancelled = false;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block15: {
                                try {
                                    try {
                                        frame.setModal(false);
                                        String hash = HashGenerator.this.generateHash(file);
                                        if (!Shutter.cancelled) {
                                            txtGenerate.setText(hash);
                                            if (file.isFile()) {
                                                String extension = filePath.substring(filePath.lastIndexOf("."));
                                                PrintWriter writer = new PrintWriter(new FileWriter(filePath.replace(extension, ".txt"), false));
                                                writer.println(hash);
                                                writer.close();
                                            } else if (file.isDirectory()) {
                                                PrintWriter writer = new PrintWriter((Writer)new FileWriter(filePath + ".txt"), false);
                                                writer.println(hash);
                                                writer.close();
                                            }
                                            break block15;
                                        }
                                        txtGenerate.setText("");
                                    }
                                    catch (Exception ex) {
                                        JOptionPane.showMessageDialog(null, "Error generating hash: " + ex.getMessage());
                                        frame.setModal(true);
                                        Shutter.progressBar1.setValue(100);
                                        FFMPEG.enableAll();
                                        FFMPEG.enfOfFunction();
                                        try {
                                            Shutter.frame.setOpacity(0.5f);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        Utils.changeDialogVisibility(frame, false);
                                    }
                                }
                                finally {
                                    frame.setModal(true);
                                    Shutter.progressBar1.setValue(100);
                                    FFMPEG.enableAll();
                                    FFMPEG.enfOfFunction();
                                    try {
                                        Shutter.frame.setOpacity(0.5f);
                                    }
                                    catch (Exception exception) {}
                                    Utils.changeDialogVisibility(frame, false);
                                }
                            }
                        }
                    });
                    t.start();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        btnCheck.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String filePath = txtFile.getText();
                final String enteredHash = txtCheck.getText().trim();
                if (!filePath.isEmpty() && !enteredHash.isEmpty()) {
                    final File file = new File(filePath);
                    Shutter.cancelled = false;
                    txtGenerate.setText("");
                    txtGenerate.setForeground(new Color(235, 235, 240));
                    txtCheck.setForeground(new Color(235, 235, 240));
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block14: {
                                try {
                                    try {
                                        frame.setModal(false);
                                        String hash = HashGenerator.this.generateHash(file);
                                        if (!Shutter.cancelled) {
                                            txtGenerate.setText(hash);
                                            if (hash.equalsIgnoreCase(enteredHash)) {
                                                txtGenerate.setForeground(Color.GREEN);
                                                txtCheck.setForeground(Color.GREEN);
                                            } else {
                                                txtCheck.setForeground(Color.RED);
                                            }
                                            break block14;
                                        }
                                        txtCheck.setText("");
                                    }
                                    catch (Exception ex) {
                                        JOptionPane.showMessageDialog(null, "Error generating hash: " + ex.getMessage());
                                        frame.setModal(true);
                                        Shutter.progressBar1.setValue(100);
                                        FFMPEG.enableAll();
                                        FFMPEG.enfOfFunction();
                                        try {
                                            Shutter.frame.setOpacity(0.5f);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        Utils.changeDialogVisibility(frame, false);
                                    }
                                }
                                finally {
                                    frame.setModal(true);
                                    Shutter.progressBar1.setValue(100);
                                    FFMPEG.enableAll();
                                    FFMPEG.enfOfFunction();
                                    try {
                                        Shutter.frame.setOpacity(0.5f);
                                    }
                                    catch (Exception exception) {}
                                    Utils.changeDialogVisibility(frame, false);
                                }
                            }
                        }
                    });
                    t.start();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        frame.setVisible(true);
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBackground(Utils.bg32);
        topPanel.setBounds(0, 0, frame.getWidth(), 28);
        quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        quit.setHorizontalAlignment(0);
        quit.setBounds(HashGenerator.frame.getSize().width - 20, 4, 15, 15);
        topPanel.add(quit);
        quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    Shutter.frame.setOpacity(1.0f);
                    frame.dispose();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        JLabel title = new JLabel(Shutter.language.getProperty("menuItemHash"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 24);
        title.setFont(new Font(Shutter.magnetoFont, 0, 17));
        topPanel.add(title);
        topImage = new JLabel();
        topImage.setBackground(new Color(35, 35, 40));
        topImage.setOpaque(true);
        topImage.setBorder(new MatteBorder(1, 0, 1, 0, new Color(45, 45, 45)));
        topImage.setBounds(title.getBounds());
        topPanel.add(topImage);
        frame.getContentPane().add(topPanel);
        topImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionX = down.getPoint().x;
                MousePositionY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        topImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePositionX, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private String generateHash(File file) throws NoSuchAlgorithmException, IOException {
        Utils.changeDialogVisibility(frame, true);
        FFMPEG.disableAll();
        Shutter.btnStart.setEnabled(false);
        Shutter.frame.setOpacity(1.0f);
        Shutter.progressBar1.setValue(0);
        Shutter.progressBar1.setMaximum(100);
        MessageDigest digest = SHA1.isSelected() ? MessageDigest.getInstance("SHA-1") : (SHA256.isSelected() ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("MD5"));
        if (file.isFile()) {
            Shutter.lblCurrentEncoding.setText(file.getName());
            this.digestFile(file, digest);
        } else if (file.isDirectory()) {
            Files.walk(file.toPath(), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(path -> {
                Shutter.lblCurrentEncoding.setText(path.toFile().getName());
                try {
                    this.digestFile(path.toFile(), digest);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        byte[] hashBytes = digest.digest();
        return this.bytesToHex(hashBytes);
    }

    private void digestFile(File file, MessageDigest digest) throws IOException {
        long fileSize = file.length();
        long currentSize = 0L;
        InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
        DigestInputStream dis = new DigestInputStream(is, digest);
        byte[] buffer = new byte[4096];
        while (dis.read(buffer) != -1) {
            Shutter.progressBar1.setValue(Math.round((float)(currentSize += 4096L) / (float)fileSize * 100.0f));
            if (Shutter.cancelled) break;
        }
        dis.close();
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    class FileTransferHandler
    extends TransferHandler {
        FileTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] arg1) {
            int i = 0;
            while (i < arg1.length) {
                DataFlavor flavor = arg1[i];
                if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                    comp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                DataFlavor flavor = flavors[i];
                try {
                    if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                        List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        Iterator iter = l.iterator();
                        ((JTextField)comp).setFont(new Font("SansSerif", 0, 12));
                        ((JTextField)comp).setForeground(new Color(235, 235, 240));
                        while (iter.hasNext()) {
                            File file = (File)iter.next();
                            if (System.getProperty("os.name").contains("Windows") && file.toString().substring(0, 2).equals("\\\\")) {
                                file = Utils.UNCPath(file);
                            }
                            ((JTextField)comp).setText(file.getAbsolutePath());
                        }
                        comp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 0));
                        return true;
                    }
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
                ++i;
            }
            return false;
        }
    }
}

