/*
 * Decompiled with CFR 0.152.
 */
package ballbreaker;

import ballbreaker.Ball;
import ballbreaker.Brick;
import ballbreaker.Bullet;
import ballbreaker.Pad;
import ballbreaker.Power;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.Timer;

public final class Game
extends JPanel
implements ActionListener {
    private Timer timer;
    private int stages = 3;
    private static String winStr = "you are Winner";
    private int livesLeft = 4;
    private String livesStr = "Lives Left";
    private String scoreStr = "Score : ";
    private String levelStr = "Level : ";
    private int[][] lives = new int[][]{{5, 485}, {25, 485}, {45, 485}, {65, 485}};
    private int B_WIDTH;
    private int B_HEIGHT;
    private boolean gamePlay = true;
    private int currentLevel = 1;
    private ArrayList<Brick> brickList;
    private ArrayList<Power> powerList;
    private int score = 0;
    private Pad pad;
    private Ball ball;
    private int[][] stage = new int[][]{{1, 1, 55, 100}, {1, 1, 100, 100}, {1, 1, 145, 100}, {1, 1, 190, 100}, {1, 1, 235, 100}, {1, 1, 280, 100}, {1, 1, 325, 100}, {1, 1, 370, 100}, {1, 1, 55, 110}, {1, 1, 100, 110}, {1, 1, 145, 110}, {1, 1, 190, 110}, {1, 1, 235, 110}, {1, 1, 280, 110}, {1, 1, 325, 110}, {1, 1, 370, 110}, {1, 1, 55, 120}, {1, 1, 100, 120}, {1, 1, 145, 120}, {1, 1, 190, 120}, {1, 1, 235, 120}, {1, 1, 280, 120}, {1, 1, 325, 120}, {1, 1, 370, 120}, {1, 1, 55, 130}, {1, 1, 100, 130}, {1, 1, 145, 130}, {1, 1, 190, 130}, {1, 1, 235, 130}, {1, 1, 280, 130}, {1, 1, 325, 130}, {1, 1, 370, 130}, {1, 1, 55, 140}, {1, 1, 100, 140}, {1, 1, 145, 140}, {1, 1, 190, 140}, {1, 1, 235, 140}, {1, 1, 280, 140}, {1, 1, 325, 140}, {1, 1, 370, 140}, {1, 1, 55, 150}, {1, 1, 100, 150}, {1, 1, 145, 150}, {1, 1, 190, 150}, {1, 1, 235, 150}, {1, 1, 280, 150}, {1, 1, 325, 150}, {1, 1, 370, 150}, {2, 3, 55, 100}, {2, 1, 145, 100}, {2, 2, 235, 100}, {2, 1, 325, 100}, {2, 1, 415, 100}, {2, 3, 55, 110}, {2, 1, 145, 110}, {2, 2, 235, 110}, {2, 1, 325, 110}, {2, 1, 415, 110}, {2, 3, 55, 120}, {2, 1, 145, 120}, {2, 2, 235, 120}, {2, 1, 325, 120}, {2, 1, 415, 120}, {2, 3, 55, 130}, {2, 1, 145, 130}, {2, 2, 235, 130}, {2, 1, 325, 130}, {2, 1, 415, 130}, {2, 3, 55, 140}, {2, 1, 145, 140}, {2, 2, 235, 140}, {2, 1, 325, 140}, {2, 1, 415, 140}, {2, 3, 55, 150}, {2, 1, 145, 150}, {2, 2, 235, 150}, {2, 1, 325, 150}, {2, 1, 415, 150}, {2, 3, 55, 100}, {2, 1, 145, 100}, {2, 2, 235, 100}, {2, 1, 325, 100}, {2, 1, 415, 100}, {3, 1, 55, 100}, {3, 1, 100, 100}, {3, 1, 145, 100}, {3, 1, 190, 100}, {3, 1, 235, 100}, {3, 1, 280, 100}, {3, 1, 325, 100}, {3, 1, 370, 100}, {3, 2, 55, 110}, {3, 2, 100, 110}, {3, 2, 145, 110}, {3, 2, 190, 110}, {3, 2, 235, 110}, {3, 2, 280, 110}, {3, 2, 325, 110}, {3, 2, 370, 110}, {3, 1, 55, 120}, {3, 1, 100, 120}, {3, 1, 145, 120}, {3, 1, 190, 120}, {3, 1, 235, 120}, {3, 1, 280, 120}, {3, 1, 325, 120}, {3, 1, 370, 120}, {3, 2, 55, 130}, {3, 2, 100, 130}, {3, 2, 145, 130}, {3, 2, 190, 130}, {3, 2, 235, 130}, {3, 2, 280, 130}, {3, 2, 325, 130}, {3, 2, 370, 130}, {3, 1, 55, 140}, {3, 1, 100, 140}, {3, 1, 145, 140}, {3, 1, 190, 140}, {3, 1, 235, 140}, {3, 1, 280, 140}, {3, 1, 325, 140}, {3, 1, 370, 140}, {3, 3, 55, 150}, {3, 3, 100, 150}, {3, 3, 145, 150}, {3, 3, 190, 150}, {3, 3, 235, 150}, {3, 3, 280, 150}, {3, 3, 325, 150}, {3, 3, 370, 150}};

    public Game() {
        this.addKeyListener(new TAdapter());
        this.setFocusable(true);
        this.setBackground(Color.WHITE);
        this.setDoubleBuffered(true);
        this.setSize(500, 550);
        this.pad = new Pad();
        this.ball = new Ball();
        this.brickList = new ArrayList();
        this.powerList = new ArrayList();
        this.setStage();
        this.score = 0;
        this.timer = new Timer(5, this);
        this.timer.start();
    }

    public void addNotify() {
        super.addNotify();
        this.B_WIDTH = this.getWidth();
        this.B_HEIGHT = this.getHeight();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.gamePlay) {
            int i;
            g.setColor(Color.black);
            g.fillRect(0, 450, 500, 3);
            g.drawString(this.livesStr, 5, 475);
            g.drawString(this.scoreStr + this.score, 350, 475);
            g.drawString(this.levelStr + this.currentLevel, 350, 500);
            for (i = 0; i < this.livesLeft - 1; ++i) {
                g.fillRect(this.lives[i][0], this.lives[i][1], 15, 5);
            }
            this.pad.draw(g);
            this.ball.drawBall(g);
            for (i = 0; i < this.brickList.size(); ++i) {
                Brick b = this.brickList.get(i);
                g.setColor(b.getColor());
                g.fillRect(b.getX(), b.getY(), b.getWidth(), b.getHeight());
            }
            g.setColor(Color.black);
            if (this.powerList.size() > 0) {
                for (i = 0; i < this.powerList.size(); ++i) {
                    Power power = this.powerList.get(i);
                    power.draw(g);
                }
            }
            ArrayList<Bullet> bullets = this.pad.getBulletList();
            for (int i2 = 0; i2 < bullets.size(); ++i2) {
                bullets.get(i2).draw(g);
            }
        } else {
            Font small = new Font("Helvetica", 1, 14);
            FontMetrics metr = this.getFontMetrics(small);
            g.setColor(Color.black);
            g.setFont(small);
            String msg = "Final Score : " + this.score;
            g.drawString(msg, (this.B_WIDTH - metr.stringWidth(msg)) / 2, (this.B_HEIGHT + 30) / 2);
            g.drawString(winStr, (this.B_WIDTH - metr.stringWidth(msg)) / 2, (this.B_HEIGHT - 30) / 2);
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.gamePlay) {
            for (int i = 0; i < this.brickList.size(); ++i) {
                if (this.brickList.get(i).getVisible()) continue;
                this.brickList.remove(i);
            }
            int total = 0;
            for (int i = 0; i < this.brickList.size(); ++i) {
                if (this.brickList.get(i).getBrickType() == 3) continue;
                ++total;
            }
            if (total == 0) {
                ++this.currentLevel;
                if (this.currentLevel > this.stages) {
                    this.gamePlay = false;
                } else {
                    this.setStage();
                    this.powerList.clear();
                    this.resetPosition();
                }
            }
            if (this.brickList.size() > 0) {
                int i;
                this.pad.move();
                this.ball.move(this);
                ArrayList<Bullet> bullets = this.pad.getBulletList();
                for (i = 0; i < bullets.size(); ++i) {
                    Bullet b = bullets.get(i);
                    if (bullets.get(i).isVisible()) {
                        b.move();
                        continue;
                    }
                    bullets.remove(i);
                }
                for (i = 0; i < this.powerList.size(); ++i) {
                    if (this.powerList.get(i).isVisible()) {
                        this.powerList.get(i).move();
                        continue;
                    }
                    this.powerList.remove(i);
                }
                this.checkCollisions();
            } else {
                ++this.currentLevel;
                if (this.currentLevel > this.stages) {
                    this.gamePlay = false;
                } else {
                    this.setStage();
                    this.powerList.clear();
                    this.resetPosition();
                }
            }
            this.repaint();
        }
    }

    public void checkCollisions() {
        if (this.gamePlay) {
            int i;
            Rectangle rp;
            Rectangle rb = this.ball.getBounds();
            if (rb.intersects(rp = this.pad.getBounds())) {
                this.ball.rotateBall(this.pad.getX(), this.pad.getY(), "onPad", this.pad);
            }
            for (i = 0; i < this.brickList.size(); ++i) {
                Brick b = this.brickList.get(i);
                Rectangle rbrick = b.getBounds();
                if (!rbrick.intersects(rb)) continue;
                if (b.getBrickType() == 1) {
                    Toolkit.getDefaultToolkit().beep();
                    this.score += 10;
                    if (b.getPower() != 0) {
                        Power power = new Power(b.getPower(), b.getX(), b.getY());
                        this.powerList.add(power);
                    }
                    if (!this.ball.isPowerBall()) {
                        this.ball.rotateBall(b.getX(), b.getY(), "onBrick", this.pad);
                    }
                    this.brickList.remove(i);
                    --i;
                    continue;
                }
                if (b.getBrickType() == 2) {
                    this.score += 10;
                    Toolkit.getDefaultToolkit().beep();
                    if (!this.ball.isPowerBall()) {
                        b.changeBrick();
                        this.ball.rotateBall(b.getX(), b.getY(), "onBrick", this.pad);
                        continue;
                    }
                    this.brickList.remove(i);
                    --i;
                    continue;
                }
                if (b.getBrickType() != 3) continue;
                this.ball.rotateBall(b.getX(), b.getY(), "onBrick", this.pad);
                Toolkit.getDefaultToolkit().beep();
            }
            for (i = 0; i < this.powerList.size(); ++i) {
                Power p = this.powerList.get(i);
                Rectangle rpower = p.getBounds();
                if (!rpower.intersects(rp)) continue;
                p.setVisible(false);
                if (p.getType() == 1) {
                    this.ball.changeBall(true);
                    continue;
                }
                if (p.getType() == 2) {
                    this.pad.changePad("makeBig");
                    continue;
                }
                if (p.getType() == 3) {
                    this.pad.changePad("makeSmall");
                    continue;
                }
                if (p.getType() == 4) {
                    this.resetPosition();
                    --this.livesLeft;
                    if (this.livesLeft != 0) continue;
                    Game.setWinStr("You lost the GAME");
                    this.endGame();
                    continue;
                }
                if (p.getType() != 5) continue;
                this.pad.changePad("makeGun");
            }
            ArrayList<Bullet> bullets = this.pad.getBulletList();
            for (int i2 = 0; i2 < bullets.size(); ++i2) {
                Bullet bullet = bullets.get(i2);
                for (int j = 0; j < this.brickList.size(); ++j) {
                    Rectangle rbrick;
                    Rectangle rbullet;
                    Brick brick = this.brickList.get(j);
                    if (!brick.getVisible() || !(rbullet = bullet.getBounds()).intersects(rbrick = brick.getBounds())) continue;
                    brick.setVisible(false);
                    bullet.setVisible(false);
                    if (brick.getBrickType() <= 0) continue;
                    this.score += 10;
                    if (brick.getPower() == 0) continue;
                    Power power = new Power(brick.getPower(), brick.getX(), brick.getY());
                    this.powerList.add(power);
                }
            }
        }
    }

    public void setStage() {
        int i;
        this.brickList = null;
        this.brickList = new ArrayList();
        this.powerList.clear();
        for (int i2 = 0; i2 < this.stage.length; ++i2) {
            if (this.stage[i2][0] == this.currentLevel) {
                Brick b = new Brick(this.stage[i2][1], this.stage[i2][2], this.stage[i2][3]);
                this.brickList.add(b);
                continue;
            }
            if (this.stage[i2][0] > this.currentLevel) break;
        }
        Random randnum = new Random();
        for (i = 0; i < 2; ++i) {
            this.brickList.get(randnum.nextInt(this.brickList.size())).setPower(1);
        }
        for (i = 0; i < 2; ++i) {
            this.brickList.get(randnum.nextInt(this.brickList.size())).setPower(2);
        }
        for (i = 0; i < 2; ++i) {
            this.brickList.get(randnum.nextInt(this.brickList.size())).setPower(3);
        }
        for (i = 0; i < 2; ++i) {
            this.brickList.get(randnum.nextInt(this.brickList.size())).setPower(4);
        }
        for (i = 0; i < 2; ++i) {
            this.brickList.get(randnum.nextInt(this.brickList.size())).setPower(5);
        }
    }

    public void setLivesLeft(int live) {
        this.livesLeft = live;
    }

    public int getLivesLeft() {
        return this.livesLeft;
    }

    public void endGame() {
        this.gamePlay = false;
    }

    public Pad getPad() {
        return this.pad;
    }

    public void resetPosition() {
        this.pad.resetPad();
        this.ball.changeBall(false);
        this.powerList.clear();
    }

    public static void setWinStr(String str) {
        winStr = str;
    }

    private class TAdapter
    extends KeyAdapter {
        private TAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            Game.this.pad.keyReleased(e);
        }

        public void keyPressed(KeyEvent e) {
            Game.this.pad.keyPressed(e);
        }
    }
}

