/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.xmldsig.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.BOMInputStream;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.xmldsig.XMLSignerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtils {
    private static final Logger logger = LoggerFactory.getLogger(DocumentUtils.class);
    private static MessagesBundle messagesBundle = new MessagesBundle();

    public static Document loadXMLDocument(String xmlFile, boolean setElementId) throws XMLSignerException {
        try {
            BufferedReader in = new BufferedReader(new FileReader(xmlFile));
            InputSource source = new InputSource(in);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document docRet = dbf.newDocumentBuilder().parse(new BOMInputStream(new FileInputStream(xmlFile)));
            docRet.setXmlStandalone(true);
            if (setElementId) {
                DocumentUtils.setDocumentElementId(docRet);
            }
            return docRet;
        }
        catch (UnsupportedEncodingException e) {
            logger.error(messagesBundle.getString("erro.unsupported.encoding.exception", "UTF-8"));
            throw new XMLSignerException(messagesBundle.getString("erro.unsupported.encoding.exception", "UTF-8"));
        }
        catch (FileNotFoundException e) {
            logger.error(messagesBundle.getString("error.file.not.found", xmlFile));
            throw new XMLSignerException(messagesBundle.getString("error.file.not.found", xmlFile));
        }
        catch (SAXException e) {
            logger.error(messagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(messagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(messagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static Document loadXMLDocumentFromString(String xmlString, boolean setElementId) throws XMLSignerException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document retDoc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
            retDoc.setXmlStandalone(true);
            if (setElementId) {
                DocumentUtils.setDocumentElementId(retDoc);
            }
            return retDoc;
        }
        catch (SAXException e) {
            logger.error(messagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(messagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(messagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static Document loadXMLDocument(byte[] xmlContent, boolean setElementId) throws XMLSignerException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            Document retDoc = dbFactory.newDocumentBuilder().parse(new BOMInputStream(new ByteArrayInputStream(xmlContent)));
            retDoc.setXmlStandalone(true);
            if (setElementId) {
                DocumentUtils.setDocumentElementId(retDoc);
            }
            return retDoc;
        }
        catch (SAXException e) {
            logger.error(messagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parser", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(messagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.io", e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            logger.error(messagesBundle.getString("error.xml.parser", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parser", e.getMessage()));
        }
    }

    public static void setDocumentElementId(Document doc) {
        NodeList nodeList = doc.getElementsByTagName("*");
        for (int n = 0; n < nodeList.getLength(); ++n) {
            Node node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            for (int a = 0; a < element.getAttributes().getLength(); ++a) {
                Node attribute = element.getAttributes().item(a);
                if (attribute.getNodeType() != 2 || !"id".equalsIgnoreCase(attribute.getLocalName())) continue;
                element.setIdAttributeNode((Attr)attribute, true);
            }
        }
    }

    public static boolean hasAnyDocumentElementAttribute(NodeList elements, String attributeName) {
        boolean hasNonBlankAttrib = false;
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            for (int a = 0; a < element.getAttributes().getLength(); ++a) {
                Node attribute = element.getAttributes().item(a);
                String value = attribute.getNodeValue();
                if (!attributeName.equalsIgnoreCase(attribute.getLocalName()) || value == null || value.isEmpty()) continue;
                hasNonBlankAttrib = true;
                break;
            }
            if (hasNonBlankAttrib) break;
        }
        return hasNonBlankAttrib;
    }

    public static byte[] readContent(String parmFile) {
        try {
            byte[] result = null;
            File file = new File(parmFile);
            FileInputStream is = new FileInputStream(parmFile);
            result = new byte[(int)file.length()];
            is.read(result);
            is.close();
            return result;
        }
        catch (IOException e) {
            logger.error(messagesBundle.getString("error.io", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.io", e.getMessage()));
        }
    }
}

