/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.xmldsig.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.demoiselle.signer.core.CertificateManager;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.repository.ConfigurationRepo;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.PeriodValidator;
import org.demoiselle.signer.xmldsig.Signer;
import org.demoiselle.signer.xmldsig.XMLSignerException;
import org.demoiselle.signer.xmldsig.impl.AlgorithmsValues;
import org.demoiselle.signer.xmldsig.util.DocumentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLDsigSigner
implements Signer {
    private static final Logger logger = LoggerFactory.getLogger(XMLDsigSigner.class);
    private static MessagesBundle messagesBundle = new MessagesBundle();
    private PrivateKey privateKey = null;
    private X509Certificate certificate;
    private Certificate[] certificateChain = null;
    private String referenceId = "";
    private String signatureAlgorithm = "SHA256withRSA";
    private String signatureDigest = "SHA-256";

    @Override
    public Document signEnveloped(boolean isFileLocation, String fileNameSource) throws XMLSignerException {
        if (!isFileLocation) {
            logger.error(messagesBundle.getString("error.xml.false.to.file"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.false.to.file"));
        }
        if (fileNameSource == null || fileNameSource.isEmpty()) {
            logger.error(messagesBundle.getString("error.xml.file.null", "fileNameSource"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.file.null", "fileNameSource"));
        }
        if (!fileNameSource.substring(fileNameSource.lastIndexOf(".") + 1).equalsIgnoreCase("xml")) {
            logger.error(messagesBundle.getString("error.xml.not.valid.file"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.not.valid.file"));
        }
        Document varDocToSing = DocumentUtils.loadXMLDocument(fileNameSource, this.referenceId != null && this.referenceId.length() > 0);
        return this.signEnveloped(varDocToSing);
    }

    @Override
    public Document signEnveloped(String xmlAsString) throws XMLSignerException {
        if (xmlAsString == null || xmlAsString.isEmpty()) {
            logger.error(messagesBundle.getString("error.xml.parameter.null", "String xmlAsString"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parameter.null", "String xmlAsString"));
        }
        return this.signEnveloped(DocumentUtils.loadXMLDocumentFromString(xmlAsString, this.referenceId != null && this.referenceId.length() > 0));
    }

    @Override
    public Document signEnveloped(byte[] content) throws XMLSignerException {
        if (content == null || content.length <= 0) {
            logger.error(messagesBundle.getString("error.xml.parameter.null", "byte[] content"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parameter.null", "byte[] content"));
        }
        return this.signEnveloped(DocumentUtils.loadXMLDocument(content, this.referenceId != null && this.referenceId.length() > 0));
    }

    private Document signEnveloped(Document docToSign) throws XMLSignerException {
        this.signInputValidation();
        XMLSignatureFactory xmlSigFac = XMLSignatureFactory.getInstance("DOM");
        SignedInfo signedInfo = null;
        DOMSignContext dsc = null;
        XMLSignature signature = null;
        try {
            DigestMethod digestMethod = xmlSigFac.newDigestMethod(AlgorithmsValues.getSignatureDigest(this.signatureDigest), null);
            Transform envelopedMethod = xmlSigFac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
            CanonicalizationMethod canonMethod = xmlSigFac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
            Reference ref = xmlSigFac.newReference(this.referenceId.length() > 0 ? "#" + this.referenceId : this.referenceId, digestMethod, Arrays.asList(envelopedMethod, canonMethod), null, null);
            SignatureMethod sigMethod = xmlSigFac.newSignatureMethod(AlgorithmsValues.getSignatureAlgorithm(this.signatureAlgorithm), null);
            signedInfo = xmlSigFac.newSignedInfo(canonMethod, sigMethod, Arrays.asList(ref));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            logger.error(messagesBundle.getString("error.no.algorithm", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.no.algorithm", e.getMessage()));
        }
        KeyInfoFactory kif = xmlSigFac.getKeyInfoFactory();
        ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
        x509Content.add(this.certificate);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Arrays.asList(xd));
        dsc = new DOMSignContext(this.privateKey, (Node)docToSign.getDocumentElement());
        signature = xmlSigFac.newXMLSignature(signedInfo, ki);
        try {
            signature.sign(dsc);
        }
        catch (MarshalException | XMLSignatureException e) {
            if (e.getCause() instanceof URIReferenceException) {
                logger.error(messagesBundle.getString("error.xml.signature.resource.not.resolved", this.referenceId));
                throw new XMLSignerException(messagesBundle.getString("error.xml.signature.resource.not.resolved", this.referenceId));
            }
            logger.error(messagesBundle.getString("error.xml.signature.exception", e.getMessage()));
            throw new XMLSignerException(messagesBundle.getString("error.xml.signature.exception", e.getMessage()));
        }
        return docToSign;
    }

    private void signInputValidation() {
        if (this.certificateChain == null) {
            logger.error(messagesBundle.getString("error.certificate.null"));
            throw new XMLSignerException(messagesBundle.getString("error.certificate.null"));
        }
        if (this.getPrivateKey() == null) {
            logger.error(messagesBundle.getString("error.privatekey.null"));
            throw new XMLSignerException(messagesBundle.getString("error.privatekey.null"));
        }
        if (this.certificate == null && this.certificateChain != null && this.certificateChain.length > 0) {
            this.certificate = (X509Certificate)this.certificateChain[0];
        }
        this.certificateChain = CAManager.getInstance().getCertificateChainArray(this.certificate);
        if (this.certificateChain.length < 3) {
            logger.error(messagesBundle.getString("error.no.ca", this.certificate.getIssuerDN()));
            throw new XMLSignerException(messagesBundle.getString("error.no.ca", this.certificate.getIssuerDN()));
        }
        try {
            new CertificateManager(this.certificate);
        }
        catch (CertificateValidatorCRLException cvre) {
            logger.warn(cvre.getMessage());
            ConfigurationRepo config = ConfigurationRepo.getInstance();
            config.setOnline(true);
            try {
                new CertificateManager(this.certificate);
            }
            catch (CertificateValidatorCRLException cvre1) {
                logger.error(cvre1.getMessage());
                throw new CertificateValidatorCRLException(cvre1.getMessage());
            }
        }
        PeriodValidator pV = new PeriodValidator();
        pV.valDate(this.certificate);
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    @Override
    public void setCertificateChain(Certificate[] certificateChain) {
        this.certificateChain = certificateChain;
    }

    @Override
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId == null ? "" : referenceId;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.setSignatureDigest(AlgorithmsValues.getdigestTosignature(signatureAlgorithm));
    }

    @Override
    public String getSignatureDigest() {
        return this.signatureDigest;
    }

    private void setSignatureDigest(String signatureDigest) {
        this.signatureDigest = signatureDigest;
    }
}

