/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.xmldsig.impl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.demoiselle.signer.core.ca.manager.CAManager;
import org.demoiselle.signer.core.exception.CertificateRevocationException;
import org.demoiselle.signer.core.exception.CertificateValidatorCRLException;
import org.demoiselle.signer.core.exception.CertificateValidatorException;
import org.demoiselle.signer.core.extension.BasicCertificate;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.core.validator.CRLValidator;
import org.demoiselle.signer.core.validator.PeriodValidator;
import org.demoiselle.signer.xmldsig.Checker;
import org.demoiselle.signer.xmldsig.XMLSignatureInformations;
import org.demoiselle.signer.xmldsig.XMLSignerException;
import org.demoiselle.signer.xmldsig.impl.CertificateKeySelector;
import org.demoiselle.signer.xmldsig.util.DocumentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDsigChecker
implements Checker {
    private static final Logger logger = LoggerFactory.getLogger(XMLDsigChecker.class);
    private static MessagesBundle messagesBundle = new MessagesBundle();
    private List<XMLSignatureInformations> signaturesInfo = new ArrayList<XMLSignatureInformations>();

    @Override
    public boolean check(boolean isFileLocation, String xmlSignedFile) throws XMLSignerException {
        if (!isFileLocation) {
            logger.error(messagesBundle.getString("error.xml.false.to.file"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.false.to.file"));
        }
        if (xmlSignedFile == null || xmlSignedFile.isEmpty()) {
            logger.error(messagesBundle.getString("error.xml.file.null", "xmlSignedFile"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.file.null", "xmlSignedFile"));
        }
        if (!xmlSignedFile.substring(xmlSignedFile.lastIndexOf(".") + 1).equalsIgnoreCase("xml")) {
            logger.error(messagesBundle.getString("error.xml.not.valid.file"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.not.valid.file"));
        }
        Document doc = DocumentUtils.loadXMLDocument(xmlSignedFile, false);
        return this.verify(doc);
    }

    @Override
    public boolean check(byte[] docData) throws XMLSignerException {
        if (docData == null || docData.length <= 0) {
            logger.error(messagesBundle.getString("error.xml.parameter.null", "byte[] docData"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.parameter.null", "byte[] docData"));
        }
        Document doc = DocumentUtils.loadXMLDocument(docData, false);
        return this.verify(doc);
    }

    @Override
    public boolean check(String xmlAsString) throws XMLSignerException {
        if (xmlAsString == null || xmlAsString.isEmpty()) {
            logger.error(messagesBundle.getString("error.xml.string.file.null", "String xmlAsString"));
            throw new XMLSignerException(messagesBundle.getString("error.xml.file.null", "String xmlAsString"));
        }
        Document doc = DocumentUtils.loadXMLDocumentFromString(xmlAsString, false);
        return this.verify(doc);
    }

    private boolean verify(Document doc) {
        NodeList root = doc.getChildNodes();
        NodeList signatureListTags = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (root.item(0) == signatureListTags.item(0)) {
            logger.error(messagesBundle.getString("error.xml.detached.content"));
            XMLSignatureInformations sigInf = new XMLSignatureInformations();
            sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.detached.content"));
            this.signaturesInfo.add(sigInf);
            return false;
        }
        int sizeSigList = signatureListTags.getLength();
        if (sizeSigList < 1) {
            logger.error(messagesBundle.getString("error.xml.signature.not.found"));
            XMLSignatureInformations sigInf = new XMLSignatureInformations();
            sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.signature.not.found"));
            this.signaturesInfo.add(sigInf);
            return false;
        }
        if (DocumentUtils.hasAnyDocumentElementAttribute(doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Reference"), "URI")) {
            DocumentUtils.setDocumentElementId(doc);
        }
        boolean verifyAllResult = true;
        for (int s = 0; s < sizeSigList; ++s) {
            XMLSignature signature;
            XMLSignatureInformations sigInf = new XMLSignatureInformations();
            this.signaturesInfo.add(sigInf);
            Element signatureTag = (Element)signatureListTags.item(s);
            XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
            DOMValidateContext valContext = new DOMValidateContext(new CertificateKeySelector(), (Node)signatureTag);
            valContext.setProperty("org.jcp.xml.dsig.secureValidation", true);
            try {
                signature = signatureFactory.unmarshalXMLSignature(valContext);
            }
            catch (MarshalException e) {
                verifyAllResult = false;
                sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.document.fail"));
                continue;
            }
            boolean sigValid = false;
            try {
                sigValid = signature.validate(valContext);
            }
            catch (XMLSignatureException e) {
                verifyAllResult = false;
                if (e.getMessage().contains("keyselector")) {
                    logger.error(messagesBundle.getString("error.invalid.certificate"));
                    sigInf.getValidatorErrors().add(messagesBundle.getString("error.invalid.certificate"));
                    continue;
                }
                logger.error(messagesBundle.getString("error.xml.signature.exception"));
                sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.signature.exception"));
                continue;
            }
            verifyAllResult &= sigValid;
            CertificateKeySelector.CertificateSelectorResult cert = (CertificateKeySelector.CertificateSelectorResult)signature.getKeySelectorResult();
            this.verifyCertificate(cert.getCertificate(), sigInf);
            if (sigValid) continue;
            try {
                Reference signRef;
                if (!signature.getSignatureValue().validate(valContext)) {
                    sigInf.setInvalidSignature(true);
                    sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.signature.invalid"));
                }
                if (signature.getSignedInfo().getReferences().isEmpty() || (signRef = signature.getSignedInfo().getReferences().get(0)).validate(valContext)) continue;
                sigInf.setInvalidSignature(true);
                sigInf.setReferenceId(signRef.getURI());
                sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.digest.invalid"));
                continue;
            }
            catch (XMLSignatureException e) {
                logger.error(messagesBundle.getString("error.xml.signature.exception"));
                sigInf.getValidatorErrors().add(messagesBundle.getString("error.xml.signature.exception"));
            }
        }
        return verifyAllResult;
    }

    private void verifyCertificate(Certificate varCert, XMLSignatureInformations sigInf) {
        X509Certificate varX509Cert = null;
        try {
            varX509Cert = (X509Certificate)varCert;
        }
        catch (ClassCastException cce) {
            logger.error("Certificate is not an X509 Certificate.");
            sigInf.getValidatorErrors().add(messagesBundle.getString("error.certificate.exception"));
            return;
        }
        CRLValidator cV = new CRLValidator();
        try {
            cV.validate(varX509Cert);
        }
        catch (CertificateValidatorCRLException cvce) {
            logger.error(cvce.getMessage());
            sigInf.getValidatorErrors().add(cvce.getMessage());
        }
        catch (CertificateRevocationException cre) {
            logger.error("certificado revogado");
            sigInf.getValidatorErrors().add(messagesBundle.getString("error.certificate.repealed", cre.getMessage()));
        }
        catch (ClassCastException cre) {
            // empty catch block
        }
        PeriodValidator pV = new PeriodValidator();
        try {
            pV.valDate(varX509Cert);
        }
        catch (CertificateValidatorException cve) {
            sigInf.getValidatorWarnins().add(cve.getMessage());
            logger.warn(cve.getMessage());
        }
        try {
            LinkedList varChain = (LinkedList)CAManager.getInstance().getCertificateChain(varX509Cert);
            sigInf.setChain(varChain);
        }
        catch (Exception e) {
            sigInf.getValidatorErrors().add(e.getMessage());
        }
        sigInf.setIcpBrasilcertificate(new BasicCertificate(varX509Cert));
        sigInf.setNotAfter(varX509Cert.getNotAfter());
    }

    @Override
    public List<XMLSignatureInformations> getSignaturesInfo() {
        return this.signaturesInfo;
    }
}

