/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.xmldsig.impl;

import java.security.Key;
import java.security.cert.Certificate;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.demoiselle.signer.xmldsig.impl.AlgorithmsValues;

public class CertificateKeySelector
extends KeySelector {
    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null || keyInfo.getContent().isEmpty()) {
            return new CertificateSelectorResult(null);
        }
        SignatureMethod sm = (SignatureMethod)method;
        List<XMLStructure> list = keyInfo.getContent();
        for (int s = 0; s < list.size(); ++s) {
            XMLStructure xmlStructure = list.get(s);
            if (!(xmlStructure instanceof X509Data)) continue;
            List<?> x509DataContent = ((X509Data)xmlStructure).getContent();
            for (int c = 0; c < x509DataContent.size(); ++c) {
                Object content = x509DataContent.get(c);
                if (!(content instanceof Certificate)) continue;
                CertificateSelectorResult resp = new CertificateSelectorResult((Certificate)content);
                if (!AlgorithmsValues.getAlgorithmsOnSignature(sm.getAlgorithm()).contains(resp.getKey().getAlgorithm())) continue;
                return resp;
            }
        }
        return new CertificateSelectorResult(null);
    }

    public static class CertificateSelectorResult
    implements KeySelectorResult {
        private Certificate certificate;

        public CertificateSelectorResult(Certificate c) {
            this.certificate = c;
        }

        @Override
        public Key getKey() {
            return this.certificate.getPublicKey();
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

