/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.timestamp.configuration.TimeStampConfig;
import org.demoiselle.signer.timestamp.connector.Connector;
import org.demoiselle.signer.timestamp.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketConnector
implements Connector {
    private static final Logger logger = LoggerFactory.getLogger(SocketConnector.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private String hostname = "";
    private int port;
    private OutputStream out = null;
    private Socket socket = null;

    @Override
    public InputStream connect(byte[] content) throws CertificateCoreException {
        try {
            TimeStampConfig.getInstance().getTimeOut();
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.send.request"));
            this.socket = new Socket(this.hostname, this.port);
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.timeout.value", TimeStampConfig.getInstance().getTimeOut()));
            this.socket.setSoTimeout(TimeStampConfig.getInstance().getTimeOut());
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.connected", this.socket.isConnected(), this.hostname, this.port));
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.socket.write"));
            this.out = this.socket.getOutputStream();
            this.out.write(Utils.intToByteArray(1 + content.length));
            this.out.write(0);
            this.out.write(content);
            this.out.flush();
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.socket.response"));
            return this.socket.getInputStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.socket", e.getMessage()));
        }
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void close() {
        try {
            this.socket.close();
            this.out.close();
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage());
        }
    }
}

