/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.connector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.exception.CertificateCoreException;
import org.demoiselle.signer.core.keystore.loader.configuration.Configuration;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.demoiselle.signer.timestamp.Timestamp;
import org.demoiselle.signer.timestamp.configuration.TimeStampConfig;
import org.demoiselle.signer.timestamp.connector.Connector;
import org.demoiselle.signer.timestamp.utils.TimeStampConfigUtil;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiConnector
implements Connector {
    private static final Logger logger = LoggerFactory.getLogger(ApiConnector.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private String clientCredentials = "";
    private String accessToken = "";
    private TimeStampConfig timeStampConfig = TimeStampConfig.getInstance();
    private TimeStampConfigUtil tscu = TimeStampConfigUtil.getInstance();

    public ApiConnector() throws CertificateCoreException {
        this.clientCredentials = this.timeStampConfig.getClientCredentials();
        this.accessToken = this.authenticate();
    }

    public ApiConnector(String clientCredentials) throws CertificateCoreException {
        this.clientCredentials = clientCredentials;
        this.accessToken = this.authenticate();
    }

    private String authenticate() throws CertificateCoreException {
        try {
            if (System.getProperty("java.version").contains("1.7")) {
                Unirest.setHttpClient(this.getHttpClient());
            } else {
                Unirest.setTimeouts(this.timeStampConfig.getTimeOut(), this.timeStampConfig.getReadTimeOut());
            }
            logger.info(timeStampMessagesBundle.getString("info.timestamp.api.authenticate", this.tscu.getApiAuthUrl()));
            HttpResponse<String> response = Unirest.post(this.tscu.getApiAuthUrl()).header("Authorization", "Basic " + this.getClientCredentials()).header("Content-Type", "application/x-www-form-urlencoded").field("grant_type", "client_credentials").asString();
            if (response.getStatus() == 200) {
                String responseBody = response.getBody();
                String varToken = this.extractAccessToken(responseBody);
                this.setAccessToken(varToken);
                return this.accessToken;
            }
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.authenticate", response.getStatus()));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.authenticate", response.getStatus()));
        }
        catch (Exception e) {
            try {
                Unirest.shutdown();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.authenticate", e.getMessage()));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.authenticate", e.getMessage()), e);
        }
    }

    private String extractAccessToken(String responseBody) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(responseBody);
            return jsonNode.get("access_token").asText();
        }
        catch (Exception e) {
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.token.extract", e.getMessage()));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.token.extract", e.getMessage()), e);
        }
    }

    public String getStampBase64(String parmString) throws CertificateCoreException {
        try {
            MessageDigest md = this.getMessageDigest();
            byte[] hash = md.digest(parmString.getBytes(StandardCharsets.UTF_8));
            String base64Hash = Base64.toBase64String(hash);
            String jsonBody = "{\"hash\": \"" + base64Hash + "\"}";
            StringEntity entity = new StringEntity(jsonBody, "UTF-8");
            HttpPost request = this.geHttpPost("/stamps");
            request.setEntity(entity);
            CloseableHttpClient httpClient = System.getProperty("java.version").contains("1.7") ? this.getHttpClient() : HttpClients.createDefault();
            org.apache.http.HttpResponse response = httpClient.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return EntityUtils.toString(response.getEntity());
            }
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
        }
        catch (Exception e) {
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.connection"), (Object)e.getMessage());
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.connection", e.getMessage()), e);
        }
    }

    public String getDecodedStamps(String parmString) throws CertificateCoreException {
        try {
            MessageDigest md = this.getMessageDigest();
            byte[] hash = md.digest(parmString.getBytes(StandardCharsets.UTF_8));
            String base64Hash = Base64.toBase64String(hash);
            String jsonBody = "{\"hash\": \"" + base64Hash + "\"}";
            StringEntity entity = new StringEntity(jsonBody, "UTF-8");
            HttpPost request = this.geHttpPost("/decoded-stamps");
            request.setEntity(entity);
            CloseableHttpClient httpClient = System.getProperty("java.version").contains("1.7") ? this.getHttpClient() : HttpClients.createDefault();
            org.apache.http.HttpResponse response = httpClient.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                return EntityUtils.toString(response.getEntity());
            }
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
        }
        catch (Exception e) {
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.connection"), (Object)e.getMessage());
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.connection", e.getMessage()), e);
        }
    }

    public byte[] getStampForContent(byte[] content) throws CertificateCoreException {
        try {
            MessageDigest md = this.getMessageDigest();
            byte[] hash = md.digest(content);
            String base64Hash = Base64.toBase64String(hash);
            String jsonBody = "{\"hash\": \"" + base64Hash + "\"}";
            StringEntity entity = new StringEntity(jsonBody, "UTF-8");
            HttpPost request = this.geHttpPost("/stamps");
            request.setEntity(entity);
            CloseableHttpClient httpClient = System.getProperty("java.version").contains("1.7") ? this.getHttpClient() : HttpClients.createDefault();
            org.apache.http.HttpResponse response = httpClient.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Timestamp tsp = this.getTimestamp(response);
                return tsp.getEncoded();
            }
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
        }
        catch (Exception e) {
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.connection"), (Object)e.getMessage());
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.connection", e.getMessage()), e);
        }
    }

    public byte[] getStampForHash(byte[] hash) throws CertificateCoreException {
        try {
            String base64Hash = Base64.toBase64String(hash);
            String jsonBody = "{\"hash\": \"" + base64Hash + "\"}";
            StringEntity entity = new StringEntity(jsonBody, "UTF-8");
            HttpPost request = this.geHttpPost("/stamps");
            request.setEntity(entity);
            CloseableHttpClient httpClient = System.getProperty("java.version").contains("1.7") ? this.getHttpClient() : HttpClients.createDefault();
            org.apache.http.HttpResponse response = httpClient.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                Timestamp tsp = this.getTimestamp(response);
                return tsp.getEncoded();
            }
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.request", statusCode));
        }
        catch (Exception e) {
            logger.error(timeStampMessagesBundle.getString("error.timestamp.api.connection"), (Object)e.getMessage());
            throw new CertificateCoreException(timeStampMessagesBundle.getString("error.timestamp.api.connection", e.getMessage()), e);
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getClientCredentials() {
        return this.clientCredentials;
    }

    public void setClientCredentials(String clientCredentials) {
        this.clientCredentials = clientCredentials;
    }

    @Override
    public void close() {
    }

    @Override
    public void setHostname(String hostname) {
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public InputStream connect(byte[] content) throws UnknownHostException, CertificateCoreException {
        return null;
    }

    private HttpPost geHttpPost(String pathEndPoint) {
        String varEndPoint = TimeStampConfigUtil.getInstance().getApiEndpointUrl() + pathEndPoint;
        HttpPost request = new HttpPost(varEndPoint);
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        request.setHeader("Content-Type", "application/json");
        request.setHeader("accept", "application/json");
        return request;
    }

    private Timestamp getTimestamp(org.apache.http.HttpResponse response) throws ParseException, IOException, TSPException {
        String jsonResp = EntityUtils.toString(response.getEntity());
        JSONObject jsonObject = new JSONObject(jsonResp);
        String timeStampbase64 = jsonObject.getString("stamp");
        TimeStampResponse timeStampResponse = new TimeStampResponse(Base64.decode(timeStampbase64));
        TimeStampToken timeStampToken = timeStampResponse.getTimeStampToken();
        Timestamp tsp = new Timestamp(timeStampToken);
        return tsp;
    }

    private MessageDigest getMessageDigest() throws NoSuchAlgorithmException {
        MessageDigest md;
        if (Configuration.getInstance().getSO().toLowerCase().indexOf("indows") > 0) {
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.winhash"));
            md = MessageDigest.getInstance("SHA-256");
        } else {
            logger.debug(timeStampMessagesBundle.getString("info.timestamp.linuxhash"));
            md = MessageDigest.getInstance("SHA-512");
        }
        return md;
    }

    private CloseableHttpClient getHttpClient() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslcontext = SSLContext.getInstance("SSL");
        sslcontext.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
        return httpclient;
    }
}

