/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp.configuration;

import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeStampConfig.class);
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    public static final String TIMESTAMP_TIMEOUT = "signer.timestamp.timeout";
    public static final String ENV_TIMESTAMP_TIMEOUT = "SIGNER_TIMESTAMP_TIMEOUT";
    public static final String TIMESTAMP_CONNECT_REPLAY = "signer.timestamp.connect_replay";
    public static final String ENV_TIMESTAMP_CONNECT_REPLAY = "SIGNER_TIMESTAMP_CONNECT_REPLAY";
    public static final String ENV_TIMESTAMP_READ_TIMEOUT = "SIGNER_TIMESTAMP_READ_TIMEOUT";
    public static final String TIMESTAMP_READ_TIMEOUT = "signer.timestamp.read.timeout";
    public static final String ENV_TIMESTAMP_CLIENT_CREDENTIALS = "SIGNER_TIMESTAMP_CLIENT_CREDENTIALS";
    public static final String TIMESTAMP_CLIENT_CREDENTIALS = "signer.timestamp.client.credentials";
    public static final String ENV_TIMESTAMP_API_SERPRO = "SIGNER_TIMESTAMP_API_SERPRO";
    public static final String TIMESTAMP_API_SERPRO = "signer.timestamp.api.serpro";
    public static TimeStampConfig instance = new TimeStampConfig();
    private int timeOut = 30000;
    private int connectReplay = 3;
    private int readTimeOut = 10000;
    private String clientCredentials = "";
    private boolean apiSERPRO = false;

    public static TimeStampConfig getInstance() {
        if (instance == null) {
            instance = new TimeStampConfig();
        }
        return instance;
    }

    private TimeStampConfig() {
        try {
            String varTimeOut = System.getenv(ENV_TIMESTAMP_TIMEOUT);
            if (varTimeOut == null || varTimeOut.isEmpty()) {
                varTimeOut = (String)System.getProperties().get(TIMESTAMP_TIMEOUT);
                if (varTimeOut == null || varTimeOut.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.timeout.value", this.getTimeOut()));
                } else {
                    LOGGER.debug("key");
                    this.setTimeOut(Integer.valueOf(varTimeOut));
                }
            } else {
                LOGGER.debug("ENV");
                this.setTimeOut(Integer.valueOf(varTimeOut));
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.timeout.value", this.getTimeOut()));
        }
        try {
            String varConnectReplay = System.getenv(ENV_TIMESTAMP_CONNECT_REPLAY);
            if (varConnectReplay == null || varConnectReplay.isEmpty()) {
                varConnectReplay = (String)System.getProperties().get(TIMESTAMP_CONNECT_REPLAY);
                if (varConnectReplay == null || varConnectReplay.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.connect.replay.value", this.getConnectReplay()));
                } else {
                    LOGGER.debug("key");
                    this.setConnectReplay(Integer.valueOf(varConnectReplay));
                }
            } else {
                LOGGER.debug("ENV");
                this.setConnectReplay(Integer.valueOf(varConnectReplay));
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.connect.replay.value", this.getConnectReplay()));
        }
        try {
            String varReadTimeOut = System.getenv(ENV_TIMESTAMP_READ_TIMEOUT);
            if (varReadTimeOut == null || varReadTimeOut.isEmpty()) {
                varReadTimeOut = (String)System.getProperties().get(TIMESTAMP_READ_TIMEOUT);
                if (varReadTimeOut == null || varReadTimeOut.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.read.timeout.value", this.getReadTimeOut()));
                } else {
                    LOGGER.debug("key");
                    this.setReadTimeOut(Integer.valueOf(varReadTimeOut));
                }
            } else {
                LOGGER.debug("ENV");
                this.setReadTimeOut(Integer.valueOf(varReadTimeOut));
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.read.timeout.value", this.getReadTimeOut()));
        }
        try {
            String varClientCredentials = System.getenv(ENV_TIMESTAMP_CLIENT_CREDENTIALS);
            if (varClientCredentials == null || varClientCredentials.isEmpty()) {
                varClientCredentials = (String)System.getProperties().get(TIMESTAMP_CLIENT_CREDENTIALS);
                if (varClientCredentials == null || varClientCredentials.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.client.credentials.value", this.getClientCredentials()));
                } else {
                    LOGGER.debug("key");
                    this.setClientCredentials(varClientCredentials);
                }
            } else {
                LOGGER.debug("ENV");
                this.setClientCredentials(varClientCredentials);
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.client.credentials.value", this.getClientCredentials()));
        }
        try {
            String varApiSERPRO = System.getenv(ENV_TIMESTAMP_API_SERPRO);
            if (varApiSERPRO == null || varApiSERPRO.isEmpty()) {
                varApiSERPRO = (String)System.getProperties().get(TIMESTAMP_API_SERPRO);
                if (varApiSERPRO == null || varApiSERPRO.isEmpty()) {
                    LOGGER.debug("DEFAULT");
                    LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.api.serpro.value", this.isApiSERPRO()));
                } else {
                    LOGGER.debug("key");
                    if (varApiSERPRO.equalsIgnoreCase("true")) {
                        this.setApiSERPRO(true);
                    } else {
                        this.setApiSERPRO(false);
                    }
                }
            } else {
                LOGGER.debug("ENV");
                if (varApiSERPRO.equalsIgnoreCase("true")) {
                    this.setApiSERPRO(true);
                } else {
                    this.setApiSERPRO(false);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug(timeStampMessagesBundle.getString("info.timestamp.api.serpro.value", this.isApiSERPRO()));
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int parmTimeOut) {
        this.timeOut = parmTimeOut;
    }

    public int getConnectReplay() {
        return this.connectReplay;
    }

    public void setConnectReplay(int connectReplay) {
        this.connectReplay = connectReplay;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getClientCredentials() {
        return this.clientCredentials;
    }

    public void setClientCredentials(String clientCredentials) {
        this.clientCredentials = clientCredentials;
    }

    public boolean isApiSERPRO() {
        return this.apiSERPRO;
    }

    public void setApiSERPRO(boolean apiSERPRO) {
        this.apiSERPRO = apiSERPRO;
    }
}

