/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.timestamp;

import java.io.IOException;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.demoiselle.signer.core.util.MessagesBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timestamp {
    private static final Logger logger = LoggerFactory.getLogger(Timestamp.class.getName());
    private static MessagesBundle timeStampMessagesBundle = new MessagesBundle();
    private TimeStampToken timeStampToken = null;

    public Timestamp(TimeStampToken timeStampToken) {
        this.timeStampToken = timeStampToken;
    }

    public byte[] getEncoded() {
        try {
            return this.timeStampToken.getEncoded();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            return null;
        }
    }

    public String getPolicy() {
        return this.timeStampToken.getTimeStampInfo().getPolicy().toString();
    }

    public String getSerialNumber() {
        return this.timeStampToken.getTimeStampInfo().getSerialNumber().toString();
    }

    public String getHashAlgorithm() {
        return this.timeStampToken.getTimeStampInfo().getHashAlgorithm().getAlgorithm().toString();
    }

    public byte[] getMessageImprintDigest() {
        return this.timeStampToken.getTimeStampInfo().getMessageImprintDigest();
    }

    public String getMessageImprintDigestBase64() {
        return Base64.toBase64String(this.timeStampToken.getTimeStampInfo().getMessageImprintDigest());
    }

    public String getMessageImprintDigestHex() {
        return Hex.toHexString(this.timeStampToken.getTimeStampInfo().getMessageImprintDigest()).toUpperCase();
    }

    public Store<?> getCRLs() {
        return this.timeStampToken.getCRLs();
    }

    public Store<?> getCertificates() {
        return this.timeStampToken.getCertificates();
    }

    public Map<?, ?> getSignedAttributes() {
        return this.timeStampToken.getSignedAttributes().toHashtable();
    }

    public Map<?, ?> getUnsignedAttributes() {
        return this.timeStampToken.getUnsignedAttributes().toHashtable();
    }

    public String getTimeStampAuthorityInfo() {
        return this.timeStampToken.getTimeStampInfo().getTsa().toString();
    }

    public BigInteger getNonce() {
        return this.timeStampToken.getTimeStampInfo().getNonce();
    }

    public String getTimeStamp() {
        SimpleDateFormat dateFormatGmt = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss:S z");
        dateFormatGmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormatGmt.format(this.timeStampToken.getTimeStampInfo().getGenTime());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(0);
        builder.append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.datetime")).append(this.getTimeStamp()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.policy")).append(this.getPolicy()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.serial.number")).append(this.getSerialNumber()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.certificate")).append(this.getTimeStampAuthorityInfo()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.hash")).append(this.getHashAlgorithm()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.mid.hex")).append(this.getMessageImprintDigestHex()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.mid.base64")).append(this.getMessageImprintDigestBase64()).append("\n");
        builder.append(timeStampMessagesBundle.getString("text.timestamp.mid")).append(this.getMessageImprintDigest()).append("\n");
        return builder.toString();
    }
}

