/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.web;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.bouncycastle.util.encoders.Base64;
import org.demoiselle.signer.core.keystore.loader.KeyStoreLoader;
import org.demoiselle.signer.core.keystore.loader.factory.KeyStoreLoaderFactory;
import org.demoiselle.signer.serpro.desktop.exception.InterpreterException;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.ProgressBar;
import org.demoiselle.signer.serpro.desktop.web.Execute;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.ErrorResponse;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerServerSSLNew
extends AbstractReceiveListener {
    public static final String DEFAULT_HOST_SERVER = "assinador-desktop.serpro.gov.br";
    public static final int DEFAULT_PORT_WSS_SERVER = 65166;
    private static SignerServerSSLNew instance = null;
    private static final Logger logger = LoggerFactory.getLogger(SignerServerSSLNew.class);
    private static String host = "UNKNOW";
    private Undertow undertowWSS = null;
    private Statistics instaSta = new Statistics();
    private String ps = "";
    private String pc = "";

    public static SignerServerSSLNew getInstance() {
        logger.debug("SignerServerSSLNew get Instance");
        if (instance == null) {
            instance = new SignerServerSSLNew();
        }
        return instance;
    }

    private SignerServerSSLNew() {
        try {
            this.initializeWSSServer(DEFAULT_HOST_SERVER, 65166);
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
            throw new RuntimeException(error.getMessage());
        }
        this.start();
    }

    private void initializeWSSServer(String host, int port) throws Throwable {
        final SignerServerSSLNew listener = this;
        logger.info("Iniciando WSSServerNew...: " + host + ":" + port);
        ProgressBar pbSslInit = new ProgressBar("Iniciando WSSServerNew...");
        Thread trSslInit = new Thread(pbSslInit);
        trSslInit.start();
        try {
            SSLContext sslContext = this.getSSLContext();
            this.undertowWSS = Undertow.builder().addHttpsListener(port, host, sslContext).setHandler(Handlers.path().addPrefixPath("/", new HttpHandler(){

                @Override
                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                    exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "utf-8");
                    StringBuilder html = new StringBuilder();
                    html.append("<!DOCTYPE html ><head><meta charset=\"utf-8\">");
                    html.append("<title>Assinador Serpro</title>");
                    html.append("<style>body { text-align: justify; text-justify: inter-word; margin: 0 auto; width: 700px;margin-top: 100px; font-size: 20px; font-family: Arial; color: green; }</style>");
                    html.append("</head><body>");
                    html.append("O procedimento foi realizado com <b>sucesso</b>.");
                    html.append("<br/>Feche esta aba do navegador e continue a utiliza\u00e7\u00e3o do sistema.");
                    html.append("</body></html>");
                    exchange.getResponseSender().send(html.toString());
                }
            }).addPrefixPath("/signer", Handlers.websocket(new WebSocketConnectionCallback(){

                @Override
                public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                    String origin = exchange.getRequestHeader("Origin");
                    String agent = exchange.getRequestHeader("User-Agent");
                    channel.setAttribute("origin", origin);
                    if (origin != null) {
                        SignerServerSSLNew.this.instaSta.setOrigin(origin);
                    }
                    SignerServerSSLNew.setHost(origin);
                    logger.info("conectado em:" + SignerServerSSLNew.getHost());
                    if (agent != null) {
                        SignerServerSSLNew.this.instaSta.setAgent(agent);
                    }
                    channel.getReceiveSetter().set(listener);
                    channel.resumeReceives();
                }
            }))).build();
            pbSslInit.dispose();
            trSslInit.interrupt();
        }
        catch (Throwable error2) {
            pbSslInit.dispose();
            trSslInit.interrupt();
            logger.error(error2.getMessage());
            throw new RuntimeException("Erro ano iniciar SSL server New: " + error2.getMessage());
        }
    }

    private SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, IOException {
        logger.debug("getSSLContextNew");
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
        keyManagerFactory.init(this.getKeyStoreFromURL(), this.pc.toCharArray());
        KeyManager[] km = keyManagerFactory.getKeyManagers();
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] c, String a) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] c, String a) throws CertificateException {
            }
        }};
        SecureRandom sr = new SecureRandom();
        sslContext.init(km, tm, sr);
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String h, SSLSession s) {
                return true;
            }
        });
        return sslContext;
    }

    public void start() {
        block4: {
            try {
                this.undertowWSS.start();
            }
            catch (RuntimeException error) {
                Throwable cause = error.getCause();
                if (!(cause instanceof BindException)) break block4;
                try {
                    this.initializeWSSServer(DEFAULT_HOST_SERVER, 65166);
                }
                catch (Throwable error2) {
                    logger.error(error2.getMessage());
                }
            }
        }
    }

    private KeyStore getKeyStoreFromURL() {
        KeyStore keystore = null;
        try {
            KeyStore cks = null;
            KeyStore sks = null;
            cks = KeyStore.getInstance("PKCS12");
            sks = KeyStore.getInstance("JKS");
            ClassLoader classLoader = SignerServerSSLNew.class.getClassLoader();
            InputStream serverC = classLoader.getResourceAsStream("server.p");
            InputStream serverS = classLoader.getResourceAsStream("servertruststore.jks");
            InputStream psIS = classLoader.getResourceAsStream("ps.enc");
            InputStream pcIS = classLoader.getResourceAsStream("pc.enc");
            byte[] psBytes = Base64.decode(IOUtils.toByteArray(psIS));
            this.ps = new String(psBytes, StandardCharsets.UTF_8);
            psIS.close();
            psBytes = new byte[]{};
            byte[] pcBytes = Base64.decode(IOUtils.toByteArray(pcIS));
            this.pc = new String(pcBytes, StandardCharsets.UTF_8);
            pcIS.close();
            pcBytes = new byte[]{};
            cks.load(serverC, this.ps.toCharArray());
            sks.load(serverS, this.ps.toCharArray());
            serverC.close();
            serverS.close();
            SSLContext sslContext = null;
            sslContext = SSLContexts.custom().loadTrustMaterial(sks, new TrustSelfSignedStrategy()).loadKeyMaterial(cks, this.ps.toCharArray()).build();
            CloseableHttpClient httpClient = HttpClients.custom().setSslcontext(sslContext).useSystemProperties().build();
            HttpResponse response = httpClient.execute(new HttpGet("https://arquivos-desktop-assinadorserpro.estaleiro.serpro.gov.br/arquivo.p"));
            InputStream isCertificado = response.getEntity().getContent();
            KeyStoreLoader loader = KeyStoreLoaderFactory.factoryKeyStoreLoader(isCertificado);
            keystore = loader.getKeyStore(this.pc);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException error) {
            logger.error(error.getMessage() + error.toString());
            throw new RuntimeException(error.getMessage() + error.toString());
        }
        return keystore;
    }

    public void stop() {
        this.undertowWSS.stop();
    }

    @Override
    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
        String result = null;
        Request request = null;
        try {
            this.instaSta.setSource("web");
            result = new Execute().executeCommand(message.getData(), (String)channel.getAttribute("origin"));
            WebSockets.sendText(result, channel, null);
        }
        catch (InterpreterException error) {
            logger.error(error.getMessage());
            ErrorResponse response = new ErrorResponse(request, "Error on try to interpreter a JSON message");
            WebSockets.sendText(response.toJson(), channel, null);
        }
        catch (Throwable error) {
            logger.error(error.getMessage() + error.getCause());
            ErrorResponse response = new ErrorResponse(request, error);
            WebSockets.sendText(response.toJson(), channel, null);
        }
    }

    public static String getHost() {
        return host;
    }

    public static void setHost(String host) {
        SignerServerSSLNew.host = host;
    }
}

