/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.web;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.demoiselle.signer.serpro.desktop.cert.CertitficateHelper;
import org.demoiselle.signer.serpro.desktop.exception.InterpreterException;
import org.demoiselle.signer.serpro.desktop.statistics.Statistics;
import org.demoiselle.signer.serpro.desktop.ui.ProgressBar;
import org.demoiselle.signer.serpro.desktop.web.Execute;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.ErrorResponse;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerServerSSL
extends AbstractReceiveListener {
    public static final String DEFAULT_HOST_SERVER = "127.0.0.1";
    public static final int DEFAULT_PORT_WSS_SERVER = 65156;
    private static SignerServerSSL instance = null;
    private static final Logger logger = LoggerFactory.getLogger(SignerServerSSL.class);
    private static String host = "UNKNOW";
    private Undertow undertowWSS = null;
    private Statistics instaSta = new Statistics();

    public static SignerServerSSL getInstance() {
        logger.debug("SignerServerSSL get Instance");
        if (instance == null) {
            instance = new SignerServerSSL();
        }
        return instance;
    }

    public static void configureCertificates() {
        try {
            CertitficateHelper.installCertificates();
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
        }
    }

    private SignerServerSSL() {
        try {
            CertitficateHelper.initializeSSLCertificate();
            this.initializeWSSServer(DEFAULT_HOST_SERVER, 65156);
        }
        catch (Throwable error) {
            logger.error(error.getMessage());
            throw new RuntimeException(error.getMessage());
        }
        this.start();
    }

    private void initializeWSSServer(String host, int port) throws Throwable {
        final SignerServerSSL listener = this;
        logger.info("Iniciando WSSServer..." + host + ":" + port);
        ProgressBar pbSslInit = new ProgressBar("Iniciando WSSServer...");
        Thread trSslInit = new Thread(pbSslInit);
        trSslInit.start();
        try {
            SSLContext sslContext = this.getSSLContext();
            this.undertowWSS = Undertow.builder().addHttpsListener(port, host, sslContext).setHandler(Handlers.path().addPrefixPath("/", new HttpHandler(){

                @Override
                public void handleRequest(HttpServerExchange exchange) throws Exception {
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                    exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "utf-8");
                    StringBuilder html = new StringBuilder();
                    html.append("<!DOCTYPE html ><head><meta charset=\"utf-8\">");
                    html.append("<title>Assinador Serpro</title>");
                    html.append("<style>body { text-align: justify; text-justify: inter-word; margin: 0 auto; width: 700px;margin-top: 100px; font-size: 20px; font-family: Arial; color: green; }</style>");
                    html.append("</head><body>");
                    html.append("O procedimento foi realizado com <b>sucesso</b>.");
                    html.append("<br/>Feche esta aba do navegador e continue a utiliza\u00e7\u00e3o do sistema.");
                    html.append("</body></html>");
                    exchange.getResponseSender().send(html.toString());
                }
            }).addPrefixPath("/signer", Handlers.websocket(new WebSocketConnectionCallback(){

                @Override
                public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                    String origin = exchange.getRequestHeader("Origin");
                    String agent = exchange.getRequestHeader("User-Agent");
                    channel.setAttribute("origin", origin);
                    if (origin != null) {
                        SignerServerSSL.this.instaSta.setOrigin(origin);
                    }
                    SignerServerSSL.setHost(origin);
                    logger.info("conectado em:" + SignerServerSSL.getHost());
                    if (agent != null) {
                        SignerServerSSL.this.instaSta.setAgent(agent);
                    }
                    channel.getReceiveSetter().set(listener);
                    channel.resumeReceives();
                }
            }))).build();
            pbSslInit.dispose();
            trSslInit.interrupt();
        }
        catch (Throwable error2) {
            pbSslInit.dispose();
            trSslInit.interrupt();
            logger.error(error2.getMessage());
            logger.info("Reinciando as configura\u00e7\u00f5es..");
            String APP_CONF_DIR = System.getProperty("user.home") + File.separator + ".serpro";
            File signerDir = new File(APP_CONF_DIR);
            FileUtils.deleteDirectory(signerDir);
            throw new RuntimeException("Erro ano iniciar SSL server" + error2.getMessage());
        }
    }

    private SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, IOException {
        logger.debug("getSSLContext");
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
        keyManagerFactory.init(this.getKeyStoreFromLocal(), CertitficateHelper.PASS);
        KeyManager[] km = keyManagerFactory.getKeyManagers();
        TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] c, String a) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] c, String a) throws CertificateException {
            }
        }};
        SecureRandom sr = new SecureRandom();
        sslContext.init(km, tm, sr);
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String h, SSLSession s) {
                return true;
            }
        });
        return sslContext;
    }

    public void start() {
        block4: {
            try {
                this.undertowWSS.start();
            }
            catch (RuntimeException error) {
                Throwable cause = error.getCause();
                if (!(cause instanceof BindException)) break block4;
                try {
                    this.initializeWSSServer(DEFAULT_HOST_SERVER, 65156);
                }
                catch (Throwable error2) {
                    logger.error(error2.getMessage());
                }
            }
        }
    }

    private KeyStore getKeyStoreFromLocal() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore localKeyStore = KeyStore.getInstance("PKCS12");
        FileInputStream is = new FileInputStream(new File(CertitficateHelper.HOST_KEYSTORE_PATH.toString()));
        localKeyStore.load(is, CertitficateHelper.PASS);
        return localKeyStore;
    }

    public void stop() {
        this.undertowWSS.stop();
    }

    @Override
    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
        String result = null;
        Request request = null;
        try {
            this.instaSta.setSource("web");
            result = new Execute().executeCommand(message.getData(), (String)channel.getAttribute("origin"));
            WebSockets.sendText(result, channel, null);
        }
        catch (InterpreterException error) {
            logger.error(error.getMessage());
            ErrorResponse response = new ErrorResponse(request, "Error on try to interpreter a JSON message");
            WebSockets.sendText(response.toJson(), channel, null);
        }
        catch (Throwable error) {
            logger.error(error.getMessage() + error.getCause());
            ErrorResponse response = new ErrorResponse(request, error);
            WebSockets.sendText(response.toJson(), channel, null);
        }
    }

    public static String getHost() {
        return host;
    }

    public static void setHost(String host) {
        SignerServerSSL.host = host;
    }
}

