/*
 * Decompiled with CFR 0.152.
 */
package org.demoiselle.signer.serpro.desktop.web;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import io.undertow.websockets.core.AbstractReceiveListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.demoiselle.signer.serpro.desktop.command.shutdown.Shutdown;
import org.demoiselle.signer.serpro.desktop.web.requestResponse.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerServerNew
extends AbstractReceiveListener {
    public static final String DEFAULT_HOST_SERVER = "assinador-desktop.serpro.gov.br";
    public static final int DEFAULT_PORT_HTTP_SERVER = 65066;
    private static SignerServerNew instance = null;
    private Undertow undertow = null;
    private static final Logger logger = LoggerFactory.getLogger(SignerServerNew.class);

    public static SignerServerNew getInstance() {
        logger.debug("get New Instance HTTP");
        if (instance == null) {
            instance = new SignerServerNew();
        }
        return instance;
    }

    private SignerServerNew() {
        this.initializeHTTPServer(DEFAULT_HOST_SERVER, 65066);
        this.start();
    }

    private void initializeHTTPServer(String host, int port) {
        logger.debug("initialize HTTP Server New");
        this.undertow = Undertow.builder().addHttpListener(port, host).setHandler(new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.getRelativePath().equals("/shutdown")) {
                    logger.info("Fechando aplica\u00e7\u00e3o via Servlet (Command)");
                    new Shutdown().doCommand((Request)null);
                } else if (exchange.getRelativePath().equals("/verify.gif")) {
                    logger.info("Verificando se a aplica\u00e7\u00e3o esta ligada");
                    try {
                        byte[] file = IOUtils.toByteArray(this.getClass().getClassLoader().getResourceAsStream("images/pixel.gif"));
                        ByteBuffer buf = ByteBuffer.wrap(file);
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "image/gif");
                        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, file.length);
                        exchange.getResponseSender().send(buf);
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        ex.printStackTrace(pw);
                        exchange.getResponseSender().send("Erro: " + sw.toString());
                    }
                } else {
                    logger.info("Acessando p\u00e1gina HTTP de verifica\u00e7\u00e3o SSL");
                    exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                    exchange.getResponseHeaders().put(Headers.CONTENT_ENCODING, "utf-8");
                    StringBuilder html = new StringBuilder();
                    html.append("<!DOCTYPE html ><head><meta charset=\"utf-8\">");
                    html.append("<title>Assinador Serrpro</title>");
                    html.append("<style>body { text-align: justify; text-justify: inter-word; margin: 0 auto; width: 700px;margin-top: 100px; font-size: 20px; font-family: Arial; }</style>");
                    html.append("</head><body>");
                    html.append("Voc\u00ea est\u00e1 utilizando o <b>Assinador Serpro</b> por meio de um sistema, para permitir essa conex\u00e3o \u00e9 necess\u00e1rio adicionar a exce\u00e7\u00e3o do certificado do Assinador Serpro em seu navegador.");
                    html.append("<br/><br/> Para realizar este procedimento clique no endere\u00e7o abaixo e siga os passos para adicionar a exce\u00e7\u00e3o.");
                    html.append("<br/><br/><b>Acesse o <a href=\"https://assinador-desktop.serpro.gov.br:65166\">endere\u00e7o com certificado do Assinador Serpro</a></b>.");
                    html.append("</body></html>");
                    exchange.getResponseSender().send(html.toString());
                }
            }
        }).build();
    }

    public void start() {
        logger.debug("Iniciando server antigo");
        this.undertow.start();
    }

    public void stop() {
        logger.debug("Parando server antigo");
        this.undertow.stop();
    }
}

